/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.ByteString;

final class TextFormatEscaper {
    static String escapeBytes(final ByteString byteString) {
        ByteSequence byteSequence = new ByteSequence(){

            @Override
            public byte byteAt(int n) {
                return byteString.byteAt(n);
            }

            @Override
            public int size() {
                return byteString.size();
            }
        };
        return TextFormatEscaper.escapeBytes(byteSequence);
    }

    /*
     * Enabled aggressive block sorting
     */
    static String escapeBytes(ByteSequence byteSequence) {
        StringBuilder stringBuilder = new StringBuilder(byteSequence.size());
        int n = 0;
        while (n < byteSequence.size()) {
            byte by = byteSequence.byteAt(n);
            switch (by) {
                default: {
                    if (by >= 32 && by <= 126) {
                        stringBuilder.append((char)by);
                        break;
                    }
                    stringBuilder.append('\\');
                    stringBuilder.append((char)((by >>> 6 & 3) + 48));
                    stringBuilder.append((char)((by >>> 3 & 7) + 48));
                    stringBuilder.append((char)((by & 7) + 48));
                    break;
                }
                case 92: {
                    stringBuilder.append("\\\\");
                    break;
                }
                case 39: {
                    stringBuilder.append("\\'");
                    break;
                }
                case 34: {
                    stringBuilder.append("\\\"");
                    break;
                }
                case 13: {
                    stringBuilder.append("\\r");
                    break;
                }
                case 12: {
                    stringBuilder.append("\\f");
                    break;
                }
                case 11: {
                    stringBuilder.append("\\v");
                    break;
                }
                case 10: {
                    stringBuilder.append("\\n");
                    break;
                }
                case 9: {
                    stringBuilder.append("\\t");
                    break;
                }
                case 8: {
                    stringBuilder.append("\\b");
                    break;
                }
                case 7: {
                    stringBuilder.append("\\a");
                }
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    static String escapeText(String string) {
        return TextFormatEscaper.escapeBytes(ByteString.copyFromUtf8(string));
    }

    private static interface ByteSequence {
        public byte byteAt(int var1);

        public int size();
    }
}

