/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.ByteString;
import androidx.test.espresso.remote.internal.deps.protobuf.CodedOutputStream;
import androidx.test.espresso.remote.internal.deps.protobuf.ExtensionSchema;
import androidx.test.espresso.remote.internal.deps.protobuf.FieldSet;
import androidx.test.espresso.remote.internal.deps.protobuf.GeneratedMessageLite;
import androidx.test.espresso.remote.internal.deps.protobuf.IntArrayList;
import androidx.test.espresso.remote.internal.deps.protobuf.Internal;
import androidx.test.espresso.remote.internal.deps.protobuf.LazyFieldLite;
import androidx.test.espresso.remote.internal.deps.protobuf.LazyStringList;
import androidx.test.espresso.remote.internal.deps.protobuf.LongArrayList;
import androidx.test.espresso.remote.internal.deps.protobuf.MapFieldSchema;
import androidx.test.espresso.remote.internal.deps.protobuf.MessageLite;
import androidx.test.espresso.remote.internal.deps.protobuf.Schema;
import androidx.test.espresso.remote.internal.deps.protobuf.UnknownFieldSchema;
import androidx.test.espresso.remote.internal.deps.protobuf.UnknownFieldSetLiteSchema;
import androidx.test.espresso.remote.internal.deps.protobuf.UnsafeUtil;
import androidx.test.espresso.remote.internal.deps.protobuf.Writer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

final class SchemaUtil {
    private static final Class GENERATED_MESSAGE_CLASS = SchemaUtil.getGeneratedMessageClass();
    private static final UnknownFieldSchema PROTO2_UNKNOWN_FIELD_SET_SCHEMA = SchemaUtil.getUnknownFieldSetSchema(false);
    private static final UnknownFieldSchema PROTO3_UNKNOWN_FIELD_SET_SCHEMA = SchemaUtil.getUnknownFieldSetSchema(true);
    private static final UnknownFieldSchema UNKNOWN_FIELD_SET_LITE_SCHEMA;

    static int computeSizeBoolList(int n, List list, boolean bl) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        if (bl) {
            return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeLengthDelimitedFieldSize(n2);
        }
        return n2 * CodedOutputStream.computeBoolSize(n, true);
    }

    static int computeSizeBoolListNoTag(List list) {
        return list.size();
    }

    static int computeSizeByteStringList(int n, List list) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        n = n2 * CodedOutputStream.computeTagSize(n);
        for (n2 = 0; n2 < list.size(); ++n2) {
            n += CodedOutputStream.computeBytesSizeNoTag((ByteString)list.get(n2));
        }
        return n;
    }

    static int computeSizeEnumList(int n, List list, boolean bl) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = SchemaUtil.computeSizeEnumListNoTag(list);
        if (bl) {
            return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeLengthDelimitedFieldSize(n3);
        }
        return n3 + n2 * CodedOutputStream.computeTagSize(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int computeSizeEnumListNoTag(List list) {
        int n = list.size();
        if (n == 0) {
            return 0;
        }
        if (list instanceof IntArrayList) {
            IntArrayList intArrayList = (IntArrayList)list;
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                n2 += CodedOutputStream.computeEnumSizeNoTag(intArrayList.getInt(n3));
                ++n3;
            }
            return n2;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            n4 += CodedOutputStream.computeEnumSizeNoTag((Integer)list.get(n5));
            ++n5;
        }
        return n4;
    }

    static int computeSizeFixed32List(int n, List list, boolean bl) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        if (bl) {
            return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeLengthDelimitedFieldSize(n2 * 4);
        }
        return n2 * CodedOutputStream.computeFixed32Size(n, 0);
    }

    static int computeSizeFixed32ListNoTag(List list) {
        return list.size() * 4;
    }

    static int computeSizeFixed64List(int n, List list, boolean bl) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        if (bl) {
            return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeLengthDelimitedFieldSize(n2 * 8);
        }
        return n2 * CodedOutputStream.computeFixed64Size(n, 0L);
    }

    static int computeSizeFixed64ListNoTag(List list) {
        return list.size() * 8;
    }

    static int computeSizeGroupList(int n, List list, Schema schema) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 += CodedOutputStream.computeGroupSize(n, (MessageLite)list.get(i), schema);
        }
        return n3;
    }

    static int computeSizeInt32List(int n, List list, boolean bl) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = SchemaUtil.computeSizeInt32ListNoTag(list);
        if (bl) {
            return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeLengthDelimitedFieldSize(n3);
        }
        return n3 + n2 * CodedOutputStream.computeTagSize(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int computeSizeInt32ListNoTag(List list) {
        int n = list.size();
        if (n == 0) {
            return 0;
        }
        if (list instanceof IntArrayList) {
            IntArrayList intArrayList = (IntArrayList)list;
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                n2 += CodedOutputStream.computeInt32SizeNoTag(intArrayList.getInt(n3));
                ++n3;
            }
            return n2;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            n4 += CodedOutputStream.computeInt32SizeNoTag((Integer)list.get(n5));
            ++n5;
        }
        return n4;
    }

    static int computeSizeInt64List(int n, List list, boolean bl) {
        if (list.size() == 0) {
            return 0;
        }
        int n2 = SchemaUtil.computeSizeInt64ListNoTag(list);
        if (bl) {
            return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeLengthDelimitedFieldSize(n2);
        }
        return n2 + list.size() * CodedOutputStream.computeTagSize(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int computeSizeInt64ListNoTag(List list) {
        int n = list.size();
        if (n == 0) {
            return 0;
        }
        if (list instanceof LongArrayList) {
            LongArrayList longArrayList = (LongArrayList)list;
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                n2 += CodedOutputStream.computeInt64SizeNoTag(longArrayList.getLong(n3));
                ++n3;
            }
            return n2;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            n4 += CodedOutputStream.computeInt64SizeNoTag((Long)list.get(n5));
            ++n5;
        }
        return n4;
    }

    static int computeSizeMessage(int n, Object object, Schema schema) {
        if (object instanceof LazyFieldLite) {
            return CodedOutputStream.computeLazyFieldSize(n, (LazyFieldLite)object);
        }
        return CodedOutputStream.computeMessageSize(n, (MessageLite)object, schema);
    }

    /*
     * Enabled aggressive block sorting
     */
    static int computeSizeMessageList(int n, List list, Schema schema) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        n = n2 * CodedOutputStream.computeTagSize(n);
        int n3 = 0;
        while (n3 < n2) {
            Object e = list.get(n3);
            n = e instanceof LazyFieldLite ? (n += CodedOutputStream.computeLazyFieldSizeNoTag((LazyFieldLite)e)) : (n += CodedOutputStream.computeMessageSizeNoTag((MessageLite)e, schema));
            ++n3;
        }
        return n;
    }

    static int computeSizeSInt32List(int n, List list, boolean bl) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = SchemaUtil.computeSizeSInt32ListNoTag(list);
        if (bl) {
            return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeLengthDelimitedFieldSize(n3);
        }
        return n3 + n2 * CodedOutputStream.computeTagSize(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int computeSizeSInt32ListNoTag(List list) {
        int n = list.size();
        if (n == 0) {
            return 0;
        }
        if (list instanceof IntArrayList) {
            IntArrayList intArrayList = (IntArrayList)list;
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                n2 += CodedOutputStream.computeSInt32SizeNoTag(intArrayList.getInt(n3));
                ++n3;
            }
            return n2;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            n4 += CodedOutputStream.computeSInt32SizeNoTag((Integer)list.get(n5));
            ++n5;
        }
        return n4;
    }

    static int computeSizeSInt64List(int n, List list, boolean bl) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = SchemaUtil.computeSizeSInt64ListNoTag(list);
        if (bl) {
            return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeLengthDelimitedFieldSize(n3);
        }
        return n3 + n2 * CodedOutputStream.computeTagSize(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int computeSizeSInt64ListNoTag(List list) {
        int n = list.size();
        if (n == 0) {
            return 0;
        }
        if (list instanceof LongArrayList) {
            LongArrayList longArrayList = (LongArrayList)list;
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                n2 += CodedOutputStream.computeSInt64SizeNoTag(longArrayList.getLong(n3));
                ++n3;
            }
            return n2;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            n4 += CodedOutputStream.computeSInt64SizeNoTag((Long)list.get(n5));
            ++n5;
        }
        return n4;
    }

    /*
     * Enabled aggressive block sorting
     */
    static int computeSizeStringList(int n, List list) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        n = n2 * CodedOutputStream.computeTagSize(n);
        if (list instanceof LazyStringList) {
            LazyStringList lazyStringList = (LazyStringList)list;
            for (int i = 0; i < n2; ++i) {
                Object object = lazyStringList.getRaw(i);
                if (object instanceof ByteString) {
                    n += CodedOutputStream.computeBytesSizeNoTag((ByteString)object);
                    continue;
                }
                n += CodedOutputStream.computeStringSizeNoTag((String)object);
            }
            return n;
        }
        for (int i = 0; i < n2; ++i) {
            Object e = list.get(i);
            if (e instanceof ByteString) {
                n += CodedOutputStream.computeBytesSizeNoTag((ByteString)e);
                continue;
            }
            n += CodedOutputStream.computeStringSizeNoTag((String)e);
        }
        return n;
    }

    static int computeSizeUInt32List(int n, List list, boolean bl) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = SchemaUtil.computeSizeUInt32ListNoTag(list);
        if (bl) {
            return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeLengthDelimitedFieldSize(n3);
        }
        return n3 + n2 * CodedOutputStream.computeTagSize(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int computeSizeUInt32ListNoTag(List list) {
        int n = list.size();
        if (n == 0) {
            return 0;
        }
        if (list instanceof IntArrayList) {
            IntArrayList intArrayList = (IntArrayList)list;
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                n2 += CodedOutputStream.computeUInt32SizeNoTag(intArrayList.getInt(n3));
                ++n3;
            }
            return n2;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            n4 += CodedOutputStream.computeUInt32SizeNoTag((Integer)list.get(n5));
            ++n5;
        }
        return n4;
    }

    static int computeSizeUInt64List(int n, List list, boolean bl) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = SchemaUtil.computeSizeUInt64ListNoTag(list);
        if (bl) {
            return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeLengthDelimitedFieldSize(n3);
        }
        return n3 + n2 * CodedOutputStream.computeTagSize(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int computeSizeUInt64ListNoTag(List list) {
        int n = list.size();
        if (n == 0) {
            return 0;
        }
        if (list instanceof LongArrayList) {
            LongArrayList longArrayList = (LongArrayList)list;
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                n2 += CodedOutputStream.computeUInt64SizeNoTag(longArrayList.getLong(n3));
                ++n3;
            }
            return n2;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            n4 += CodedOutputStream.computeUInt64SizeNoTag((Long)list.get(n5));
            ++n5;
        }
        return n4;
    }

    private static UnknownFieldSchema getUnknownFieldSetSchema(boolean bl) {
        GenericDeclaration genericDeclaration;
        block3: {
            try {
                genericDeclaration = SchemaUtil.getUnknownFieldSetSchemaClass();
                if (genericDeclaration != null) break block3;
                return null;
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        Object[] objectArray = new Class[]{Boolean.TYPE};
        genericDeclaration = ((Class)genericDeclaration).getConstructor((Class<?>[])objectArray);
        objectArray = new Object[]{bl};
        UnknownFieldSchema unknownFieldSchema = (UnknownFieldSchema)((Constructor)genericDeclaration).newInstance(objectArray);
        return unknownFieldSchema;
    }

    public static UnknownFieldSchema proto2UnknownFieldSetSchema() {
        return PROTO2_UNKNOWN_FIELD_SET_SCHEMA;
    }

    public static UnknownFieldSchema proto3UnknownFieldSetSchema() {
        return PROTO3_UNKNOWN_FIELD_SET_SCHEMA;
    }

    public static UnknownFieldSchema unknownFieldSetLiteSchema() {
        return UNKNOWN_FIELD_SET_LITE_SCHEMA;
    }

    private static Class getGeneratedMessageClass() {
        try {
            Class<?> clazz = Class.forName("androidx.test.espresso.remote.internal.deps.protobuf.GeneratedMessage");
            return clazz;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Class getUnknownFieldSetSchemaClass() {
        try {
            Class<?> clazz = Class.forName("androidx.test.espresso.remote.internal.deps.protobuf.UnknownFieldSetSchema");
            return clazz;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static Object filterUnknownEnumList(int n, List object, Internal.EnumLiteMap enumLiteMap, Object object2, UnknownFieldSchema unknownFieldSchema) {
        int n2;
        int n3;
        if (enumLiteMap == null) {
            return object2;
        }
        if (object instanceof RandomAccess) {
            n3 = object.size();
            n2 = 0;
        } else {
            Iterator iterator = object.iterator();
            object = object2;
            while (true) {
                if (!iterator.hasNext()) {
                    return object;
                }
                int n4 = (Integer)iterator.next();
                if (enumLiteMap.findValueByNumber(n4) != null) continue;
                object = SchemaUtil.storeUnknownEnum(n, n4, object, unknownFieldSchema);
                iterator.remove();
            }
        }
        for (int i = 0; i < n3; ++i) {
            int n5 = (Integer)object.get(i);
            if (enumLiteMap.findValueByNumber(n5) != null) {
                if (i != n2) {
                    object.set(n2, n5);
                }
                n5 = n2 + 1;
            } else {
                object2 = SchemaUtil.storeUnknownEnum(n, n5, object2, unknownFieldSchema);
                n5 = n2;
            }
            n2 = n5;
        }
        if (n2 == n3) {
            return object2;
        }
        object.subList(n2, n3).clear();
        return object2;
    }

    /*
     * Enabled aggressive block sorting
     */
    static Object filterUnknownEnumList(int n, List object, Internal.EnumVerifier enumVerifier, Object object2, UnknownFieldSchema unknownFieldSchema) {
        int n2;
        int n3;
        if (enumVerifier == null) {
            return object2;
        }
        if (object instanceof RandomAccess) {
            n3 = object.size();
            n2 = 0;
        } else {
            Iterator iterator = object.iterator();
            object = object2;
            while (true) {
                if (!iterator.hasNext()) {
                    return object;
                }
                int n4 = (Integer)iterator.next();
                if (enumVerifier.isInRange(n4)) continue;
                object = SchemaUtil.storeUnknownEnum(n, n4, object, unknownFieldSchema);
                iterator.remove();
            }
        }
        for (int i = 0; i < n3; ++i) {
            int n5 = (Integer)object.get(i);
            if (enumVerifier.isInRange(n5)) {
                if (i != n2) {
                    object.set(n2, n5);
                }
                n5 = n2 + 1;
            } else {
                object2 = SchemaUtil.storeUnknownEnum(n, n5, object2, unknownFieldSchema);
                n5 = n2;
            }
            n2 = n5;
        }
        if (n2 == n3) {
            return object2;
        }
        object.subList(n2, n3).clear();
        return object2;
    }

    static Object storeUnknownEnum(int n, int n2, Object object, UnknownFieldSchema unknownFieldSchema) {
        if (object == null) {
            object = unknownFieldSchema.newBuilder();
        }
        unknownFieldSchema.addVarint(object, n, n2);
        return object;
    }

    static {
        UnknownFieldSetLiteSchema unknownFieldSetLiteSchema = new UnknownFieldSetLiteSchema();
        UNKNOWN_FIELD_SET_LITE_SCHEMA = unknownFieldSetLiteSchema;
    }

    static void mergeExtensions(ExtensionSchema extensionSchema, Object object, Object object2) {
        if (!((FieldSet)(object2 = extensionSchema.getExtensions(object2))).isEmpty()) {
            extensionSchema.getMutableExtensions(object).mergeFrom((FieldSet)object2);
            return;
        }
    }

    static void mergeMap(MapFieldSchema mapFieldSchema, Object object, Object object2, long l) {
        UnsafeUtil.putObject(object, l, mapFieldSchema.mergeFrom(UnsafeUtil.getObject(object, l), UnsafeUtil.getObject(object2, l)));
    }

    static void mergeUnknownFields(UnknownFieldSchema unknownFieldSchema, Object object, Object object2) {
        unknownFieldSchema.setToMessage(object, unknownFieldSchema.merge(unknownFieldSchema.getFromMessage(object), unknownFieldSchema.getFromMessage(object2)));
    }

    public static void requireGeneratedMessage(Class serializable) {
        if (!GeneratedMessageLite.class.isAssignableFrom((Class<?>)serializable) && GENERATED_MESSAGE_CLASS != null && !GENERATED_MESSAGE_CLASS.isAssignableFrom((Class<?>)serializable)) {
            serializable = new IllegalArgumentException("Message classes must extend GeneratedMessage or GeneratedMessageLite");
            throw serializable;
        }
    }

    public static void writeBoolList(int n, List list, Writer writer, boolean bl) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeBoolList(n, list, bl);
            return;
        }
    }

    public static void writeBytesList(int n, List list, Writer writer) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeBytesList(n, list);
            return;
        }
    }

    public static void writeDoubleList(int n, List list, Writer writer, boolean bl) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeDoubleList(n, list, bl);
            return;
        }
    }

    public static void writeEnumList(int n, List list, Writer writer, boolean bl) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeEnumList(n, list, bl);
            return;
        }
    }

    public static void writeFixed32List(int n, List list, Writer writer, boolean bl) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeFixed32List(n, list, bl);
            return;
        }
    }

    public static void writeFixed64List(int n, List list, Writer writer, boolean bl) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeFixed64List(n, list, bl);
            return;
        }
    }

    public static void writeFloatList(int n, List list, Writer writer, boolean bl) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeFloatList(n, list, bl);
            return;
        }
    }

    public static void writeGroupList(int n, List list, Writer writer, Schema schema) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeGroupList(n, list, schema);
            return;
        }
    }

    public static void writeInt32List(int n, List list, Writer writer, boolean bl) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeInt32List(n, list, bl);
            return;
        }
    }

    public static void writeInt64List(int n, List list, Writer writer, boolean bl) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeInt64List(n, list, bl);
            return;
        }
    }

    public static void writeMessageList(int n, List list, Writer writer, Schema schema) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeMessageList(n, list, schema);
            return;
        }
    }

    public static void writeSFixed32List(int n, List list, Writer writer, boolean bl) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeSFixed32List(n, list, bl);
            return;
        }
    }

    public static void writeSFixed64List(int n, List list, Writer writer, boolean bl) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeSFixed64List(n, list, bl);
            return;
        }
    }

    public static void writeSInt32List(int n, List list, Writer writer, boolean bl) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeSInt32List(n, list, bl);
            return;
        }
    }

    public static void writeSInt64List(int n, List list, Writer writer, boolean bl) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeSInt64List(n, list, bl);
            return;
        }
    }

    public static void writeStringList(int n, List list, Writer writer) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeStringList(n, list);
            return;
        }
    }

    public static void writeUInt32List(int n, List list, Writer writer, boolean bl) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeUInt32List(n, list, bl);
            return;
        }
    }

    public static void writeUInt64List(int n, List list, Writer writer, boolean bl) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeUInt64List(n, list, bl);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean safeEquals(Object object, Object object2) {
        if (object == object2) return true;
        if (object == null) return false;
        if (!object.equals(object2)) return false;
        return true;
    }
}

