/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.AbstractProtobufList;
import java.util.Arrays;
import java.util.RandomAccess;

final class ProtobufArrayList<E>
extends AbstractProtobufList<E>
implements RandomAccess {
    private static final ProtobufArrayList EMPTY_LIST;
    private Object[] array;
    private int size;

    @Override
    public int size() {
        return this.size;
    }

    public static ProtobufArrayList emptyList() {
        return EMPTY_LIST;
    }

    @Override
    public ProtobufArrayList mutableCopyWithCapacity(int n) {
        if (n < ((ProtobufArrayList)object).size) {
            Object object = new IllegalArgumentException();
            throw object;
        }
        Object object = ((ProtobufArrayList)object).array;
        Object[] objectArray = Arrays.copyOf(object, n);
        object = new ProtobufArrayList(objectArray, ((ProtobufArrayList)object).size);
        return object;
    }

    @Override
    public E get(int n) {
        this.ensureIndexInRange(n);
        return (E)this.array[n];
    }

    @Override
    public E remove(int n) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n);
        Object object = this.array[n];
        if (n < this.size + -1) {
            System.arraycopy(this.array, n + 1, this.array, n, this.size - n + -1);
        }
        this.size += -1;
        ++this.modCount;
        return (E)object;
    }

    @Override
    public E set(int n, E e) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n);
        Object object = this.array;
        object = object[n];
        this.array[n] = e;
        ++this.modCount;
        return (E)object;
    }

    private String makeOutOfBoundsExceptionMessage(int n) {
        int n2 = this.size;
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    static {
        ProtobufArrayList protobufArrayList;
        EMPTY_LIST = protobufArrayList = new ProtobufArrayList(new Object[0], 0);
        EMPTY_LIST.makeImmutable();
    }

    ProtobufArrayList() {
        this(new Object[10], 0);
    }

    private ProtobufArrayList(Object[] objectArray, int n) {
        this.array = objectArray;
        this.size = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void add(int n, E object) {
        this.ensureIsMutable();
        if (n < 0 || n > this.size) {
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n));
            throw indexOutOfBoundsException;
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, n, this.array, n + 1, this.size - n);
        } else {
            Object[] objectArray = ProtobufArrayList.createArray(this.size * 3 / 2 + 1);
            System.arraycopy(this.array, 0, objectArray, 0, n);
            System.arraycopy(this.array, n, objectArray, n + 1, this.size - n);
            this.array = objectArray;
        }
        this.array[n] = object;
        ++this.size;
        ++this.modCount;
    }

    private void ensureIndexInRange(int n) {
        if (n < 0 || n >= this.size) {
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n));
            throw indexOutOfBoundsException;
        }
    }

    @Override
    public boolean add(E e) {
        this.ensureIsMutable();
        if (this.size == this.array.length) {
            int n = this.size;
            this.array = Arrays.copyOf(this.array, n * 3 / 2 + 1);
        }
        Object[] objectArray = this.array;
        int n = this.size;
        this.size = n + 1;
        objectArray[n] = e;
        ++this.modCount;
        return true;
    }

    private static Object[] createArray(int n) {
        return new Object[n];
    }
}

