/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.ExtensionRegistryLite;
import androidx.test.espresso.remote.internal.deps.protobuf.Internal;
import androidx.test.espresso.remote.internal.deps.protobuf.ManifestSchemaFactory;
import androidx.test.espresso.remote.internal.deps.protobuf.Reader;
import androidx.test.espresso.remote.internal.deps.protobuf.Schema;
import androidx.test.espresso.remote.internal.deps.protobuf.SchemaFactory;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class Protobuf {
    private static final Protobuf INSTANCE;
    private final SchemaFactory schemaFactory;
    private final ConcurrentMap schemaCache;

    public static Protobuf getInstance() {
        return INSTANCE;
    }

    public Schema registerSchema(Class clazz, Schema schema) {
        Internal.checkNotNull(clazz, "messageType");
        Internal.checkNotNull(schema, "schema");
        return this.schemaCache.putIfAbsent(clazz, schema);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Schema schemaFor(Class clazz) {
        Internal.checkNotNull(clazz, "messageType");
        Schema schema = (Schema)((Protobuf)this).schemaCache.get(clazz);
        if (schema != null) return schema;
        schema = ((Protobuf)this).schemaFactory.createSchema(clazz);
        if ((this = ((Protobuf)this).registerSchema(clazz, schema)) != null) return this;
        return schema;
    }

    public Schema schemaFor(Object object) {
        return this.schemaFor(object.getClass());
    }

    static {
        Protobuf protobuf;
        INSTANCE = protobuf = new Protobuf();
    }

    private Protobuf() {
        Object object = new ConcurrentHashMap();
        this.schemaCache = object;
        this.schemaFactory = object = new ManifestSchemaFactory();
    }

    public void mergeFrom(Object object, Reader reader, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        this.schemaFor(object).mergeFrom(object, reader, extensionRegistryLite);
    }
}

