/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.ByteOutput;
import androidx.test.espresso.remote.internal.deps.protobuf.ByteString;
import androidx.test.espresso.remote.internal.deps.protobuf.CodedInputStream;
import androidx.test.espresso.remote.internal.deps.protobuf.Internal;
import androidx.test.espresso.remote.internal.deps.protobuf.RopeByteString;
import androidx.test.espresso.remote.internal.deps.protobuf.Utf8;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

final class NioByteString
extends ByteString.LeafByteString {
    private final ByteBuffer buffer;

    @Override
    public byte byteAt(int n) {
        byte by;
        try {
            by = this.buffer.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException = new ArrayIndexOutOfBoundsException(indexOutOfBoundsException.getMessage());
            throw arrayIndexOutOfBoundsException;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw arrayIndexOutOfBoundsException;
        }
        return by;
    }

    @Override
    public byte internalByteAt(int n) {
        return this.byteAt(n);
    }

    @Override
    protected int partialHash(int n, int n2, int n3) {
        for (int i = n2; i < n2 + n3; ++i) {
            n = n * 31 + this.buffer.get(i);
        }
        return n;
    }

    @Override
    public int size() {
        return this.buffer.remaining();
    }

    @Override
    public ByteString substring(int n, int n2) {
        NioByteString nioByteString;
        try {
            ByteBuffer byteBuffer = ((NioByteString)((Object)byteBuffer)).slice(n, n2);
            nioByteString = new NioByteString(byteBuffer);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException = new ArrayIndexOutOfBoundsException(indexOutOfBoundsException.getMessage());
            throw arrayIndexOutOfBoundsException;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw arrayIndexOutOfBoundsException;
        }
        return nioByteString;
    }

    @Override
    public CodedInputStream newCodedInput() {
        return CodedInputStream.newInstance(this.buffer, true);
    }

    private Object writeReplace() {
        return ByteString.copyFrom(this.buffer.slice());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String toStringInternal(Charset charset) {
        int n;
        Object object;
        int n2;
        if (((NioByteString)object).buffer.hasArray()) {
            byte[] byArray = ((NioByteString)object).buffer.array();
            n2 = ((NioByteString)object).buffer.arrayOffset() + ((NioByteString)object).buffer.position();
            int n3 = ((NioByteString)object).buffer.remaining();
            object = byArray;
            n = n2;
            n2 = n3;
            return new String((byte[])object, n, n2, charset);
        }
        object = ((ByteString)object).toByteArray();
        n2 = ((Object)object).length;
        n = 0;
        return new String((byte[])object, n, n2, charset);
    }

    @Override
    public ByteBuffer asReadOnlyByteBuffer() {
        return this.buffer.asReadOnlyBuffer();
    }

    private ByteBuffer slice(int n, int n2) {
        if (n < serializable.buffer.position() || n2 > serializable.buffer.limit() || n > n2) {
            Object[] objectArray = new Object[]{n, n2};
            Serializable serializable = new IllegalArgumentException(String.format("Invalid indices [%d, %d]", objectArray));
            throw serializable;
        }
        ByteBuffer byteBuffer = serializable.buffer.slice();
        ((Buffer)byteBuffer).position(n - serializable.buffer.position());
        ((Buffer)byteBuffer).limit(n2 - serializable.buffer.position());
        return byteBuffer;
    }

    NioByteString(ByteBuffer byteBuffer) {
        Internal.checkNotNull(byteBuffer, "buffer");
        this.buffer = byteBuffer.slice().order(ByteOrder.nativeOrder());
    }

    @Override
    protected void copyToInternal(byte[] byArray, int n, int n2, int n3) {
        ByteBuffer byteBuffer = ((NioByteString)((Object)byteBuffer)).buffer.slice();
        ((Buffer)byteBuffer).position(n);
        byteBuffer.get(byArray, n2, n3);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        Serializable serializable = new InvalidObjectException("NioByteString instances are not to be serialized directly");
        throw serializable;
    }

    @Override
    void writeTo(ByteOutput byteOutput) throws IOException {
        byteOutput.writeLazy(this.buffer.slice());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ByteString)) {
            return false;
        }
        ByteString byteString = (ByteString)object;
        if (this.size() != byteString.size()) {
            return false;
        }
        if (this.size() == 0) {
            return true;
        }
        if (object instanceof NioByteString) {
            return this.buffer.equals(((NioByteString)object).buffer);
        }
        if (object instanceof RopeByteString) {
            return object.equals(this);
        }
        return this.buffer.equals(byteString.asReadOnlyByteBuffer());
    }

    @Override
    public boolean isValidUtf8() {
        return Utf8.isValidUtf8(this.buffer);
    }
}

