/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.ArrayDecoders;
import androidx.test.espresso.remote.internal.deps.protobuf.ByteString;
import androidx.test.espresso.remote.internal.deps.protobuf.ExtensionRegistryLite;
import androidx.test.espresso.remote.internal.deps.protobuf.ExtensionSchema;
import androidx.test.espresso.remote.internal.deps.protobuf.FieldSet;
import androidx.test.espresso.remote.internal.deps.protobuf.GeneratedMessageLite;
import androidx.test.espresso.remote.internal.deps.protobuf.InvalidProtocolBufferException;
import androidx.test.espresso.remote.internal.deps.protobuf.LazyField;
import androidx.test.espresso.remote.internal.deps.protobuf.MessageLite;
import androidx.test.espresso.remote.internal.deps.protobuf.Protobuf;
import androidx.test.espresso.remote.internal.deps.protobuf.Reader;
import androidx.test.espresso.remote.internal.deps.protobuf.Schema;
import androidx.test.espresso.remote.internal.deps.protobuf.SchemaUtil;
import androidx.test.espresso.remote.internal.deps.protobuf.UnknownFieldSchema;
import androidx.test.espresso.remote.internal.deps.protobuf.UnknownFieldSetLite;
import androidx.test.espresso.remote.internal.deps.protobuf.WireFormat;
import androidx.test.espresso.remote.internal.deps.protobuf.Writer;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

final class MessageSetSchema
implements Schema {
    private final MessageLite defaultInstance;
    private final UnknownFieldSchema unknownFieldSchema;
    private final boolean hasExtensions;
    private final ExtensionSchema extensionSchema;

    @Override
    public int getSerializedSize(Object object) {
        int n = this.getUnknownFieldsSerializedSize(this.unknownFieldSchema, object);
        if (this.hasExtensions) {
            return n + this.extensionSchema.getExtensions(object).getMessageSetSerializedSize();
        }
        return n;
    }

    private int getUnknownFieldsSerializedSize(UnknownFieldSchema unknownFieldSchema, Object object) {
        return unknownFieldSchema.getSerializedSizeAsMessageSet(unknownFieldSchema.getFromMessage(object));
    }

    @Override
    public int hashCode(Object object) {
        int n = this.unknownFieldSchema.getFromMessage(object).hashCode();
        if (this.hasExtensions) {
            return n * 53 + this.extensionSchema.getExtensions(object).hashCode();
        }
        return n;
    }

    static MessageSetSchema newSchema(UnknownFieldSchema unknownFieldSchema, ExtensionSchema extensionSchema, MessageLite messageLite) {
        MessageSetSchema messageSetSchema = new MessageSetSchema(unknownFieldSchema, extensionSchema, messageLite);
        return messageSetSchema;
    }

    @Override
    public Object newInstance() {
        return this.defaultInstance.newBuilderForType().buildPartial();
    }

    private MessageSetSchema(UnknownFieldSchema unknownFieldSchema, ExtensionSchema extensionSchema, MessageLite messageLite) {
        this.unknownFieldSchema = unknownFieldSchema;
        this.hasExtensions = extensionSchema.hasExtensions(messageLite);
        this.extensionSchema = extensionSchema;
        this.defaultInstance = messageLite;
    }

    @Override
    public void makeImmutable(Object object) {
        this.unknownFieldSchema.makeImmutable(object);
        this.extensionSchema.makeImmutable(object);
    }

    @Override
    public void mergeFrom(Object object, Object object2) {
        SchemaUtil.mergeUnknownFields(this.unknownFieldSchema, object, object2);
        if (this.hasExtensions) {
            SchemaUtil.mergeExtensions(this.extensionSchema, object, object2);
            return;
        }
    }

    @Override
    public void mergeFrom(Object object, Reader reader, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        this.mergeFromHelper(this.unknownFieldSchema, this.extensionSchema, object, reader, extensionRegistryLite);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void mergeFrom(Object object, byte[] byArray, int n, int n2, ArrayDecoders.Registers registers) throws IOException {
        UnknownFieldSetLite unknownFieldSetLite = ((GeneratedMessageLite)object).unknownFields;
        if (unknownFieldSetLite == UnknownFieldSetLite.getDefaultInstance()) {
            ((GeneratedMessageLite)object).unknownFields = unknownFieldSetLite = UnknownFieldSetLite.newInstance();
        }
        FieldSet fieldSet = ((GeneratedMessageLite.ExtendableMessage)object).ensureExtensionsAreMutable();
        int n3 = n;
        GeneratedMessageLite.GeneratedExtension generatedExtension = null;
        while (true) {
            ByteString byteString;
            int n4;
            GeneratedMessageLite.GeneratedExtension generatedExtension2;
            if (n3 < n2) {
                n3 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
                int n5 = registers.int1;
                if (n5 != WireFormat.MESSAGE_SET_ITEM_TAG) {
                    if (WireFormat.getTagWireType(n5) == 2) {
                        generatedExtension = (GeneratedMessageLite.GeneratedExtension)this.extensionSchema.findExtensionByNumber(registers.extensionRegistry, this.defaultInstance, WireFormat.getTagFieldNumber(n5));
                        if (generatedExtension != null) {
                            n3 = ArrayDecoders.decodeMessageField(Protobuf.getInstance().schemaFor(generatedExtension.getMessageDefaultInstance().getClass()), byArray, n3, n2, registers);
                            fieldSet.setField(generatedExtension.descriptor, registers.object1);
                            continue;
                        }
                        n3 = ArrayDecoders.decodeUnknownField(n5, byArray, n3, n2, unknownFieldSetLite, registers);
                        continue;
                    }
                    n3 = ArrayDecoders.skipField(n5, byArray, n3, n2, registers);
                    continue;
                }
                generatedExtension2 = generatedExtension;
                n4 = 0;
                byteString = null;
            } else {
                if (n3 != n2) {
                    throw InvalidProtocolBufferException.parseFailure();
                }
                return;
            }
            block5: while (n3 < n2) {
                n3 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
                int n6 = registers.int1;
                int n7 = WireFormat.getTagFieldNumber(n6);
                int n8 = WireFormat.getTagWireType(n6);
                switch (n7) {
                    case 3: {
                        if (generatedExtension2 != null) {
                            n3 = ArrayDecoders.decodeMessageField(Protobuf.getInstance().schemaFor(generatedExtension2.getMessageDefaultInstance().getClass()), byArray, n3, n2, registers);
                            fieldSet.setField(generatedExtension2.descriptor, registers.object1);
                            continue block5;
                        }
                        if (n8 == 2) {
                            n3 = ArrayDecoders.decodeBytes(byArray, n3, registers);
                            byteString = (ByteString)registers.object1;
                            continue block5;
                        }
                    }
                    default: {
                        break;
                    }
                    case 2: {
                        if (n8 != 0) break;
                        n3 = ArrayDecoders.decodeVarint32(byArray, n3, registers);
                        n4 = registers.int1;
                        generatedExtension2 = (GeneratedMessageLite.GeneratedExtension)this.extensionSchema.findExtensionByNumber(registers.extensionRegistry, this.defaultInstance, n4);
                        continue block5;
                    }
                }
                if (n6 == WireFormat.MESSAGE_SET_ITEM_END_TAG) break;
                n3 = ArrayDecoders.skipField(n6, byArray, n3, n2, registers);
            }
            if (byteString != null) {
                unknownFieldSetLite.storeField(WireFormat.makeTag(n4, 2), byteString);
                generatedExtension = generatedExtension2;
                continue;
            }
            generatedExtension = generatedExtension2;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void mergeFromHelper(UnknownFieldSchema unknownFieldSchema, ExtensionSchema extensionSchema, Object object, Reader reader, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        Object object2 = unknownFieldSchema.getBuilderFromMessage(object);
        FieldSet fieldSet = extensionSchema.getMutableExtensions(object);
        while (true) {
            int n;
            try {
                n = reader.getFieldNumber();
                if (n == Integer.MAX_VALUE) {
                    unknownFieldSchema.setBuilderToMessage(object, object2);
                    return;
                }
            }
            catch (Throwable throwable) {
                unknownFieldSchema.setBuilderToMessage(object, object2);
                throw throwable;
            }
            {
                n = this.parseMessageSetItemOrUnknownField(reader, extensionRegistryLite, extensionSchema, fieldSet, unknownFieldSchema, object2) ? 1 : 0;
                if (n != 0) continue;
            }
            break;
        }
        unknownFieldSchema.setBuilderToMessage(object, object2);
    }

    @Override
    public void writeTo(Object object, Writer writer) throws IOException {
        Iterator iterator = ((MessageSetSchema)object2).extensionSchema.getExtensions(object).iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            FieldSet.FieldDescriptorLite fieldDescriptorLite = (FieldSet.FieldDescriptorLite)entry.getKey();
            if (fieldDescriptorLite.getLiteJavaType() != WireFormat.JavaType.MESSAGE || fieldDescriptorLite.isRepeated() || fieldDescriptorLite.isPacked()) {
                Object object2 = new IllegalStateException("Found invalid MessageSet item.");
                throw object2;
            }
            if (entry instanceof LazyField.LazyEntry) {
                writer.writeMessageSetItem(fieldDescriptorLite.getNumber(), ((LazyField.LazyEntry)entry).getField().toByteString());
                continue;
            }
            writer.writeMessageSetItem(fieldDescriptorLite.getNumber(), entry.getValue());
        }
        ((MessageSetSchema)object2).writeUnknownFieldsHelper(((MessageSetSchema)object2).unknownFieldSchema, object, writer);
    }

    private void writeUnknownFieldsHelper(UnknownFieldSchema unknownFieldSchema, Object object, Writer writer) throws IOException {
        unknownFieldSchema.writeAsMessageSetTo(unknownFieldSchema.getFromMessage(object), writer);
    }

    @Override
    public boolean equals(Object object, Object object2) {
        if (!this.unknownFieldSchema.getFromMessage(object).equals(this.unknownFieldSchema.getFromMessage(object2))) {
            return false;
        }
        if (this.hasExtensions) {
            return this.extensionSchema.getExtensions(object).equals(this.extensionSchema.getExtensions(object2));
        }
        return true;
    }

    @Override
    public final boolean isInitialized(Object object) {
        return this.extensionSchema.getExtensions(object).isInitialized();
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseMessageSetItemOrUnknownField(Reader reader, ExtensionRegistryLite extensionRegistryLite, ExtensionSchema extensionSchema, FieldSet fieldSet, UnknownFieldSchema unknownFieldSchema, Object object) throws IOException {
        int n = reader.getTag();
        if (n != WireFormat.MESSAGE_SET_ITEM_TAG) {
            if (WireFormat.getTagWireType(n) != 2) return reader.skipField();
            Object object2 = extensionSchema.findExtensionByNumber(extensionRegistryLite, ((MessageSetSchema)object2).defaultInstance, WireFormat.getTagFieldNumber(n));
            if (object2 == null) return unknownFieldSchema.mergeOneFieldFrom(object, reader);
            extensionSchema.parseLengthPrefixedMessageSetItem(reader, object2, extensionRegistryLite, fieldSet);
            return true;
        }
        n = 0;
        ByteString byteString = null;
        Object object3 = null;
        while (reader.getFieldNumber() != Integer.MAX_VALUE) {
            int n2 = reader.getTag();
            if (n2 == WireFormat.MESSAGE_SET_TYPE_ID_TAG) {
                n = reader.readUInt32();
                object3 = extensionSchema.findExtensionByNumber(extensionRegistryLite, ((MessageSetSchema)object2).defaultInstance, n);
                continue;
            }
            if (n2 == WireFormat.MESSAGE_SET_MESSAGE_TAG) {
                if (object3 != null) {
                    extensionSchema.parseLengthPrefixedMessageSetItem(reader, object3, extensionRegistryLite, fieldSet);
                    continue;
                }
                byteString = reader.readBytes();
                continue;
            }
            if (reader.skipField()) continue;
        }
        if (reader.getTag() != WireFormat.MESSAGE_SET_ITEM_END_TAG) {
            throw InvalidProtocolBufferException.invalidEndTag();
        }
        if (byteString == null) return true;
        if (object3 != null) {
            extensionSchema.parseMessageSetItem(byteString, object3, extensionRegistryLite, fieldSet);
            return true;
        }
        unknownFieldSchema.addLengthDelimited(object, n, byteString);
        return true;
    }
}

