/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.ByteString;
import androidx.test.espresso.remote.internal.deps.protobuf.GeneratedMessageLite;
import androidx.test.espresso.remote.internal.deps.protobuf.MessageLite;
import androidx.test.espresso.remote.internal.deps.protobuf.TextFormatEscaper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

final class MessageLiteToString {
    private static final String camelCaseToSnakeCase(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c)) {
                stringBuilder.append("_");
            }
            stringBuilder.append(Character.toLowerCase(c));
        }
        return stringBuilder.toString();
    }

    static String toString(MessageLite messageLite, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("# ").append(string);
        MessageLiteToString.reflectivePrintWithIndent(messageLite, stringBuilder, 0);
        return stringBuilder.toString();
    }

    static final void printField(StringBuilder stringBuilder, int n, String object, Object iterator) {
        if (iterator instanceof List) {
            iterator = ((List)((Object)iterator)).iterator();
            while (iterator.hasNext()) {
                MessageLiteToString.printField(stringBuilder, n, (String)object, iterator.next());
            }
            return;
        }
        if (iterator instanceof Map) {
            iterator = ((Map)((Object)iterator)).entrySet().iterator();
            while (iterator.hasNext()) {
                MessageLiteToString.printField(stringBuilder, n, (String)object, (Map.Entry)iterator.next());
            }
            return;
        }
        stringBuilder.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        stringBuilder.append((String)object);
        if (iterator instanceof String) {
            stringBuilder.append(": \"").append(TextFormatEscaper.escapeText((String)((Object)iterator))).append('\"');
            return;
        }
        if (iterator instanceof ByteString) {
            stringBuilder.append(": \"").append(TextFormatEscaper.escapeBytes((ByteString)((Object)iterator))).append('\"');
            return;
        }
        if (iterator instanceof GeneratedMessageLite) {
            stringBuilder.append(" {");
            MessageLiteToString.reflectivePrintWithIndent((GeneratedMessageLite)((Object)iterator), stringBuilder, n + 2);
            stringBuilder.append("\n");
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(' ');
            }
            stringBuilder.append("}");
            return;
        }
        if (iterator instanceof Map.Entry) {
            stringBuilder.append(" {");
            object = (Map.Entry)((Object)iterator);
            MessageLiteToString.printField(stringBuilder, n + 2, "key", object.getKey());
            MessageLiteToString.printField(stringBuilder, n + 2, "value", object.getValue());
            stringBuilder.append("\n");
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(' ');
            }
            stringBuilder.append("}");
            return;
        }
        stringBuilder.append(": ").append(iterator);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void reflectivePrintWithIndent(MessageLite messageLite, StringBuilder stringBuilder, int n) {
        Object object = new HashMap();
        Object object2 = new HashMap();
        Object object3 = new TreeSet();
        for (Method method : messageLite.getClass().getDeclaredMethods()) {
            object2.put(method.getName(), method);
            if (method.getParameterTypes().length != 0) continue;
            object.put(method.getName(), method);
            if (!method.getName().startsWith("get")) continue;
            object3.add(method.getName());
        }
        object3 = object3.iterator();
        while (object3.hasNext()) {
            StringBuilder stringBuilder2;
            Object object4 = (String)object3.next();
            Object object5 = ((String)object4).startsWith("get") ? ((String)object4).substring(3) : object4;
            if (((String)object5).endsWith("List") && !((String)object5).endsWith("OrBuilderList") && !((String)object5).equals("List")) {
                String string = ((String)object5).substring(0, 1);
                string = string.toLowerCase();
                int n2 = ((String)object5).length();
                int n3 = "List".length();
                String string2 = ((String)object5).substring(1, n2 - n3);
                stringBuilder2 = new StringBuilder();
                string = stringBuilder2.append(string).append(string2).toString();
                Method method = (Method)object.get(object4);
                if (method != null && method.getReturnType().equals(List.class)) {
                    MessageLiteToString.printField(stringBuilder, n, MessageLiteToString.camelCaseToSnakeCase(string), GeneratedMessageLite.invokeOrDie(method, messageLite, new Object[0]));
                    continue;
                }
            }
            if (((String)object5).endsWith("Map") && !((String)object5).equals("Map")) {
                String string = ((String)object5).substring(0, 1);
                string = string.toLowerCase();
                int n4 = ((String)object5).length();
                int n5 = "Map".length();
                String string3 = ((String)object5).substring(1, n4 - n5);
                stringBuilder2 = new StringBuilder();
                string = stringBuilder2.append(string).append(string3).toString();
                if ((object4 = (Method)object.get(object4)) != null && ((Method)object4).getReturnType().equals(Map.class) && !((AccessibleObject)object4).isAnnotationPresent(Deprecated.class) && Modifier.isPublic(((Method)object4).getModifiers())) {
                    MessageLiteToString.printField(stringBuilder, n, MessageLiteToString.camelCaseToSnakeCase(string), GeneratedMessageLite.invokeOrDie((Method)object4, messageLite, new Object[0]));
                    continue;
                }
            }
            if ((Method)object2.get(((StringBuilder)(object4 = new StringBuilder())).append("set").append((String)object5).toString()) == null) continue;
            if (((String)object5).endsWith("Bytes")) {
                int n6 = ((String)object5).length();
                int n7 = "Bytes".length();
                object4 = ((String)object5).substring(0, n6 - n7);
                StringBuilder stringBuilder3 = new StringBuilder();
                if (object.containsKey(stringBuilder3.append("get").append((String)object4).toString())) continue;
            }
            object4 = ((String)object5).substring(0, 1);
            object4 = ((String)object4).toLowerCase();
            Object object6 = ((String)object5).substring(1);
            StringBuilder stringBuilder4 = new StringBuilder();
            object4 = stringBuilder4.append((String)object4).append((String)object6).toString();
            object6 = new StringBuilder();
            object6 = (Method)object.get(((StringBuilder)object6).append("get").append((String)object5).toString());
            StringBuilder stringBuilder5 = new StringBuilder();
            object5 = (Method)object.get(stringBuilder5.append("has").append((String)object5).toString());
            if (object6 == null) continue;
            object6 = GeneratedMessageLite.invokeOrDie((Method)object6, messageLite, new Object[0]);
            boolean bl = object5 == null ? !MessageLiteToString.isDefaultValue(object6) : (Boolean)GeneratedMessageLite.invokeOrDie((Method)object5, messageLite, new Object[0]);
            if (!bl) continue;
            MessageLiteToString.printField(stringBuilder, n, MessageLiteToString.camelCaseToSnakeCase((String)object4), object6);
        }
        if (messageLite instanceof GeneratedMessageLite.ExtendableMessage) {
            Iterator iterator = ((GeneratedMessageLite.ExtendableMessage)messageLite).extensions.iterator();
            while (iterator.hasNext()) {
                object = (Map.Entry)iterator.next();
                object2 = object.getKey();
                object2 = (GeneratedMessageLite.ExtensionDescriptor)object2;
                int n8 = ((GeneratedMessageLite.ExtensionDescriptor)object2).getNumber();
                object3 = new StringBuilder();
                MessageLiteToString.printField(stringBuilder, n, ((StringBuilder)object3).append("[").append(n8).append("]").toString(), object.getValue());
            }
        }
        if (((GeneratedMessageLite)messageLite).unknownFields != null) {
            ((GeneratedMessageLite)messageLite).unknownFields.printWithIndent(stringBuilder, n);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isDefaultValue(Object object) {
        if (object instanceof Boolean) {
            if ((Boolean)object != false) return false;
            return true;
        }
        if (object instanceof Integer) {
            if ((Integer)object != 0) return false;
            return true;
        }
        if (object instanceof Float) {
            if (Float.floatToRawIntBits(((Float)object).floatValue()) != 0) return false;
            return true;
        }
        if (object instanceof Double) {
            if (Double.doubleToRawLongBits((Double)object) != 0L) return false;
            return true;
        }
        if (object instanceof String) {
            return object.equals("");
        }
        if (object instanceof ByteString) {
            return object.equals(ByteString.EMPTY);
        }
        if (object instanceof MessageLite) {
            if (object != ((MessageLite)object).getDefaultInstanceForType()) return false;
            return true;
        }
        if (!(object instanceof Enum)) return false;
        if (((Enum)object).ordinal() != 0) return false;
        return true;
    }
}

