/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.Internal;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class MapFieldLite<K, V>
extends LinkedHashMap<K, V> {
    private static final MapFieldLite EMPTY_MAP_FIELD;
    private boolean isMutable = true;

    static int calculateHashCodeForMap(Map map) {
        Iterator iterator = map.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            n += MapFieldLite.calculateHashCodeForObject(entry.getKey()) ^ MapFieldLite.calculateHashCodeForObject(entry.getValue());
        }
        return n;
    }

    private static int calculateHashCodeForObject(Object object) {
        if (object instanceof byte[]) {
            return Internal.hashCode((byte[])object);
        }
        if (object instanceof Internal.EnumLite) {
            object = new UnsupportedOperationException();
            throw object;
        }
        return object.hashCode();
    }

    @Override
    public int hashCode() {
        return MapFieldLite.calculateHashCodeForMap(this);
    }

    public static MapFieldLite emptyMapField() {
        return EMPTY_MAP_FIELD;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MapFieldLite mutableCopy() {
        if (this.isEmpty()) {
            return new MapFieldLite<K, V>();
        }
        MapFieldLite<K, V> mapFieldLite = new MapFieldLite<K, V>((Map)this);
        return mapFieldLite;
    }

    @Override
    public V put(K k, V v) {
        this.ensureMutable();
        Internal.checkNotNull(k);
        Internal.checkNotNull(v);
        return super.put(k, v);
    }

    @Override
    public V remove(Object object) {
        this.ensureMutable();
        return super.remove(object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (!((HashMap)((Object)this)).isEmpty()) return super.entrySet();
        return Collections.emptySet();
    }

    static {
        MapFieldLite mapFieldLite;
        EMPTY_MAP_FIELD = mapFieldLite = new MapFieldLite();
        EMPTY_MAP_FIELD.makeImmutable();
    }

    private MapFieldLite() {
    }

    private MapFieldLite(Map map) {
        super(map);
    }

    private static void checkForNullKeysAndValues(Map map) {
        for (Object k : map.keySet()) {
            Internal.checkNotNull(k);
            Internal.checkNotNull(map.get(k));
        }
    }

    @Override
    public void clear() {
        this.ensureMutable();
        super.clear();
    }

    private void ensureMutable() {
        if (!serializable.isMutable()) {
            Serializable serializable = new UnsupportedOperationException();
            throw serializable;
        }
    }

    public void makeImmutable() {
        this.isMutable = false;
    }

    public void mergeFrom(MapFieldLite mapFieldLite) {
        this.ensureMutable();
        if (!mapFieldLite.isEmpty()) {
            this.putAll(mapFieldLite);
            return;
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.ensureMutable();
        MapFieldLite.checkForNullKeysAndValues(map);
        super.putAll(map);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Map)) return false;
        if (!MapFieldLite.equals(this, (Map)object)) return false;
        return true;
    }

    private static boolean equals(Object object, Object object2) {
        if (object instanceof byte[] && object2 instanceof byte[]) {
            return Arrays.equals((byte[])object, (byte[])object2);
        }
        return object.equals(object2);
    }

    static boolean equals(Map object, Map map) {
        if (object == map) {
            return true;
        }
        if (object.size() != map.size()) {
            return false;
        }
        for (Map.Entry entry : object.entrySet()) {
            if (!map.containsKey(entry.getKey())) {
                return false;
            }
            if (MapFieldLite.equals(entry.getValue(), map.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public boolean isMutable() {
        return this.isMutable;
    }
}

