/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.ExtensionSchemas;
import androidx.test.espresso.remote.internal.deps.protobuf.GeneratedMessageInfoFactory;
import androidx.test.espresso.remote.internal.deps.protobuf.GeneratedMessageLite;
import androidx.test.espresso.remote.internal.deps.protobuf.Internal;
import androidx.test.espresso.remote.internal.deps.protobuf.ListFieldSchema;
import androidx.test.espresso.remote.internal.deps.protobuf.MapFieldSchemas;
import androidx.test.espresso.remote.internal.deps.protobuf.MessageInfo;
import androidx.test.espresso.remote.internal.deps.protobuf.MessageInfoFactory;
import androidx.test.espresso.remote.internal.deps.protobuf.MessageSchema;
import androidx.test.espresso.remote.internal.deps.protobuf.MessageSetSchema;
import androidx.test.espresso.remote.internal.deps.protobuf.NewInstanceSchemas;
import androidx.test.espresso.remote.internal.deps.protobuf.ProtoSyntax;
import androidx.test.espresso.remote.internal.deps.protobuf.Schema;
import androidx.test.espresso.remote.internal.deps.protobuf.SchemaFactory;
import androidx.test.espresso.remote.internal.deps.protobuf.SchemaUtil;
import java.lang.reflect.Method;

final class ManifestSchemaFactory
implements SchemaFactory {
    private static final MessageInfoFactory EMPTY_FACTORY;
    private final MessageInfoFactory messageInfoFactory;

    private static MessageInfoFactory getDefaultMessageInfoFactory() {
        MessageInfoFactory[] messageInfoFactoryArray = new MessageInfoFactory[]{GeneratedMessageInfoFactory.getInstance(), ManifestSchemaFactory.getDescriptorMessageInfoFactory()};
        CompositeMessageInfoFactory compositeMessageInfoFactory = new CompositeMessageInfoFactory(messageInfoFactoryArray);
        return compositeMessageInfoFactory;
    }

    private static MessageInfoFactory getDescriptorMessageInfoFactory() {
        try {
            Object object = Class.forName("androidx.test.espresso.remote.internal.deps.protobuf.DescriptorMessageInfoFactory").getDeclaredMethod("getInstance", new Class[0]);
            object = (MessageInfoFactory)((Method)object).invoke(null, new Object[0]);
            return object;
        }
        catch (Exception exception) {
            return EMPTY_FACTORY;
        }
    }

    @Override
    public Schema createSchema(Class clazz) {
        SchemaUtil.requireGeneratedMessage(clazz);
        MessageInfo messageInfo = ((ManifestSchemaFactory)((Object)messageInfo)).messageInfoFactory.messageInfoFor(clazz);
        if (messageInfo.isMessageSetWireFormat()) {
            if (GeneratedMessageLite.class.isAssignableFrom(clazz)) {
                return MessageSetSchema.newSchema(SchemaUtil.unknownFieldSetLiteSchema(), ExtensionSchemas.lite(), messageInfo.getDefaultInstance());
            }
            return MessageSetSchema.newSchema(SchemaUtil.proto2UnknownFieldSetSchema(), ExtensionSchemas.full(), messageInfo.getDefaultInstance());
        }
        return ManifestSchemaFactory.newSchema(clazz, messageInfo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Schema newSchema(Class object, MessageInfo messageInfo) {
        if (GeneratedMessageLite.class.isAssignableFrom((Class<?>)object)) {
            if (!ManifestSchemaFactory.isProto2(messageInfo)) return MessageSchema.newSchema((Class)object, messageInfo, NewInstanceSchemas.lite(), ListFieldSchema.lite(), SchemaUtil.unknownFieldSetLiteSchema(), null, MapFieldSchemas.lite());
            return MessageSchema.newSchema((Class)object, messageInfo, NewInstanceSchemas.lite(), ListFieldSchema.lite(), SchemaUtil.unknownFieldSetLiteSchema(), ExtensionSchemas.lite(), MapFieldSchemas.lite());
        }
        if (!ManifestSchemaFactory.isProto2(messageInfo)) return MessageSchema.newSchema((Class)object, messageInfo, NewInstanceSchemas.full(), ListFieldSchema.full(), SchemaUtil.proto3UnknownFieldSetSchema(), null, MapFieldSchemas.full());
        return MessageSchema.newSchema((Class)object, messageInfo, NewInstanceSchemas.full(), ListFieldSchema.full(), SchemaUtil.proto2UnknownFieldSetSchema(), ExtensionSchemas.full(), MapFieldSchemas.full());
    }

    static {
        MessageInfoFactory messageInfoFactory;
        EMPTY_FACTORY = messageInfoFactory = new MessageInfoFactory(){

            @Override
            public MessageInfo messageInfoFor(Class clazz) {
                Object object = new IllegalStateException("This should never be called.");
                throw object;
            }

            @Override
            public boolean isSupported(Class clazz) {
                return false;
            }
        };
    }

    public ManifestSchemaFactory() {
        this(ManifestSchemaFactory.getDefaultMessageInfoFactory());
    }

    private ManifestSchemaFactory(MessageInfoFactory messageInfoFactory) {
        this.messageInfoFactory = (MessageInfoFactory)Internal.checkNotNull(messageInfoFactory, "messageInfoFactory");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isProto2(MessageInfo messageInfo) {
        if (messageInfo.getSyntax() != ProtoSyntax.PROTO2) return false;
        return true;
    }

    private static class CompositeMessageInfoFactory
    implements MessageInfoFactory {
        private MessageInfoFactory[] factories;

        @Override
        public MessageInfo messageInfoFor(Class object) {
            Object object2 = this.factories;
            int n = ((MessageInfoFactory[])object2).length;
            int n2 = 0;
            while (true) {
                if (n2 < n) {
                    MessageInfoFactory messageInfoFactory = object2[n2];
                    if (messageInfoFactory.isSupported((Class)object)) {
                        return messageInfoFactory.messageInfoFor((Class)object);
                    }
                } else {
                    object = ((Class)object).getName();
                    object2 = new StringBuilder();
                    UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException(((StringBuilder)object2).append("No factory is available for message type: ").append((String)object).toString());
                    throw unsupportedOperationException;
                }
                ++n2;
            }
        }

        CompositeMessageInfoFactory(MessageInfoFactory ... messageInfoFactoryArray) {
            this.factories = messageInfoFactoryArray;
        }

        @Override
        public boolean isSupported(Class clazz) {
            MessageInfoFactory[] messageInfoFactoryArray = this.factories;
            int n = messageInfoFactoryArray.length;
            for (int i = 0; i < n; ++i) {
                if (!messageInfoFactoryArray[i].isSupported(clazz)) continue;
                return true;
            }
            return false;
        }
    }
}

