/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.AbstractProtobufList;
import androidx.test.espresso.remote.internal.deps.protobuf.Internal;
import androidx.test.espresso.remote.internal.deps.protobuf.PrimitiveNonBoxingCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class LongArrayList
extends AbstractProtobufList
implements Internal.LongList,
RandomAccess,
PrimitiveNonBoxingCollection {
    private static final LongArrayList EMPTY_LIST;
    private long[] array;
    private int size;

    @Override
    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Internal.hashLong(this.array[i]);
        }
        return n;
    }

    @Override
    public int indexOf(Object object) {
        if (!(object instanceof Long)) {
            return -1;
        }
        long l = (Long)object;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.array[i] != l) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    public long getLong(int n) {
        this.ensureIndexInRange(n);
        return this.array[n];
    }

    public long setLong(int n, long l) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n);
        long[] lArray = this.array;
        long l2 = lArray[n];
        this.array[n] = l;
        return l2;
    }

    @Override
    public Internal.LongList mutableCopyWithCapacity(int n) {
        if (n < ((LongArrayList)object).size) {
            Object object = new IllegalArgumentException();
            throw object;
        }
        LongArrayList longArrayList = new LongArrayList(Arrays.copyOf(((LongArrayList)object).array, n), ((LongArrayList)object).size);
        return longArrayList;
    }

    public static LongArrayList emptyList() {
        return EMPTY_LIST;
    }

    @Override
    public Long get(int n) {
        return this.getLong(n);
    }

    @Override
    public Long remove(int n) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n);
        long l = this.array[n];
        if (n < this.size + -1) {
            System.arraycopy(this.array, n + 1, this.array, n, this.size - n + -1);
        }
        this.size += -1;
        ++this.modCount;
        return l;
    }

    @Override
    public Long set(int n, Long l) {
        return this.setLong(n, l);
    }

    private String makeOutOfBoundsExceptionMessage(int n) {
        int n2 = this.size;
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    static {
        LongArrayList longArrayList;
        EMPTY_LIST = longArrayList = new LongArrayList(new long[0], 0);
        EMPTY_LIST.makeImmutable();
    }

    LongArrayList() {
        this(new long[10], 0);
    }

    private LongArrayList(long[] lArray, int n) {
        this.array = lArray;
        this.size = n;
    }

    @Override
    public void add(int n, Long l) {
        this.addLong(n, l);
    }

    public void addLong(long l) {
        long[] lArray;
        this.ensureIsMutable();
        if (this.size == this.array.length) {
            lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.array, 0, lArray, 0, this.size);
            this.array = lArray;
        }
        lArray = this.array;
        int n = this.size;
        this.size = n + 1;
        lArray[n] = l;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addLong(int n, long l) {
        this.ensureIsMutable();
        if (n < 0 || n > this.size) {
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n));
            throw indexOutOfBoundsException;
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, n, this.array, n + 1, this.size - n);
        } else {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.array, 0, lArray, 0, n);
            System.arraycopy(this.array, n, lArray, n + 1, this.size - n);
            this.array = lArray;
        }
        this.array[n] = l;
        ++this.size;
        ++this.modCount;
    }

    private void ensureIndexInRange(int n) {
        if (n < 0 || n >= this.size) {
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n));
            throw indexOutOfBoundsException;
        }
    }

    @Override
    protected void removeRange(int n, int n2) {
        ((AbstractProtobufList)object).ensureIsMutable();
        if (n2 < n) {
            Object object = new IndexOutOfBoundsException("toIndex < fromIndex");
            throw object;
        }
        System.arraycopy(((LongArrayList)object).array, n2, ((LongArrayList)object).array, n, ((LongArrayList)object).size - n2);
        ((LongArrayList)object).size -= n2 - n;
        ++((LongArrayList)object).modCount;
    }

    @Override
    public boolean add(Long l) {
        this.addLong(l);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Long> longArrayList) {
        ((AbstractProtobufList)object).ensureIsMutable();
        Internal.checkNotNull(longArrayList);
        if (!(longArrayList instanceof LongArrayList)) {
            return super.addAll(longArrayList);
        }
        longArrayList = longArrayList;
        if (longArrayList.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - ((LongArrayList)object).size < longArrayList.size) {
            Object object = new OutOfMemoryError();
            throw object;
        }
        int n = ((LongArrayList)object).size + longArrayList.size;
        if (n > ((LongArrayList)object).array.length) {
            ((LongArrayList)object).array = Arrays.copyOf(((LongArrayList)object).array, n);
        }
        System.arraycopy(longArrayList.array, 0, ((LongArrayList)object).array, ((LongArrayList)object).size, longArrayList.size);
        ((LongArrayList)object).size = n;
        ++((LongArrayList)object).modCount;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean contains(Object object) {
        if (this.indexOf(object) == -1) return false;
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LongArrayList)) {
            return super.equals(object);
        }
        object = (LongArrayList)object;
        if (this.size != ((LongArrayList)object).size) {
            return false;
        }
        long[] lArray = ((LongArrayList)object).array;
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }
}

