/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.Internal;
import androidx.test.espresso.remote.internal.deps.protobuf.LazyStringArrayList;
import androidx.test.espresso.remote.internal.deps.protobuf.LazyStringList;
import androidx.test.espresso.remote.internal.deps.protobuf.ListFieldSchema-IA;
import androidx.test.espresso.remote.internal.deps.protobuf.PrimitiveNonBoxingCollection;
import androidx.test.espresso.remote.internal.deps.protobuf.UnmodifiableLazyStringList;
import androidx.test.espresso.remote.internal.deps.protobuf.UnsafeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

abstract class ListFieldSchema {
    private static final ListFieldSchema FULL_INSTANCE;
    private static final ListFieldSchema LITE_INSTANCE;

    static ListFieldSchema full() {
        return FULL_INSTANCE;
    }

    static ListFieldSchema lite() {
        return LITE_INSTANCE;
    }

    abstract List mutableListAt(Object var1, long var2);

    static {
        ListFieldSchema listFieldSchema = new ListFieldSchemaFull();
        FULL_INSTANCE = listFieldSchema;
        listFieldSchema = new ListFieldSchemaLite();
        LITE_INSTANCE = listFieldSchema;
    }

    private ListFieldSchema() {
    }

    /* synthetic */ ListFieldSchema(ListFieldSchema-IA listFieldSchema-IA) {
        this();
    }

    abstract void makeImmutableListAt(Object var1, long var2);

    abstract void mergeListsAt(Object var1, Object var2, long var3);

    private static final class ListFieldSchemaFull
    extends ListFieldSchema {
        private static final Class UNMODIFIABLE_LIST_CLASS = Collections.unmodifiableList(Collections.emptyList()).getClass();

        static List getList(Object object, long l) {
            return (List)UnsafeUtil.getObject(object, l);
        }

        @Override
        List mutableListAt(Object object, long l) {
            return ListFieldSchemaFull.mutableListAt(object, l, 10);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        private static List mutableListAt(Object abstractList, long l, int n) {
            void var0_2;
            void var3_9;
            void var1_8;
            ArrayList arrayList = ListFieldSchemaFull.getList(abstractList, (long)var1_8);
            if (arrayList.isEmpty()) {
                void var3_11;
                if (arrayList instanceof LazyStringList) {
                    ArrayList arrayList2 = arrayList = new ArrayList((int)var3_9);
                } else if (arrayList instanceof PrimitiveNonBoxingCollection && arrayList instanceof Internal.ProtobufList) {
                    Internal.ProtobufList protobufList = ((Internal.ProtobufList)((Object)arrayList)).mutableCopyWithCapacity((int)var3_9);
                } else {
                    ArrayList arrayList3 = arrayList = new ArrayList((int)var3_9);
                }
                UnsafeUtil.putObject(abstractList, (long)var1_8, var3_11);
                void var0_1 = var3_11;
                return var0_2;
            }
            if (UNMODIFIABLE_LIST_CLASS.isAssignableFrom(arrayList.getClass())) {
                ArrayList arrayList4 = new ArrayList(arrayList.size() + var3_9);
                arrayList4.addAll(arrayList);
                UnsafeUtil.putObject(abstractList, (long)var1_8, arrayList4);
                ArrayList arrayList5 = arrayList4;
                return var0_2;
            }
            if (arrayList instanceof UnmodifiableLazyStringList) {
                LazyStringArrayList lazyStringArrayList = new LazyStringArrayList(arrayList.size() + var3_9);
                lazyStringArrayList.addAll((UnmodifiableLazyStringList)((Object)arrayList));
                UnsafeUtil.putObject(abstractList, (long)var1_8, lazyStringArrayList);
                LazyStringArrayList lazyStringArrayList2 = lazyStringArrayList;
                return var0_2;
            }
            if (!(arrayList instanceof PrimitiveNonBoxingCollection)) {
                ArrayList arrayList6 = arrayList;
                return var0_2;
            }
            if (!(arrayList instanceof Internal.ProtobufList)) {
                ArrayList arrayList7 = arrayList;
                return var0_2;
            }
            if (((Internal.ProtobufList)((Object)arrayList)).isModifiable()) {
                ArrayList arrayList8 = arrayList;
                return var0_2;
            }
            Internal.ProtobufList protobufList = ((Internal.ProtobufList)((Object)arrayList)).mutableCopyWithCapacity(arrayList.size() + var3_9);
            UnsafeUtil.putObject(abstractList, (long)var1_8, protobufList);
            return protobufList;
        }

        private ListFieldSchemaFull() {
            super(null);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        void makeImmutableListAt(Object object, long l) {
            List list = (List)UnsafeUtil.getObject(object, l);
            if (list instanceof LazyStringList) {
                list = ((LazyStringList)list).getUnmodifiableView();
            } else {
                if (UNMODIFIABLE_LIST_CLASS.isAssignableFrom(list.getClass())) {
                    return;
                }
                if (list instanceof PrimitiveNonBoxingCollection && list instanceof Internal.ProtobufList) {
                    if (((Internal.ProtobufList)list).isModifiable()) {
                        ((Internal.ProtobufList)list).makeImmutable();
                        return;
                    }
                    return;
                }
                list = Collections.unmodifiableList(list);
            }
            UnsafeUtil.putObject(object, l, list);
        }

        @Override
        void mergeListsAt(Object object, Object object2, long l) {
            Object object3 = ListFieldSchemaFull.getList(object2, l);
            object2 = ListFieldSchemaFull.mutableListAt(object, l, object3.size());
            int n = object2.size();
            int n2 = object3.size();
            if (n > 0 && n2 > 0) {
                object2.addAll(object3);
            }
            if (n > 0) {
                object3 = object2;
            }
            UnsafeUtil.putObject(object, l, object3);
        }
    }

    private static final class ListFieldSchemaLite
    extends ListFieldSchema {
        static Internal.ProtobufList getProtobufList(Object object, long l) {
            return (Internal.ProtobufList)UnsafeUtil.getObject(object, l);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        List mutableListAt(Object object, long l) {
            Internal.ProtobufList protobufList = ListFieldSchemaLite.getProtobufList(object, l);
            if (protobufList.isModifiable()) {
                return protobufList;
            }
            int n = protobufList.size();
            n = n == 0 ? 10 : (n += n);
            Internal.ProtobufList protobufList2 = protobufList.mutableCopyWithCapacity(n);
            UnsafeUtil.putObject(object, l, protobufList2);
            return protobufList2;
        }

        private ListFieldSchemaLite() {
            super(null);
        }

        @Override
        void makeImmutableListAt(Object object, long l) {
            ListFieldSchemaLite.getProtobufList(object, l).makeImmutable();
        }

        @Override
        void mergeListsAt(Object object, Object object2, long l) {
            Object object3 = ListFieldSchemaLite.getProtobufList(object, l);
            object2 = ListFieldSchemaLite.getProtobufList(object2, l);
            int n = object3.size();
            int n2 = object2.size();
            if (n > 0 && n2 > 0) {
                if (!object3.isModifiable()) {
                    object3 = object3.mutableCopyWithCapacity(n + n2);
                }
                object3.addAll(object2);
            }
            if (n <= 0) {
                object3 = object2;
            }
            UnsafeUtil.putObject(object, l, object3);
        }
    }
}

