/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.AbstractProtobufList;
import androidx.test.espresso.remote.internal.deps.protobuf.ByteString;
import androidx.test.espresso.remote.internal.deps.protobuf.Internal;
import androidx.test.espresso.remote.internal.deps.protobuf.LazyStringList;
import androidx.test.espresso.remote.internal.deps.protobuf.UnmodifiableLazyStringList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

public class LazyStringArrayList
extends AbstractProtobufList
implements LazyStringList,
RandomAccess {
    private static final LazyStringArrayList EMPTY_LIST;
    public static final LazyStringList EMPTY;
    private final List list;

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public LazyStringArrayList mutableCopyWithCapacity(int n) {
        Object object;
        if (n < ((LazyStringArrayList)object).size()) {
            object = new IllegalArgumentException();
            throw object;
        }
        ArrayList arrayList = new ArrayList(n);
        arrayList.addAll(((LazyStringArrayList)object).list);
        object = new LazyStringArrayList(arrayList);
        return object;
    }

    @Override
    public LazyStringList getUnmodifiableView() {
        if (this.isModifiable()) {
            UnmodifiableLazyStringList unmodifiableLazyStringList = new UnmodifiableLazyStringList(this);
            return unmodifiableLazyStringList;
        }
        return this;
    }

    @Override
    public Object getRaw(int n) {
        return this.list.get(n);
    }

    private static String asString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof ByteString) {
            return ((ByteString)object).toStringUtf8();
        }
        return Internal.toStringUtf8((byte[])object);
    }

    @Override
    public String get(int n) {
        Object object = this.list.get(n);
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof ByteString) {
            object = (ByteString)object;
            String string = ((ByteString)object).toStringUtf8();
            if (((ByteString)object).isValidUtf8()) {
                this.list.set(n, string);
            }
            return string;
        }
        object = (byte[])object;
        String string = Internal.toStringUtf8((byte[])object);
        if (Internal.isValidUtf8((byte[])object)) {
            this.list.set(n, string);
        }
        return string;
    }

    @Override
    public String remove(int n) {
        this.ensureIsMutable();
        List list = this.list;
        Object e = list.remove(n);
        ++this.modCount;
        return LazyStringArrayList.asString(e);
    }

    @Override
    public String set(int n, String string) {
        this.ensureIsMutable();
        return LazyStringArrayList.asString(this.list.set(n, string));
    }

    @Override
    public List getUnderlyingElements() {
        return Collections.unmodifiableList(this.list);
    }

    static {
        LazyStringArrayList lazyStringArrayList;
        EMPTY_LIST = lazyStringArrayList = new LazyStringArrayList();
        EMPTY_LIST.makeImmutable();
        EMPTY = EMPTY_LIST;
    }

    public LazyStringArrayList() {
        this(10);
    }

    public LazyStringArrayList(int n) {
        ArrayList arrayList = new ArrayList(n);
        this(arrayList);
    }

    private LazyStringArrayList(ArrayList arrayList) {
        this.list = arrayList;
    }

    @Override
    public void add(ByteString byteString) {
        this.ensureIsMutable();
        this.list.add(byteString);
        ++this.modCount;
    }

    @Override
    public void add(int n, String string) {
        this.ensureIsMutable();
        this.list.add(n, string);
        ++this.modCount;
    }

    @Override
    public void clear() {
        this.ensureIsMutable();
        this.list.clear();
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends String> collection) {
        return this.addAll(this.size(), collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends String> list) {
        this.ensureIsMutable();
        if (list instanceof LazyStringList) {
            list = ((LazyStringList)list).getUnderlyingElements();
        }
        List list2 = this.list;
        n = list2.addAll(n, list) ? 1 : 0;
        ++this.modCount;
        return n != 0;
    }
}

