/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.ByteString;
import androidx.test.espresso.remote.internal.deps.protobuf.ExtensionRegistryLite;
import androidx.test.espresso.remote.internal.deps.protobuf.InvalidProtocolBufferException;
import androidx.test.espresso.remote.internal.deps.protobuf.MessageLite;

public class LazyFieldLite {
    private static final ExtensionRegistryLite EMPTY_REGISTRY = ExtensionRegistryLite.getEmptyRegistry();
    private ByteString delayedBytes;
    private ExtensionRegistryLite extensionRegistry;
    protected volatile MessageLite value;
    private volatile ByteString memoizedBytes;

    public int getSerializedSize() {
        if (this.memoizedBytes != null) {
            return this.memoizedBytes.size();
        }
        if (this.delayedBytes != null) {
            return this.delayedBytes.size();
        }
        if (this.value != null) {
            return this.value.getSerializedSize();
        }
        return 0;
    }

    public int hashCode() {
        return 1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteString toByteString() {
        if (this.memoizedBytes != null) {
            return this.memoizedBytes;
        }
        if (this.delayedBytes != null) {
            return this.delayedBytes;
        }
        synchronized (this) {
            Object object = this.memoizedBytes;
            if (object != null) {
                return this.memoizedBytes;
            }
            object = this.value;
            this.memoizedBytes = object == null ? ByteString.EMPTY : this.value.toByteString();
            return this.memoizedBytes;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public MessageLite getValue(MessageLite messageLite) {
        this.ensureInitialized(messageLite);
        return this.value;
    }

    public MessageLite setValue(MessageLite messageLite) {
        MessageLite messageLite2 = this.value;
        this.delayedBytes = null;
        this.memoizedBytes = null;
        this.value = messageLite;
        return messageLite2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void ensureInitialized(MessageLite messageLite) {
        if (this.value != null) {
            return;
        }
        synchronized (this) {
            Object object = this.value;
            if (object != null) {
                return;
            }
            try {
                object = this.delayedBytes;
                if (object != null) {
                    this.value = (MessageLite)messageLite.getParserForType().parseFrom(this.delayedBytes, this.extensionRegistry);
                    this.memoizedBytes = this.delayedBytes;
                } else {
                    this.value = messageLite;
                    this.memoizedBytes = ByteString.EMPTY;
                }
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                this.value = messageLite;
                this.memoizedBytes = ByteString.EMPTY;
            }
            return;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LazyFieldLite)) {
            return false;
        }
        object = (LazyFieldLite)object;
        MessageLite messageLite = this.value;
        MessageLite messageLite2 = ((LazyFieldLite)object).value;
        if (messageLite == null && messageLite2 == null) {
            return this.toByteString().equals(((LazyFieldLite)object).toByteString());
        }
        if (messageLite != null && messageLite2 != null) {
            return messageLite.equals(messageLite2);
        }
        if (messageLite != null) {
            return messageLite.equals(((LazyFieldLite)object).getValue(messageLite.getDefaultInstanceForType()));
        }
        return this.getValue(messageLite2.getDefaultInstanceForType()).equals(messageLite2);
    }
}

