/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.MessageLite;
import java.io.IOException;

public class InvalidProtocolBufferException
extends IOException {
    private static final long serialVersionUID = -1616151763072450476L;
    private MessageLite unfinishedMessage = null;
    private boolean wasThrownFromInputStream;

    static InvalidWireTypeException invalidWireType() {
        InvalidWireTypeException invalidWireTypeException = new InvalidWireTypeException("Protocol message tag had invalid wire type.");
        return invalidWireTypeException;
    }

    static InvalidProtocolBufferException invalidEndTag() {
        InvalidProtocolBufferException invalidProtocolBufferException = new InvalidProtocolBufferException("Protocol message end-group tag did not match expected tag.");
        return invalidProtocolBufferException;
    }

    static InvalidProtocolBufferException invalidTag() {
        InvalidProtocolBufferException invalidProtocolBufferException = new InvalidProtocolBufferException("Protocol message contained an invalid tag (zero).");
        return invalidProtocolBufferException;
    }

    static InvalidProtocolBufferException invalidUtf8() {
        InvalidProtocolBufferException invalidProtocolBufferException = new InvalidProtocolBufferException("Protocol message had invalid UTF-8.");
        return invalidProtocolBufferException;
    }

    static InvalidProtocolBufferException malformedVarint() {
        InvalidProtocolBufferException invalidProtocolBufferException = new InvalidProtocolBufferException("CodedInputStream encountered a malformed varint.");
        return invalidProtocolBufferException;
    }

    static InvalidProtocolBufferException negativeSize() {
        InvalidProtocolBufferException invalidProtocolBufferException = new InvalidProtocolBufferException("CodedInputStream encountered an embedded string or message which claimed to have negative size.");
        return invalidProtocolBufferException;
    }

    static InvalidProtocolBufferException parseFailure() {
        InvalidProtocolBufferException invalidProtocolBufferException = new InvalidProtocolBufferException("Failed to parse the message.");
        return invalidProtocolBufferException;
    }

    static InvalidProtocolBufferException recursionLimitExceeded() {
        InvalidProtocolBufferException invalidProtocolBufferException = new InvalidProtocolBufferException("Protocol message had too many levels of nesting.  May be malicious.  Use CodedInputStream.setRecursionLimit() to increase the depth limit.");
        return invalidProtocolBufferException;
    }

    public InvalidProtocolBufferException setUnfinishedMessage(MessageLite messageLite) {
        this.unfinishedMessage = messageLite;
        return this;
    }

    static InvalidProtocolBufferException sizeLimitExceeded() {
        InvalidProtocolBufferException invalidProtocolBufferException = new InvalidProtocolBufferException("Protocol message was too large.  May be malicious.  Use CodedInputStream.setSizeLimit() to increase the size limit.");
        return invalidProtocolBufferException;
    }

    static InvalidProtocolBufferException truncatedMessage() {
        InvalidProtocolBufferException invalidProtocolBufferException = new InvalidProtocolBufferException("While parsing a protocol message, the input ended unexpectedly in the middle of a field.  This could mean either that the input has been truncated or that an embedded message misreported its own length.");
        return invalidProtocolBufferException;
    }

    public InvalidProtocolBufferException(IOException iOException) {
        super(iOException.getMessage(), iOException);
    }

    public InvalidProtocolBufferException(String string) {
        super(string);
    }

    void setThrownFromInputStream() {
        this.wasThrownFromInputStream = true;
    }

    boolean getThrownFromInputStream() {
        return this.wasThrownFromInputStream;
    }

    public static class InvalidWireTypeException
    extends InvalidProtocolBufferException {
        private static final long serialVersionUID = 3283890091615336259L;

        public InvalidWireTypeException(String string) {
            super(string);
        }
    }
}

