/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.AbstractProtobufList;
import androidx.test.espresso.remote.internal.deps.protobuf.Internal;
import androidx.test.espresso.remote.internal.deps.protobuf.PrimitiveNonBoxingCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class IntArrayList
extends AbstractProtobufList
implements Internal.IntList,
RandomAccess,
PrimitiveNonBoxingCollection {
    private static final IntArrayList EMPTY_LIST;
    private int[] array;
    private int size;

    public int getInt(int n) {
        this.ensureIndexInRange(n);
        return this.array[n];
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.array[i];
        }
        return n;
    }

    @Override
    public int indexOf(Object object) {
        if (!(object instanceof Integer)) {
            return -1;
        }
        int n = (Integer)object;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            if (this.array[i] != n) continue;
            return i;
        }
        return -1;
    }

    public int setInt(int n, int n2) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n);
        int[] nArray = this.array;
        int n3 = nArray[n];
        this.array[n] = n2;
        return n3;
    }

    @Override
    public int size() {
        return this.size;
    }

    public static IntArrayList emptyList() {
        return EMPTY_LIST;
    }

    @Override
    public Internal.IntList mutableCopyWithCapacity(int n) {
        if (n < ((IntArrayList)object).size) {
            Object object = new IllegalArgumentException();
            throw object;
        }
        IntArrayList intArrayList = new IntArrayList(Arrays.copyOf(((IntArrayList)object).array, n), ((IntArrayList)object).size);
        return intArrayList;
    }

    @Override
    public Integer get(int n) {
        return this.getInt(n);
    }

    @Override
    public Integer remove(int n) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n);
        int n2 = this.array[n];
        if (n < this.size + -1) {
            System.arraycopy(this.array, n + 1, this.array, n, this.size - n + -1);
        }
        this.size += -1;
        ++this.modCount;
        return n2;
    }

    @Override
    public Integer set(int n, Integer n2) {
        return this.setInt(n, n2);
    }

    private String makeOutOfBoundsExceptionMessage(int n) {
        int n2 = this.size;
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    static {
        IntArrayList intArrayList;
        EMPTY_LIST = intArrayList = new IntArrayList(new int[0], 0);
        EMPTY_LIST.makeImmutable();
    }

    IntArrayList() {
        this(new int[10], 0);
    }

    private IntArrayList(int[] nArray, int n) {
        this.array = nArray;
        this.size = n;
    }

    @Override
    public void add(int n, Integer n2) {
        this.addInt(n, n2);
    }

    public void addInt(int n) {
        int[] nArray;
        this.ensureIsMutable();
        if (this.size == this.array.length) {
            nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.array, 0, nArray, 0, this.size);
            this.array = nArray;
        }
        nArray = this.array;
        int n2 = this.size;
        this.size = n2 + 1;
        nArray[n2] = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addInt(int n, int n2) {
        this.ensureIsMutable();
        if (n < 0 || n > this.size) {
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n));
            throw indexOutOfBoundsException;
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, n, this.array, n + 1, this.size - n);
        } else {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.array, 0, nArray, 0, n);
            System.arraycopy(this.array, n, nArray, n + 1, this.size - n);
            this.array = nArray;
        }
        this.array[n] = n2;
        ++this.size;
        ++this.modCount;
    }

    private void ensureIndexInRange(int n) {
        if (n < 0 || n >= this.size) {
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n));
            throw indexOutOfBoundsException;
        }
    }

    @Override
    protected void removeRange(int n, int n2) {
        ((AbstractProtobufList)object).ensureIsMutable();
        if (n2 < n) {
            Object object = new IndexOutOfBoundsException("toIndex < fromIndex");
            throw object;
        }
        System.arraycopy(((IntArrayList)object).array, n2, ((IntArrayList)object).array, n, ((IntArrayList)object).size - n2);
        ((IntArrayList)object).size -= n2 - n;
        ++((IntArrayList)object).modCount;
    }

    @Override
    public boolean add(Integer n) {
        this.addInt(n);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> intArrayList) {
        ((AbstractProtobufList)object).ensureIsMutable();
        Internal.checkNotNull(intArrayList);
        if (!(intArrayList instanceof IntArrayList)) {
            return super.addAll(intArrayList);
        }
        intArrayList = intArrayList;
        if (intArrayList.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - ((IntArrayList)object).size < intArrayList.size) {
            Object object = new OutOfMemoryError();
            throw object;
        }
        int n = ((IntArrayList)object).size + intArrayList.size;
        if (n > ((IntArrayList)object).array.length) {
            ((IntArrayList)object).array = Arrays.copyOf(((IntArrayList)object).array, n);
        }
        System.arraycopy(intArrayList.array, 0, ((IntArrayList)object).array, ((IntArrayList)object).size, intArrayList.size);
        ((IntArrayList)object).size = n;
        ++((IntArrayList)object).modCount;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean contains(Object object) {
        if (this.indexOf(object) == -1) return false;
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IntArrayList)) {
            return super.equals(object);
        }
        object = (IntArrayList)object;
        if (this.size != ((IntArrayList)object).size) {
            return false;
        }
        int[] nArray = ((IntArrayList)object).array;
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }
}

