/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.AbstractProtobufList;
import androidx.test.espresso.remote.internal.deps.protobuf.Internal;
import androidx.test.espresso.remote.internal.deps.protobuf.PrimitiveNonBoxingCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class FloatArrayList
extends AbstractProtobufList
implements Internal.FloatList,
RandomAccess,
PrimitiveNonBoxingCollection {
    private static final FloatArrayList EMPTY_LIST;
    private float[] array;
    private int size;

    public float getFloat(int n) {
        this.ensureIndexInRange(n);
        return this.array[n];
    }

    public float setFloat(int n, float f) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n);
        float[] fArray = this.array;
        float f2 = fArray[n];
        this.array[n] = f;
        return f2;
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Float.floatToIntBits(this.array[i]);
        }
        return n;
    }

    @Override
    public int indexOf(Object object) {
        if (!(object instanceof Float)) {
            return -1;
        }
        float f = ((Float)object).floatValue();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.array[i] != f) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    public static FloatArrayList emptyList() {
        return EMPTY_LIST;
    }

    @Override
    public Internal.FloatList mutableCopyWithCapacity(int n) {
        if (n < ((FloatArrayList)object).size) {
            Object object = new IllegalArgumentException();
            throw object;
        }
        FloatArrayList floatArrayList = new FloatArrayList(Arrays.copyOf(((FloatArrayList)object).array, n), ((FloatArrayList)object).size);
        return floatArrayList;
    }

    @Override
    public Float get(int n) {
        return Float.valueOf(this.getFloat(n));
    }

    @Override
    public Float remove(int n) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n);
        float f = this.array[n];
        if (n < this.size + -1) {
            System.arraycopy(this.array, n + 1, this.array, n, this.size - n + -1);
        }
        this.size += -1;
        ++this.modCount;
        return Float.valueOf(f);
    }

    @Override
    public Float set(int n, Float f) {
        return Float.valueOf(this.setFloat(n, f.floatValue()));
    }

    private String makeOutOfBoundsExceptionMessage(int n) {
        int n2 = this.size;
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    static {
        FloatArrayList floatArrayList;
        EMPTY_LIST = floatArrayList = new FloatArrayList(new float[0], 0);
        EMPTY_LIST.makeImmutable();
    }

    FloatArrayList() {
        this(new float[10], 0);
    }

    private FloatArrayList(float[] fArray, int n) {
        this.array = fArray;
        this.size = n;
    }

    @Override
    public void add(int n, Float f) {
        this.addFloat(n, f.floatValue());
    }

    public void addFloat(float f) {
        float[] fArray;
        this.ensureIsMutable();
        if (this.size == this.array.length) {
            fArray = new float[this.size * 3 / 2 + 1];
            System.arraycopy(this.array, 0, fArray, 0, this.size);
            this.array = fArray;
        }
        fArray = this.array;
        int n = this.size;
        this.size = n + 1;
        fArray[n] = f;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addFloat(int n, float f) {
        this.ensureIsMutable();
        if (n < 0 || n > this.size) {
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n));
            throw indexOutOfBoundsException;
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, n, this.array, n + 1, this.size - n);
        } else {
            float[] fArray = new float[this.size * 3 / 2 + 1];
            System.arraycopy(this.array, 0, fArray, 0, n);
            System.arraycopy(this.array, n, fArray, n + 1, this.size - n);
            this.array = fArray;
        }
        this.array[n] = f;
        ++this.size;
        ++this.modCount;
    }

    private void ensureIndexInRange(int n) {
        if (n < 0 || n >= this.size) {
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n));
            throw indexOutOfBoundsException;
        }
    }

    @Override
    protected void removeRange(int n, int n2) {
        ((AbstractProtobufList)object).ensureIsMutable();
        if (n2 < n) {
            Object object = new IndexOutOfBoundsException("toIndex < fromIndex");
            throw object;
        }
        System.arraycopy(((FloatArrayList)object).array, n2, ((FloatArrayList)object).array, n, ((FloatArrayList)object).size - n2);
        ((FloatArrayList)object).size -= n2 - n;
        ++((FloatArrayList)object).modCount;
    }

    @Override
    public boolean add(Float f) {
        this.addFloat(f.floatValue());
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Float> floatArrayList) {
        ((AbstractProtobufList)object).ensureIsMutable();
        Internal.checkNotNull(floatArrayList);
        if (!(floatArrayList instanceof FloatArrayList)) {
            return super.addAll(floatArrayList);
        }
        floatArrayList = floatArrayList;
        if (floatArrayList.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - ((FloatArrayList)object).size < floatArrayList.size) {
            Object object = new OutOfMemoryError();
            throw object;
        }
        int n = ((FloatArrayList)object).size + floatArrayList.size;
        if (n > ((FloatArrayList)object).array.length) {
            ((FloatArrayList)object).array = Arrays.copyOf(((FloatArrayList)object).array, n);
        }
        System.arraycopy(floatArrayList.array, 0, ((FloatArrayList)object).array, ((FloatArrayList)object).size, floatArrayList.size);
        ((FloatArrayList)object).size = n;
        ++((FloatArrayList)object).modCount;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean contains(Object object) {
        if (this.indexOf(object) == -1) return false;
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FloatArrayList)) {
            return super.equals(object);
        }
        object = (FloatArrayList)object;
        if (this.size != ((FloatArrayList)object).size) {
            return false;
        }
        float[] fArray = ((FloatArrayList)object).array;
        for (int i = 0; i < this.size; ++i) {
            if (Float.floatToIntBits(this.array[i]) == Float.floatToIntBits(fArray[i])) continue;
            return false;
        }
        return true;
    }
}

