/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.ByteString;
import androidx.test.espresso.remote.internal.deps.protobuf.CodedOutputStream;
import androidx.test.espresso.remote.internal.deps.protobuf.Internal;
import androidx.test.espresso.remote.internal.deps.protobuf.LazyField;
import androidx.test.espresso.remote.internal.deps.protobuf.MessageLite;
import androidx.test.espresso.remote.internal.deps.protobuf.MessageLiteOrBuilder;
import androidx.test.espresso.remote.internal.deps.protobuf.MutableMessageLite;
import androidx.test.espresso.remote.internal.deps.protobuf.SmallSortedMap;
import androidx.test.espresso.remote.internal.deps.protobuf.WireFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class FieldSet {
    private static final FieldSet DEFAULT_INSTANCE;
    final SmallSortedMap fields;
    private boolean isImmutable;
    private boolean hasLazyField;

    static int computeElementSize(WireFormat.FieldType fieldType, int n, Object object) {
        n = CodedOutputStream.computeTagSize(n);
        if (fieldType == WireFormat.FieldType.GROUP && !Internal.isProto1Group((MessageLite)object)) {
            n += n;
        }
        return n + FieldSet.computeElementSizeNoTag(fieldType, object);
    }

    static int computeElementSizeNoTag(WireFormat.FieldType object, Object object2) {
        switch (object) {
            case ENUM: {
                if (object2 instanceof Internal.EnumLite) {
                    return CodedOutputStream.computeEnumSizeNoTag(((Internal.EnumLite)object2).getNumber());
                }
                return CodedOutputStream.computeEnumSizeNoTag((Integer)object2);
            }
            case SINT64: {
                return CodedOutputStream.computeSInt64SizeNoTag((Long)object2);
            }
            case SINT32: {
                return CodedOutputStream.computeSInt32SizeNoTag((Integer)object2);
            }
            case SFIXED64: {
                return CodedOutputStream.computeSFixed64SizeNoTag((Long)object2);
            }
            case SFIXED32: {
                return CodedOutputStream.computeSFixed32SizeNoTag((Integer)object2);
            }
            case UINT32: {
                return CodedOutputStream.computeUInt32SizeNoTag((Integer)object2);
            }
            case BYTES: {
                if (object2 instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)object2);
                }
                return CodedOutputStream.computeByteArraySizeNoTag((byte[])object2);
            }
            case STRING: {
                if (object2 instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)object2);
                }
                return CodedOutputStream.computeStringSizeNoTag((String)object2);
            }
            case MESSAGE: {
                if (object2 instanceof LazyField) {
                    return CodedOutputStream.computeLazyFieldSizeNoTag((LazyField)object2);
                }
                return CodedOutputStream.computeMessageSizeNoTag((MessageLite)object2);
            }
            case GROUP: {
                return CodedOutputStream.computeGroupSizeNoTag((MessageLite)object2);
            }
            case BOOL: {
                return CodedOutputStream.computeBoolSizeNoTag((Boolean)object2);
            }
            case FIXED32: {
                return CodedOutputStream.computeFixed32SizeNoTag((Integer)object2);
            }
            case FIXED64: {
                return CodedOutputStream.computeFixed64SizeNoTag((Long)object2);
            }
            case INT32: {
                return CodedOutputStream.computeInt32SizeNoTag((Integer)object2);
            }
            case UINT64: {
                return CodedOutputStream.computeUInt64SizeNoTag((Long)object2);
            }
            case INT64: {
                return CodedOutputStream.computeInt64SizeNoTag((Long)object2);
            }
            case FLOAT: {
                return CodedOutputStream.computeFloatSizeNoTag(((Float)object2).floatValue());
            }
            default: {
                object = new RuntimeException("There is no way to get here, but the compiler thinks otherwise.");
                throw object;
            }
            case DOUBLE: 
        }
        return CodedOutputStream.computeDoubleSizeNoTag((Double)object2);
    }

    public static int computeFieldSize(FieldDescriptorLite fieldDescriptorLite, Object iterator) {
        WireFormat.FieldType fieldType = fieldDescriptorLite.getLiteType();
        int n = fieldDescriptorLite.getNumber();
        if (fieldDescriptorLite.isRepeated()) {
            iterator = (List)((Object)iterator);
            if (fieldDescriptorLite.isPacked()) {
                if (iterator.isEmpty()) {
                    return 0;
                }
                iterator = iterator.iterator();
                int n2 = 0;
                while (iterator.hasNext()) {
                    n2 += FieldSet.computeElementSizeNoTag(fieldType, iterator.next());
                }
                return n2 + CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeUInt32SizeNoTag(n2);
            }
            iterator = iterator.iterator();
            int n3 = 0;
            while (iterator.hasNext()) {
                n3 += FieldSet.computeElementSize(fieldType, n, iterator.next());
            }
            return n3;
        }
        return FieldSet.computeElementSize(fieldType, n, iterator);
    }

    public int getMessageSetSerializedSize() {
        int n = 0;
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            n += this.getMessageSetSerializedSize(this.fields.getArrayEntryAt(i));
        }
        Iterator iterator = this.fields.getOverflowEntries().iterator();
        while (iterator.hasNext()) {
            n += this.getMessageSetSerializedSize((Map.Entry)iterator.next());
        }
        return n;
    }

    private int getMessageSetSerializedSize(Map.Entry entry) {
        FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
        Object v = entry.getValue();
        if (fieldDescriptorLite.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !fieldDescriptorLite.isRepeated() && !fieldDescriptorLite.isPacked()) {
            if (v instanceof LazyField) {
                return CodedOutputStream.computeLazyFieldMessageSetExtensionSize(((FieldDescriptorLite)entry.getKey()).getNumber(), (LazyField)v);
            }
            return CodedOutputStream.computeMessageSetExtensionSize(((FieldDescriptorLite)entry.getKey()).getNumber(), (MessageLite)v);
        }
        return FieldSet.computeFieldSize(fieldDescriptorLite, v);
    }

    public int getSerializedSize() {
        int n = 0;
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            Map.Entry entry = this.fields.getArrayEntryAt(i);
            n += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        Iterator iterator = this.fields.getOverflowEntries().iterator();
        int n2 = n;
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            n2 += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        return n2;
    }

    static int getWireFormatForFieldType(WireFormat.FieldType fieldType, boolean bl) {
        if (bl) {
            return 2;
        }
        return fieldType.getWireType();
    }

    public int hashCode() {
        return this.fields.hashCode();
    }

    public FieldSet clone() {
        FieldSet fieldSet = FieldSet.newFieldSet();
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            Map.Entry entry = this.fields.getArrayEntryAt(i);
            fieldSet.setField((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : this.fields.getOverflowEntries()) {
            fieldSet.setField((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        fieldSet.hasLazyField = this.hasLazyField;
        return fieldSet;
    }

    public static FieldSet emptySet() {
        return DEFAULT_INSTANCE;
    }

    public static FieldSet newFieldSet() {
        FieldSet fieldSet = new FieldSet();
        return fieldSet;
    }

    private static Object cloneIfMutable(Object object) {
        if (object instanceof MutableMessageLite) {
            return ((MutableMessageLite)object).clone();
        }
        if (object instanceof byte[]) {
            object = (byte[])object;
            byte[] byArray = new byte[((Object)object).length];
            System.arraycopy(object, 0, byArray, 0, ((Object)object).length);
            return byArray;
        }
        return object;
    }

    public Object getField(FieldDescriptorLite fieldDescriptorLite) {
        FieldSet fieldSet = fieldSet.fields.get(fieldDescriptorLite);
        if (fieldSet instanceof LazyField) {
            return ((LazyField)((Object)fieldSet)).getValue();
        }
        return fieldSet;
    }

    Iterator descendingIterator() {
        if (this.hasLazyField) {
            LazyField.LazyIterator lazyIterator = new LazyField.LazyIterator(this.fields.descendingEntrySet().iterator());
            return lazyIterator;
        }
        return this.fields.descendingEntrySet().iterator();
    }

    public Iterator iterator() {
        if (this.hasLazyField) {
            LazyField.LazyIterator lazyIterator = new LazyField.LazyIterator(this.fields.entrySet().iterator());
            return lazyIterator;
        }
        return this.fields.entrySet().iterator();
    }

    static {
        FieldSet fieldSet;
        DEFAULT_INSTANCE = fieldSet = new FieldSet(true);
    }

    private FieldSet() {
        this.fields = SmallSortedMap.newFieldMap(16);
    }

    private FieldSet(SmallSortedMap smallSortedMap) {
        this.fields = smallSortedMap;
        this.makeImmutable();
    }

    private FieldSet(boolean bl) {
        this(SmallSortedMap.newFieldMap(0));
        this.makeImmutable();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addRepeatedField(FieldDescriptorLite fieldDescriptorLite, Object object) {
        ArrayList<Object> arrayList;
        if (!fieldDescriptorLite.isRepeated()) {
            arrayList = new ArrayList<Object>("addRepeatedField() can only be called on repeated fields.");
            throw arrayList;
        }
        ((FieldSet)((Object)arrayList)).verifyType(fieldDescriptorLite, object);
        ArrayList<Object> arrayList2 = ((FieldSet)((Object)arrayList)).getField(fieldDescriptorLite);
        if (arrayList2 == null) {
            arrayList2 = new ArrayList<Object>();
            ((FieldSet)((Object)arrayList)).fields.put(fieldDescriptorLite, (Object)arrayList2);
            arrayList = arrayList2;
        } else {
            arrayList = arrayList2;
        }
        arrayList.add(object);
    }

    public void makeImmutable() {
        if (this.isImmutable) {
            return;
        }
        this.fields.makeImmutable();
        this.isImmutable = true;
    }

    public void mergeFrom(FieldSet object) {
        for (int i = 0; i < ((FieldSet)object).fields.getNumArrayEntries(); ++i) {
            this.mergeFromField(((FieldSet)object).fields.getArrayEntryAt(i));
        }
        object = ((FieldSet)object).fields.getOverflowEntries().iterator();
        while (object.hasNext()) {
            this.mergeFromField((Map.Entry)object.next());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void mergeFromField(Map.Entry object) {
        FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)object.getKey();
        if ((object = object.getValue()) instanceof LazyField) {
            object = ((LazyField)object).getValue();
        }
        if (fieldDescriptorLite.isRepeated()) {
            ArrayList arrayList = this.getField(fieldDescriptorLite);
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            object = ((List)object).iterator();
            while (true) {
                if (!object.hasNext()) {
                    this.fields.put(fieldDescriptorLite, (Object)arrayList);
                    return;
                }
                Object e = object.next();
                ((List)arrayList).add(FieldSet.cloneIfMutable(e));
            }
        }
        if (fieldDescriptorLite.getLiteJavaType() != WireFormat.JavaType.MESSAGE) {
            this.fields.put(fieldDescriptorLite, FieldSet.cloneIfMutable(object));
            return;
        }
        Object object2 = this.getField(fieldDescriptorLite);
        if (object2 == null) {
            this.fields.put(fieldDescriptorLite, FieldSet.cloneIfMutable(object));
            return;
        }
        object = object2 instanceof MutableMessageLite ? fieldDescriptorLite.internalMergeFrom((MutableMessageLite)object2, (MutableMessageLite)object) : fieldDescriptorLite.internalMergeFrom(((MessageLite)object2).toBuilder(), (MessageLite)object).build();
        this.fields.put(fieldDescriptorLite, object);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setField(FieldDescriptorLite fieldDescriptorLite, Object object) {
        if (fieldDescriptorLite.isRepeated()) {
            if (!(object instanceof List)) {
                Object object2 = new IllegalArgumentException("Wrong object type used with protocol message reflection.");
                throw object2;
            }
            ArrayList arrayList = new ArrayList();
            arrayList.addAll((List)object);
            object = arrayList.iterator();
            while (object.hasNext()) {
                super.verifyType(fieldDescriptorLite, object.next());
            }
            object = arrayList;
        } else {
            ((FieldSet)object2).verifyType(fieldDescriptorLite, object);
        }
        if (object instanceof LazyField) {
            ((FieldSet)object2).hasLazyField = true;
        }
        ((FieldSet)object2).fields.put(fieldDescriptorLite, object);
    }

    private void verifyType(FieldDescriptorLite fieldDescriptorLite, Object object) {
        if (!FieldSet.isValidType(fieldDescriptorLite.getLiteType(), object)) {
            Object[] objectArray = new Object[]{fieldDescriptorLite.getNumber(), fieldDescriptorLite.getLiteType().getJavaType(), object.getClass().getName()};
            Object object2 = new IllegalArgumentException(String.format("Wrong object type used with protocol message reflection.\nField number: %d, field java type: %s, value type: %s\n", objectArray));
            throw object2;
        }
    }

    static void writeElement(CodedOutputStream codedOutputStream, WireFormat.FieldType fieldType, int n, Object object) throws IOException {
        if (fieldType == WireFormat.FieldType.GROUP) {
            if (Internal.isProto1Group((MessageLite)object)) {
                codedOutputStream.writeTag(n, 3);
                codedOutputStream.writeGroupNoTag((MessageLite)object);
                return;
            }
            codedOutputStream.writeGroup(n, (MessageLite)object);
            return;
        }
        codedOutputStream.writeTag(n, FieldSet.getWireFormatForFieldType(fieldType, false));
        FieldSet.writeElementNoTag(codedOutputStream, fieldType, object);
    }

    static void writeElementNoTag(CodedOutputStream codedOutputStream, WireFormat.FieldType fieldType, Object object) throws IOException {
        switch (fieldType) {
            case ENUM: {
                if (object instanceof Internal.EnumLite) {
                    codedOutputStream.writeEnumNoTag(((Internal.EnumLite)object).getNumber());
                    return;
                }
                codedOutputStream.writeEnumNoTag((Integer)object);
                return;
            }
            case SINT64: {
                codedOutputStream.writeSInt64NoTag((Long)object);
                return;
            }
            case SINT32: {
                codedOutputStream.writeSInt32NoTag((Integer)object);
                return;
            }
            case SFIXED64: {
                codedOutputStream.writeSFixed64NoTag((Long)object);
                return;
            }
            case SFIXED32: {
                codedOutputStream.writeSFixed32NoTag((Integer)object);
                return;
            }
            case UINT32: {
                codedOutputStream.writeUInt32NoTag((Integer)object);
                return;
            }
            case BYTES: {
                if (object instanceof ByteString) {
                    codedOutputStream.writeBytesNoTag((ByteString)object);
                    return;
                }
                codedOutputStream.writeByteArrayNoTag((byte[])object);
                return;
            }
            case STRING: {
                if (object instanceof ByteString) {
                    codedOutputStream.writeBytesNoTag((ByteString)object);
                    return;
                }
                codedOutputStream.writeStringNoTag((String)object);
                return;
            }
            default: {
                return;
            }
            case MESSAGE: {
                codedOutputStream.writeMessageNoTag((MessageLite)object);
                return;
            }
            case GROUP: {
                codedOutputStream.writeGroupNoTag((MessageLite)object);
                return;
            }
            case BOOL: {
                codedOutputStream.writeBoolNoTag((Boolean)object);
                return;
            }
            case FIXED32: {
                codedOutputStream.writeFixed32NoTag((Integer)object);
                return;
            }
            case FIXED64: {
                codedOutputStream.writeFixed64NoTag((Long)object);
                return;
            }
            case INT32: {
                codedOutputStream.writeInt32NoTag((Integer)object);
                return;
            }
            case UINT64: {
                codedOutputStream.writeUInt64NoTag((Long)object);
                return;
            }
            case INT64: {
                codedOutputStream.writeInt64NoTag((Long)object);
                return;
            }
            case FLOAT: {
                codedOutputStream.writeFloatNoTag(((Float)object).floatValue());
                return;
            }
            case DOUBLE: 
        }
        codedOutputStream.writeDoubleNoTag((Double)object);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FieldSet)) {
            return false;
        }
        object = (FieldSet)object;
        return this.fields.equals(((FieldSet)object).fields);
    }

    boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public boolean isInitialized() {
        for (int i = 0; i < ((FieldSet)((Object)iterator)).fields.getNumArrayEntries(); ++i) {
            if (FieldSet.isInitialized(((FieldSet)((Object)iterator)).fields.getArrayEntryAt(i))) continue;
            return false;
        }
        Iterator iterator = ((FieldSet)((Object)iterator)).fields.getOverflowEntries().iterator();
        while (iterator.hasNext()) {
            if (FieldSet.isInitialized((Map.Entry)iterator.next())) continue;
            return false;
        }
        return true;
    }

    private static boolean isInitialized(Map.Entry object) {
        FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)object.getKey();
        if (fieldDescriptorLite.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
            if (fieldDescriptorLite.isRepeated()) {
                object = ((List)object.getValue()).iterator();
                while (object.hasNext()) {
                    if (FieldSet.isMessageFieldValueInitialized(object.next())) continue;
                    return false;
                }
            } else {
                return FieldSet.isMessageFieldValueInitialized(object.getValue());
            }
        }
        return true;
    }

    private static boolean isMessageFieldValueInitialized(Object object) {
        if (object instanceof MessageLiteOrBuilder) {
            return ((MessageLiteOrBuilder)object).isInitialized();
        }
        if (!(object instanceof LazyField)) {
            object = new IllegalArgumentException("Wrong object type used with protocol message reflection.");
            throw object;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isValidType(WireFormat.FieldType fieldType, Object object) {
        Internal.checkNotNull(object);
        switch (1.$SwitchMap$com$google$protobuf$WireFormat$JavaType[fieldType.getJavaType().ordinal()]) {
            case 9: {
                if (object instanceof MessageLite) return true;
                if (!(object instanceof LazyField)) return false;
                return true;
            }
            case 8: {
                if (object instanceof Integer) return true;
                if (!(object instanceof Internal.EnumLite)) return false;
                return true;
            }
            case 7: {
                if (object instanceof ByteString) return true;
                if (!(object instanceof byte[])) return false;
                return true;
            }
            default: {
                return false;
            }
            case 6: {
                return object instanceof String;
            }
            case 5: {
                return object instanceof Boolean;
            }
            case 4: {
                return object instanceof Double;
            }
            case 3: {
                return object instanceof Float;
            }
            case 2: {
                return object instanceof Long;
            }
            case 1: 
        }
        return object instanceof Integer;
    }

    public static interface FieldDescriptorLite
    extends Comparable {
        public int getNumber();

        public MessageLite.Builder internalMergeFrom(MessageLite.Builder var1, MessageLite var2);

        public MutableMessageLite internalMergeFrom(MutableMessageLite var1, MutableMessageLite var2);

        public WireFormat.FieldType getLiteType();

        public WireFormat.JavaType getLiteJavaType();

        public boolean isPacked();

        public boolean isRepeated();
    }
}

