/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.FieldType;
import androidx.test.espresso.remote.internal.deps.protobuf.Internal;
import androidx.test.espresso.remote.internal.deps.protobuf.OneofInfo;
import java.lang.reflect.Field;

final class FieldInfo
implements Comparable<FieldInfo> {
    private final Field field;
    private final FieldType type;
    private final Class messageClass;
    private final int fieldNumber;
    private final Field presenceField;
    private final int presenceMask;
    private final boolean required;
    private final boolean enforceUtf8;
    private final OneofInfo oneof;
    private final Field cachedSizeField;
    private final Class oneofStoredType;
    private final Object mapDefaultEntry;
    private final Internal.EnumVerifier enumVerifier;

    @Override
    public int compareTo(FieldInfo fieldInfo) {
        return this.fieldNumber - fieldInfo.fieldNumber;
    }

    public int getFieldNumber() {
        return this.fieldNumber;
    }

    public int getPresenceMask() {
        return this.presenceMask;
    }

    public static FieldInfo forField(Field object, int n, FieldType fieldType, boolean bl) {
        FieldInfo.checkFieldNumber(n);
        Internal.checkNotNull(object, "field");
        Internal.checkNotNull((Object)fieldType, "fieldType");
        if (fieldType == FieldType.MESSAGE_LIST || fieldType == FieldType.GROUP_LIST) {
            object = new IllegalStateException("Shouldn't be called for repeated message fields.");
            throw object;
        }
        FieldInfo fieldInfo = new FieldInfo((Field)object, n, fieldType, null, null, 0, false, bl, null, null, null, null, null);
        return fieldInfo;
    }

    public static FieldInfo forFieldWithEnumVerifier(Field field, int n, FieldType fieldType, Internal.EnumVerifier enumVerifier) {
        FieldInfo.checkFieldNumber(n);
        Internal.checkNotNull(field, "field");
        FieldInfo fieldInfo = new FieldInfo(field, n, fieldType, null, null, 0, false, false, null, null, null, enumVerifier, null);
        return fieldInfo;
    }

    public static FieldInfo forMapField(Field field, int n, Object object, Internal.EnumVerifier enumVerifier) {
        Internal.checkNotNull(object, "mapDefaultEntry");
        FieldInfo.checkFieldNumber(n);
        Internal.checkNotNull(field, "field");
        FieldInfo fieldInfo = new FieldInfo(field, n, FieldType.MAP, null, null, 0, false, true, null, null, object, enumVerifier, null);
        return fieldInfo;
    }

    public static FieldInfo forOneofMemberField(int n, FieldType object, OneofInfo object2, Class serializable, boolean bl, Internal.EnumVerifier enumVerifier) {
        FieldInfo.checkFieldNumber(n);
        Internal.checkNotNull(object, "fieldType");
        Internal.checkNotNull(object2, "oneof");
        Internal.checkNotNull(serializable, "oneofStoredType");
        if (!object.isScalar()) {
            object = String.valueOf(object);
            serializable = new StringBuilder();
            object2 = new IllegalArgumentException(((StringBuilder)serializable).append("Oneof is only supported for scalar fields. Field ").append(n).append(" is of type ").append((String)object).toString());
            throw object2;
        }
        FieldInfo fieldInfo = new FieldInfo(null, n, (FieldType)((Object)object), null, null, 0, false, bl, (OneofInfo)object2, (Class)serializable, null, enumVerifier, null);
        return fieldInfo;
    }

    public static FieldInfo forProto2OptionalField(Field object, int n, FieldType fieldType, Field field, int n2, boolean bl, Internal.EnumVerifier enumVerifier) {
        FieldInfo.checkFieldNumber(n);
        Internal.checkNotNull(object, "field");
        Internal.checkNotNull((Object)fieldType, "fieldType");
        Internal.checkNotNull(field, "presenceField");
        if (field != null && !FieldInfo.isExactlyOneBitSet(n2)) {
            StringBuilder stringBuilder = new StringBuilder();
            object = new IllegalArgumentException(stringBuilder.append("presenceMask must have exactly one bit set: ").append(n2).toString());
            throw object;
        }
        FieldInfo fieldInfo = new FieldInfo((Field)object, n, fieldType, null, field, n2, false, bl, null, null, null, enumVerifier, null);
        return fieldInfo;
    }

    public static FieldInfo forProto2RequiredField(Field object, int n, FieldType fieldType, Field field, int n2, boolean bl, Internal.EnumVerifier enumVerifier) {
        FieldInfo.checkFieldNumber(n);
        Internal.checkNotNull(object, "field");
        Internal.checkNotNull((Object)fieldType, "fieldType");
        Internal.checkNotNull(field, "presenceField");
        if (field != null && !FieldInfo.isExactlyOneBitSet(n2)) {
            StringBuilder stringBuilder = new StringBuilder();
            object = new IllegalArgumentException(stringBuilder.append("presenceMask must have exactly one bit set: ").append(n2).toString());
            throw object;
        }
        FieldInfo fieldInfo = new FieldInfo((Field)object, n, fieldType, null, field, n2, true, bl, null, null, null, enumVerifier, null);
        return fieldInfo;
    }

    public static FieldInfo forRepeatedMessageField(Field field, int n, FieldType fieldType, Class clazz) {
        FieldInfo.checkFieldNumber(n);
        Internal.checkNotNull(field, "field");
        Internal.checkNotNull((Object)fieldType, "fieldType");
        Internal.checkNotNull(clazz, "messageClass");
        FieldInfo fieldInfo = new FieldInfo(field, n, fieldType, clazz, null, 0, false, false, null, null, null, null, null);
        return fieldInfo;
    }

    public FieldType getType() {
        return this.type;
    }

    public Internal.EnumVerifier getEnumVerifier() {
        return this.enumVerifier;
    }

    public OneofInfo getOneof() {
        return this.oneof;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Class getMessageFieldClass() {
        switch (1.$SwitchMap$com$google$protobuf$FieldType[((FieldInfo)((Object)this)).type.ordinal()]) {
            case 3: 
            case 4: {
                return ((FieldInfo)((Object)this)).messageClass;
            }
            case 1: 
            case 2: {
                if (((FieldInfo)((Object)this)).field == null) return ((FieldInfo)((Object)this)).oneofStoredType;
                return ((FieldInfo)((Object)this)).field.getType();
            }
        }
        return null;
    }

    public Object getMapDefaultEntry() {
        return this.mapDefaultEntry;
    }

    public Field getCachedSizeField() {
        return this.cachedSizeField;
    }

    public Field getField() {
        return this.field;
    }

    public Field getPresenceField() {
        return this.presenceField;
    }

    private FieldInfo(Field field, int n, FieldType fieldType, Class clazz, Field field2, int n2, boolean bl, boolean bl2, OneofInfo oneofInfo, Class clazz2, Object object, Internal.EnumVerifier enumVerifier, Field field3) {
        this.field = field;
        this.type = fieldType;
        this.messageClass = clazz;
        this.fieldNumber = n;
        this.presenceField = field2;
        this.presenceMask = n2;
        this.required = bl;
        this.enforceUtf8 = bl2;
        this.oneof = oneofInfo;
        this.oneofStoredType = clazz2;
        this.mapDefaultEntry = object;
        this.enumVerifier = enumVerifier;
        this.cachedSizeField = field3;
    }

    private static void checkFieldNumber(int n) {
        if (n <= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(stringBuilder.append("fieldNumber must be positive: ").append(n).toString());
            throw illegalArgumentException;
        }
    }

    public boolean isEnforceUtf8() {
        return this.enforceUtf8;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isExactlyOneBitSet(int n) {
        if (n == 0) return 0 != 0;
        if ((n & n + -1) != 0) return 0 != 0;
        return 1 != 0;
    }

    public boolean isRequired() {
        return this.required;
    }
}

