/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.ExtensionSchema;
import androidx.test.espresso.remote.internal.deps.protobuf.ExtensionSchemaLite;

final class ExtensionSchemas {
    private static final ExtensionSchema LITE_SCHEMA;
    private static final ExtensionSchema FULL_SCHEMA;

    static ExtensionSchema full() {
        if (FULL_SCHEMA == null) {
            IllegalStateException illegalStateException = new IllegalStateException("Protobuf runtime is not correctly loaded.");
            throw illegalStateException;
        }
        return FULL_SCHEMA;
    }

    static ExtensionSchema lite() {
        return LITE_SCHEMA;
    }

    private static ExtensionSchema loadSchemaForFullRuntime() {
        try {
            ExtensionSchema extensionSchema = (ExtensionSchema)Class.forName("androidx.test.espresso.remote.internal.deps.protobuf.ExtensionSchemaFull").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return extensionSchema;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        ExtensionSchemaLite extensionSchemaLite = new ExtensionSchemaLite();
        LITE_SCHEMA = extensionSchemaLite;
        FULL_SCHEMA = ExtensionSchemas.loadSchemaForFullRuntime();
    }
}

