/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.ExtensionRegistryFactory;
import androidx.test.espresso.remote.internal.deps.protobuf.GeneratedMessageLite;
import androidx.test.espresso.remote.internal.deps.protobuf.MessageLite;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ExtensionRegistryLite {
    private static volatile boolean eagerlyParseMessageSets;
    private static boolean doFullRuntimeInheritanceCheck;
    private static volatile ExtensionRegistryLite emptyRegistry;
    static final ExtensionRegistryLite EMPTY_REGISTRY_LITE;
    private final Map extensionsByNumber;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ExtensionRegistryLite getEmptyRegistry() {
        if (!doFullRuntimeInheritanceCheck) {
            return EMPTY_REGISTRY_LITE;
        }
        ExtensionRegistryLite extensionRegistryLite = emptyRegistry;
        if (extensionRegistryLite != null) return extensionRegistryLite;
        Class<ExtensionRegistryLite> clazz = ExtensionRegistryLite.class;
        synchronized (clazz) {
            extensionRegistryLite = emptyRegistry;
            if (extensionRegistryLite != null) return extensionRegistryLite;
            emptyRegistry = extensionRegistryLite = ExtensionRegistryFactory.createEmpty();
            return extensionRegistryLite;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public GeneratedMessageLite.GeneratedExtension findLiteExtensionByNumber(MessageLite messageLite, int n) {
        Map map = ((ExtensionRegistryLite)((Object)map)).extensionsByNumber;
        ObjectIntPair objectIntPair = new ObjectIntPair(messageLite, n);
        return (GeneratedMessageLite.GeneratedExtension)map.get(objectIntPair);
    }

    static {
        ExtensionRegistryLite extensionRegistryLite;
        eagerlyParseMessageSets = false;
        doFullRuntimeInheritanceCheck = true;
        EMPTY_REGISTRY_LITE = extensionRegistryLite = new ExtensionRegistryLite(true);
    }

    ExtensionRegistryLite() {
        HashMap hashMap;
        this.extensionsByNumber = hashMap = new HashMap();
    }

    ExtensionRegistryLite(boolean bl) {
        this.extensionsByNumber = Collections.emptyMap();
    }

    private static final class ObjectIntPair {
        private final Object object;
        private final int number;

        public int hashCode() {
            return System.identityHashCode(this.object) * 65535 + this.number;
        }

        ObjectIntPair(Object object, int n) {
            this.object = object;
            this.number = n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof ObjectIntPair)) {
                return false;
            }
            object = (ObjectIntPair)object;
            if (this.object != ((ObjectIntPair)object).object) return false;
            if (this.number != ((ObjectIntPair)object).number) return false;
            return true;
        }
    }
}

