/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.AbstractProtobufList;
import androidx.test.espresso.remote.internal.deps.protobuf.Internal;
import androidx.test.espresso.remote.internal.deps.protobuf.PrimitiveNonBoxingCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class DoubleArrayList
extends AbstractProtobufList
implements Internal.DoubleList,
RandomAccess,
PrimitiveNonBoxingCollection {
    private static final DoubleArrayList EMPTY_LIST;
    private double[] array;
    private int size;

    public double getDouble(int n) {
        this.ensureIndexInRange(n);
        return this.array[n];
    }

    public double setDouble(int n, double d) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n);
        double[] dArray = this.array;
        double d2 = dArray[n];
        this.array[n] = d;
        return d2;
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Internal.hashLong(Double.doubleToLongBits(this.array[i]));
        }
        return n;
    }

    @Override
    public int indexOf(Object object) {
        if (!(object instanceof Double)) {
            return -1;
        }
        double d = (Double)object;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.array[i] != d) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    public static DoubleArrayList emptyList() {
        return EMPTY_LIST;
    }

    @Override
    public Internal.DoubleList mutableCopyWithCapacity(int n) {
        if (n < ((DoubleArrayList)object).size) {
            Object object = new IllegalArgumentException();
            throw object;
        }
        DoubleArrayList doubleArrayList = new DoubleArrayList(Arrays.copyOf(((DoubleArrayList)object).array, n), ((DoubleArrayList)object).size);
        return doubleArrayList;
    }

    @Override
    public Double get(int n) {
        return this.getDouble(n);
    }

    @Override
    public Double remove(int n) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n);
        double d = this.array[n];
        if (n < this.size + -1) {
            System.arraycopy(this.array, n + 1, this.array, n, this.size - n + -1);
        }
        this.size += -1;
        ++this.modCount;
        return d;
    }

    @Override
    public Double set(int n, Double d) {
        return this.setDouble(n, d);
    }

    private String makeOutOfBoundsExceptionMessage(int n) {
        int n2 = this.size;
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    static {
        DoubleArrayList doubleArrayList;
        EMPTY_LIST = doubleArrayList = new DoubleArrayList(new double[0], 0);
        EMPTY_LIST.makeImmutable();
    }

    DoubleArrayList() {
        this(new double[10], 0);
    }

    private DoubleArrayList(double[] dArray, int n) {
        this.array = dArray;
        this.size = n;
    }

    @Override
    public void add(int n, Double d) {
        this.addDouble(n, d);
    }

    public void addDouble(double d) {
        double[] dArray;
        this.ensureIsMutable();
        if (this.size == this.array.length) {
            dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.array, 0, dArray, 0, this.size);
            this.array = dArray;
        }
        dArray = this.array;
        int n = this.size;
        this.size = n + 1;
        dArray[n] = d;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addDouble(int n, double d) {
        this.ensureIsMutable();
        if (n < 0 || n > this.size) {
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n));
            throw indexOutOfBoundsException;
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, n, this.array, n + 1, this.size - n);
        } else {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.array, 0, dArray, 0, n);
            System.arraycopy(this.array, n, dArray, n + 1, this.size - n);
            this.array = dArray;
        }
        this.array[n] = d;
        ++this.size;
        ++this.modCount;
    }

    private void ensureIndexInRange(int n) {
        if (n < 0 || n >= this.size) {
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n));
            throw indexOutOfBoundsException;
        }
    }

    @Override
    protected void removeRange(int n, int n2) {
        ((AbstractProtobufList)object).ensureIsMutable();
        if (n2 < n) {
            Object object = new IndexOutOfBoundsException("toIndex < fromIndex");
            throw object;
        }
        System.arraycopy(((DoubleArrayList)object).array, n2, ((DoubleArrayList)object).array, n, ((DoubleArrayList)object).size - n2);
        ((DoubleArrayList)object).size -= n2 - n;
        ++((DoubleArrayList)object).modCount;
    }

    @Override
    public boolean add(Double d) {
        this.addDouble(d);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Double> doubleArrayList) {
        ((AbstractProtobufList)object).ensureIsMutable();
        Internal.checkNotNull(doubleArrayList);
        if (!(doubleArrayList instanceof DoubleArrayList)) {
            return super.addAll(doubleArrayList);
        }
        doubleArrayList = doubleArrayList;
        if (doubleArrayList.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - ((DoubleArrayList)object).size < doubleArrayList.size) {
            Object object = new OutOfMemoryError();
            throw object;
        }
        int n = ((DoubleArrayList)object).size + doubleArrayList.size;
        if (n > ((DoubleArrayList)object).array.length) {
            ((DoubleArrayList)object).array = Arrays.copyOf(((DoubleArrayList)object).array, n);
        }
        System.arraycopy(doubleArrayList.array, 0, ((DoubleArrayList)object).array, ((DoubleArrayList)object).size, doubleArrayList.size);
        ((DoubleArrayList)object).size = n;
        ++((DoubleArrayList)object).modCount;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean contains(Object object) {
        if (this.indexOf(object) == -1) return false;
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DoubleArrayList)) {
            return super.equals(object);
        }
        object = (DoubleArrayList)object;
        if (this.size != ((DoubleArrayList)object).size) {
            return false;
        }
        double[] dArray = ((DoubleArrayList)object).array;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.array[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }
}

