/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.ByteString;
import androidx.test.espresso.remote.internal.deps.protobuf.CodedOutputStream;
import androidx.test.espresso.remote.internal.deps.protobuf.Internal;
import androidx.test.espresso.remote.internal.deps.protobuf.LazyStringList;
import androidx.test.espresso.remote.internal.deps.protobuf.MapEntryLite;
import androidx.test.espresso.remote.internal.deps.protobuf.MessageLite;
import androidx.test.espresso.remote.internal.deps.protobuf.Schema;
import androidx.test.espresso.remote.internal.deps.protobuf.Writer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class CodedOutputStreamWriter
implements Writer {
    private final CodedOutputStream output;

    public static CodedOutputStreamWriter forCodedOutput(CodedOutputStream codedOutputStream) {
        if (codedOutputStream.wrapper != null) {
            return codedOutputStream.wrapper;
        }
        CodedOutputStreamWriter codedOutputStreamWriter = new CodedOutputStreamWriter(codedOutputStream);
        return codedOutputStreamWriter;
    }

    @Override
    public Writer.FieldOrder fieldOrder() {
        return Writer.FieldOrder.ASCENDING;
    }

    private CodedOutputStreamWriter(CodedOutputStream codedOutputStream) {
        this.output = (CodedOutputStream)Internal.checkNotNull(codedOutputStream, "output");
        this.output.wrapper = this;
    }

    @Override
    public void writeBool(int n, boolean bl) throws IOException {
        this.output.writeBool(n, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeBoolList(int n, List list, boolean n2) throws IOException {
        if (n2 != 0) {
            this.output.writeTag(n, 2);
            n = 0;
            for (n2 = 0; n2 < list.size(); n += CodedOutputStream.computeBoolSizeNoTag((Boolean)list.get(n2)), ++n2) {
            }
            this.output.writeUInt32NoTag(n);
            for (n = 0; n < list.size(); ++n) {
                this.output.writeBoolNoTag((Boolean)list.get(n));
            }
            return;
        } else {
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.output.writeBool(n, (Boolean)list.get(n2));
            }
        }
    }

    @Override
    public void writeBytes(int n, ByteString byteString) throws IOException {
        this.output.writeBytes(n, byteString);
    }

    @Override
    public void writeBytesList(int n, List list) throws IOException {
        for (int i = 0; i < list.size(); ++i) {
            this.output.writeBytes(n, (ByteString)list.get(i));
        }
    }

    private void writeDeterministicBooleanMapEntry(int n, boolean bl, Object object, MapEntryLite.Metadata metadata) throws IOException {
        this.output.writeTag(n, 2);
        this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, bl, object));
        MapEntryLite.writeTo(this.output, metadata, bl, object);
    }

    private void writeDeterministicIntegerMap(int n, MapEntryLite.Metadata metadata, Map map) throws IOException {
        int[] nArray = new int[map.size()];
        Iterator iterator = map.keySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            int n3 = n2 + 1;
            nArray[n2] = (Integer)iterator.next();
            n2 = n3;
        }
        Arrays.sort(nArray);
        for (int n3 : nArray) {
            Object v = map.get(n3);
            this.output.writeTag(n, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, n3, v));
            MapEntryLite.writeTo(this.output, metadata, n3, v);
        }
    }

    private void writeDeterministicLongMap(int n, MapEntryLite.Metadata metadata, Map map) throws IOException {
        long[] lArray = new long[map.size()];
        Iterator iterator = map.keySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            int n3 = n2 + 1;
            lArray[n2] = (Long)iterator.next();
            n2 = n3;
        }
        Arrays.sort(lArray);
        for (long l : lArray) {
            Object v = map.get(l);
            this.output.writeTag(n, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, l, v));
            MapEntryLite.writeTo(this.output, metadata, l, v);
        }
    }

    private void writeDeterministicMap(int n, MapEntryLite.Metadata object, Map map) throws IOException {
        switch (1.$SwitchMap$com$google$protobuf$WireFormat$FieldType[((MapEntryLite.Metadata)object).keyType.ordinal()]) {
            case 12: {
                ((CodedOutputStreamWriter)object3).writeDeterministicStringMap(n, (MapEntryLite.Metadata)object, map);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                ((CodedOutputStreamWriter)object3).writeDeterministicLongMap(n, (MapEntryLite.Metadata)object, map);
                return;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                ((CodedOutputStreamWriter)object3).writeDeterministicIntegerMap(n, (MapEntryLite.Metadata)object, map);
                return;
            }
            case 1: {
                Object v = map.get(Boolean.FALSE);
                if (v != null) {
                    super.writeDeterministicBooleanMapEntry(n, false, v, (MapEntryLite.Metadata)object);
                }
                if ((map = map.get(Boolean.TRUE)) == null) break;
                super.writeDeterministicBooleanMapEntry(n, true, map, (MapEntryLite.Metadata)object);
                return;
            }
            default: {
                Object object2 = ((MapEntryLite.Metadata)object).keyType;
                object2 = String.valueOf(object2);
                object = new StringBuilder();
                Object object3 = new IllegalArgumentException(((StringBuilder)object).append("does not support key type: ").append((String)object2).toString());
                throw object3;
            }
        }
    }

    private void writeDeterministicStringMap(int n, MapEntryLite.Metadata metadata, Map map) throws IOException {
        Object[] objectArray = new String[map.size()];
        Iterator iterator = map.keySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            int n3 = n2 + 1;
            objectArray[n2] = (String)iterator.next();
            n2 = n3;
        }
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            Object v = map.get(object);
            this.output.writeTag(n, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, object, v));
            MapEntryLite.writeTo(this.output, metadata, object, v);
        }
    }

    @Override
    public void writeDouble(int n, double d) throws IOException {
        this.output.writeDouble(n, d);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeDoubleList(int n, List list, boolean n2) throws IOException {
        if (n2 != 0) {
            this.output.writeTag(n, 2);
            n = 0;
            for (n2 = 0; n2 < list.size(); n += CodedOutputStream.computeDoubleSizeNoTag((Double)list.get(n2)), ++n2) {
            }
            this.output.writeUInt32NoTag(n);
            for (n = 0; n < list.size(); ++n) {
                this.output.writeDoubleNoTag((Double)list.get(n));
            }
            return;
        } else {
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.output.writeDouble(n, (Double)list.get(n2));
            }
        }
    }

    @Override
    @Deprecated
    public void writeEndGroup(int n) throws IOException {
        this.output.writeTag(n, 4);
    }

    @Override
    public void writeEnum(int n, int n2) throws IOException {
        this.output.writeEnum(n, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeEnumList(int n, List list, boolean n2) throws IOException {
        if (n2 != 0) {
            this.output.writeTag(n, 2);
            n = 0;
            for (n2 = 0; n2 < list.size(); n += CodedOutputStream.computeEnumSizeNoTag((Integer)list.get(n2)), ++n2) {
            }
            this.output.writeUInt32NoTag(n);
            for (n = 0; n < list.size(); ++n) {
                this.output.writeEnumNoTag((Integer)list.get(n));
            }
            return;
        } else {
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.output.writeEnum(n, (Integer)list.get(n2));
            }
        }
    }

    @Override
    public void writeFixed32(int n, int n2) throws IOException {
        this.output.writeFixed32(n, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeFixed32List(int n, List list, boolean n2) throws IOException {
        if (n2 != 0) {
            this.output.writeTag(n, 2);
            n = 0;
            for (n2 = 0; n2 < list.size(); n += CodedOutputStream.computeFixed32SizeNoTag((Integer)list.get(n2)), ++n2) {
            }
            this.output.writeUInt32NoTag(n);
            for (n = 0; n < list.size(); ++n) {
                this.output.writeFixed32NoTag((Integer)list.get(n));
            }
            return;
        } else {
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.output.writeFixed32(n, (Integer)list.get(n2));
            }
        }
    }

    @Override
    public void writeFixed64(int n, long l) throws IOException {
        this.output.writeFixed64(n, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeFixed64List(int n, List list, boolean n2) throws IOException {
        if (n2 != 0) {
            this.output.writeTag(n, 2);
            n = 0;
            for (n2 = 0; n2 < list.size(); n += CodedOutputStream.computeFixed64SizeNoTag((Long)list.get(n2)), ++n2) {
            }
            this.output.writeUInt32NoTag(n);
            for (n = 0; n < list.size(); ++n) {
                this.output.writeFixed64NoTag((Long)list.get(n));
            }
            return;
        } else {
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.output.writeFixed64(n, (Long)list.get(n2));
            }
        }
    }

    @Override
    public void writeFloat(int n, float f) throws IOException {
        this.output.writeFloat(n, f);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeFloatList(int n, List list, boolean n2) throws IOException {
        if (n2 != 0) {
            this.output.writeTag(n, 2);
            n = 0;
            for (n2 = 0; n2 < list.size(); n += CodedOutputStream.computeFloatSizeNoTag(((Float)list.get(n2)).floatValue()), ++n2) {
            }
            this.output.writeUInt32NoTag(n);
            for (n = 0; n < list.size(); ++n) {
                this.output.writeFloatNoTag(((Float)list.get(n)).floatValue());
            }
            return;
        } else {
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.output.writeFloat(n, ((Float)list.get(n2)).floatValue());
            }
        }
    }

    @Override
    public void writeGroup(int n, Object object, Schema schema) throws IOException {
        this.output.writeGroup(n, (MessageLite)object, schema);
    }

    @Override
    public void writeGroupList(int n, List list, Schema schema) throws IOException {
        for (int i = 0; i < list.size(); ++i) {
            this.writeGroup(n, list.get(i), schema);
        }
    }

    @Override
    public void writeInt32(int n, int n2) throws IOException {
        this.output.writeInt32(n, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeInt32List(int n, List list, boolean n2) throws IOException {
        if (n2 != 0) {
            this.output.writeTag(n, 2);
            n = 0;
            for (n2 = 0; n2 < list.size(); n += CodedOutputStream.computeInt32SizeNoTag((Integer)list.get(n2)), ++n2) {
            }
            this.output.writeUInt32NoTag(n);
            for (n = 0; n < list.size(); ++n) {
                this.output.writeInt32NoTag((Integer)list.get(n));
            }
            return;
        } else {
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.output.writeInt32(n, (Integer)list.get(n2));
            }
        }
    }

    @Override
    public void writeInt64(int n, long l) throws IOException {
        this.output.writeInt64(n, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeInt64List(int n, List list, boolean n2) throws IOException {
        if (n2 != 0) {
            this.output.writeTag(n, 2);
            n = 0;
            for (n2 = 0; n2 < list.size(); n += CodedOutputStream.computeInt64SizeNoTag((Long)list.get(n2)), ++n2) {
            }
            this.output.writeUInt32NoTag(n);
            for (n = 0; n < list.size(); ++n) {
                this.output.writeInt64NoTag((Long)list.get(n));
            }
            return;
        } else {
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.output.writeInt64(n, (Long)list.get(n2));
            }
        }
    }

    private void writeLazyString(int n, Object object) throws IOException {
        if (object instanceof String) {
            this.output.writeString(n, (String)object);
            return;
        }
        this.output.writeBytes(n, (ByteString)object);
    }

    @Override
    public void writeMap(int n, MapEntryLite.Metadata metadata, Map object) throws IOException {
        if (this.output.isSerializationDeterministic()) {
            this.writeDeterministicMap(n, metadata, (Map)((Object)object));
            return;
        }
        for (Map.Entry entry : object.entrySet()) {
            this.output.writeTag(n, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, entry.getKey(), entry.getValue()));
            MapEntryLite.writeTo(this.output, metadata, entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void writeMessage(int n, Object object, Schema schema) throws IOException {
        this.output.writeMessage(n, (MessageLite)object, schema);
    }

    @Override
    public void writeMessageList(int n, List list, Schema schema) throws IOException {
        for (int i = 0; i < list.size(); ++i) {
            this.writeMessage(n, list.get(i), schema);
        }
    }

    @Override
    public final void writeMessageSetItem(int n, Object object) throws IOException {
        if (object instanceof ByteString) {
            this.output.writeRawMessageSetExtension(n, (ByteString)object);
            return;
        }
        this.output.writeMessageSetExtension(n, (MessageLite)object);
    }

    @Override
    public void writeSFixed32(int n, int n2) throws IOException {
        this.output.writeSFixed32(n, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeSFixed32List(int n, List list, boolean n2) throws IOException {
        if (n2 != 0) {
            this.output.writeTag(n, 2);
            n = 0;
            for (n2 = 0; n2 < list.size(); n += CodedOutputStream.computeSFixed32SizeNoTag((Integer)list.get(n2)), ++n2) {
            }
            this.output.writeUInt32NoTag(n);
            for (n = 0; n < list.size(); ++n) {
                this.output.writeSFixed32NoTag((Integer)list.get(n));
            }
            return;
        } else {
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.output.writeSFixed32(n, (Integer)list.get(n2));
            }
        }
    }

    @Override
    public void writeSFixed64(int n, long l) throws IOException {
        this.output.writeSFixed64(n, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeSFixed64List(int n, List list, boolean n2) throws IOException {
        if (n2 != 0) {
            this.output.writeTag(n, 2);
            n = 0;
            for (n2 = 0; n2 < list.size(); n += CodedOutputStream.computeSFixed64SizeNoTag((Long)list.get(n2)), ++n2) {
            }
            this.output.writeUInt32NoTag(n);
            for (n = 0; n < list.size(); ++n) {
                this.output.writeSFixed64NoTag((Long)list.get(n));
            }
            return;
        } else {
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.output.writeSFixed64(n, (Long)list.get(n2));
            }
        }
    }

    @Override
    public void writeSInt32(int n, int n2) throws IOException {
        this.output.writeSInt32(n, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeSInt32List(int n, List list, boolean n2) throws IOException {
        if (n2 != 0) {
            this.output.writeTag(n, 2);
            n = 0;
            for (n2 = 0; n2 < list.size(); n += CodedOutputStream.computeSInt32SizeNoTag((Integer)list.get(n2)), ++n2) {
            }
            this.output.writeUInt32NoTag(n);
            for (n = 0; n < list.size(); ++n) {
                this.output.writeSInt32NoTag((Integer)list.get(n));
            }
            return;
        } else {
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.output.writeSInt32(n, (Integer)list.get(n2));
            }
        }
    }

    @Override
    public void writeSInt64(int n, long l) throws IOException {
        this.output.writeSInt64(n, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeSInt64List(int n, List list, boolean n2) throws IOException {
        if (n2 != 0) {
            this.output.writeTag(n, 2);
            n = 0;
            for (n2 = 0; n2 < list.size(); n += CodedOutputStream.computeSInt64SizeNoTag((Long)list.get(n2)), ++n2) {
            }
            this.output.writeUInt32NoTag(n);
            for (n = 0; n < list.size(); ++n) {
                this.output.writeSInt64NoTag((Long)list.get(n));
            }
            return;
        } else {
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.output.writeSInt64(n, (Long)list.get(n2));
            }
        }
    }

    @Override
    @Deprecated
    public void writeStartGroup(int n) throws IOException {
        this.output.writeTag(n, 3);
    }

    @Override
    public void writeString(int n, String string) throws IOException {
        this.output.writeString(n, string);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeStringList(int n, List list) throws IOException {
        if (list instanceof LazyStringList) {
            LazyStringList lazyStringList = (LazyStringList)list;
            for (int i = 0; i < list.size(); ++i) {
                this.writeLazyString(n, lazyStringList.getRaw(i));
            }
            return;
        } else {
            for (int i = 0; i < list.size(); ++i) {
                this.output.writeString(n, (String)list.get(i));
            }
        }
    }

    @Override
    public void writeUInt32(int n, int n2) throws IOException {
        this.output.writeUInt32(n, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeUInt32List(int n, List list, boolean n2) throws IOException {
        if (n2 != 0) {
            this.output.writeTag(n, 2);
            n = 0;
            for (n2 = 0; n2 < list.size(); n += CodedOutputStream.computeUInt32SizeNoTag((Integer)list.get(n2)), ++n2) {
            }
            this.output.writeUInt32NoTag(n);
            for (n = 0; n < list.size(); ++n) {
                this.output.writeUInt32NoTag((Integer)list.get(n));
            }
            return;
        } else {
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.output.writeUInt32(n, (Integer)list.get(n2));
            }
        }
    }

    @Override
    public void writeUInt64(int n, long l) throws IOException {
        this.output.writeUInt64(n, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeUInt64List(int n, List list, boolean n2) throws IOException {
        if (n2 != 0) {
            this.output.writeTag(n, 2);
            n = 0;
            for (n2 = 0; n2 < list.size(); n += CodedOutputStream.computeUInt64SizeNoTag((Long)list.get(n2)), ++n2) {
            }
            this.output.writeUInt32NoTag(n);
            for (n = 0; n < list.size(); ++n) {
                this.output.writeUInt64NoTag((Long)list.get(n));
            }
            return;
        } else {
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.output.writeUInt64(n, (Long)list.get(n2));
            }
        }
    }
}

