/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.AbstractMessageLite;
import androidx.test.espresso.remote.internal.deps.protobuf.ByteOutput;
import androidx.test.espresso.remote.internal.deps.protobuf.ByteString;
import androidx.test.espresso.remote.internal.deps.protobuf.CodedOutputStream-IA;
import androidx.test.espresso.remote.internal.deps.protobuf.CodedOutputStreamWriter;
import androidx.test.espresso.remote.internal.deps.protobuf.Internal;
import androidx.test.espresso.remote.internal.deps.protobuf.LazyFieldLite;
import androidx.test.espresso.remote.internal.deps.protobuf.MessageLite;
import androidx.test.espresso.remote.internal.deps.protobuf.Schema;
import androidx.test.espresso.remote.internal.deps.protobuf.UnsafeUtil;
import androidx.test.espresso.remote.internal.deps.protobuf.Utf8;
import androidx.test.espresso.remote.internal.deps.protobuf.WireFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class CodedOutputStream
extends ByteOutput {
    private static final Logger logger = Logger.getLogger(CodedOutputStream.class.getName());
    private static final boolean HAS_UNSAFE_ARRAY_OPERATIONS = UnsafeUtil.hasUnsafeArrayOperations();
    CodedOutputStreamWriter wrapper;
    private boolean serializationDeterministic;

    public static int computeBoolSize(int n, boolean bl) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeBoolSizeNoTag(bl);
    }

    public static int computeBoolSizeNoTag(boolean bl) {
        return 1;
    }

    public static int computeByteArraySizeNoTag(byte[] byArray) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(byArray.length);
    }

    public static int computeBytesSize(int n, ByteString byteString) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeBytesSizeNoTag(byteString);
    }

    public static int computeBytesSizeNoTag(ByteString byteString) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(byteString.size());
    }

    public static int computeDoubleSize(int n, double d) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeDoubleSizeNoTag(d);
    }

    public static int computeDoubleSizeNoTag(double d) {
        return 8;
    }

    public static int computeEnumSize(int n, int n2) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeEnumSizeNoTag(n2);
    }

    public static int computeEnumSizeNoTag(int n) {
        return CodedOutputStream.computeInt32SizeNoTag(n);
    }

    public static int computeFixed32Size(int n, int n2) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeFixed32SizeNoTag(n2);
    }

    public static int computeFixed32SizeNoTag(int n) {
        return 4;
    }

    public static int computeFixed64Size(int n, long l) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeFixed64SizeNoTag(l);
    }

    public static int computeFixed64SizeNoTag(long l) {
        return 8;
    }

    public static int computeFloatSize(int n, float f) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeFloatSizeNoTag(f);
    }

    public static int computeFloatSizeNoTag(float f) {
        return 4;
    }

    @Deprecated
    static int computeGroupSize(int n, MessageLite messageLite, Schema schema) {
        n = CodedOutputStream.computeTagSize(n);
        return n + n + CodedOutputStream.computeGroupSizeNoTag(messageLite, schema);
    }

    @Deprecated
    public static int computeGroupSizeNoTag(MessageLite messageLite) {
        return messageLite.getSerializedSize();
    }

    @Deprecated
    static int computeGroupSizeNoTag(MessageLite messageLite, Schema schema) {
        return ((AbstractMessageLite)messageLite).getSerializedSize(schema);
    }

    public static int computeInt32Size(int n, int n2) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeInt32SizeNoTag(n2);
    }

    public static int computeInt32SizeNoTag(int n) {
        if (n >= 0) {
            return CodedOutputStream.computeUInt32SizeNoTag(n);
        }
        return 10;
    }

    public static int computeInt64Size(int n, long l) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeInt64SizeNoTag(l);
    }

    public static int computeInt64SizeNoTag(long l) {
        return CodedOutputStream.computeUInt64SizeNoTag(l);
    }

    public static int computeLazyFieldMessageSetExtensionSize(int n, LazyFieldLite lazyFieldLite) {
        int n2 = CodedOutputStream.computeTagSize(1);
        return n2 + n2 + CodedOutputStream.computeUInt32Size(2, n) + CodedOutputStream.computeLazyFieldSize(3, lazyFieldLite);
    }

    public static int computeLazyFieldSize(int n, LazyFieldLite lazyFieldLite) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeLazyFieldSizeNoTag(lazyFieldLite);
    }

    public static int computeLazyFieldSizeNoTag(LazyFieldLite lazyFieldLite) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(lazyFieldLite.getSerializedSize());
    }

    static int computeLengthDelimitedFieldSize(int n) {
        return CodedOutputStream.computeUInt32SizeNoTag(n) + n;
    }

    public static int computeMessageSetExtensionSize(int n, MessageLite messageLite) {
        int n2 = CodedOutputStream.computeTagSize(1);
        return n2 + n2 + CodedOutputStream.computeUInt32Size(2, n) + CodedOutputStream.computeMessageSize(3, messageLite);
    }

    public static int computeMessageSize(int n, MessageLite messageLite) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeMessageSizeNoTag(messageLite);
    }

    static int computeMessageSize(int n, MessageLite messageLite, Schema schema) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeMessageSizeNoTag(messageLite, schema);
    }

    public static int computeMessageSizeNoTag(MessageLite messageLite) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(messageLite.getSerializedSize());
    }

    static int computeMessageSizeNoTag(MessageLite messageLite, Schema schema) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(((AbstractMessageLite)messageLite).getSerializedSize(schema));
    }

    static int computePreferredBufferSize(int n) {
        if (n > 4096) {
            return 4096;
        }
        return n;
    }

    public static int computeRawMessageSetExtensionSize(int n, ByteString byteString) {
        int n2 = CodedOutputStream.computeTagSize(1);
        return n2 + n2 + CodedOutputStream.computeUInt32Size(2, n) + CodedOutputStream.computeBytesSize(3, byteString);
    }

    public static int computeSFixed32Size(int n, int n2) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeSFixed32SizeNoTag(n2);
    }

    public static int computeSFixed32SizeNoTag(int n) {
        return 4;
    }

    public static int computeSFixed64Size(int n, long l) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeSFixed64SizeNoTag(l);
    }

    public static int computeSFixed64SizeNoTag(long l) {
        return 8;
    }

    public static int computeSInt32Size(int n, int n2) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeSInt32SizeNoTag(n2);
    }

    public static int computeSInt32SizeNoTag(int n) {
        return CodedOutputStream.computeUInt32SizeNoTag(CodedOutputStream.encodeZigZag32(n));
    }

    public static int computeSInt64Size(int n, long l) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeSInt64SizeNoTag(l);
    }

    public static int computeSInt64SizeNoTag(long l) {
        return CodedOutputStream.computeUInt64SizeNoTag(CodedOutputStream.encodeZigZag64(l));
    }

    public static int computeStringSize(int n, String string) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeStringSizeNoTag(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int computeStringSizeNoTag(String string) {
        int n;
        try {
            int n2;
            n = n2 = Utf8.encodedLength(string);
        }
        catch (Utf8.UnpairedSurrogateException unpairedSurrogateException) {
            n = string.getBytes(Internal.UTF_8).length;
            return CodedOutputStream.computeLengthDelimitedFieldSize(n);
        }
        return CodedOutputStream.computeLengthDelimitedFieldSize(n);
    }

    public static int computeTagSize(int n) {
        return CodedOutputStream.computeUInt32SizeNoTag(WireFormat.makeTag(n, 0));
    }

    public static int computeUInt32Size(int n, int n2) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeUInt32SizeNoTag(n2);
    }

    public static int computeUInt32SizeNoTag(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int computeUInt64Size(int n, long l) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeUInt64SizeNoTag(l);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int computeUInt64SizeNoTag(long l) {
        int n;
        long l2;
        int n2;
        long l3;
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (l < 0L) {
            return 10;
        }
        if ((l & 0xFFFFFFF800000000L) != 0L) {
            l3 = l >>> 28;
            n2 = 6;
        } else {
            l3 = l;
            n2 = 2;
        }
        if ((l3 & 0xFFFFFFFFFFE00000L) != 0L) {
            l2 = l3 >>> 14;
            n = n2 += 2;
        } else {
            l2 = l3;
            n = n2;
        }
        if ((l2 & 0xFFFFFFFFFFFFC000L) != 0L) {
            return n + 1;
        }
        return n;
    }

    public static int encodeZigZag32(int n) {
        return n + n ^ n >> 31;
    }

    public abstract int spaceLeft();

    public static long encodeZigZag64(long l) {
        return l + l ^ l >> 63;
    }

    public static CodedOutputStream newInstance(byte[] byArray) {
        return CodedOutputStream.newInstance(byArray, 0, byArray.length);
    }

    public static CodedOutputStream newInstance(OutputStream outputStream, int n) {
        OutputStreamEncoder outputStreamEncoder = new OutputStreamEncoder(outputStream, n);
        return outputStreamEncoder;
    }

    public static CodedOutputStream newInstance(byte[] byArray, int n, int n2) {
        ArrayEncoder arrayEncoder = new ArrayEncoder(byArray, n, n2);
        return arrayEncoder;
    }

    private CodedOutputStream() {
    }

    /* synthetic */ CodedOutputStream(CodedOutputStream-IA codedOutputStream-IA) {
        this();
    }

    public final void checkNoSpaceLeft() {
        if (((CodedOutputStream)object).spaceLeft() != 0) {
            Object object = new IllegalStateException("Did not write as much data as expected.");
            throw object;
        }
    }

    public abstract void flush() throws IOException;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void inefficientWriteStringNoTag(String object, Utf8.UnpairedSurrogateException unpairedSurrogateException) throws IOException {
        logger.logp(Level.WARNING, "androidx.test.espresso.remote.internal.deps.protobuf.CodedOutputStream", "inefficientWriteStringNoTag", "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", unpairedSurrogateException);
        object = ((String)object).getBytes(Internal.UTF_8);
        try {
            this.writeUInt32NoTag(((Object)object).length);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            object = new OutOfSpaceException(indexOutOfBoundsException);
            throw object;
        }
        {
            this.writeLazy((byte[])object, 0, ((Object)object).length);
            return;
        }
    }

    public abstract void write(byte var1) throws IOException;

    public abstract void writeBool(int var1, boolean var2) throws IOException;

    /*
     * Enabled aggressive block sorting
     */
    public final void writeBoolNoTag(boolean bl) throws IOException {
        bl = bl;
        this.write(bl ? 1 : 0);
    }

    public final void writeByteArrayNoTag(byte[] byArray) throws IOException {
        this.writeByteArrayNoTag(byArray, 0, byArray.length);
    }

    abstract void writeByteArrayNoTag(byte[] var1, int var2, int var3) throws IOException;

    public abstract void writeBytes(int var1, ByteString var2) throws IOException;

    public abstract void writeBytesNoTag(ByteString var1) throws IOException;

    public final void writeDouble(int n, double d) throws IOException {
        this.writeFixed64(n, Double.doubleToRawLongBits(d));
    }

    public final void writeDoubleNoTag(double d) throws IOException {
        this.writeFixed64NoTag(Double.doubleToRawLongBits(d));
    }

    public final void writeEnum(int n, int n2) throws IOException {
        this.writeInt32(n, n2);
    }

    public final void writeEnumNoTag(int n) throws IOException {
        this.writeInt32NoTag(n);
    }

    public abstract void writeFixed32(int var1, int var2) throws IOException;

    public abstract void writeFixed32NoTag(int var1) throws IOException;

    public abstract void writeFixed64(int var1, long var2) throws IOException;

    public abstract void writeFixed64NoTag(long var1) throws IOException;

    public final void writeFloat(int n, float f) throws IOException {
        this.writeFixed32(n, Float.floatToRawIntBits(f));
    }

    public final void writeFloatNoTag(float f) throws IOException {
        this.writeFixed32NoTag(Float.floatToRawIntBits(f));
    }

    @Deprecated
    public final void writeGroup(int n, MessageLite messageLite) throws IOException {
        this.writeTag(n, 3);
        this.writeGroupNoTag(messageLite);
        this.writeTag(n, 4);
    }

    @Deprecated
    final void writeGroup(int n, MessageLite messageLite, Schema schema) throws IOException {
        this.writeTag(n, 3);
        this.writeGroupNoTag(messageLite, schema);
        this.writeTag(n, 4);
    }

    @Deprecated
    public final void writeGroupNoTag(MessageLite messageLite) throws IOException {
        messageLite.writeTo(this);
    }

    @Deprecated
    final void writeGroupNoTag(MessageLite messageLite, Schema schema) throws IOException {
        schema.writeTo(messageLite, this.wrapper);
    }

    public abstract void writeInt32(int var1, int var2) throws IOException;

    public abstract void writeInt32NoTag(int var1) throws IOException;

    public final void writeInt64(int n, long l) throws IOException {
        this.writeUInt64(n, l);
    }

    public final void writeInt64NoTag(long l) throws IOException {
        this.writeUInt64NoTag(l);
    }

    @Override
    public abstract void writeLazy(byte[] var1, int var2, int var3) throws IOException;

    abstract void writeMessage(int var1, MessageLite var2, Schema var3) throws IOException;

    public abstract void writeMessageNoTag(MessageLite var1) throws IOException;

    public abstract void writeMessageSetExtension(int var1, MessageLite var2) throws IOException;

    public abstract void writeRawMessageSetExtension(int var1, ByteString var2) throws IOException;

    public final void writeSFixed32(int n, int n2) throws IOException {
        this.writeFixed32(n, n2);
    }

    public final void writeSFixed32NoTag(int n) throws IOException {
        this.writeFixed32NoTag(n);
    }

    public final void writeSFixed64(int n, long l) throws IOException {
        this.writeFixed64(n, l);
    }

    public final void writeSFixed64NoTag(long l) throws IOException {
        this.writeFixed64NoTag(l);
    }

    public final void writeSInt32(int n, int n2) throws IOException {
        this.writeUInt32(n, CodedOutputStream.encodeZigZag32(n2));
    }

    public final void writeSInt32NoTag(int n) throws IOException {
        this.writeUInt32NoTag(CodedOutputStream.encodeZigZag32(n));
    }

    public final void writeSInt64(int n, long l) throws IOException {
        this.writeUInt64(n, CodedOutputStream.encodeZigZag64(l));
    }

    public final void writeSInt64NoTag(long l) throws IOException {
        this.writeUInt64NoTag(CodedOutputStream.encodeZigZag64(l));
    }

    public abstract void writeString(int var1, String var2) throws IOException;

    public abstract void writeStringNoTag(String var1) throws IOException;

    public abstract void writeTag(int var1, int var2) throws IOException;

    public abstract void writeUInt32(int var1, int var2) throws IOException;

    public abstract void writeUInt32NoTag(int var1) throws IOException;

    public abstract void writeUInt64(int var1, long var2) throws IOException;

    public abstract void writeUInt64NoTag(long var1) throws IOException;

    boolean isSerializationDeterministic() {
        return this.serializationDeterministic;
    }

    private static final class OutputStreamEncoder
    extends AbstractBufferedEncoder {
        private final OutputStream out;

        OutputStreamEncoder(OutputStream outputStream, int n) {
            super(n);
            if (outputStream == null) {
                Object object = new NullPointerException("out");
                throw object;
            }
            ((OutputStreamEncoder)object).out = outputStream;
        }

        private void doFlush() throws IOException {
            this.out.write(this.buffer, 0, this.position);
            this.position = 0;
        }

        @Override
        public void flush() throws IOException {
            if (this.position > 0) {
                this.doFlush();
                return;
            }
        }

        private void flushIfNotAvailable(int n) throws IOException {
            if (this.limit - this.position < n) {
                this.doFlush();
                return;
            }
        }

        @Override
        public void write(byte by) throws IOException {
            if (this.position == this.limit) {
                this.doFlush();
            }
            this.buffer(by);
        }

        public void write(ByteBuffer byteBuffer) throws IOException {
            int n = byteBuffer.remaining();
            if (this.limit - this.position >= n) {
                byteBuffer.get(this.buffer, this.position, n);
                this.position += n;
                this.totalBytesWritten += n;
                return;
            }
            int n2 = this.limit - this.position;
            byteBuffer.get(this.buffer, this.position, n2);
            n -= n2;
            this.position = this.limit;
            this.totalBytesWritten += n2;
            this.doFlush();
            while (n > this.limit) {
                byteBuffer.get(this.buffer, 0, this.limit);
                this.out.write(this.buffer, 0, this.limit);
                n -= this.limit;
                this.totalBytesWritten += this.limit;
            }
            byteBuffer.get(this.buffer, 0, n);
            this.position = n;
            this.totalBytesWritten += n;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.limit - this.position >= n2) {
                System.arraycopy(byArray, n, this.buffer, this.position, n2);
                this.position += n2;
                this.totalBytesWritten += n2;
                return;
            }
            int n3 = this.limit - this.position;
            System.arraycopy(byArray, n, this.buffer, this.position, n3);
            n += n3;
            this.position = this.limit;
            this.totalBytesWritten += n3;
            this.doFlush();
            if ((n2 -= n3) <= this.limit) {
                System.arraycopy(byArray, n, this.buffer, 0, n2);
                this.position = n2;
            } else {
                this.out.write(byArray, n, n2);
            }
            this.totalBytesWritten += n2;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeBool(int n, boolean bl) throws IOException {
            this.flushIfNotAvailable(11);
            this.bufferTag(n, 0);
            n = bl ? 1 : 0;
            this.buffer((byte)n);
        }

        @Override
        public void writeByteArrayNoTag(byte[] byArray, int n, int n2) throws IOException {
            this.writeUInt32NoTag(n2);
            this.write(byArray, n, n2);
        }

        @Override
        public void writeBytes(int n, ByteString byteString) throws IOException {
            this.writeTag(n, 2);
            this.writeBytesNoTag(byteString);
        }

        @Override
        public void writeBytesNoTag(ByteString byteString) throws IOException {
            this.writeUInt32NoTag(byteString.size());
            byteString.writeTo(this);
        }

        @Override
        public void writeFixed32(int n, int n2) throws IOException {
            this.flushIfNotAvailable(14);
            this.bufferTag(n, 5);
            this.bufferFixed32NoTag(n2);
        }

        @Override
        public void writeFixed32NoTag(int n) throws IOException {
            this.flushIfNotAvailable(4);
            this.bufferFixed32NoTag(n);
        }

        @Override
        public void writeFixed64(int n, long l) throws IOException {
            this.flushIfNotAvailable(18);
            this.bufferTag(n, 1);
            this.bufferFixed64NoTag(l);
        }

        @Override
        public void writeFixed64NoTag(long l) throws IOException {
            this.flushIfNotAvailable(8);
            this.bufferFixed64NoTag(l);
        }

        @Override
        public void writeInt32(int n, int n2) throws IOException {
            this.flushIfNotAvailable(20);
            this.bufferTag(n, 0);
            this.bufferInt32NoTag(n2);
        }

        @Override
        public void writeInt32NoTag(int n) throws IOException {
            if (n >= 0) {
                this.writeUInt32NoTag(n);
                return;
            }
            this.writeUInt64NoTag(n);
        }

        @Override
        public void writeLazy(ByteBuffer byteBuffer) throws IOException {
            this.write(byteBuffer);
        }

        @Override
        public void writeLazy(byte[] byArray, int n, int n2) throws IOException {
            this.write(byArray, n, n2);
        }

        public void writeMessage(int n, MessageLite messageLite) throws IOException {
            this.writeTag(n, 2);
            this.writeMessageNoTag(messageLite);
        }

        @Override
        void writeMessage(int n, MessageLite messageLite, Schema schema) throws IOException {
            this.writeTag(n, 2);
            this.writeMessageNoTag(messageLite, schema);
        }

        @Override
        public void writeMessageNoTag(MessageLite messageLite) throws IOException {
            this.writeUInt32NoTag(messageLite.getSerializedSize());
            messageLite.writeTo(this);
        }

        void writeMessageNoTag(MessageLite messageLite, Schema schema) throws IOException {
            this.writeUInt32NoTag(((AbstractMessageLite)messageLite).getSerializedSize(schema));
            schema.writeTo(messageLite, this.wrapper);
        }

        @Override
        public void writeMessageSetExtension(int n, MessageLite messageLite) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, n);
            this.writeMessage(3, messageLite);
            this.writeTag(1, 4);
        }

        @Override
        public void writeRawMessageSetExtension(int n, ByteString byteString) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, n);
            this.writeBytes(3, byteString);
            this.writeTag(1, 4);
        }

        @Override
        public void writeString(int n, String string) throws IOException {
            this.writeTag(n, 2);
            this.writeStringNoTag(string);
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void writeStringNoTag(String var1_1) throws IOException {
            var2_2 = var1_1.length();
            var3_6 = OutputStreamEncoder.computeUInt32SizeNoTag(var2_2 *= 3);
            var4_11 = var3_6 + var2_2;
            var5_12 = this.limit;
            if (var4_11 > var5_12) {
                var3_7 = new byte[var2_2];
                var2_2 = Utf8.encode(var1_1, var3_7, 0, var2_2);
                this.writeUInt32NoTag(var2_2);
                this.writeLazy(var3_7, 0, var2_2);
                return;
            }
            var4_11 = this.limit;
            var5_12 = this.position;
            if ((var2_2 = var3_6 + var2_2) > var4_11 - var5_12) {
                this.doFlush();
            }
            var2_2 = OutputStreamEncoder.computeUInt32SizeNoTag(var1_1.length());
            var4_11 = this.position;
            if (var2_2 != var3_6) ** GOTO lbl34
            {
                catch (Utf8.UnpairedSurrogateException var2_3) {
                    this.inefficientWriteStringNoTag(var1_1, var2_3);
                    return;
                }
            }
            try {
                block12: {
                    this.position = var4_11 + var2_2;
                    var3_8 = this.buffer;
                    var5_12 = this.position;
                    var6_13 = this.limit;
                    var7_14 = this.position;
                    var3_9 = Utf8.encode(var1_1, var3_8, var5_12, var6_13 -= var7_14);
                    this.position = var4_11;
                    var2_2 = var3_9 - var4_11 - var2_2;
                    this.bufferUInt32NoTag(var2_2);
                    this.position = var3_9;
                    break block12;
lbl34:
                    // 1 sources

                    var2_2 = Utf8.encodedLength(var1_1);
                    this.bufferUInt32NoTag(var2_2);
                    this.position = Utf8.encode(var1_1, this.buffer, this.position, var2_2);
                }
                this.totalBytesWritten += var2_2;
                return;
            }
            catch (Utf8.UnpairedSurrogateException var2_4) {
                this.totalBytesWritten -= this.position - var4_11;
                this.position = var4_11;
                throw var2_4;
            }
            catch (ArrayIndexOutOfBoundsException var2_5) {}
            var3_10 = new OutOfSpaceException(var2_5);
            throw var3_10;
        }

        @Override
        public void writeTag(int n, int n2) throws IOException {
            this.writeUInt32NoTag(WireFormat.makeTag(n, n2));
        }

        @Override
        public void writeUInt32(int n, int n2) throws IOException {
            this.flushIfNotAvailable(20);
            this.bufferTag(n, 0);
            this.bufferUInt32NoTag(n2);
        }

        @Override
        public void writeUInt32NoTag(int n) throws IOException {
            this.flushIfNotAvailable(5);
            this.bufferUInt32NoTag(n);
        }

        @Override
        public void writeUInt64(int n, long l) throws IOException {
            this.flushIfNotAvailable(20);
            this.bufferTag(n, 0);
            this.bufferUInt64NoTag(l);
        }

        @Override
        public void writeUInt64NoTag(long l) throws IOException {
            this.flushIfNotAvailable(10);
            this.bufferUInt64NoTag(l);
        }
    }

    private static class ArrayEncoder
    extends CodedOutputStream {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        @Override
        public final int spaceLeft() {
            return this.limit - this.position;
        }

        ArrayEncoder(byte[] byArray, int n, int n2) {
            super(null);
            Object object;
            if (byArray == null) {
                object = new NullPointerException("buffer");
                throw object;
            }
            if ((n | n2 | byArray.length - (n + n2)) < 0) {
                Object[] objectArray = new Object[]{byArray.length, n, n2};
                object = new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", objectArray));
                throw object;
            }
            ((ArrayEncoder)object).buffer = byArray;
            ((ArrayEncoder)object).offset = n;
            ((ArrayEncoder)object).position = n;
            ((ArrayEncoder)object).limit = n + n2;
        }

        @Override
        public void flush() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void write(byte by) throws IOException {
            try {
                byte[] byArray = this.buffer;
                int n = this.position;
                this.position = n + 1;
                byArray[n] = by;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                Object[] objectArray = new Object[]{this.position, this.limit, 1};
                OutOfSpaceException outOfSpaceException = new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", objectArray), indexOutOfBoundsException);
                throw outOfSpaceException;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void write(ByteBuffer byteBuffer) throws IOException {
            int n = byteBuffer.remaining();
            try {
                byteBuffer.get(this.buffer, this.position, n);
                this.position += n;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                Object[] objectArray = new Object[]{this.position, this.limit, n};
                OutOfSpaceException outOfSpaceException = new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", objectArray), indexOutOfBoundsException);
                throw outOfSpaceException;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                System.arraycopy(byArray, n, this.buffer, this.position, n2);
                this.position += n2;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                Object[] objectArray = new Object[]{this.position, this.limit, n2};
                OutOfSpaceException outOfSpaceException = new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", objectArray), indexOutOfBoundsException);
                throw outOfSpaceException;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public final void writeBool(int n, boolean bl) throws IOException {
            this.writeTag(n, 0);
            n = bl ? 1 : 0;
            this.write((byte)n);
        }

        @Override
        public final void writeByteArrayNoTag(byte[] byArray, int n, int n2) throws IOException {
            this.writeUInt32NoTag(n2);
            this.write(byArray, n, n2);
        }

        @Override
        public final void writeBytes(int n, ByteString byteString) throws IOException {
            this.writeTag(n, 2);
            this.writeBytesNoTag(byteString);
        }

        @Override
        public final void writeBytesNoTag(ByteString byteString) throws IOException {
            this.writeUInt32NoTag(byteString.size());
            byteString.writeTo(this);
        }

        @Override
        public final void writeFixed32(int n, int n2) throws IOException {
            this.writeTag(n, 5);
            this.writeFixed32NoTag(n2);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void writeFixed32NoTag(int n) throws IOException {
            try {
                byte[] byArray = this.buffer;
                int n2 = this.position;
                this.position = n2 + 1;
                byArray[n2] = (byte)(n & 0xFF);
                byArray = this.buffer;
                n2 = this.position;
                this.position = n2 + 1;
                byArray[n2] = (byte)(n >> 8 & 0xFF);
                byArray = this.buffer;
                n2 = this.position;
                this.position = n2 + 1;
                byArray[n2] = (byte)(n >> 16 & 0xFF);
                byArray = this.buffer;
                n2 = this.position;
                this.position = n2 + 1;
                byArray[n2] = (byte)(n >> 24 & 0xFF);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                Object[] objectArray = new Object[]{this.position, this.limit, 1};
                OutOfSpaceException outOfSpaceException = new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", objectArray), indexOutOfBoundsException);
                throw outOfSpaceException;
            }
        }

        @Override
        public final void writeFixed64(int n, long l) throws IOException {
            this.writeTag(n, 1);
            this.writeFixed64NoTag(l);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void writeFixed64NoTag(long l) throws IOException {
            try {
                byte[] byArray = this.buffer;
                int n = this.position;
                this.position = n + 1;
                byArray[n] = (byte)((int)l & 0xFF);
                byArray = this.buffer;
                n = this.position;
                this.position = n + 1;
                byArray[n] = (byte)((int)(l >> 8) & 0xFF);
                byArray = this.buffer;
                n = this.position;
                this.position = n + 1;
                byArray[n] = (byte)((int)(l >> 16) & 0xFF);
                byArray = this.buffer;
                n = this.position;
                this.position = n + 1;
                byArray[n] = (byte)((int)(l >> 24) & 0xFF);
                byArray = this.buffer;
                n = this.position;
                this.position = n + 1;
                byArray[n] = (byte)((int)(l >> 32) & 0xFF);
                byArray = this.buffer;
                n = this.position;
                this.position = n + 1;
                byArray[n] = (byte)((int)(l >> 40) & 0xFF);
                byArray = this.buffer;
                n = this.position;
                this.position = n + 1;
                byArray[n] = (byte)((int)(l >> 48) & 0xFF);
                byArray = this.buffer;
                n = this.position;
                this.position = n + 1;
                byArray[n] = (byte)((int)(l >> 56) & 0xFF);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                Object[] objectArray = new Object[]{this.position, this.limit, 1};
                OutOfSpaceException outOfSpaceException = new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", objectArray), indexOutOfBoundsException);
                throw outOfSpaceException;
            }
        }

        @Override
        public final void writeInt32(int n, int n2) throws IOException {
            this.writeTag(n, 0);
            this.writeInt32NoTag(n2);
        }

        @Override
        public final void writeInt32NoTag(int n) throws IOException {
            if (n >= 0) {
                this.writeUInt32NoTag(n);
                return;
            }
            this.writeUInt64NoTag(n);
        }

        @Override
        public final void writeLazy(ByteBuffer byteBuffer) throws IOException {
            this.write(byteBuffer);
        }

        @Override
        public final void writeLazy(byte[] byArray, int n, int n2) throws IOException {
            this.write(byArray, n, n2);
        }

        public final void writeMessage(int n, MessageLite messageLite) throws IOException {
            this.writeTag(n, 2);
            this.writeMessageNoTag(messageLite);
        }

        @Override
        final void writeMessage(int n, MessageLite messageLite, Schema schema) throws IOException {
            this.writeTag(n, 2);
            this.writeUInt32NoTag(((AbstractMessageLite)messageLite).getSerializedSize(schema));
            schema.writeTo(messageLite, this.wrapper);
        }

        @Override
        public final void writeMessageNoTag(MessageLite messageLite) throws IOException {
            this.writeUInt32NoTag(messageLite.getSerializedSize());
            messageLite.writeTo(this);
        }

        @Override
        public final void writeMessageSetExtension(int n, MessageLite messageLite) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, n);
            this.writeMessage(3, messageLite);
            this.writeTag(1, 4);
        }

        @Override
        public final void writeRawMessageSetExtension(int n, ByteString byteString) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, n);
            this.writeBytes(3, byteString);
            this.writeTag(1, 4);
        }

        @Override
        public final void writeString(int n, String string) throws IOException {
            this.writeTag(n, 2);
            this.writeStringNoTag(string);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void writeStringNoTag(String object) throws IOException {
            int n = this.position;
            try {
                int n2 = ArrayEncoder.computeUInt32SizeNoTag(((String)object).length() * 3);
                int n3 = ArrayEncoder.computeUInt32SizeNoTag(((String)object).length());
                if (n3 == n2) {
                    this.position = n + n3;
                    byte[] byArray = this.buffer;
                    int n4 = this.position;
                    int n5 = this.spaceLeft();
                    int n6 = Utf8.encode((CharSequence)object, byArray, n4, n5);
                    this.position = n;
                    this.writeUInt32NoTag(n6 - n - n3);
                    this.position = n6;
                    return;
                }
                this.writeUInt32NoTag(Utf8.encodedLength((CharSequence)object));
                this.position = Utf8.encode((CharSequence)object, this.buffer, this.position, this.spaceLeft());
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                object = new OutOfSpaceException(indexOutOfBoundsException);
                throw object;
            }
            catch (Utf8.UnpairedSurrogateException unpairedSurrogateException) {
                this.position = n;
                this.inefficientWriteStringNoTag((String)object, unpairedSurrogateException);
                return;
            }
        }

        @Override
        public final void writeTag(int n, int n2) throws IOException {
            this.writeUInt32NoTag(WireFormat.makeTag(n, n2));
        }

        @Override
        public final void writeUInt32(int n, int n2) throws IOException {
            this.writeTag(n, 0);
            this.writeUInt32NoTag(n2);
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public final void writeUInt32NoTag(int var1_1) throws IOException {
            while (true) {
                if ((var1_1 & -128) != 0) ** GOTO lbl9
                try {
                    var2_3 /* !! */  = this.buffer;
                    var3_4 = this.position;
                    this.position = var3_4 + 1;
                    var2_3 /* !! */ [var3_4] = (byte)var1_1;
                    return;
lbl9:
                    // 1 sources

                    var2_3 /* !! */  = this.buffer;
                    var3_4 = this.position;
                    this.position = var3_4 + 1;
                    var2_3 /* !! */ [var3_4] = (byte)(var1_1 & 127 | 128);
                }
                catch (IndexOutOfBoundsException var1_2) {
                    var2_3 /* !! */  = (byte[])new OutOfSpaceException;
                    var3_5 = new Object[]{this.position, this.limit, 1};
                    var2_3 /* !! */ (String.format("Pos: %d, limit: %d, len: %d", var3_5), var1_2);
                    throw var2_3 /* !! */ ;
                }
                var1_1 >>>= 7;
            }
        }

        @Override
        public final void writeUInt64(int n, long l) throws IOException {
            this.writeTag(n, 0);
            this.writeUInt64NoTag(l);
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public final void writeUInt64NoTag(long var1_1) throws IOException {
            block6: {
                if (!CodedOutputStream.-$$Nest$sfgetHAS_UNSAFE_ARRAY_OPERATIONS()) break block6;
                if (this.spaceLeft() >= 10) {
                    var3_2 = var1_1;
                    while (true) {
                        if ((var3_2 & -128L) == 0L) {
                            var5_3 = this.buffer;
                            var6_6 = this.position;
                            this.position = var6_6 + 1;
                            UnsafeUtil.putByte(var5_3, var6_6, (byte)var3_2);
                            return;
                        }
                        var5_3 = this.buffer;
                        var6_6 = this.position;
                        this.position = var6_6 + 1;
                        UnsafeUtil.putByte(var5_3, var6_6, (byte)((int)var3_2 & 127 | 128));
                        var3_2 >>>= 7;
                    }
                }
                var5_4 = var1_1;
lbl18:
                // 2 sources

                while (true) {
                    if ((var5_4 & -128L) != 0L) ** GOTO lbl26
                    try {
                        var7_8 /* !! */  = this.buffer;
                        var8_9 = this.position;
                        this.position = var8_9 + 1;
                        var7_8 /* !! */ [var8_9] = (byte)var5_4;
                        return;
lbl26:
                        // 1 sources

                        var7_8 /* !! */  = this.buffer;
                        var8_9 = this.position;
                        this.position = var8_9 + 1;
                        var7_8 /* !! */ [var8_9] = (byte)((int)var5_4 & 127 | 128);
                        var5_4 = var1_1 = var5_4 >>> 7;
                    }
                    catch (IndexOutOfBoundsException var5_5) {
                        var7_8 /* !! */  = (byte[])new Object[3];
                        var7_8 /* !! */ [0] = (byte)this.position;
                        var7_8 /* !! */ [1] = (byte)this.limit;
                        var7_8 /* !! */ [2] = (byte)1;
                        var6_7 = new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", var7_8 /* !! */ ), var5_5);
                        throw var6_7;
                    }
                    break;
                }
            }
            var5_4 = var1_1;
            ** while (true)
        }
    }

    public static class OutOfSpaceException
    extends IOException {
        private static final long serialVersionUID = -6947486886997889499L;

        OutOfSpaceException() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }

        OutOfSpaceException(Throwable throwable) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.", throwable);
        }

        OutOfSpaceException(String string, Throwable throwable) {
            StringBuilder stringBuilder = new StringBuilder();
            super(stringBuilder.append("CodedOutputStream was writing to a flat byte array and ran out of space.: ").append(string).toString(), throwable);
        }
    }

    private static abstract class AbstractBufferedEncoder
    extends CodedOutputStream {
        final byte[] buffer;
        final int limit;
        int position;
        int totalBytesWritten;

        @Override
        public final int spaceLeft() {
            Object object = new UnsupportedOperationException("spaceLeft() can only be called on CodedOutputStreams that are writing to a flat array or ByteBuffer.");
            throw object;
        }

        AbstractBufferedEncoder(int n) {
            super(null);
            if (n < 0) {
                Object object = new IllegalArgumentException("bufferSize must be >= 0");
                throw object;
            }
            ((AbstractBufferedEncoder)object).buffer = new byte[Math.max(n, 20)];
            ((AbstractBufferedEncoder)object).limit = ((AbstractBufferedEncoder)object).buffer.length;
        }

        final void buffer(byte by) {
            byte[] byArray = this.buffer;
            int n = this.position;
            this.position = n + 1;
            byArray[n] = by;
            ++this.totalBytesWritten;
        }

        final void bufferFixed32NoTag(int n) {
            byte[] byArray = this.buffer;
            int n2 = this.position;
            this.position = n2 + 1;
            byArray[n2] = (byte)(n & 0xFF);
            byArray = this.buffer;
            n2 = this.position;
            this.position = n2 + 1;
            byArray[n2] = (byte)(n >> 8 & 0xFF);
            byArray = this.buffer;
            n2 = this.position;
            this.position = n2 + 1;
            byArray[n2] = (byte)(n >> 16 & 0xFF);
            byArray = this.buffer;
            n2 = this.position;
            this.position = n2 + 1;
            byArray[n2] = (byte)(n >> 24 & 0xFF);
            this.totalBytesWritten += 4;
        }

        final void bufferFixed64NoTag(long l) {
            byte[] byArray = this.buffer;
            int n = this.position;
            this.position = n + 1;
            byArray[n] = (byte)(l & 0xFFL);
            byArray = this.buffer;
            n = this.position;
            this.position = n + 1;
            byArray[n] = (byte)(l >> 8 & 0xFFL);
            byArray = this.buffer;
            n = this.position;
            this.position = n + 1;
            byArray[n] = (byte)(l >> 16 & 0xFFL);
            byArray = this.buffer;
            n = this.position;
            this.position = n + 1;
            byArray[n] = (byte)(l >> 24 & 0xFFL);
            byArray = this.buffer;
            n = this.position;
            this.position = n + 1;
            byArray[n] = (byte)((int)(l >> 32) & 0xFF);
            byArray = this.buffer;
            n = this.position;
            this.position = n + 1;
            byArray[n] = (byte)((int)(l >> 40) & 0xFF);
            byArray = this.buffer;
            n = this.position;
            this.position = n + 1;
            byArray[n] = (byte)((int)(l >> 48) & 0xFF);
            byArray = this.buffer;
            n = this.position;
            this.position = n + 1;
            byArray[n] = (byte)((int)(l >> 56) & 0xFF);
            this.totalBytesWritten += 8;
        }

        final void bufferInt32NoTag(int n) {
            if (n >= 0) {
                this.bufferUInt32NoTag(n);
                return;
            }
            this.bufferUInt64NoTag(n);
        }

        final void bufferTag(int n, int n2) {
            this.bufferUInt32NoTag(WireFormat.makeTag(n, n2));
        }

        final void bufferUInt32NoTag(int n) {
            if (HAS_UNSAFE_ARRAY_OPERATIONS) {
                long l = this.position;
                while (true) {
                    int n2;
                    byte[] byArray;
                    if ((n & 0xFFFFFF80) == 0) {
                        byArray = this.buffer;
                        n2 = this.position;
                        this.position = n2 + 1;
                        UnsafeUtil.putByte(byArray, n2, (byte)n);
                        n = this.position;
                        this.totalBytesWritten += (int)((long)n - l);
                        return;
                    }
                    byArray = this.buffer;
                    n2 = this.position;
                    this.position = n2 + 1;
                    UnsafeUtil.putByte(byArray, n2, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            while (true) {
                int n3;
                byte[] byArray;
                if ((n & 0xFFFFFF80) == 0) {
                    byArray = this.buffer;
                    n3 = this.position;
                    this.position = n3 + 1;
                    byArray[n3] = (byte)n;
                    ++this.totalBytesWritten;
                    return;
                }
                byArray = this.buffer;
                n3 = this.position;
                this.position = n3 + 1;
                byArray[n3] = (byte)(n & 0x7F | 0x80);
                ++this.totalBytesWritten;
                n >>>= 7;
            }
        }

        final void bufferUInt64NoTag(long l) {
            if (HAS_UNSAFE_ARRAY_OPERATIONS) {
                long l2 = this.position;
                long l3 = l;
                while (true) {
                    int n;
                    byte[] byArray;
                    if ((l3 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        byArray = this.buffer;
                        n = this.position;
                        this.position = n + 1;
                        UnsafeUtil.putByte(byArray, n, (byte)l3);
                        int n2 = this.position;
                        this.totalBytesWritten += (int)((long)n2 - l2);
                        return;
                    }
                    byArray = this.buffer;
                    n = this.position;
                    this.position = n + 1;
                    UnsafeUtil.putByte(byArray, n, (byte)((int)l3 & 0x7F | 0x80));
                    l3 = l = l3 >>> 7;
                }
            }
            long l4 = l;
            while (true) {
                int n;
                byte[] byArray;
                if ((l4 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    byArray = this.buffer;
                    n = this.position;
                    this.position = n + 1;
                    byArray[n] = (byte)l4;
                    ++this.totalBytesWritten;
                    return;
                }
                byArray = this.buffer;
                n = this.position;
                this.position = n + 1;
                byArray[n] = (byte)((int)l4 & 0x7F | 0x80);
                ++this.totalBytesWritten;
                l4 = l = l4 >>> 7;
            }
        }
    }
}

