/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.BooleanArrayList;
import androidx.test.espresso.remote.internal.deps.protobuf.ByteString;
import androidx.test.espresso.remote.internal.deps.protobuf.CodedInputStream;
import androidx.test.espresso.remote.internal.deps.protobuf.DoubleArrayList;
import androidx.test.espresso.remote.internal.deps.protobuf.ExtensionRegistryLite;
import androidx.test.espresso.remote.internal.deps.protobuf.FloatArrayList;
import androidx.test.espresso.remote.internal.deps.protobuf.IntArrayList;
import androidx.test.espresso.remote.internal.deps.protobuf.Internal;
import androidx.test.espresso.remote.internal.deps.protobuf.InvalidProtocolBufferException;
import androidx.test.espresso.remote.internal.deps.protobuf.LazyStringList;
import androidx.test.espresso.remote.internal.deps.protobuf.LongArrayList;
import androidx.test.espresso.remote.internal.deps.protobuf.MapEntryLite;
import androidx.test.espresso.remote.internal.deps.protobuf.Protobuf;
import androidx.test.espresso.remote.internal.deps.protobuf.Reader;
import androidx.test.espresso.remote.internal.deps.protobuf.Schema;
import androidx.test.espresso.remote.internal.deps.protobuf.WireFormat;
import java.io.IOException;
import java.util.List;
import java.util.Map;

final class CodedInputStreamReader
implements Reader {
    private final CodedInputStream input;
    private int tag;
    private int endGroupTag;
    private int nextTag = 0;

    @Override
    public double readDouble() throws IOException {
        this.requireWireType(1);
        return this.input.readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        this.requireWireType(5);
        return this.input.readFloat();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getFieldNumber() throws IOException {
        if (this.nextTag != 0) {
            this.tag = this.nextTag;
            this.nextTag = 0;
        } else {
            this.tag = this.input.readTag();
        }
        if (this.tag != 0 && this.tag != this.endGroupTag) {
            return WireFormat.getTagFieldNumber(this.tag);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int getTag() {
        return this.tag;
    }

    @Override
    public int readEnum() throws IOException {
        this.requireWireType(0);
        return this.input.readEnum();
    }

    @Override
    public int readFixed32() throws IOException {
        this.requireWireType(5);
        return this.input.readFixed32();
    }

    @Override
    public int readInt32() throws IOException {
        this.requireWireType(0);
        return this.input.readInt32();
    }

    @Override
    public int readSFixed32() throws IOException {
        this.requireWireType(5);
        return this.input.readSFixed32();
    }

    @Override
    public int readSInt32() throws IOException {
        this.requireWireType(0);
        return this.input.readSInt32();
    }

    @Override
    public int readUInt32() throws IOException {
        this.requireWireType(0);
        return this.input.readUInt32();
    }

    @Override
    public long readFixed64() throws IOException {
        this.requireWireType(1);
        return this.input.readFixed64();
    }

    @Override
    public long readInt64() throws IOException {
        this.requireWireType(0);
        return this.input.readInt64();
    }

    @Override
    public long readSFixed64() throws IOException {
        this.requireWireType(1);
        return this.input.readSFixed64();
    }

    @Override
    public long readSInt64() throws IOException {
        this.requireWireType(0);
        return this.input.readSInt64();
    }

    @Override
    public long readUInt64() throws IOException {
        this.requireWireType(0);
        return this.input.readUInt64();
    }

    @Override
    public ByteString readBytes() throws IOException {
        this.requireWireType(2);
        return this.input.readBytes();
    }

    public static CodedInputStreamReader forCodedInput(CodedInputStream codedInputStream) {
        if (codedInputStream.wrapper != null) {
            return codedInputStream.wrapper;
        }
        CodedInputStreamReader codedInputStreamReader = new CodedInputStreamReader(codedInputStream);
        return codedInputStreamReader;
    }

    private Object readField(WireFormat.FieldType fieldType, Class clazz, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        switch (1.$SwitchMap$com$google$protobuf$WireFormat$FieldType[fieldType.ordinal()]) {
            default: {
                Object object = new IllegalArgumentException("unsupported field type.");
                throw object;
            }
            case 17: {
                return ((CodedInputStreamReader)object).readUInt64();
            }
            case 16: {
                return ((CodedInputStreamReader)object).readUInt32();
            }
            case 15: {
                return ((CodedInputStreamReader)object).readStringRequireUtf8();
            }
            case 14: {
                return ((CodedInputStreamReader)object).readSInt64();
            }
            case 13: {
                return ((CodedInputStreamReader)object).readSInt32();
            }
            case 12: {
                return ((CodedInputStreamReader)object).readSFixed64();
            }
            case 11: {
                return ((CodedInputStreamReader)object).readSFixed32();
            }
            case 10: {
                return ((CodedInputStreamReader)object).readMessage(clazz, extensionRegistryLite);
            }
            case 9: {
                return ((CodedInputStreamReader)object).readInt64();
            }
            case 8: {
                return ((CodedInputStreamReader)object).readInt32();
            }
            case 7: {
                return Float.valueOf(((CodedInputStreamReader)object).readFloat());
            }
            case 6: {
                return ((CodedInputStreamReader)object).readFixed64();
            }
            case 5: {
                return ((CodedInputStreamReader)object).readFixed32();
            }
            case 4: {
                return ((CodedInputStreamReader)object).readEnum();
            }
            case 3: {
                return ((CodedInputStreamReader)object).readDouble();
            }
            case 2: {
                return ((CodedInputStreamReader)object).readBytes();
            }
            case 1: 
        }
        return ((CodedInputStreamReader)object).readBool();
    }

    private Object readGroup(Schema schema, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        Object object;
        int n;
        block3: {
            n = this.endGroupTag;
            this.endGroupTag = WireFormat.makeTag(WireFormat.getTagFieldNumber(this.tag), 4);
            try {
                object = schema.newInstance();
                schema.mergeFrom(object, this, extensionRegistryLite);
                schema.makeImmutable(object);
                int n2 = this.tag;
                int n3 = this.endGroupTag;
                if (n2 == n3) break block3;
            }
            catch (Throwable throwable) {
                this.endGroupTag = n;
                throw throwable;
            }
            throw InvalidProtocolBufferException.parseFailure();
        }
        this.endGroupTag = n;
        return object;
    }

    @Override
    @Deprecated
    public Object readGroup(Class clazz, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        this.requireWireType(3);
        return this.readGroup(Protobuf.getInstance().schemaFor(clazz), extensionRegistryLite);
    }

    @Override
    @Deprecated
    public Object readGroupBySchemaWithCheck(Schema schema, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        this.requireWireType(3);
        return this.readGroup(schema, extensionRegistryLite);
    }

    private Object readMessage(Schema object, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        int n = this.input.readUInt32();
        if (this.input.recursionDepth >= this.input.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        Object object2 = this.input;
        n = ((CodedInputStream)object2).pushLimit(n);
        object2 = object.newInstance();
        CodedInputStream codedInputStream = this.input;
        ++codedInputStream.recursionDepth;
        object.mergeFrom(object2, this, extensionRegistryLite);
        object.makeImmutable(object2);
        this.input.checkLastTagWas(0);
        object = this.input;
        ((CodedInputStream)object).recursionDepth += -1;
        this.input.popLimit(n);
        return object2;
    }

    @Override
    public Object readMessage(Class clazz, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        this.requireWireType(2);
        return this.readMessage(Protobuf.getInstance().schemaFor(clazz), extensionRegistryLite);
    }

    @Override
    public Object readMessageBySchemaWithCheck(Schema schema, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        this.requireWireType(2);
        return this.readMessage(schema, extensionRegistryLite);
    }

    @Override
    public String readString() throws IOException {
        this.requireWireType(2);
        return this.input.readString();
    }

    @Override
    public String readStringRequireUtf8() throws IOException {
        this.requireWireType(2);
        return this.input.readStringRequireUtf8();
    }

    private CodedInputStreamReader(CodedInputStream codedInputStream) {
        this.input = (CodedInputStream)Internal.checkNotNull(codedInputStream, "input");
        this.input.wrapper = this;
    }

    @Override
    public void readBoolList(List list) throws IOException {
        int n;
        if (list instanceof BooleanArrayList) {
            list = (BooleanArrayList)list;
            switch (WireFormat.getTagWireType(this.tag)) {
                case 0: {
                    int n2;
                    do {
                        ((BooleanArrayList)list).addBoolean(this.input.readBool());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((n2 = this.input.readTag()) == this.tag);
                    this.nextTag = n2;
                    return;
                }
                case 2: {
                    CodedInputStream codedInputStream = this.input;
                    int n3 = codedInputStream.readUInt32();
                    n3 = this.input.getTotalBytesRead() + n3;
                    do {
                        ((BooleanArrayList)list).addBoolean(this.input.readBool());
                    } while (this.input.getTotalBytesRead() < n3);
                    this.requirePosition(n3);
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }
        switch (WireFormat.getTagWireType(this.tag)) {
            case 0: {
                int n4;
                do {
                    list.add(this.input.readBool());
                    if (!this.input.isAtEnd()) continue;
                    return;
                } while ((n4 = this.input.readTag()) == this.tag);
                this.nextTag = n4;
                return;
            }
            case 2: {
                CodedInputStream codedInputStream = this.input;
                n = codedInputStream.readUInt32();
                n = this.input.getTotalBytesRead() + n;
                do {
                    list.add(this.input.readBool());
                } while (this.input.getTotalBytesRead() < n);
                break;
            }
            default: {
                throw InvalidProtocolBufferException.invalidWireType();
            }
        }
        this.requirePosition(n);
    }

    @Override
    public void readBytesList(List list) throws IOException {
        int n;
        if (WireFormat.getTagWireType(this.tag) == 2) {
            do {
                list.add(this.readBytes());
                if (!this.input.isAtEnd()) continue;
                return;
            } while ((n = this.input.readTag()) == this.tag);
        } else {
            throw InvalidProtocolBufferException.invalidWireType();
        }
        this.nextTag = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void readDoubleList(List list) throws IOException {
        int n;
        if (list instanceof DoubleArrayList) {
            list = (DoubleArrayList)list;
            switch (WireFormat.getTagWireType(this.tag)) {
                case 1: {
                    int n2;
                    do {
                        ((DoubleArrayList)list).addDouble(this.input.readDouble());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((n2 = this.input.readTag()) == this.tag);
                    this.nextTag = n2;
                    return;
                }
                case 2: {
                    int n3 = this.input.readUInt32();
                    this.verifyPackedFixed64Length(n3);
                    n3 = this.input.getTotalBytesRead() + n3;
                    do {
                        ((DoubleArrayList)list).addDouble(this.input.readDouble());
                    } while (this.input.getTotalBytesRead() < n3);
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }
        switch (WireFormat.getTagWireType(this.tag)) {
            case 1: {
                int n4;
                do {
                    list.add(this.input.readDouble());
                    if (!this.input.isAtEnd()) continue;
                    return;
                } while ((n4 = this.input.readTag()) == this.tag);
                this.nextTag = n4;
                return;
            }
            case 2: {
                n = this.input.readUInt32();
                this.verifyPackedFixed64Length(n);
                n = this.input.getTotalBytesRead() + n;
                break;
            }
            default: {
                throw InvalidProtocolBufferException.invalidWireType();
            }
        }
        do {
            list.add(this.input.readDouble());
        } while (this.input.getTotalBytesRead() < n);
    }

    @Override
    public void readEnumList(List list) throws IOException {
        int n;
        if (list instanceof IntArrayList) {
            list = (IntArrayList)list;
            switch (WireFormat.getTagWireType(this.tag)) {
                case 0: {
                    int n2;
                    do {
                        ((IntArrayList)list).addInt(this.input.readEnum());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((n2 = this.input.readTag()) == this.tag);
                    this.nextTag = n2;
                    return;
                }
                case 2: {
                    CodedInputStream codedInputStream = this.input;
                    int n3 = codedInputStream.readUInt32();
                    n3 = this.input.getTotalBytesRead() + n3;
                    do {
                        ((IntArrayList)list).addInt(this.input.readEnum());
                    } while (this.input.getTotalBytesRead() < n3);
                    this.requirePosition(n3);
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }
        switch (WireFormat.getTagWireType(this.tag)) {
            case 0: {
                int n4;
                do {
                    list.add(this.input.readEnum());
                    if (!this.input.isAtEnd()) continue;
                    return;
                } while ((n4 = this.input.readTag()) == this.tag);
                this.nextTag = n4;
                return;
            }
            case 2: {
                CodedInputStream codedInputStream = this.input;
                n = codedInputStream.readUInt32();
                n = this.input.getTotalBytesRead() + n;
                do {
                    list.add(this.input.readEnum());
                } while (this.input.getTotalBytesRead() < n);
                break;
            }
            default: {
                throw InvalidProtocolBufferException.invalidWireType();
            }
        }
        this.requirePosition(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void readFixed32List(List list) throws IOException {
        int n;
        if (list instanceof IntArrayList) {
            list = (IntArrayList)list;
            switch (WireFormat.getTagWireType(this.tag)) {
                case 5: {
                    int n2;
                    do {
                        ((IntArrayList)list).addInt(this.input.readFixed32());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((n2 = this.input.readTag()) == this.tag);
                    this.nextTag = n2;
                    return;
                }
                case 2: {
                    int n3 = this.input.readUInt32();
                    this.verifyPackedFixed32Length(n3);
                    n3 = this.input.getTotalBytesRead() + n3;
                    do {
                        ((IntArrayList)list).addInt(this.input.readFixed32());
                    } while (this.input.getTotalBytesRead() < n3);
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }
        switch (WireFormat.getTagWireType(this.tag)) {
            case 5: {
                int n4;
                do {
                    list.add(this.input.readFixed32());
                    if (!this.input.isAtEnd()) continue;
                    return;
                } while ((n4 = this.input.readTag()) == this.tag);
                this.nextTag = n4;
                return;
            }
            case 2: {
                n = this.input.readUInt32();
                this.verifyPackedFixed32Length(n);
                n = this.input.getTotalBytesRead() + n;
                break;
            }
            default: {
                throw InvalidProtocolBufferException.invalidWireType();
            }
        }
        do {
            list.add(this.input.readFixed32());
        } while (this.input.getTotalBytesRead() < n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void readFixed64List(List list) throws IOException {
        int n;
        if (list instanceof LongArrayList) {
            list = (LongArrayList)list;
            switch (WireFormat.getTagWireType(this.tag)) {
                case 1: {
                    int n2;
                    do {
                        ((LongArrayList)list).addLong(this.input.readFixed64());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((n2 = this.input.readTag()) == this.tag);
                    this.nextTag = n2;
                    return;
                }
                case 2: {
                    int n3 = this.input.readUInt32();
                    this.verifyPackedFixed64Length(n3);
                    n3 = this.input.getTotalBytesRead() + n3;
                    do {
                        ((LongArrayList)list).addLong(this.input.readFixed64());
                    } while (this.input.getTotalBytesRead() < n3);
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }
        switch (WireFormat.getTagWireType(this.tag)) {
            case 1: {
                int n4;
                do {
                    list.add(this.input.readFixed64());
                    if (!this.input.isAtEnd()) continue;
                    return;
                } while ((n4 = this.input.readTag()) == this.tag);
                this.nextTag = n4;
                return;
            }
            case 2: {
                n = this.input.readUInt32();
                this.verifyPackedFixed64Length(n);
                n = this.input.getTotalBytesRead() + n;
                break;
            }
            default: {
                throw InvalidProtocolBufferException.invalidWireType();
            }
        }
        do {
            list.add(this.input.readFixed64());
        } while (this.input.getTotalBytesRead() < n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void readFloatList(List list) throws IOException {
        int n;
        if (list instanceof FloatArrayList) {
            list = (FloatArrayList)list;
            switch (WireFormat.getTagWireType(this.tag)) {
                case 5: {
                    int n2;
                    do {
                        ((FloatArrayList)list).addFloat(this.input.readFloat());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((n2 = this.input.readTag()) == this.tag);
                    this.nextTag = n2;
                    return;
                }
                case 2: {
                    int n3 = this.input.readUInt32();
                    this.verifyPackedFixed32Length(n3);
                    n3 = this.input.getTotalBytesRead() + n3;
                    do {
                        ((FloatArrayList)list).addFloat(this.input.readFloat());
                    } while (this.input.getTotalBytesRead() < n3);
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }
        switch (WireFormat.getTagWireType(this.tag)) {
            case 5: {
                int n4;
                do {
                    list.add(Float.valueOf(this.input.readFloat()));
                    if (!this.input.isAtEnd()) continue;
                    return;
                } while ((n4 = this.input.readTag()) == this.tag);
                this.nextTag = n4;
                return;
            }
            case 2: {
                n = this.input.readUInt32();
                this.verifyPackedFixed32Length(n);
                n = this.input.getTotalBytesRead() + n;
                break;
            }
            default: {
                throw InvalidProtocolBufferException.invalidWireType();
            }
        }
        do {
            list.add(Float.valueOf(this.input.readFloat()));
        } while (this.input.getTotalBytesRead() < n);
    }

    @Override
    @Deprecated
    public void readGroupList(List list, Schema schema, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        int n;
        if (WireFormat.getTagWireType(this.tag) != 3) {
            throw InvalidProtocolBufferException.invalidWireType();
        }
        int n2 = this.tag;
        do {
            list.add(this.readGroup(schema, extensionRegistryLite));
            if (!this.input.isAtEnd() && this.nextTag == 0) continue;
            return;
        } while ((n = this.input.readTag()) == n2);
        this.nextTag = n;
    }

    @Override
    public void readInt32List(List list) throws IOException {
        int n;
        if (list instanceof IntArrayList) {
            list = (IntArrayList)list;
            switch (WireFormat.getTagWireType(this.tag)) {
                case 0: {
                    int n2;
                    do {
                        ((IntArrayList)list).addInt(this.input.readInt32());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((n2 = this.input.readTag()) == this.tag);
                    this.nextTag = n2;
                    return;
                }
                case 2: {
                    CodedInputStream codedInputStream = this.input;
                    int n3 = codedInputStream.readUInt32();
                    n3 = this.input.getTotalBytesRead() + n3;
                    do {
                        ((IntArrayList)list).addInt(this.input.readInt32());
                    } while (this.input.getTotalBytesRead() < n3);
                    this.requirePosition(n3);
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }
        switch (WireFormat.getTagWireType(this.tag)) {
            case 0: {
                int n4;
                do {
                    list.add(this.input.readInt32());
                    if (!this.input.isAtEnd()) continue;
                    return;
                } while ((n4 = this.input.readTag()) == this.tag);
                this.nextTag = n4;
                return;
            }
            case 2: {
                CodedInputStream codedInputStream = this.input;
                n = codedInputStream.readUInt32();
                n = this.input.getTotalBytesRead() + n;
                do {
                    list.add(this.input.readInt32());
                } while (this.input.getTotalBytesRead() < n);
                break;
            }
            default: {
                throw InvalidProtocolBufferException.invalidWireType();
            }
        }
        this.requirePosition(n);
    }

    @Override
    public void readInt64List(List list) throws IOException {
        int n;
        if (list instanceof LongArrayList) {
            list = (LongArrayList)list;
            switch (WireFormat.getTagWireType(this.tag)) {
                case 0: {
                    int n2;
                    do {
                        ((LongArrayList)list).addLong(this.input.readInt64());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((n2 = this.input.readTag()) == this.tag);
                    this.nextTag = n2;
                    return;
                }
                case 2: {
                    CodedInputStream codedInputStream = this.input;
                    int n3 = codedInputStream.readUInt32();
                    n3 = this.input.getTotalBytesRead() + n3;
                    do {
                        ((LongArrayList)list).addLong(this.input.readInt64());
                    } while (this.input.getTotalBytesRead() < n3);
                    this.requirePosition(n3);
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }
        switch (WireFormat.getTagWireType(this.tag)) {
            case 0: {
                int n4;
                do {
                    list.add(this.input.readInt64());
                    if (!this.input.isAtEnd()) continue;
                    return;
                } while ((n4 = this.input.readTag()) == this.tag);
                this.nextTag = n4;
                return;
            }
            case 2: {
                CodedInputStream codedInputStream = this.input;
                n = codedInputStream.readUInt32();
                n = this.input.getTotalBytesRead() + n;
                do {
                    list.add(this.input.readInt64());
                } while (this.input.getTotalBytesRead() < n);
                break;
            }
            default: {
                throw InvalidProtocolBufferException.invalidWireType();
            }
        }
        this.requirePosition(n);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void readMap(Map var1_1, MapEntryLite.Metadata var2_3, ExtensionRegistryLite var3_4) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [9 : 195->201)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void readMessageList(List list, Schema schema, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        int n;
        if (WireFormat.getTagWireType(this.tag) != 2) {
            throw InvalidProtocolBufferException.invalidWireType();
        }
        int n2 = this.tag;
        do {
            list.add(this.readMessage(schema, extensionRegistryLite));
            if (!this.input.isAtEnd() && this.nextTag == 0) continue;
            return;
        } while ((n = this.input.readTag()) == n2);
        this.nextTag = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void readSFixed32List(List list) throws IOException {
        int n;
        if (list instanceof IntArrayList) {
            list = (IntArrayList)list;
            switch (WireFormat.getTagWireType(this.tag)) {
                case 5: {
                    int n2;
                    do {
                        ((IntArrayList)list).addInt(this.input.readSFixed32());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((n2 = this.input.readTag()) == this.tag);
                    this.nextTag = n2;
                    return;
                }
                case 2: {
                    int n3 = this.input.readUInt32();
                    this.verifyPackedFixed32Length(n3);
                    n3 = this.input.getTotalBytesRead() + n3;
                    do {
                        ((IntArrayList)list).addInt(this.input.readSFixed32());
                    } while (this.input.getTotalBytesRead() < n3);
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }
        switch (WireFormat.getTagWireType(this.tag)) {
            case 5: {
                int n4;
                do {
                    list.add(this.input.readSFixed32());
                    if (!this.input.isAtEnd()) continue;
                    return;
                } while ((n4 = this.input.readTag()) == this.tag);
                this.nextTag = n4;
                return;
            }
            case 2: {
                n = this.input.readUInt32();
                this.verifyPackedFixed32Length(n);
                n = this.input.getTotalBytesRead() + n;
                break;
            }
            default: {
                throw InvalidProtocolBufferException.invalidWireType();
            }
        }
        do {
            list.add(this.input.readSFixed32());
        } while (this.input.getTotalBytesRead() < n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void readSFixed64List(List list) throws IOException {
        int n;
        if (list instanceof LongArrayList) {
            list = (LongArrayList)list;
            switch (WireFormat.getTagWireType(this.tag)) {
                case 1: {
                    int n2;
                    do {
                        ((LongArrayList)list).addLong(this.input.readSFixed64());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((n2 = this.input.readTag()) == this.tag);
                    this.nextTag = n2;
                    return;
                }
                case 2: {
                    int n3 = this.input.readUInt32();
                    this.verifyPackedFixed64Length(n3);
                    n3 = this.input.getTotalBytesRead() + n3;
                    do {
                        ((LongArrayList)list).addLong(this.input.readSFixed64());
                    } while (this.input.getTotalBytesRead() < n3);
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }
        switch (WireFormat.getTagWireType(this.tag)) {
            case 1: {
                int n4;
                do {
                    list.add(this.input.readSFixed64());
                    if (!this.input.isAtEnd()) continue;
                    return;
                } while ((n4 = this.input.readTag()) == this.tag);
                this.nextTag = n4;
                return;
            }
            case 2: {
                n = this.input.readUInt32();
                this.verifyPackedFixed64Length(n);
                n = this.input.getTotalBytesRead() + n;
                break;
            }
            default: {
                throw InvalidProtocolBufferException.invalidWireType();
            }
        }
        do {
            list.add(this.input.readSFixed64());
        } while (this.input.getTotalBytesRead() < n);
    }

    @Override
    public void readSInt32List(List list) throws IOException {
        int n;
        if (list instanceof IntArrayList) {
            list = (IntArrayList)list;
            switch (WireFormat.getTagWireType(this.tag)) {
                case 0: {
                    int n2;
                    do {
                        ((IntArrayList)list).addInt(this.input.readSInt32());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((n2 = this.input.readTag()) == this.tag);
                    this.nextTag = n2;
                    return;
                }
                case 2: {
                    CodedInputStream codedInputStream = this.input;
                    int n3 = codedInputStream.readUInt32();
                    n3 = this.input.getTotalBytesRead() + n3;
                    do {
                        ((IntArrayList)list).addInt(this.input.readSInt32());
                    } while (this.input.getTotalBytesRead() < n3);
                    this.requirePosition(n3);
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }
        switch (WireFormat.getTagWireType(this.tag)) {
            case 0: {
                int n4;
                do {
                    list.add(this.input.readSInt32());
                    if (!this.input.isAtEnd()) continue;
                    return;
                } while ((n4 = this.input.readTag()) == this.tag);
                this.nextTag = n4;
                return;
            }
            case 2: {
                CodedInputStream codedInputStream = this.input;
                n = codedInputStream.readUInt32();
                n = this.input.getTotalBytesRead() + n;
                do {
                    list.add(this.input.readSInt32());
                } while (this.input.getTotalBytesRead() < n);
                break;
            }
            default: {
                throw InvalidProtocolBufferException.invalidWireType();
            }
        }
        this.requirePosition(n);
    }

    @Override
    public void readSInt64List(List list) throws IOException {
        int n;
        if (list instanceof LongArrayList) {
            list = (LongArrayList)list;
            switch (WireFormat.getTagWireType(this.tag)) {
                case 0: {
                    int n2;
                    do {
                        ((LongArrayList)list).addLong(this.input.readSInt64());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((n2 = this.input.readTag()) == this.tag);
                    this.nextTag = n2;
                    return;
                }
                case 2: {
                    CodedInputStream codedInputStream = this.input;
                    int n3 = codedInputStream.readUInt32();
                    n3 = this.input.getTotalBytesRead() + n3;
                    do {
                        ((LongArrayList)list).addLong(this.input.readSInt64());
                    } while (this.input.getTotalBytesRead() < n3);
                    this.requirePosition(n3);
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }
        switch (WireFormat.getTagWireType(this.tag)) {
            case 0: {
                int n4;
                do {
                    list.add(this.input.readSInt64());
                    if (!this.input.isAtEnd()) continue;
                    return;
                } while ((n4 = this.input.readTag()) == this.tag);
                this.nextTag = n4;
                return;
            }
            case 2: {
                CodedInputStream codedInputStream = this.input;
                n = codedInputStream.readUInt32();
                n = this.input.getTotalBytesRead() + n;
                do {
                    list.add(this.input.readSInt64());
                } while (this.input.getTotalBytesRead() < n);
                break;
            }
            default: {
                throw InvalidProtocolBufferException.invalidWireType();
            }
        }
        this.requirePosition(n);
    }

    @Override
    public void readStringList(List list) throws IOException {
        this.readStringListInternal(list, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void readStringListInternal(List list, boolean n) throws IOException {
        if (WireFormat.getTagWireType(this.tag) != 2) {
            throw InvalidProtocolBufferException.invalidWireType();
        }
        if (!(list instanceof LazyStringList) || n != 0) {
            int n2;
            do {
                String string = n != 0 ? this.readStringRequireUtf8() : this.readString();
                list.add(string);
                if (!this.input.isAtEnd()) continue;
                return;
            } while ((n2 = this.input.readTag()) == this.tag);
            this.nextTag = n2;
            return;
        }
        list = (LazyStringList)list;
        do {
            list.add(this.readBytes());
            if (!this.input.isAtEnd()) continue;
            return;
        } while ((n = this.input.readTag()) == this.tag);
        this.nextTag = n;
    }

    @Override
    public void readStringListRequireUtf8(List list) throws IOException {
        this.readStringListInternal(list, true);
    }

    @Override
    public void readUInt32List(List list) throws IOException {
        int n;
        if (list instanceof IntArrayList) {
            list = (IntArrayList)list;
            switch (WireFormat.getTagWireType(this.tag)) {
                case 0: {
                    int n2;
                    do {
                        ((IntArrayList)list).addInt(this.input.readUInt32());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((n2 = this.input.readTag()) == this.tag);
                    this.nextTag = n2;
                    return;
                }
                case 2: {
                    CodedInputStream codedInputStream = this.input;
                    int n3 = codedInputStream.readUInt32();
                    n3 = this.input.getTotalBytesRead() + n3;
                    do {
                        ((IntArrayList)list).addInt(this.input.readUInt32());
                    } while (this.input.getTotalBytesRead() < n3);
                    this.requirePosition(n3);
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }
        switch (WireFormat.getTagWireType(this.tag)) {
            case 0: {
                int n4;
                do {
                    list.add(this.input.readUInt32());
                    if (!this.input.isAtEnd()) continue;
                    return;
                } while ((n4 = this.input.readTag()) == this.tag);
                this.nextTag = n4;
                return;
            }
            case 2: {
                CodedInputStream codedInputStream = this.input;
                n = codedInputStream.readUInt32();
                n = this.input.getTotalBytesRead() + n;
                do {
                    list.add(this.input.readUInt32());
                } while (this.input.getTotalBytesRead() < n);
                break;
            }
            default: {
                throw InvalidProtocolBufferException.invalidWireType();
            }
        }
        this.requirePosition(n);
    }

    @Override
    public void readUInt64List(List list) throws IOException {
        int n;
        if (list instanceof LongArrayList) {
            list = (LongArrayList)list;
            switch (WireFormat.getTagWireType(this.tag)) {
                case 0: {
                    int n2;
                    do {
                        ((LongArrayList)list).addLong(this.input.readUInt64());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((n2 = this.input.readTag()) == this.tag);
                    this.nextTag = n2;
                    return;
                }
                case 2: {
                    CodedInputStream codedInputStream = this.input;
                    int n3 = codedInputStream.readUInt32();
                    n3 = this.input.getTotalBytesRead() + n3;
                    do {
                        ((LongArrayList)list).addLong(this.input.readUInt64());
                    } while (this.input.getTotalBytesRead() < n3);
                    this.requirePosition(n3);
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }
        switch (WireFormat.getTagWireType(this.tag)) {
            case 0: {
                int n4;
                do {
                    list.add(this.input.readUInt64());
                    if (!this.input.isAtEnd()) continue;
                    return;
                } while ((n4 = this.input.readTag()) == this.tag);
                this.nextTag = n4;
                return;
            }
            case 2: {
                CodedInputStream codedInputStream = this.input;
                n = codedInputStream.readUInt32();
                n = this.input.getTotalBytesRead() + n;
                do {
                    list.add(this.input.readUInt64());
                } while (this.input.getTotalBytesRead() < n);
                break;
            }
            default: {
                throw InvalidProtocolBufferException.invalidWireType();
            }
        }
        this.requirePosition(n);
    }

    private void requirePosition(int n) throws IOException {
        if (this.input.getTotalBytesRead() != n) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
    }

    private void requireWireType(int n) throws IOException {
        if (WireFormat.getTagWireType(this.tag) != n) {
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    private void verifyPackedFixed32Length(int n) throws IOException {
        if ((n & 3) != 0) {
            throw InvalidProtocolBufferException.parseFailure();
        }
    }

    private void verifyPackedFixed64Length(int n) throws IOException {
        if ((n & 7) != 0) {
            throw InvalidProtocolBufferException.parseFailure();
        }
    }

    @Override
    public boolean readBool() throws IOException {
        this.requireWireType(0);
        return this.input.readBool();
    }

    @Override
    public boolean skipField() throws IOException {
        if (this.input.isAtEnd() || this.tag == this.endGroupTag) {
            return false;
        }
        return this.input.skipField(this.tag);
    }
}

