/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.ByteString;
import androidx.test.espresso.remote.internal.deps.protobuf.CodedInputStream-IA;
import androidx.test.espresso.remote.internal.deps.protobuf.CodedInputStreamReader;
import androidx.test.espresso.remote.internal.deps.protobuf.Internal;
import androidx.test.espresso.remote.internal.deps.protobuf.InvalidProtocolBufferException;
import androidx.test.espresso.remote.internal.deps.protobuf.UnsafeUtil;
import androidx.test.espresso.remote.internal.deps.protobuf.Utf8;
import androidx.test.espresso.remote.internal.deps.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class CodedInputStream {
    private static volatile int defaultRecursionLimit = 100;
    int recursionDepth;
    int recursionLimit = defaultRecursionLimit;
    int sizeLimit = Integer.MAX_VALUE;
    CodedInputStreamReader wrapper;
    private boolean shouldDiscardUnknownFields = false;

    public abstract double readDouble() throws IOException;

    public abstract float readFloat() throws IOException;

    public static int decodeZigZag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public abstract int getTotalBytesRead();

    public abstract int pushLimit(int var1) throws InvalidProtocolBufferException;

    public abstract int readEnum() throws IOException;

    public abstract int readFixed32() throws IOException;

    public abstract int readInt32() throws IOException;

    public static int readRawVarint32(int n, InputStream inputStream) throws IOException {
        int n2;
        int n3;
        if ((n & 0x80) == 0) {
            return n;
        }
        n &= 0x7F;
        for (n3 = 7; n3 < 32; n3 += 7) {
            n2 = inputStream.read();
            if (n2 == -1) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            n |= (n2 & 0x7F) << n3;
            if ((n2 & 0x80) != 0) continue;
            return n;
        }
        while (true) {
            if (n3 < 64) {
                n2 = inputStream.read();
                if (n2 == -1) {
                    throw InvalidProtocolBufferException.truncatedMessage();
                }
                if ((n2 & 0x80) == 0) {
                    return n;
                }
            } else {
                throw InvalidProtocolBufferException.malformedVarint();
            }
            n3 += 7;
        }
    }

    public abstract int readSFixed32() throws IOException;

    public abstract int readSInt32() throws IOException;

    public abstract int readTag() throws IOException;

    public abstract int readUInt32() throws IOException;

    public static long decodeZigZag64(long l) {
        return l >>> 1 ^ -(l & 1L);
    }

    public abstract long readFixed64() throws IOException;

    public abstract long readInt64() throws IOException;

    public abstract long readSFixed64() throws IOException;

    public abstract long readSInt64() throws IOException;

    public abstract long readUInt64() throws IOException;

    public abstract ByteString readBytes() throws IOException;

    public static CodedInputStream newInstance(InputStream inputStream) {
        return CodedInputStream.newInstance(inputStream, 4096);
    }

    public static CodedInputStream newInstance(ByteBuffer byteBuffer) {
        return CodedInputStream.newInstance(byteBuffer, false);
    }

    public static CodedInputStream newInstance(byte[] byArray) {
        return CodedInputStream.newInstance(byArray, 0, byArray.length);
    }

    public static CodedInputStream newInstance(InputStream object, int n) {
        if (n <= 0) {
            object = new IllegalArgumentException("bufferSize must be > 0");
            throw object;
        }
        if (object == null) {
            return CodedInputStream.newInstance(Internal.EMPTY_BYTE_ARRAY);
        }
        StreamDecoder streamDecoder = new StreamDecoder((InputStream)object, n);
        return streamDecoder;
    }

    static CodedInputStream newInstance(ByteBuffer byteBuffer, boolean bl) {
        if (byteBuffer.hasArray()) {
            return CodedInputStream.newInstance(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining(), bl);
        }
        if (byteBuffer.isDirect() && UnsafeDirectNioDecoder.isSupported()) {
            UnsafeDirectNioDecoder unsafeDirectNioDecoder = new UnsafeDirectNioDecoder(byteBuffer, bl);
            return unsafeDirectNioDecoder;
        }
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.duplicate().get(byArray);
        return CodedInputStream.newInstance(byArray, 0, byArray.length, true);
    }

    public static CodedInputStream newInstance(byte[] byArray, int n, int n2) {
        return CodedInputStream.newInstance(byArray, n, n2, false);
    }

    static CodedInputStream newInstance(byte[] byArray, int n, int n2, boolean bl) {
        ArrayDecoder arrayDecoder = new ArrayDecoder(byArray, n, n2, bl);
        try {
            arrayDecoder.pushLimit(n2);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(invalidProtocolBufferException);
            throw illegalArgumentException;
        }
        return arrayDecoder;
    }

    public abstract String readString() throws IOException;

    public abstract String readStringRequireUtf8() throws IOException;

    private CodedInputStream() {
    }

    /* synthetic */ CodedInputStream(CodedInputStream-IA codedInputStream-IA) {
        this();
    }

    public abstract void checkLastTagWas(int var1) throws InvalidProtocolBufferException;

    public abstract void popLimit(int var1);

    public abstract boolean isAtEnd() throws IOException;

    public abstract boolean readBool() throws IOException;

    public abstract boolean skipField(int var1) throws IOException;

    private static final class StreamDecoder
    extends CodedInputStream {
        private final InputStream input;
        private final byte[] buffer;
        private int bufferSize;
        private int bufferSizeAfterLimit;
        private int pos;
        private int lastTag;
        private int totalBytesRetired;
        private int currentLimit = Integer.MAX_VALUE;
        private RefillCallback refillCallback = null;

        public byte readRawByte() throws IOException {
            if (this.pos == this.bufferSize) {
                this.refillBuffer(1);
            }
            byte[] byArray = this.buffer;
            int n = this.pos;
            this.pos = n + 1;
            return byArray[n];
        }

        @Override
        public double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readRawLittleEndian64());
        }

        @Override
        public float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readRawLittleEndian32());
        }

        private static int available(InputStream inputStream) throws IOException {
            int n;
            try {
                n = inputStream.available();
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                invalidProtocolBufferException.setThrownFromInputStream();
                throw invalidProtocolBufferException;
            }
            return n;
        }

        @Override
        public int getTotalBytesRead() {
            return this.totalBytesRetired + this.pos;
        }

        @Override
        public int pushLimit(int n) throws InvalidProtocolBufferException {
            if (n < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            int n2 = this.currentLimit;
            if ((n += this.totalBytesRetired + this.pos) > n2) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.currentLimit = n;
            this.recomputeBufferSizeAfterLimit();
            return n2;
        }

        private static int read(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
            int n3;
            try {
                n3 = inputStream.read(byArray, n, n2);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                invalidProtocolBufferException.setThrownFromInputStream();
                throw invalidProtocolBufferException;
            }
            return n3;
        }

        @Override
        public int readEnum() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public int readFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public int readInt32() throws IOException {
            return this.readRawVarint32();
        }

        public int readRawLittleEndian32() throws IOException {
            int n = this.pos;
            if (this.bufferSize - n < 4) {
                this.refillBuffer(4);
                n = this.pos;
            }
            byte[] byArray = this.buffer;
            this.pos = n + 4;
            return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
        }

        /*
         * Enabled aggressive block sorting
         */
        public int readRawVarint32() throws IOException {
            int n;
            int n2;
            block6: {
                int n3;
                int n4;
                block9: {
                    block10: {
                        block11: {
                            block12: {
                                block13: {
                                    block14: {
                                        block4: {
                                            int n5;
                                            byte[] byArray;
                                            block8: {
                                                block7: {
                                                    block5: {
                                                        n2 = this.pos;
                                                        if (this.bufferSize == n2) break block4;
                                                        byArray = this.buffer;
                                                        n4 = n2 + 1;
                                                        if ((n2 = byArray[n2]) >= 0) {
                                                            this.pos = n4;
                                                            return n2;
                                                        }
                                                        if (this.bufferSize - n4 < 9) break block4;
                                                        n5 = n4 + 1;
                                                        if ((n2 ^= byArray[n4] << 7) >= 0) break block5;
                                                        n = n2 ^ 0xFFFFFF80;
                                                        n2 = n5;
                                                        break block6;
                                                    }
                                                    n4 = n5 + 1;
                                                    if ((n2 ^= byArray[n5] << 14) < 0) break block7;
                                                    n = n2 ^ 0x3F80;
                                                    n2 = n4;
                                                    break block6;
                                                }
                                                n5 = n4 + 1;
                                                if ((n2 ^= byArray[n4] << 21) >= 0) break block8;
                                                n = n2 ^ 0xFFE03F80;
                                                n2 = n5;
                                                break block6;
                                            }
                                            n4 = n5 + 1;
                                            n5 = byArray[n5];
                                            n3 = n2 ^ n5 << 28 ^ 0xFE03F80;
                                            if (n5 >= 0) break block9;
                                            n2 = n4 + 1;
                                            if (byArray[n4] >= 0) break block10;
                                            n4 = n2 + 1;
                                            if (byArray[n2] >= 0) break block11;
                                            n2 = n4 + 1;
                                            if (byArray[n4] >= 0) break block12;
                                            n4 = n2 + 1;
                                            if (byArray[n2] >= 0) break block13;
                                            n2 = n4 + 1;
                                            if (byArray[n4] >= 0) break block14;
                                        }
                                        return (int)this.readRawVarint64SlowPath();
                                    }
                                    n = n3;
                                    break block6;
                                }
                                n2 = n4;
                                n = n3;
                                break block6;
                            }
                            n = n3;
                            break block6;
                        }
                        n2 = n4;
                        n = n3;
                        break block6;
                    }
                    n = n3;
                    break block6;
                }
                n2 = n4;
                n = n3;
            }
            this.pos = n2;
            return n;
        }

        @Override
        public int readSFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public int readSInt32() throws IOException {
            return StreamDecoder.decodeZigZag32(this.readRawVarint32());
        }

        @Override
        public int readTag() throws IOException {
            if (this.isAtEnd()) {
                this.lastTag = 0;
                return 0;
            }
            this.lastTag = this.readRawVarint32();
            if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
                throw InvalidProtocolBufferException.invalidTag();
            }
            return this.lastTag;
        }

        @Override
        public int readUInt32() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public long readFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public long readInt64() throws IOException {
            return this.readRawVarint64();
        }

        public long readRawLittleEndian64() throws IOException {
            int n = this.pos;
            if (this.bufferSize - n < 8) {
                this.refillBuffer(8);
                n = this.pos;
            }
            byte[] byArray = this.buffer;
            this.pos = n + 8;
            return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | ((long)byArray[n + 7] & 0xFFL) << 56;
        }

        /*
         * Enabled aggressive block sorting
         */
        public long readRawVarint64() throws IOException {
            long l;
            int n;
            block6: {
                long l2;
                int n2;
                block13: {
                    block14: {
                        block4: {
                            long l3;
                            byte[] byArray;
                            block12: {
                                block11: {
                                    block10: {
                                        long l4;
                                        block9: {
                                            int n3;
                                            block8: {
                                                block7: {
                                                    block5: {
                                                        n = this.pos;
                                                        if (this.bufferSize == n) break block4;
                                                        byArray = this.buffer;
                                                        n2 = n + 1;
                                                        if ((n = byArray[n]) >= 0) {
                                                            this.pos = n2;
                                                            return n;
                                                        }
                                                        if (this.bufferSize - n2 < 9) break block4;
                                                        n3 = n2 + 1;
                                                        if ((n ^= byArray[n2] << 7) >= 0) break block5;
                                                        long l5 = n ^ 0xFFFFFF80;
                                                        n = n3;
                                                        l = l5;
                                                        break block6;
                                                    }
                                                    n2 = n3 + 1;
                                                    if ((n ^= byArray[n3] << 14) < 0) break block7;
                                                    long l6 = n ^ 0x3F80;
                                                    n = n2;
                                                    l = l6;
                                                    break block6;
                                                }
                                                n3 = n2 + 1;
                                                if ((n ^= byArray[n2] << 21) >= 0) break block8;
                                                long l7 = n ^ 0xFFE03F80;
                                                n = n3;
                                                l = l7;
                                                break block6;
                                            }
                                            n2 = n3 + 1;
                                            l4 = (long)n ^ (long)byArray[n3] << 28;
                                            if (l4 < 0L) break block9;
                                            long l8 = l4 ^ 0xFE03F80L;
                                            n = n2;
                                            l = l8;
                                            break block6;
                                        }
                                        n = n2 + 1;
                                        l3 = l4 ^ (long)byArray[n2] << 35;
                                        if (l3 >= 0L) break block10;
                                        l = l3 ^= 0xFFFFFFF80FE03F80L;
                                        break block6;
                                    }
                                    n2 = n + 1;
                                    if ((l3 ^= (long)byArray[n] << 42) < 0L) break block11;
                                    n = n2;
                                    l = l3 ^= 0x3F80FE03F80L;
                                    break block6;
                                }
                                n = n2 + 1;
                                if ((l3 ^= (long)byArray[n2] << 49) >= 0L) break block12;
                                l = l3 ^= 0xFFFE03F80FE03F80L;
                                break block6;
                            }
                            n2 = n + 1;
                            l2 = l3 ^ (long)byArray[n] << 56 ^ 0xFE03F80FE03F80L;
                            if (l2 >= 0L) break block13;
                            n = n2 + 1;
                            if ((long)byArray[n2] >= 0L) break block14;
                        }
                        return this.readRawVarint64SlowPath();
                    }
                    l = l2;
                    break block6;
                }
                n = n2;
                l = l2;
            }
            this.pos = n;
            return l;
        }

        long readRawVarint64SlowPath() throws IOException {
            long l = 0L;
            int n = 0;
            while (true) {
                long l2;
                if (n < 64) {
                    byte by = this.readRawByte();
                    l2 = l | (long)(by & 0x7F) << n;
                    if ((by & 0x80) == 0) {
                        return l2;
                    }
                } else {
                    throw InvalidProtocolBufferException.malformedVarint();
                }
                n += 7;
                l = l2;
            }
        }

        @Override
        public long readSFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public long readSInt64() throws IOException {
            return StreamDecoder.decodeZigZag64(this.readRawVarint64());
        }

        @Override
        public long readUInt64() throws IOException {
            return this.readRawVarint64();
        }

        private static long skip(InputStream inputStream, long l) throws IOException {
            long l2;
            try {
                l2 = inputStream.skip(l);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                invalidProtocolBufferException.setThrownFromInputStream();
                throw invalidProtocolBufferException;
            }
            return l2;
        }

        @Override
        public ByteString readBytes() throws IOException {
            int n = this.readRawVarint32();
            if (n <= this.bufferSize - this.pos && n > 0) {
                Object object = this.buffer;
                int n2 = this.pos;
                object = ByteString.copyFrom(object, n2, n);
                this.pos += n;
                return object;
            }
            if (n == 0) {
                return ByteString.EMPTY;
            }
            return this.readBytesSlowPath(n);
        }

        private ByteString readBytesSlowPath(int n) throws IOException {
            byte[] byArray = this.readRawBytesSlowPathOneChunk(n);
            if (byArray != null) {
                return ByteString.copyFrom(byArray);
            }
            int n2 = this.pos;
            int n3 = this.bufferSize - this.pos;
            this.totalBytesRetired += this.bufferSize;
            this.pos = 0;
            this.bufferSize = 0;
            List list = this.readRawBytesSlowPathRemainingChunks(n - n3);
            byte[] byArray2 = new byte[n];
            System.arraycopy(this.buffer, n2, byArray2, 0, n3);
            Iterator iterator = list.iterator();
            int n4 = n3;
            while (iterator.hasNext()) {
                byte[] byArray3 = (byte[])iterator.next();
                System.arraycopy(byArray3, 0, byArray2, n4, byArray3.length);
                n4 += byArray3.length;
            }
            return ByteString.wrap(byArray2);
        }

        @Override
        public String readString() throws IOException {
            int n = this.readRawVarint32();
            if (n > 0 && n <= this.bufferSize - this.pos) {
                String string = new String(this.buffer, this.pos, n, Internal.UTF_8);
                this.pos += n;
                return string;
            }
            if (n == 0) {
                return "";
            }
            if (n <= this.bufferSize) {
                this.refillBuffer(n);
                String string = new String(this.buffer, this.pos, n, Internal.UTF_8);
                this.pos += n;
                return string;
            }
            String string = new String(this.readRawBytesSlowPath(n, false), Internal.UTF_8);
            return string;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String readStringRequireUtf8() throws IOException {
            Object object;
            int n;
            int n2 = ((StreamDecoder)object).readRawVarint32();
            if (n2 <= ((StreamDecoder)object).bufferSize - (n = ((StreamDecoder)object).pos) && n2 > 0) {
                byte[] byArray = ((StreamDecoder)object).buffer;
                ((StreamDecoder)object).pos = n + n2;
                object = byArray;
                return Utf8.decodeUtf8((byte[])object, n, n2);
            }
            if (n2 == 0) {
                return "";
            }
            if (n2 <= ((StreamDecoder)object).bufferSize) {
                ((StreamDecoder)object).refillBuffer(n2);
                byte[] byArray = ((StreamDecoder)object).buffer;
                ((StreamDecoder)object).pos = n2;
                object = byArray;
                n = 0;
                return Utf8.decodeUtf8((byte[])object, n, n2);
            }
            object = ((StreamDecoder)object).readRawBytesSlowPath(n2, false);
            n = 0;
            return Utf8.decodeUtf8((byte[])object, n, n2);
        }

        private List readRawBytesSlowPathRemainingChunks(int n) throws IOException {
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            while (n > 0) {
                int n2;
                byte[] byArray = new byte[Math.min(n, 4096)];
                for (int i = 0; i < byArray.length; i += n2) {
                    n2 = this.input.read(byArray, i, byArray.length - i);
                    if (n2 == -1) {
                        throw InvalidProtocolBufferException.truncatedMessage();
                    }
                    this.totalBytesRetired += n2;
                }
                n -= byArray.length;
                arrayList.add(byArray);
            }
            return arrayList;
        }

        private StreamDecoder(InputStream inputStream, int n) {
            super(null);
            Internal.checkNotNull(inputStream, "input");
            this.input = inputStream;
            this.buffer = new byte[n];
            this.bufferSize = 0;
            this.pos = 0;
            this.totalBytesRetired = 0;
        }

        @Override
        public void checkLastTagWas(int n) throws InvalidProtocolBufferException {
            if (this.lastTag != n) {
                throw InvalidProtocolBufferException.invalidEndTag();
            }
        }

        @Override
        public void popLimit(int n) {
            this.currentLimit = n;
            this.recomputeBufferSizeAfterLimit();
        }

        private void recomputeBufferSizeAfterLimit() {
            this.bufferSize += this.bufferSizeAfterLimit;
            int n = this.totalBytesRetired + this.bufferSize;
            if (n > this.currentLimit) {
                this.bufferSizeAfterLimit = n - this.currentLimit;
                this.bufferSize -= this.bufferSizeAfterLimit;
                return;
            }
            this.bufferSizeAfterLimit = 0;
        }

        private void refillBuffer(int n) throws IOException {
            if (!this.tryRefillBuffer(n)) {
                if (n > this.sizeLimit - this.totalBytesRetired - this.pos) {
                    throw InvalidProtocolBufferException.sizeLimitExceeded();
                }
                throw InvalidProtocolBufferException.truncatedMessage();
            }
        }

        public void skipMessage() throws IOException {
            int n;
            while ((n = this.readTag()) != 0 && this.skipField(n)) {
            }
        }

        public void skipRawBytes(int n) throws IOException {
            if (n <= this.bufferSize - this.pos && n >= 0) {
                this.pos += n;
                return;
            }
            this.skipRawBytesSlowPath(n);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void skipRawBytesSlowPath(int n) throws IOException {
            int n2;
            if (n < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if (this.totalBytesRetired + this.pos + n > this.currentLimit) {
                this.skipRawBytes(this.currentLimit - this.totalBytesRetired - this.pos);
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            if (this.refillCallback != null) {
                n2 = 0;
            } else {
                long l;
                this.totalBytesRetired += this.pos;
                this.bufferSize = 0;
                this.pos = 0;
                for (n2 = this.bufferSize - this.pos; n2 < n; n2 += (int)l) {
                    int n3 = n - n2;
                    try {
                        l = StreamDecoder.skip(this.input, n3);
                        if (l < 0L || l > (long)n3) {
                            Object object = this.input;
                            object = object.getClass();
                            object = String.valueOf(object);
                            StringBuilder stringBuilder = new StringBuilder();
                            IllegalStateException illegalStateException = new IllegalStateException(stringBuilder.append((String)object).append("#skip returned invalid result: ").append(l).append("\nThe InputStream implementation is buggy.").toString());
                            throw illegalStateException;
                        }
                        if (l != 0L) continue;
                        break;
                    }
                    catch (Throwable throwable) {
                        this.totalBytesRetired += n2;
                        this.recomputeBufferSizeAfterLimit();
                        throw throwable;
                    }
                }
                this.totalBytesRetired += n2;
                this.recomputeBufferSizeAfterLimit();
            }
            if (n2 >= n) {
                return;
            }
            n2 = this.bufferSize - this.pos;
            this.pos = this.bufferSize;
            this.refillBuffer(1);
            while (true) {
                if (n - n2 <= this.bufferSize) {
                    this.pos = n - n2;
                    return;
                }
                n2 += this.bufferSize;
                this.pos = this.bufferSize;
                this.refillBuffer(1);
            }
        }

        private void skipRawVarint() throws IOException {
            if (this.bufferSize - this.pos >= 10) {
                this.skipRawVarintFastPath();
                return;
            }
            this.skipRawVarintSlowPath();
        }

        private void skipRawVarintFastPath() throws IOException {
            int n = 0;
            while (true) {
                if (n < 10) {
                    byte[] byArray = this.buffer;
                    int n2 = this.pos;
                    this.pos = n2 + 1;
                    if (byArray[n2] >= 0) {
                        return;
                    }
                } else {
                    throw InvalidProtocolBufferException.malformedVarint();
                }
                ++n;
            }
        }

        private void skipRawVarintSlowPath() throws IOException {
            int n = 0;
            while (true) {
                if (n < 10) {
                    if (this.readRawByte() >= 0) {
                        return;
                    }
                } else {
                    throw InvalidProtocolBufferException.malformedVarint();
                }
                ++n;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isAtEnd() throws IOException {
            if (this.pos != this.bufferSize) return false;
            if (this.tryRefillBuffer(1)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean readBool() throws IOException {
            if (this.readRawVarint64() == 0L) return false;
            return true;
        }

        @Override
        public boolean skipField(int n) throws IOException {
            switch (WireFormat.getTagWireType(n)) {
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
                case 5: {
                    this.skipRawBytes(4);
                    return true;
                }
                case 4: {
                    return false;
                }
                case 3: {
                    this.skipMessage();
                    this.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(n), 4));
                    return true;
                }
                case 2: {
                    this.skipRawBytes(this.readRawVarint32());
                    return true;
                }
                case 1: {
                    this.skipRawBytes(8);
                    return true;
                }
                case 0: 
            }
            this.skipRawVarint();
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean tryRefillBuffer(int n) throws IOException {
            int n2;
            Object object;
            if (((StreamDecoder)object).pos + n <= ((StreamDecoder)object).bufferSize) {
                StringBuilder stringBuilder = new StringBuilder();
                object = new IllegalStateException(stringBuilder.append("refillBuffer() called when ").append(n).append(" bytes were already available in buffer").toString());
                throw object;
            }
            if (n > ((StreamDecoder)object).sizeLimit - ((StreamDecoder)object).totalBytesRetired - ((StreamDecoder)object).pos) {
                return false;
            }
            if (((StreamDecoder)object).totalBytesRetired + ((StreamDecoder)object).pos + n > ((StreamDecoder)object).currentLimit) {
                return false;
            }
            if (((StreamDecoder)object).refillCallback != null) {
                ((StreamDecoder)object).refillCallback.onRefill();
            }
            if ((n2 = ((StreamDecoder)object).pos) > 0) {
                if (((StreamDecoder)object).bufferSize > n2) {
                    System.arraycopy(((StreamDecoder)object).buffer, n2, ((StreamDecoder)object).buffer, 0, ((StreamDecoder)object).bufferSize - n2);
                }
                ((StreamDecoder)object).totalBytesRetired += n2;
                ((StreamDecoder)object).bufferSize -= n2;
                ((StreamDecoder)object).pos = 0;
            }
            if ((n2 = StreamDecoder.read(((StreamDecoder)object).input, ((StreamDecoder)object).buffer, ((StreamDecoder)object).bufferSize, Math.min(((StreamDecoder)object).buffer.length - ((StreamDecoder)object).bufferSize, ((StreamDecoder)object).sizeLimit - ((StreamDecoder)object).totalBytesRetired - ((StreamDecoder)object).bufferSize))) == 0 || n2 < -1 || n2 > ((StreamDecoder)object).buffer.length) {
                object = ((StreamDecoder)object).input;
                object = object.getClass();
                object = String.valueOf(object);
                StringBuilder stringBuilder = new StringBuilder();
                IllegalStateException illegalStateException = new IllegalStateException(stringBuilder.append((String)object).append("#read(byte[]) returned invalid result: ").append(n2).append("\nThe InputStream implementation is buggy.").toString());
                throw illegalStateException;
            }
            if (n2 <= 0) return false;
            ((StreamDecoder)object).bufferSize += n2;
            super.recomputeBufferSizeAfterLimit();
            if (((StreamDecoder)object).bufferSize < n) return super.tryRefillBuffer(n);
            return true;
        }

        private byte[] readRawBytesSlowPath(int n, boolean bl) throws IOException {
            byte[] n2 = this.readRawBytesSlowPathOneChunk(n);
            if (n2 != null) {
                if (bl) {
                    return (byte[])n2.clone();
                }
                return n2;
            }
            int iterator = this.pos;
            int byArray3 = this.bufferSize - this.pos;
            this.totalBytesRetired += this.bufferSize;
            this.pos = 0;
            this.bufferSize = 0;
            List list = this.readRawBytesSlowPathRemainingChunks(n - byArray3);
            byte[] byArray2 = new byte[n];
            System.arraycopy(this.buffer, iterator, byArray2, 0, byArray3);
            Iterator iterator2 = list.iterator();
            int n3 = byArray3;
            while (iterator2.hasNext()) {
                byte[] byArray = (byte[])iterator2.next();
                System.arraycopy(byArray, 0, byArray2, n3, byArray.length);
                n3 += byArray.length;
            }
            return byArray2;
        }

        private byte[] readRawBytesSlowPathOneChunk(int n) throws IOException {
            if (n == 0) {
                return Internal.EMPTY_BYTE_ARRAY;
            }
            if (n < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            int n2 = this.totalBytesRetired + this.pos + n;
            if (n2 - this.sizeLimit > 0) {
                throw InvalidProtocolBufferException.sizeLimitExceeded();
            }
            if (n2 > this.currentLimit) {
                this.skipRawBytes(this.currentLimit - this.totalBytesRetired - this.pos);
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            n2 = this.bufferSize - this.pos;
            int n3 = n - n2;
            if (n3 < 4096 || n3 <= StreamDecoder.available(this.input)) {
                byte[] byArray = new byte[n];
                System.arraycopy(this.buffer, this.pos, byArray, 0, n2);
                this.totalBytesRetired += this.bufferSize;
                this.pos = 0;
                this.bufferSize = 0;
                while (n2 < byArray.length) {
                    int n4 = StreamDecoder.read(this.input, byArray, n2, n - n2);
                    if (n4 == -1) {
                        throw InvalidProtocolBufferException.truncatedMessage();
                    }
                    this.totalBytesRetired += n4;
                    n2 += n4;
                }
                return byArray;
            }
            return null;
        }

        private static interface RefillCallback {
            public void onRefill();
        }
    }

    private static final class UnsafeDirectNioDecoder
    extends CodedInputStream {
        private final ByteBuffer buffer;
        private final boolean immutable;
        private final long address;
        private long limit;
        private long pos;
        private long startPos;
        private int bufferSizeAfterLimit;
        private int lastTag;
        private boolean enableAliasing;
        private int currentLimit = Integer.MAX_VALUE;

        public byte readRawByte() throws IOException {
            if (this.pos == this.limit) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            long l = this.pos;
            this.pos = l + 1L;
            return UnsafeUtil.getByte(l);
        }

        @Override
        public double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readRawLittleEndian64());
        }

        @Override
        public float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readRawLittleEndian32());
        }

        private int bufferPos(long l) {
            return (int)(l - this.address);
        }

        @Override
        public int getTotalBytesRead() {
            return (int)(this.pos - this.startPos);
        }

        @Override
        public int pushLimit(int n) throws InvalidProtocolBufferException {
            int n2;
            if (n < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if ((n += this.getTotalBytesRead()) > (n2 = this.currentLimit)) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.currentLimit = n;
            this.recomputeBufferSizeAfterLimit();
            return n2;
        }

        @Override
        public int readEnum() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public int readFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public int readInt32() throws IOException {
            return this.readRawVarint32();
        }

        public int readRawLittleEndian32() throws IOException {
            long l = this.pos;
            if (this.limit - l < 4L) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.pos = l + 4L;
            return UnsafeUtil.getByte(l) & 0xFF | (UnsafeUtil.getByte(l + 1L) & 0xFF) << 8 | (UnsafeUtil.getByte(l + 2L) & 0xFF) << 16 | (UnsafeUtil.getByte(l + 3L) & 0xFF) << 24;
        }

        /*
         * Enabled aggressive block sorting
         */
        public int readRawVarint32() throws IOException {
            int n;
            long l;
            block6: {
                int n2;
                long l2;
                block9: {
                    long l3;
                    block10: {
                        long l4;
                        block11: {
                            block12: {
                                block13: {
                                    long l5;
                                    block14: {
                                        block4: {
                                            long l6;
                                            int n3;
                                            block8: {
                                                block7: {
                                                    block5: {
                                                        l3 = this.pos;
                                                        if (this.limit == l3) break block4;
                                                        long l7 = l3 + 1L;
                                                        n3 = UnsafeUtil.getByte(l3);
                                                        if (n3 >= 0) {
                                                            this.pos = l7;
                                                            return n3;
                                                        }
                                                        if (this.limit - l7 < 9L) break block4;
                                                        l2 = l7 + 1L;
                                                        if ((n3 ^= UnsafeUtil.getByte(l7) << 7) >= 0) break block5;
                                                        int n4 = n3 ^ 0xFFFFFF80;
                                                        l = l2;
                                                        n = n4;
                                                        break block6;
                                                    }
                                                    l3 = l2 + 1L;
                                                    if ((n3 ^= UnsafeUtil.getByte(l2) << 14) < 0) break block7;
                                                    int n5 = n3 ^ 0x3F80;
                                                    l = l3;
                                                    n = n5;
                                                    break block6;
                                                }
                                                l6 = l3 + 1L;
                                                if ((n3 ^= UnsafeUtil.getByte(l3) << 21) >= 0) break block8;
                                                int n6 = n3 ^ 0xFFE03F80;
                                                l = l6;
                                                n = n6;
                                                break block6;
                                            }
                                            l2 = l6 + 1L;
                                            byte by = UnsafeUtil.getByte(l6);
                                            n2 = n3 ^ by << 28 ^ 0xFE03F80;
                                            if (by >= 0) break block9;
                                            l3 = l2 + 1L;
                                            if (UnsafeUtil.getByte(l2) >= 0) break block10;
                                            l4 = l3 + 1L;
                                            if (UnsafeUtil.getByte(l3) >= 0) break block11;
                                            l2 = l4 + 1L;
                                            if (UnsafeUtil.getByte(l4) >= 0) break block12;
                                            l3 = l2 + 1L;
                                            if (UnsafeUtil.getByte(l2) >= 0) break block13;
                                            l5 = l3 + 1L;
                                            if (UnsafeUtil.getByte(l3) >= 0) break block14;
                                        }
                                        return (int)this.readRawVarint64SlowPath();
                                    }
                                    l = l5;
                                    n = n2;
                                    break block6;
                                }
                                l = l3;
                                n = n2;
                                break block6;
                            }
                            l = l2;
                            n = n2;
                            break block6;
                        }
                        l = l4;
                        n = n2;
                        break block6;
                    }
                    l = l3;
                    n = n2;
                    break block6;
                }
                l = l2;
                n = n2;
            }
            this.pos = l;
            return n;
        }

        @Override
        public int readSFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public int readSInt32() throws IOException {
            return UnsafeDirectNioDecoder.decodeZigZag32(this.readRawVarint32());
        }

        @Override
        public int readTag() throws IOException {
            if (this.isAtEnd()) {
                this.lastTag = 0;
                return 0;
            }
            this.lastTag = this.readRawVarint32();
            if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
                throw InvalidProtocolBufferException.invalidTag();
            }
            return this.lastTag;
        }

        @Override
        public int readUInt32() throws IOException {
            return this.readRawVarint32();
        }

        private int remaining() {
            return (int)(this.limit - this.pos);
        }

        @Override
        public long readFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public long readInt64() throws IOException {
            return this.readRawVarint64();
        }

        public long readRawLittleEndian64() throws IOException {
            long l = this.pos;
            if (this.limit - l < 8L) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.pos = l + 8L;
            return (long)UnsafeUtil.getByte(l) & 0xFFL | ((long)UnsafeUtil.getByte(l + 1L) & 0xFFL) << 8 | ((long)UnsafeUtil.getByte(l + 2L) & 0xFFL) << 16 | ((long)UnsafeUtil.getByte(l + 3L) & 0xFFL) << 24 | ((long)UnsafeUtil.getByte(l + 4L) & 0xFFL) << 32 | ((long)UnsafeUtil.getByte(l + 5L) & 0xFFL) << 40 | ((long)UnsafeUtil.getByte(l + 6L) & 0xFFL) << 48 | ((long)UnsafeUtil.getByte(l + 7L) & 0xFFL) << 56;
        }

        /*
         * Enabled aggressive block sorting
         */
        public long readRawVarint64() throws IOException {
            long l;
            long l2;
            block6: {
                long l3;
                long l4;
                block13: {
                    long l5;
                    block14: {
                        block4: {
                            long l6;
                            block12: {
                                block11: {
                                    long l7;
                                    block10: {
                                        long l8;
                                        block9: {
                                            int n;
                                            block8: {
                                                long l9;
                                                block7: {
                                                    long l10;
                                                    block5: {
                                                        l2 = this.pos;
                                                        if (this.limit == l2) break block4;
                                                        long l11 = l2 + 1L;
                                                        n = UnsafeUtil.getByte(l2);
                                                        if (n >= 0) {
                                                            this.pos = l11;
                                                            return n;
                                                        }
                                                        if (this.limit - l11 < 9L) break block4;
                                                        l10 = l11 + 1L;
                                                        if ((n ^= UnsafeUtil.getByte(l11) << 7) >= 0) break block5;
                                                        long l12 = n ^ 0xFFFFFF80;
                                                        l2 = l10;
                                                        l = l12;
                                                        break block6;
                                                    }
                                                    l9 = l10 + 1L;
                                                    if ((n ^= UnsafeUtil.getByte(l10) << 14) < 0) break block7;
                                                    long l13 = n ^ 0x3F80;
                                                    l2 = l9;
                                                    l = l13;
                                                    break block6;
                                                }
                                                l6 = l9 + 1L;
                                                if ((n ^= UnsafeUtil.getByte(l9) << 21) >= 0) break block8;
                                                long l14 = n ^ 0xFFE03F80;
                                                l2 = l6;
                                                l = l14;
                                                break block6;
                                            }
                                            l4 = l6 + 1L;
                                            l8 = (long)n ^ (long)UnsafeUtil.getByte(l6) << 28;
                                            if (l8 < 0L) break block9;
                                            l6 = l8 ^ 0xFE03F80L;
                                            l2 = l4;
                                            l = l6;
                                            break block6;
                                        }
                                        l7 = l4 + 1L;
                                        l6 = l8 ^ (long)UnsafeUtil.getByte(l4) << 35;
                                        if (l6 >= 0L) break block10;
                                        l2 = l7;
                                        l = l6 ^= 0xFFFFFFF80FE03F80L;
                                        break block6;
                                    }
                                    l4 = l7 + 1L;
                                    l3 = l6 ^ (long)UnsafeUtil.getByte(l7) << 42;
                                    if (l3 < 0L) break block11;
                                    l6 = l3 ^ 0x3F80FE03F80L;
                                    l2 = l4;
                                    l = l6;
                                    break block6;
                                }
                                l5 = l4 + 1L;
                                l6 = l3 ^ (long)UnsafeUtil.getByte(l4) << 49;
                                if (l6 >= 0L) break block12;
                                l2 = l5;
                                l = l6 ^= 0xFFFE03F80FE03F80L;
                                break block6;
                            }
                            l4 = l5 + 1L;
                            l3 = l6 ^ (long)UnsafeUtil.getByte(l5) << 56 ^ 0xFE03F80FE03F80L;
                            if (l3 >= 0L) break block13;
                            l5 = l4 + 1L;
                            if ((long)UnsafeUtil.getByte(l4) >= 0L) break block14;
                        }
                        return this.readRawVarint64SlowPath();
                    }
                    l2 = l5;
                    l = l3;
                    break block6;
                }
                l2 = l4;
                l = l3;
            }
            this.pos = l2;
            return l;
        }

        long readRawVarint64SlowPath() throws IOException {
            long l = 0L;
            int n = 0;
            while (true) {
                long l2;
                if (n < 64) {
                    byte by = this.readRawByte();
                    l2 = l | (long)(by & 0x7F) << n;
                    if ((by & 0x80) == 0) {
                        return l2;
                    }
                } else {
                    throw InvalidProtocolBufferException.malformedVarint();
                }
                n += 7;
                l = l2;
            }
        }

        @Override
        public long readSFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public long readSInt64() throws IOException {
            return UnsafeDirectNioDecoder.decodeZigZag64(this.readRawVarint64());
        }

        @Override
        public long readUInt64() throws IOException {
            return this.readRawVarint64();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public ByteString readBytes() throws IOException {
            int n = this.readRawVarint32();
            if (n > 0 && n <= this.remaining()) {
                if (this.immutable && this.enableAliasing) {
                    long l = this.pos;
                    long l2 = this.pos;
                    ByteBuffer byteBuffer = this.slice(l, l2 + (long)n);
                    this.pos += (long)n;
                    return ByteString.wrap(byteBuffer);
                }
                byte[] byArray = new byte[n];
                UnsafeUtil.copyMemory(this.pos, byArray, 0L, n);
                this.pos += (long)n;
                return ByteString.wrap(byArray);
            }
            if (n == 0) {
                return ByteString.EMPTY;
            }
            if (n >= 0) throw InvalidProtocolBufferException.truncatedMessage();
            throw InvalidProtocolBufferException.negativeSize();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public String readString() throws IOException {
            int n = this.readRawVarint32();
            if (n > 0 && n <= this.remaining()) {
                byte[] byArray = new byte[n];
                UnsafeUtil.copyMemory(this.pos, byArray, 0L, n);
                String string = new String(byArray, Internal.UTF_8);
                this.pos += (long)n;
                return string;
            }
            if (n == 0) {
                return "";
            }
            if (n >= 0) throw InvalidProtocolBufferException.truncatedMessage();
            throw InvalidProtocolBufferException.negativeSize();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public String readStringRequireUtf8() throws IOException {
            int n = this.readRawVarint32();
            if (n > 0 && n <= this.remaining()) {
                long l = this.pos;
                int n2 = this.bufferPos(l);
                ByteBuffer byteBuffer = this.buffer;
                String string = Utf8.decodeUtf8(byteBuffer, n2, n);
                this.pos += (long)n;
                return string;
            }
            if (n == 0) {
                return "";
            }
            if (n > 0) throw InvalidProtocolBufferException.truncatedMessage();
            throw InvalidProtocolBufferException.negativeSize();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private ByteBuffer slice(long var1_3, long var3_4) throws IOException {
            var5_5 = this.buffer.position();
            var6_6 = this.buffer.limit();
            var7_7 = this.buffer;
            try {
                var7_7.position(this.bufferPos(var1_3));
                var7_7.limit(this.bufferPos(var3_4));
                this = this.buffer.slice();
            }
            catch (Throwable var0_1) {
                var7_7.position(var5_5);
                var7_7.limit(var6_6);
                throw var0_1;
            }
            catch (IllegalArgumentException var0_2) {
                ** GOTO lbl-1000
            }
            var7_7.position(var5_5);
            var7_7.limit(var6_6);
            return this;
lbl-1000:
            // 1 sources

            {
                var8_8 = InvalidProtocolBufferException.truncatedMessage();
                var8_8.initCause(var0_2);
                throw var8_8;
            }
        }

        private UnsafeDirectNioDecoder(ByteBuffer byteBuffer, boolean bl) {
            super(null);
            this.buffer = byteBuffer;
            this.address = UnsafeUtil.addressOffset(byteBuffer);
            this.limit = this.address + (long)byteBuffer.limit();
            this.startPos = this.pos = this.address + (long)byteBuffer.position();
            this.immutable = bl;
        }

        @Override
        public void checkLastTagWas(int n) throws InvalidProtocolBufferException {
            if (this.lastTag != n) {
                throw InvalidProtocolBufferException.invalidEndTag();
            }
        }

        @Override
        public void popLimit(int n) {
            this.currentLimit = n;
            this.recomputeBufferSizeAfterLimit();
        }

        private void recomputeBufferSizeAfterLimit() {
            this.limit += (long)this.bufferSizeAfterLimit;
            int n = (int)(this.limit - this.startPos);
            if (n > this.currentLimit) {
                this.bufferSizeAfterLimit = n - this.currentLimit;
                this.limit -= (long)this.bufferSizeAfterLimit;
                return;
            }
            this.bufferSizeAfterLimit = 0;
        }

        public void skipMessage() throws IOException {
            int n;
            while ((n = this.readTag()) != 0 && this.skipField(n)) {
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void skipRawBytes(int n) throws IOException {
            if (n >= 0 && n <= this.remaining()) {
                this.pos += (long)n;
                return;
            }
            if (n >= 0) throw InvalidProtocolBufferException.truncatedMessage();
            throw InvalidProtocolBufferException.negativeSize();
        }

        private void skipRawVarint() throws IOException {
            if (this.remaining() >= 10) {
                this.skipRawVarintFastPath();
                return;
            }
            this.skipRawVarintSlowPath();
        }

        private void skipRawVarintFastPath() throws IOException {
            int n = 0;
            while (true) {
                if (n < 10) {
                    long l = this.pos;
                    this.pos = l + 1L;
                    if (UnsafeUtil.getByte(l) >= 0) {
                        return;
                    }
                } else {
                    throw InvalidProtocolBufferException.malformedVarint();
                }
                ++n;
            }
        }

        private void skipRawVarintSlowPath() throws IOException {
            int n = 0;
            while (true) {
                if (n < 10) {
                    if (this.readRawByte() >= 0) {
                        return;
                    }
                } else {
                    throw InvalidProtocolBufferException.malformedVarint();
                }
                ++n;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isAtEnd() throws IOException {
            if (this.pos != this.limit) return false;
            return true;
        }

        static boolean isSupported() {
            return UnsafeUtil.hasUnsafeByteBufferOperations();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean readBool() throws IOException {
            if (this.readRawVarint64() == 0L) return false;
            return true;
        }

        @Override
        public boolean skipField(int n) throws IOException {
            switch (WireFormat.getTagWireType(n)) {
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
                case 5: {
                    this.skipRawBytes(4);
                    return true;
                }
                case 4: {
                    return false;
                }
                case 3: {
                    this.skipMessage();
                    this.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(n), 4));
                    return true;
                }
                case 2: {
                    this.skipRawBytes(this.readRawVarint32());
                    return true;
                }
                case 1: {
                    this.skipRawBytes(8);
                    return true;
                }
                case 0: 
            }
            this.skipRawVarint();
            return true;
        }
    }

    private static final class ArrayDecoder
    extends CodedInputStream {
        private final byte[] buffer;
        private final boolean immutable;
        private int limit;
        private int bufferSizeAfterLimit;
        private int pos;
        private int startPos;
        private int lastTag;
        private boolean enableAliasing;
        private int currentLimit = Integer.MAX_VALUE;

        public byte readRawByte() throws IOException {
            if (this.pos == this.limit) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            byte[] byArray = this.buffer;
            int n = this.pos;
            this.pos = n + 1;
            return byArray[n];
        }

        @Override
        public double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readRawLittleEndian64());
        }

        @Override
        public float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readRawLittleEndian32());
        }

        @Override
        public int getTotalBytesRead() {
            return this.pos - this.startPos;
        }

        @Override
        public int pushLimit(int n) throws InvalidProtocolBufferException {
            if (n < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if ((n += this.getTotalBytesRead()) < 0) {
                throw InvalidProtocolBufferException.parseFailure();
            }
            int n2 = this.currentLimit;
            if (n > n2) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.currentLimit = n;
            this.recomputeBufferSizeAfterLimit();
            return n2;
        }

        @Override
        public int readEnum() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public int readFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public int readInt32() throws IOException {
            return this.readRawVarint32();
        }

        public int readRawLittleEndian32() throws IOException {
            int n = this.pos;
            if (this.limit - n < 4) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            byte[] byArray = this.buffer;
            this.pos = n + 4;
            return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
        }

        /*
         * Enabled aggressive block sorting
         */
        public int readRawVarint32() throws IOException {
            int n;
            int n2;
            block6: {
                int n3;
                int n4;
                block9: {
                    block10: {
                        block11: {
                            block12: {
                                block13: {
                                    block14: {
                                        block4: {
                                            int n5;
                                            byte[] byArray;
                                            block8: {
                                                block7: {
                                                    block5: {
                                                        n2 = this.pos;
                                                        if (this.limit == n2) break block4;
                                                        byArray = this.buffer;
                                                        n4 = n2 + 1;
                                                        if ((n2 = byArray[n2]) >= 0) {
                                                            this.pos = n4;
                                                            return n2;
                                                        }
                                                        if (this.limit - n4 < 9) break block4;
                                                        n5 = n4 + 1;
                                                        if ((n2 ^= byArray[n4] << 7) >= 0) break block5;
                                                        n = n2 ^ 0xFFFFFF80;
                                                        n2 = n5;
                                                        break block6;
                                                    }
                                                    n4 = n5 + 1;
                                                    if ((n2 ^= byArray[n5] << 14) < 0) break block7;
                                                    n = n2 ^ 0x3F80;
                                                    n2 = n4;
                                                    break block6;
                                                }
                                                n5 = n4 + 1;
                                                if ((n2 ^= byArray[n4] << 21) >= 0) break block8;
                                                n = n2 ^ 0xFFE03F80;
                                                n2 = n5;
                                                break block6;
                                            }
                                            n4 = n5 + 1;
                                            n5 = byArray[n5];
                                            n3 = n2 ^ n5 << 28 ^ 0xFE03F80;
                                            if (n5 >= 0) break block9;
                                            n2 = n4 + 1;
                                            if (byArray[n4] >= 0) break block10;
                                            n4 = n2 + 1;
                                            if (byArray[n2] >= 0) break block11;
                                            n2 = n4 + 1;
                                            if (byArray[n4] >= 0) break block12;
                                            n4 = n2 + 1;
                                            if (byArray[n2] >= 0) break block13;
                                            n2 = n4 + 1;
                                            if (byArray[n4] >= 0) break block14;
                                        }
                                        return (int)this.readRawVarint64SlowPath();
                                    }
                                    n = n3;
                                    break block6;
                                }
                                n2 = n4;
                                n = n3;
                                break block6;
                            }
                            n = n3;
                            break block6;
                        }
                        n2 = n4;
                        n = n3;
                        break block6;
                    }
                    n = n3;
                    break block6;
                }
                n2 = n4;
                n = n3;
            }
            this.pos = n2;
            return n;
        }

        @Override
        public int readSFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public int readSInt32() throws IOException {
            return ArrayDecoder.decodeZigZag32(this.readRawVarint32());
        }

        @Override
        public int readTag() throws IOException {
            if (this.isAtEnd()) {
                this.lastTag = 0;
                return 0;
            }
            this.lastTag = this.readRawVarint32();
            if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
                throw InvalidProtocolBufferException.invalidTag();
            }
            return this.lastTag;
        }

        @Override
        public int readUInt32() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public long readFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public long readInt64() throws IOException {
            return this.readRawVarint64();
        }

        public long readRawLittleEndian64() throws IOException {
            int n = this.pos;
            if (this.limit - n < 8) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            byte[] byArray = this.buffer;
            this.pos = n + 8;
            return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | ((long)byArray[n + 7] & 0xFFL) << 56;
        }

        /*
         * Enabled aggressive block sorting
         */
        public long readRawVarint64() throws IOException {
            long l;
            int n;
            block6: {
                long l2;
                int n2;
                block13: {
                    block14: {
                        block4: {
                            long l3;
                            byte[] byArray;
                            block12: {
                                block11: {
                                    block10: {
                                        long l4;
                                        block9: {
                                            int n3;
                                            block8: {
                                                block7: {
                                                    block5: {
                                                        n = this.pos;
                                                        if (this.limit == n) break block4;
                                                        byArray = this.buffer;
                                                        n2 = n + 1;
                                                        if ((n = byArray[n]) >= 0) {
                                                            this.pos = n2;
                                                            return n;
                                                        }
                                                        if (this.limit - n2 < 9) break block4;
                                                        n3 = n2 + 1;
                                                        if ((n ^= byArray[n2] << 7) >= 0) break block5;
                                                        long l5 = n ^ 0xFFFFFF80;
                                                        n = n3;
                                                        l = l5;
                                                        break block6;
                                                    }
                                                    n2 = n3 + 1;
                                                    if ((n ^= byArray[n3] << 14) < 0) break block7;
                                                    long l6 = n ^ 0x3F80;
                                                    n = n2;
                                                    l = l6;
                                                    break block6;
                                                }
                                                n3 = n2 + 1;
                                                if ((n ^= byArray[n2] << 21) >= 0) break block8;
                                                long l7 = n ^ 0xFFE03F80;
                                                n = n3;
                                                l = l7;
                                                break block6;
                                            }
                                            n2 = n3 + 1;
                                            l4 = (long)n ^ (long)byArray[n3] << 28;
                                            if (l4 < 0L) break block9;
                                            long l8 = l4 ^ 0xFE03F80L;
                                            n = n2;
                                            l = l8;
                                            break block6;
                                        }
                                        n = n2 + 1;
                                        l3 = l4 ^ (long)byArray[n2] << 35;
                                        if (l3 >= 0L) break block10;
                                        l = l3 ^= 0xFFFFFFF80FE03F80L;
                                        break block6;
                                    }
                                    n2 = n + 1;
                                    if ((l3 ^= (long)byArray[n] << 42) < 0L) break block11;
                                    n = n2;
                                    l = l3 ^= 0x3F80FE03F80L;
                                    break block6;
                                }
                                n = n2 + 1;
                                if ((l3 ^= (long)byArray[n2] << 49) >= 0L) break block12;
                                l = l3 ^= 0xFFFE03F80FE03F80L;
                                break block6;
                            }
                            n2 = n + 1;
                            l2 = l3 ^ (long)byArray[n] << 56 ^ 0xFE03F80FE03F80L;
                            if (l2 >= 0L) break block13;
                            n = n2 + 1;
                            if ((long)byArray[n2] >= 0L) break block14;
                        }
                        return this.readRawVarint64SlowPath();
                    }
                    l = l2;
                    break block6;
                }
                n = n2;
                l = l2;
            }
            this.pos = n;
            return l;
        }

        long readRawVarint64SlowPath() throws IOException {
            long l = 0L;
            int n = 0;
            while (true) {
                long l2;
                if (n < 64) {
                    byte by = this.readRawByte();
                    l2 = l | (long)(by & 0x7F) << n;
                    if ((by & 0x80) == 0) {
                        return l2;
                    }
                } else {
                    throw InvalidProtocolBufferException.malformedVarint();
                }
                n += 7;
                l = l2;
            }
        }

        @Override
        public long readSFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public long readSInt64() throws IOException {
            return ArrayDecoder.decodeZigZag64(this.readRawVarint64());
        }

        @Override
        public long readUInt64() throws IOException {
            return this.readRawVarint64();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public ByteString readBytes() throws IOException {
            int n = this.readRawVarint32();
            if (n > 0 && n <= this.limit - this.pos) {
                ByteString byteString = this.immutable && this.enableAliasing ? ByteString.wrap(this.buffer, this.pos, n) : ByteString.copyFrom(this.buffer, this.pos, n);
                this.pos += n;
                return byteString;
            }
            if (n == 0) {
                return ByteString.EMPTY;
            }
            return ByteString.wrap(this.readRawBytes(n));
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public String readString() throws IOException {
            int n = this.readRawVarint32();
            if (n > 0 && n <= this.limit - this.pos) {
                String string = new String(this.buffer, this.pos, n, Internal.UTF_8);
                this.pos += n;
                return string;
            }
            if (n == 0) {
                return "";
            }
            if (n >= 0) throw InvalidProtocolBufferException.truncatedMessage();
            throw InvalidProtocolBufferException.negativeSize();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public String readStringRequireUtf8() throws IOException {
            int n = this.readRawVarint32();
            if (n > 0 && n <= this.limit - this.pos) {
                byte[] byArray = this.buffer;
                int n2 = this.pos;
                String string = Utf8.decodeUtf8(byArray, n2, n);
                this.pos += n;
                return string;
            }
            if (n == 0) {
                return "";
            }
            if (n > 0) throw InvalidProtocolBufferException.truncatedMessage();
            throw InvalidProtocolBufferException.negativeSize();
        }

        private ArrayDecoder(byte[] byArray, int n, int n2, boolean bl) {
            super(null);
            this.buffer = byArray;
            this.limit = n + n2;
            this.startPos = this.pos = n;
            this.immutable = bl;
        }

        @Override
        public void checkLastTagWas(int n) throws InvalidProtocolBufferException {
            if (this.lastTag != n) {
                throw InvalidProtocolBufferException.invalidEndTag();
            }
        }

        @Override
        public void popLimit(int n) {
            this.currentLimit = n;
            this.recomputeBufferSizeAfterLimit();
        }

        private void recomputeBufferSizeAfterLimit() {
            this.limit += this.bufferSizeAfterLimit;
            int n = this.limit - this.startPos;
            if (n > this.currentLimit) {
                this.bufferSizeAfterLimit = n - this.currentLimit;
                this.limit -= this.bufferSizeAfterLimit;
                return;
            }
            this.bufferSizeAfterLimit = 0;
        }

        public void skipMessage() throws IOException {
            int n;
            while ((n = this.readTag()) != 0 && this.skipField(n)) {
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void skipRawBytes(int n) throws IOException {
            if (n >= 0 && n <= this.limit - this.pos) {
                this.pos += n;
                return;
            }
            if (n >= 0) throw InvalidProtocolBufferException.truncatedMessage();
            throw InvalidProtocolBufferException.negativeSize();
        }

        private void skipRawVarint() throws IOException {
            if (this.limit - this.pos >= 10) {
                this.skipRawVarintFastPath();
                return;
            }
            this.skipRawVarintSlowPath();
        }

        private void skipRawVarintFastPath() throws IOException {
            int n = 0;
            while (true) {
                if (n < 10) {
                    byte[] byArray = this.buffer;
                    int n2 = this.pos;
                    this.pos = n2 + 1;
                    if (byArray[n2] >= 0) {
                        return;
                    }
                } else {
                    throw InvalidProtocolBufferException.malformedVarint();
                }
                ++n;
            }
        }

        private void skipRawVarintSlowPath() throws IOException {
            int n = 0;
            while (true) {
                if (n < 10) {
                    if (this.readRawByte() >= 0) {
                        return;
                    }
                } else {
                    throw InvalidProtocolBufferException.malformedVarint();
                }
                ++n;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isAtEnd() throws IOException {
            if (this.pos != this.limit) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean readBool() throws IOException {
            if (this.readRawVarint64() == 0L) return false;
            return true;
        }

        @Override
        public boolean skipField(int n) throws IOException {
            switch (WireFormat.getTagWireType(n)) {
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
                case 5: {
                    this.skipRawBytes(4);
                    return true;
                }
                case 4: {
                    return false;
                }
                case 3: {
                    this.skipMessage();
                    this.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(n), 4));
                    return true;
                }
                case 2: {
                    this.skipRawBytes(this.readRawVarint32());
                    return true;
                }
                case 1: {
                    this.skipRawBytes(8);
                    return true;
                }
                case 0: 
            }
            this.skipRawVarint();
            return true;
        }

        public byte[] readRawBytes(int n) throws IOException {
            if (n > 0 && n <= this.limit - this.pos) {
                int n2 = this.pos;
                this.pos += n;
                return Arrays.copyOfRange(this.buffer, n2, this.pos);
            }
            if (n <= 0) {
                if (n != 0) {
                    throw InvalidProtocolBufferException.negativeSize();
                }
            } else {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            return Internal.EMPTY_BYTE_ARRAY;
        }
    }
}

