/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.Android;
import androidx.test.espresso.remote.internal.deps.protobuf.ByteOutput;
import androidx.test.espresso.remote.internal.deps.protobuf.CodedInputStream;
import androidx.test.espresso.remote.internal.deps.protobuf.CodedOutputStream;
import androidx.test.espresso.remote.internal.deps.protobuf.Internal;
import androidx.test.espresso.remote.internal.deps.protobuf.NioByteString;
import androidx.test.espresso.remote.internal.deps.protobuf.TextFormatEscaper;
import androidx.test.espresso.remote.internal.deps.protobuf.Utf8;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ByteString
implements Iterable<Byte>,
Serializable {
    public static final ByteString EMPTY;
    private static final ByteArrayCopier byteArrayCopier;
    private static final Comparator UNSIGNED_LEXICOGRAPHICAL_COMPARATOR;
    private int hash = 0;

    public abstract byte byteAt(int var1);

    abstract byte internalByteAt(int var1);

    /*
     * Enabled aggressive block sorting
     */
    static int checkRange(int n, int n2, int n3) {
        int n4 = n2 - n;
        if ((n | n2 | n4 | n3 - n2) >= 0) {
            return n4;
        }
        if (n < 0) {
            StringBuilder stringBuilder = new StringBuilder();
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(stringBuilder.append("Beginning index: ").append(n).append(" < 0").toString());
            throw indexOutOfBoundsException;
        }
        if (n2 >= n) {
            StringBuilder stringBuilder = new StringBuilder();
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(stringBuilder.append("End index: ").append(n2).append(" >= ").append(n3).toString());
            throw indexOutOfBoundsException;
        }
        StringBuilder stringBuilder = new StringBuilder();
        IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(stringBuilder.append("Beginning index larger than ending index: ").append(n).append(", ").append(n2).toString());
        throw indexOutOfBoundsException;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int hashCode() {
        int n = this.hash;
        if (n != 0) return n;
        n = this.size();
        if ((n = this.partialHash(n, 0, n)) == 0) {
            n = 1;
        }
        this.hash = n;
        return n;
    }

    protected abstract int partialHash(int var1, int var2, int var3);

    protected final int peekCachedHashCode() {
        return this.hash;
    }

    public abstract int size();

    private static int toInt(byte by) {
        return by & 0xFF;
    }

    public ByteIterator iterator() {
        AbstractByteIterator abstractByteIterator = new AbstractByteIterator(){
            private int position = 0;
            private final int limit = ByteString.this.size();

            @Override
            public byte nextByte() {
                int n = object.position;
                if (n >= object.limit) {
                    Object object = new NoSuchElementException();
                    throw object;
                }
                object.position = n + 1;
                return object.ByteString.this.internalByteAt(n);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean hasNext() {
                if (this.position >= this.limit) return false;
                return true;
            }
        };
        return abstractByteIterator;
    }

    static CodedBuilder newCodedBuilder(int n) {
        CodedBuilder codedBuilder = new CodedBuilder(n);
        return codedBuilder;
    }

    public static ByteString copyFrom(ByteBuffer byteBuffer) {
        return ByteString.copyFrom(byteBuffer, byteBuffer.remaining());
    }

    public static ByteString copyFrom(byte[] byArray) {
        return ByteString.copyFrom(byArray, 0, byArray.length);
    }

    public static ByteString copyFrom(ByteBuffer object, int n) {
        ByteString.checkRange(0, n, ((Buffer)object).remaining());
        byte[] byArray = new byte[n];
        ((ByteBuffer)object).get(byArray);
        object = new LiteralByteString(byArray);
        return object;
    }

    public static ByteString copyFrom(byte[] byArray, int n, int n2) {
        ByteString.checkRange(n, n + n2, byArray.length);
        LiteralByteString literalByteString = new LiteralByteString(byteArrayCopier.copyFrom(byArray, n, n2));
        return literalByteString;
    }

    public static ByteString copyFromUtf8(String string) {
        LiteralByteString literalByteString = new LiteralByteString(string.getBytes(Internal.UTF_8));
        return literalByteString;
    }

    public abstract ByteString substring(int var1, int var2);

    static ByteString wrap(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            int n = byteBuffer.arrayOffset();
            return ByteString.wrap(byteBuffer.array(), n + byteBuffer.position(), byteBuffer.remaining());
        }
        NioByteString nioByteString = new NioByteString(byteBuffer);
        return nioByteString;
    }

    static ByteString wrap(byte[] byArray) {
        LiteralByteString literalByteString = new LiteralByteString(byArray);
        return literalByteString;
    }

    static ByteString wrap(byte[] byArray, int n, int n2) {
        BoundedByteString boundedByteString = new BoundedByteString(byArray, n, n2);
        return boundedByteString;
    }

    public abstract CodedInputStream newCodedInput();

    public final String toString() {
        Locale locale = Locale.ROOT;
        Object[] objectArray = new Object[]{Integer.toHexString(System.identityHashCode(this)), this.size(), this.truncateAndEscapeForDisplay()};
        return String.format(locale, "<ByteString@%s size=%d contents=\"%s\">", objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final String toString(Charset charset) {
        if (((ByteString)this).size() != 0) return ((ByteString)this).toStringInternal(charset);
        return "";
    }

    protected abstract String toStringInternal(Charset var1);

    public final String toStringUtf8() {
        return this.toString(Internal.UTF_8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String truncateAndEscapeForDisplay() {
        if (((ByteString)object).size() <= 50) {
            return TextFormatEscaper.escapeBytes((ByteString)object);
        }
        Object object = ((ByteString)object).substring(0, 47);
        object = TextFormatEscaper.escapeBytes((ByteString)object);
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.append((String)object).append("...").toString();
    }

    public abstract ByteBuffer asReadOnlyByteBuffer();

    /*
     * Enabled aggressive block sorting
     */
    static {
        Comparator comparator = new LiteralByteString(Internal.EMPTY_BYTE_ARRAY);
        EMPTY = comparator;
        comparator = Android.isOnAndroidDevice() ? new SystemByteArrayCopier() : new ArraysByteArrayCopier();
        byteArrayCopier = comparator;
        comparator = new Comparator(){

            public int compare(ByteString byteString, ByteString byteString2) {
                ByteIterator byteIterator = byteString.iterator();
                ByteIterator byteIterator2 = byteString2.iterator();
                while (byteIterator.hasNext() && byteIterator2.hasNext()) {
                    int n = Integer.valueOf(ByteString.toInt(byteIterator.nextByte())).compareTo(ByteString.toInt(byteIterator2.nextByte()));
                    if (n == 0) continue;
                    return n;
                }
                return Integer.valueOf(byteString.size()).compareTo(byteString2.size());
            }
        };
        UNSIGNED_LEXICOGRAPHICAL_COMPARATOR = comparator;
    }

    ByteString() {
    }

    static void checkIndex(int n, int n2) {
        if ((n | n2 - (n + 1)) < 0) {
            if (n < 0) {
                StringBuilder stringBuilder = new StringBuilder();
                ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException = new ArrayIndexOutOfBoundsException(stringBuilder.append("Index < 0: ").append(n).toString());
                throw arrayIndexOutOfBoundsException;
            }
            StringBuilder stringBuilder = new StringBuilder();
            ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException = new ArrayIndexOutOfBoundsException(stringBuilder.append("Index > length: ").append(n).append(", ").append(n2).toString());
            throw arrayIndexOutOfBoundsException;
        }
    }

    protected abstract void copyToInternal(byte[] var1, int var2, int var3, int var4);

    abstract void writeTo(ByteOutput var1) throws IOException;

    public abstract boolean equals(Object var1);

    public abstract boolean isValidUtf8();

    public final byte[] toByteArray() {
        int n = this.size();
        if (n == 0) {
            return Internal.EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[n];
        this.copyToInternal(byArray, 0, 0, n);
        return byArray;
    }

    private static class LiteralByteString
    extends LeafByteString {
        private static final long serialVersionUID = 1L;
        protected final byte[] bytes;

        @Override
        public byte byteAt(int n) {
            return this.bytes[n];
        }

        @Override
        byte internalByteAt(int n) {
            return this.bytes[n];
        }

        protected int getOffsetIntoBytes() {
            return 0;
        }

        @Override
        protected final int partialHash(int n, int n2, int n3) {
            return Internal.partialHash(n, this.bytes, this.getOffsetIntoBytes() + n2, n3);
        }

        @Override
        public int size() {
            return this.bytes.length;
        }

        @Override
        public final ByteString substring(int n, int n2) {
            if ((n2 = LiteralByteString.checkRange(n, n2, this.size())) == 0) {
                return EMPTY;
            }
            BoundedByteString boundedByteString = new BoundedByteString(this.bytes, this.getOffsetIntoBytes() + n, n2);
            return boundedByteString;
        }

        @Override
        public final CodedInputStream newCodedInput() {
            return CodedInputStream.newInstance(this.bytes, this.getOffsetIntoBytes(), this.size(), true);
        }

        @Override
        protected final String toStringInternal(Charset charset) {
            String string = new String(this.bytes, this.getOffsetIntoBytes(), this.size(), charset);
            return string;
        }

        @Override
        public final ByteBuffer asReadOnlyByteBuffer() {
            return ByteBuffer.wrap(this.bytes, this.getOffsetIntoBytes(), this.size()).asReadOnlyBuffer();
        }

        /*
         * WARNING - void declaration
         */
        LiteralByteString(byte[] byArray) {
            void var1_2;
            if (var1_2 == null) {
                NullPointerException nullPointerException = new NullPointerException();
                throw nullPointerException;
            }
            this.bytes = var1_2;
        }

        @Override
        protected void copyToInternal(byte[] byArray, int n, int n2, int n3) {
            System.arraycopy(this.bytes, n, byArray, n2, n3);
        }

        @Override
        final void writeTo(ByteOutput byteOutput) throws IOException {
            byteOutput.writeLazy(this.bytes, this.getOffsetIntoBytes(), this.size());
        }

        @Override
        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ByteString)) {
                return false;
            }
            if (this.size() != ((ByteString)object).size()) {
                return false;
            }
            if (this.size() == 0) {
                return true;
            }
            if (object instanceof LiteralByteString) {
                LiteralByteString literalByteString = (LiteralByteString)object;
                int n = this.peekCachedHashCode();
                int n2 = literalByteString.peekCachedHashCode();
                if (n != 0 && n2 != 0 && n != n2) {
                    return false;
                }
                return this.equalsRange((LiteralByteString)object, 0, this.size());
            }
            return object.equals(this);
        }

        final boolean equalsRange(ByteString serializable, int n, int n2) {
            if (n2 > ((ByteString)serializable).size()) {
                int n3 = ((LiteralByteString)serializable2).size();
                StringBuilder stringBuilder = new StringBuilder();
                serializable = new IllegalArgumentException(stringBuilder.append("Length too large: ").append(n2).append(n3).toString());
                throw serializable;
            }
            if (n + n2 > ((ByteString)serializable).size()) {
                int n4 = ((ByteString)serializable).size();
                StringBuilder stringBuilder = new StringBuilder();
                Serializable serializable2 = new IllegalArgumentException(stringBuilder.append("Ran off end of other: ").append(n).append(", ").append(n2).append(", ").append(n4).toString());
                throw serializable2;
            }
            if (serializable instanceof LiteralByteString) {
                serializable = (LiteralByteString)serializable;
                byte[] byArray = ((LiteralByteString)serializable2).bytes;
                byte[] byArray2 = ((LiteralByteString)serializable).bytes;
                n2 = ((LiteralByteString)serializable2).getOffsetIntoBytes() + n2;
                int n5 = ((LiteralByteString)serializable2).getOffsetIntoBytes();
                int n6 = ((LiteralByteString)serializable).getOffsetIntoBytes() + n;
                while (n5 < n2) {
                    if (byArray[n5] != byArray2[n6]) {
                        return false;
                    }
                    ++n5;
                    ++n6;
                }
                return true;
            }
            return ((ByteString)serializable).substring(n, n + n2).equals(((LiteralByteString)serializable2).substring(0, n2));
        }

        @Override
        public final boolean isValidUtf8() {
            int n = this.getOffsetIntoBytes();
            return Utf8.isValidUtf8(this.bytes, n, n + this.size());
        }
    }

    private static interface ByteArrayCopier {
        public byte[] copyFrom(byte[] var1, int var2, int var3);
    }

    private static final class BoundedByteString
    extends LiteralByteString {
        private static final long serialVersionUID = 1L;
        private final int bytesOffset;
        private final int bytesLength;

        @Override
        public byte byteAt(int n) {
            BoundedByteString.checkIndex(n, this.size());
            return this.bytes[this.bytesOffset + n];
        }

        @Override
        byte internalByteAt(int n) {
            return this.bytes[this.bytesOffset + n];
        }

        @Override
        protected int getOffsetIntoBytes() {
            return this.bytesOffset;
        }

        @Override
        public int size() {
            return this.bytesLength;
        }

        Object writeReplace() {
            return ByteString.wrap(this.toByteArray());
        }

        BoundedByteString(byte[] byArray, int n, int n2) {
            super(byArray);
            BoundedByteString.checkRange(n, n + n2, byArray.length);
            this.bytesOffset = n;
            this.bytesLength = n2;
        }

        @Override
        protected void copyToInternal(byte[] byArray, int n, int n2, int n3) {
            System.arraycopy(this.bytes, this.getOffsetIntoBytes() + n, byArray, n2, n3);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException {
            Serializable serializable = new InvalidObjectException("BoundedByteStream instances are not to be serialized directly");
            throw serializable;
        }
    }

    static final class CodedBuilder {
        private final CodedOutputStream output;
        private final byte[] buffer;

        public ByteString build() {
            this.output.checkNoSpaceLeft();
            LiteralByteString literalByteString = new LiteralByteString(this.buffer);
            return literalByteString;
        }

        public CodedOutputStream getCodedOutput() {
            return this.output;
        }

        private CodedBuilder(int n) {
            this.buffer = new byte[n];
            this.output = CodedOutputStream.newInstance(this.buffer);
        }
    }

    public static interface ByteIterator
    extends Iterator {
        public byte nextByte();
    }

    private static final class SystemByteArrayCopier
    implements ByteArrayCopier {
        private SystemByteArrayCopier() {
        }

        @Override
        public byte[] copyFrom(byte[] byArray, int n, int n2) {
            Object object = new byte[n2];
            System.arraycopy(byArray, n, object, 0, n2);
            return object;
        }
    }

    private static final class ArraysByteArrayCopier
    implements ByteArrayCopier {
        private ArraysByteArrayCopier() {
        }

        @Override
        public byte[] copyFrom(byte[] byArray, int n, int n2) {
            return Arrays.copyOfRange(byArray, n, n + n2);
        }
    }

    static abstract class LeafByteString
    extends ByteString {
        LeafByteString() {
        }
    }

    static abstract class AbstractByteIterator
    implements ByteIterator {
        public final Byte next() {
            return this.nextByte();
        }

        AbstractByteIterator() {
        }

        @Override
        public final void remove() {
            Object object = new UnsupportedOperationException();
            throw object;
        }
    }
}

