/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.AbstractProtobufList;
import androidx.test.espresso.remote.internal.deps.protobuf.Internal;
import androidx.test.espresso.remote.internal.deps.protobuf.PrimitiveNonBoxingCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class BooleanArrayList
extends AbstractProtobufList
implements Internal.BooleanList,
RandomAccess,
PrimitiveNonBoxingCollection {
    private static final BooleanArrayList EMPTY_LIST;
    private boolean[] array;
    private int size;

    @Override
    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Internal.hashBoolean(this.array[i]);
        }
        return n;
    }

    @Override
    public int indexOf(Object object) {
        if (!(object instanceof Boolean)) {
            return -1;
        }
        boolean bl = (Boolean)object;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.array[i] != bl) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    public static BooleanArrayList emptyList() {
        return EMPTY_LIST;
    }

    @Override
    public Internal.BooleanList mutableCopyWithCapacity(int n) {
        if (n < ((BooleanArrayList)object).size) {
            Object object = new IllegalArgumentException();
            throw object;
        }
        BooleanArrayList booleanArrayList = new BooleanArrayList(Arrays.copyOf(((BooleanArrayList)object).array, n), ((BooleanArrayList)object).size);
        return booleanArrayList;
    }

    @Override
    public Boolean get(int n) {
        return this.getBoolean(n);
    }

    @Override
    public Boolean remove(int n) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n);
        boolean bl = this.array[n];
        if (n < this.size + -1) {
            System.arraycopy(this.array, n + 1, this.array, n, this.size - n + -1);
        }
        this.size += -1;
        ++this.modCount;
        return bl;
    }

    @Override
    public Boolean set(int n, Boolean bl) {
        return this.setBoolean(n, bl);
    }

    private String makeOutOfBoundsExceptionMessage(int n) {
        int n2 = this.size;
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    static {
        BooleanArrayList booleanArrayList;
        EMPTY_LIST = booleanArrayList = new BooleanArrayList(new boolean[0], 0);
        EMPTY_LIST.makeImmutable();
    }

    BooleanArrayList() {
        this(new boolean[10], 0);
    }

    private BooleanArrayList(boolean[] blArray, int n) {
        this.array = blArray;
        this.size = n;
    }

    @Override
    public void add(int n, Boolean bl) {
        this.addBoolean(n, bl);
    }

    public void addBoolean(boolean bl) {
        boolean[] blArray;
        this.ensureIsMutable();
        if (this.size == this.array.length) {
            blArray = new boolean[this.size * 3 / 2 + 1];
            System.arraycopy(this.array, 0, blArray, 0, this.size);
            this.array = blArray;
        }
        blArray = this.array;
        int n = this.size;
        this.size = n + 1;
        blArray[n] = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addBoolean(int n, boolean bl) {
        this.ensureIsMutable();
        if (n < 0 || n > this.size) {
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n));
            throw indexOutOfBoundsException;
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, n, this.array, n + 1, this.size - n);
        } else {
            boolean[] blArray = new boolean[this.size * 3 / 2 + 1];
            System.arraycopy(this.array, 0, blArray, 0, n);
            System.arraycopy(this.array, n, blArray, n + 1, this.size - n);
            this.array = blArray;
        }
        this.array[n] = bl;
        ++this.size;
        ++this.modCount;
    }

    private void ensureIndexInRange(int n) {
        if (n < 0 || n >= this.size) {
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n));
            throw indexOutOfBoundsException;
        }
    }

    @Override
    protected void removeRange(int n, int n2) {
        ((AbstractProtobufList)object).ensureIsMutable();
        if (n2 < n) {
            Object object = new IndexOutOfBoundsException("toIndex < fromIndex");
            throw object;
        }
        System.arraycopy(((BooleanArrayList)object).array, n2, ((BooleanArrayList)object).array, n, ((BooleanArrayList)object).size - n2);
        ((BooleanArrayList)object).size -= n2 - n;
        ++((BooleanArrayList)object).modCount;
    }

    @Override
    public boolean add(Boolean bl) {
        this.addBoolean(bl);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Boolean> booleanArrayList) {
        ((AbstractProtobufList)object).ensureIsMutable();
        Internal.checkNotNull(booleanArrayList);
        if (!(booleanArrayList instanceof BooleanArrayList)) {
            return super.addAll(booleanArrayList);
        }
        booleanArrayList = booleanArrayList;
        if (booleanArrayList.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - ((BooleanArrayList)object).size < booleanArrayList.size) {
            Object object = new OutOfMemoryError();
            throw object;
        }
        int n = ((BooleanArrayList)object).size + booleanArrayList.size;
        if (n > ((BooleanArrayList)object).array.length) {
            ((BooleanArrayList)object).array = Arrays.copyOf(((BooleanArrayList)object).array, n);
        }
        System.arraycopy(booleanArrayList.array, 0, ((BooleanArrayList)object).array, ((BooleanArrayList)object).size, booleanArrayList.size);
        ((BooleanArrayList)object).size = n;
        ++((BooleanArrayList)object).modCount;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean contains(Object object) {
        if (this.indexOf(object) == -1) return false;
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BooleanArrayList)) {
            return super.equals(object);
        }
        object = (BooleanArrayList)object;
        if (this.size != ((BooleanArrayList)object).size) {
            return false;
        }
        boolean[] blArray = ((BooleanArrayList)object).array;
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    public boolean getBoolean(int n) {
        this.ensureIndexInRange(n);
        return this.array[n];
    }

    public boolean setBoolean(int n, boolean bl) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n);
        boolean[] blArray = this.array;
        boolean bl2 = blArray[n];
        this.array[n] = bl;
        return bl2;
    }
}

