/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.BinaryReader-IA;
import androidx.test.espresso.remote.internal.deps.protobuf.BooleanArrayList;
import androidx.test.espresso.remote.internal.deps.protobuf.ByteString;
import androidx.test.espresso.remote.internal.deps.protobuf.CodedInputStream;
import androidx.test.espresso.remote.internal.deps.protobuf.DoubleArrayList;
import androidx.test.espresso.remote.internal.deps.protobuf.ExtensionRegistryLite;
import androidx.test.espresso.remote.internal.deps.protobuf.FloatArrayList;
import androidx.test.espresso.remote.internal.deps.protobuf.IntArrayList;
import androidx.test.espresso.remote.internal.deps.protobuf.Internal;
import androidx.test.espresso.remote.internal.deps.protobuf.InvalidProtocolBufferException;
import androidx.test.espresso.remote.internal.deps.protobuf.LazyStringList;
import androidx.test.espresso.remote.internal.deps.protobuf.LongArrayList;
import androidx.test.espresso.remote.internal.deps.protobuf.MapEntryLite;
import androidx.test.espresso.remote.internal.deps.protobuf.Protobuf;
import androidx.test.espresso.remote.internal.deps.protobuf.Reader;
import androidx.test.espresso.remote.internal.deps.protobuf.Schema;
import androidx.test.espresso.remote.internal.deps.protobuf.Utf8;
import androidx.test.espresso.remote.internal.deps.protobuf.WireFormat;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

abstract class BinaryReader
implements Reader {
    public static BinaryReader newInstance(ByteBuffer object, boolean bl) {
        if (!((ByteBuffer)object).hasArray()) {
            object = new IllegalArgumentException("Direct buffers not yet supported");
            throw object;
        }
        SafeHeapReader safeHeapReader = new SafeHeapReader((ByteBuffer)object, bl);
        return safeHeapReader;
    }

    private BinaryReader() {
    }

    /* synthetic */ BinaryReader(BinaryReader-IA binaryReader-IA) {
        this();
    }

    private static final class SafeHeapReader
    extends BinaryReader {
        private final boolean bufferIsImmutable;
        private final byte[] buffer;
        private int pos;
        private final int initialPos;
        private int limit;
        private int tag;
        private int endGroupTag;

        private byte readByte() throws IOException {
            if (this.pos == this.limit) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            byte[] byArray = this.buffer;
            int n = this.pos;
            this.pos = n + 1;
            return byArray[n];
        }

        @Override
        public double readDouble() throws IOException {
            this.requireWireType(1);
            return Double.longBitsToDouble(this.readLittleEndian64());
        }

        @Override
        public float readFloat() throws IOException {
            this.requireWireType(5);
            return Float.intBitsToFloat(this.readLittleEndian32());
        }

        @Override
        public int getFieldNumber() throws IOException {
            if (this.isAtEnd()) {
                return Integer.MAX_VALUE;
            }
            this.tag = this.readVarint32();
            if (this.tag == this.endGroupTag) {
                return Integer.MAX_VALUE;
            }
            return WireFormat.getTagFieldNumber(this.tag);
        }

        @Override
        public int getTag() {
            return this.tag;
        }

        @Override
        public int readEnum() throws IOException {
            this.requireWireType(0);
            return this.readVarint32();
        }

        @Override
        public int readFixed32() throws IOException {
            this.requireWireType(5);
            return this.readLittleEndian32();
        }

        @Override
        public int readInt32() throws IOException {
            this.requireWireType(0);
            return this.readVarint32();
        }

        private int readLittleEndian32() throws IOException {
            this.requireBytes(4);
            return this.readLittleEndian32_NoCheck();
        }

        private int readLittleEndian32_NoCheck() {
            int n = this.pos;
            byte[] byArray = this.buffer;
            this.pos = n + 4;
            return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
        }

        @Override
        public int readSFixed32() throws IOException {
            this.requireWireType(5);
            return this.readLittleEndian32();
        }

        @Override
        public int readSInt32() throws IOException {
            this.requireWireType(0);
            return CodedInputStream.decodeZigZag32(this.readVarint32());
        }

        @Override
        public int readUInt32() throws IOException {
            this.requireWireType(0);
            return this.readVarint32();
        }

        /*
         * Enabled aggressive block sorting
         */
        private int readVarint32() throws IOException {
            int n;
            int n2;
            block8: {
                int n3;
                block12: {
                    block13: {
                        block14: {
                            int n4;
                            block11: {
                                block10: {
                                    block9: {
                                        n2 = this.pos;
                                        if (this.limit == this.pos) {
                                            throw InvalidProtocolBufferException.truncatedMessage();
                                        }
                                        n = n2 + 1;
                                        if ((n2 = this.buffer[n2]) >= 0) {
                                            this.pos = n;
                                            return n2;
                                        }
                                        if (this.limit - n < 9) {
                                            return (int)this.readVarint64SlowPath();
                                        }
                                        n4 = n + 1;
                                        if ((n2 ^= this.buffer[n] << 7) >= 0) break block9;
                                        n = n2 ^ 0xFFFFFF80;
                                        n2 = n4;
                                        break block8;
                                    }
                                    n = n4 + 1;
                                    if ((n2 ^= this.buffer[n4] << 14) < 0) break block10;
                                    n4 = n2 ^ 0x3F80;
                                    n2 = n;
                                    n = n4;
                                    break block8;
                                }
                                n4 = n + 1;
                                if ((n2 ^= this.buffer[n] << 21) >= 0) break block11;
                                n = n2 ^ 0xFFE03F80;
                                n2 = n4;
                                break block8;
                            }
                            n = n4 + 1;
                            n4 = this.buffer[n4];
                            n3 = n2 ^ n4 << 28 ^ 0xFE03F80;
                            if (n4 >= 0) break block12;
                            n2 = n + 1;
                            if (this.buffer[n] >= 0) break block13;
                            n = n2 + 1;
                            if (this.buffer[n2] >= 0) break block14;
                            n2 = n + 1;
                            if (this.buffer[n] < 0) {
                                n = n2 + 1;
                                if (this.buffer[n2] < 0) {
                                    n2 = n + 1;
                                    if (this.buffer[n] < 0) {
                                        throw InvalidProtocolBufferException.malformedVarint();
                                    }
                                    n = n3;
                                    break block8;
                                } else {
                                    n2 = n;
                                    n = n3;
                                }
                                break block8;
                            } else {
                                n = n3;
                            }
                            break block8;
                        }
                        n2 = n;
                        n = n3;
                        break block8;
                    }
                    n = n3;
                    break block8;
                }
                n2 = n;
                n = n3;
            }
            this.pos = n2;
            return n;
        }

        @Override
        public long readFixed64() throws IOException {
            this.requireWireType(1);
            return this.readLittleEndian64();
        }

        @Override
        public long readInt64() throws IOException {
            this.requireWireType(0);
            return this.readVarint64();
        }

        private long readLittleEndian64() throws IOException {
            this.requireBytes(8);
            return this.readLittleEndian64_NoCheck();
        }

        private long readLittleEndian64_NoCheck() {
            int n = this.pos;
            byte[] byArray = this.buffer;
            this.pos = n + 8;
            return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | ((long)byArray[n + 7] & 0xFFL) << 56;
        }

        @Override
        public long readSFixed64() throws IOException {
            this.requireWireType(1);
            return this.readLittleEndian64();
        }

        @Override
        public long readSInt64() throws IOException {
            this.requireWireType(0);
            return CodedInputStream.decodeZigZag64(this.readVarint64());
        }

        @Override
        public long readUInt64() throws IOException {
            this.requireWireType(0);
            return this.readVarint64();
        }

        /*
         * Enabled aggressive block sorting
         */
        public long readVarint64() throws IOException {
            long l;
            int n = this.pos;
            if (this.limit == n) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            byte[] byArray = this.buffer;
            int n2 = n + 1;
            if ((n = byArray[n]) >= 0) {
                this.pos = n2;
                return n;
            }
            if (this.limit - n2 < 9) {
                return this.readVarint64SlowPath();
            }
            int n3 = n2 + 1;
            if ((n ^= byArray[n2] << 7) < 0) {
                long l2 = n ^ 0xFFFFFF80;
                n = n3;
                l = l2;
            } else {
                n2 = n3 + 1;
                if ((n ^= byArray[n3] << 14) >= 0) {
                    long l3 = n ^ 0x3F80;
                    n = n2;
                    l = l3;
                } else {
                    n3 = n2 + 1;
                    if ((n ^= byArray[n2] << 21) < 0) {
                        long l4 = n ^ 0xFFE03F80;
                        n = n3;
                        l = l4;
                    } else {
                        n2 = n3 + 1;
                        long l5 = (long)n ^ (long)byArray[n3] << 28;
                        if (l5 >= 0L) {
                            long l6 = l5 ^ 0xFE03F80L;
                            n = n2;
                            l = l6;
                        } else {
                            n = n2 + 1;
                            long l7 = l5 ^ (long)byArray[n2] << 35;
                            if (l7 < 0L) {
                                l = l7 ^= 0xFFFFFFF80FE03F80L;
                            } else {
                                n2 = n + 1;
                                if ((l7 ^= (long)byArray[n] << 42) >= 0L) {
                                    n = n2;
                                    l = l7 ^= 0x3F80FE03F80L;
                                } else {
                                    n = n2 + 1;
                                    if ((l7 ^= (long)byArray[n2] << 49) < 0L) {
                                        l = l7 ^= 0xFFFE03F80FE03F80L;
                                    } else {
                                        n2 = n + 1;
                                        long l8 = l7 ^ (long)byArray[n] << 56 ^ 0xFE03F80FE03F80L;
                                        if (l8 < 0L) {
                                            n = n2 + 1;
                                            if ((long)byArray[n2] < 0L) {
                                                throw InvalidProtocolBufferException.malformedVarint();
                                            }
                                            l = l8;
                                        } else {
                                            n = n2;
                                            l = l8;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            this.pos = n;
            return l;
        }

        private long readVarint64SlowPath() throws IOException {
            long l = 0L;
            int n = 0;
            while (true) {
                long l2;
                if (n < 64) {
                    byte by = this.readByte();
                    l2 = l | (long)(by & 0x7F) << n;
                    if ((by & 0x80) == 0) {
                        return l2;
                    }
                } else {
                    throw InvalidProtocolBufferException.malformedVarint();
                }
                n += 7;
                l = l2;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public ByteString readBytes() throws IOException {
            this.requireWireType(2);
            int n = this.readVarint32();
            if (n == 0) {
                return ByteString.EMPTY;
            }
            this.requireBytes(n);
            ByteString byteString = this.bufferIsImmutable ? ByteString.wrap(this.buffer, this.pos, n) : ByteString.copyFrom(this.buffer, this.pos, n);
            this.pos += n;
            return byteString;
        }

        private Object readField(WireFormat.FieldType fieldType, Class clazz, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            switch (1.$SwitchMap$com$google$protobuf$WireFormat$FieldType[fieldType.ordinal()]) {
                default: {
                    Object object = new RuntimeException("unsupported field type.");
                    throw object;
                }
                case 17: {
                    return ((SafeHeapReader)object).readUInt64();
                }
                case 16: {
                    return ((SafeHeapReader)object).readUInt32();
                }
                case 15: {
                    return ((SafeHeapReader)object).readStringRequireUtf8();
                }
                case 14: {
                    return ((SafeHeapReader)object).readSInt64();
                }
                case 13: {
                    return ((SafeHeapReader)object).readSInt32();
                }
                case 12: {
                    return ((SafeHeapReader)object).readSFixed64();
                }
                case 11: {
                    return ((SafeHeapReader)object).readSFixed32();
                }
                case 10: {
                    return ((SafeHeapReader)object).readMessage(clazz, extensionRegistryLite);
                }
                case 9: {
                    return ((SafeHeapReader)object).readInt64();
                }
                case 8: {
                    return ((SafeHeapReader)object).readInt32();
                }
                case 7: {
                    return Float.valueOf(((SafeHeapReader)object).readFloat());
                }
                case 6: {
                    return ((SafeHeapReader)object).readFixed64();
                }
                case 5: {
                    return ((SafeHeapReader)object).readFixed32();
                }
                case 4: {
                    return ((SafeHeapReader)object).readEnum();
                }
                case 3: {
                    return ((SafeHeapReader)object).readDouble();
                }
                case 2: {
                    return ((SafeHeapReader)object).readBytes();
                }
                case 1: 
            }
            return ((SafeHeapReader)object).readBool();
        }

        private Object readGroup(Schema schema, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            Object object;
            int n;
            block3: {
                n = this.endGroupTag;
                this.endGroupTag = WireFormat.makeTag(WireFormat.getTagFieldNumber(this.tag), 4);
                try {
                    object = schema.newInstance();
                    schema.mergeFrom(object, this, extensionRegistryLite);
                    schema.makeImmutable(object);
                    int n2 = this.tag;
                    int n3 = this.endGroupTag;
                    if (n2 == n3) break block3;
                }
                catch (Throwable throwable) {
                    this.endGroupTag = n;
                    throw throwable;
                }
                throw InvalidProtocolBufferException.parseFailure();
            }
            this.endGroupTag = n;
            return object;
        }

        @Override
        @Deprecated
        public Object readGroup(Class clazz, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            this.requireWireType(3);
            return this.readGroup(Protobuf.getInstance().schemaFor(clazz), extensionRegistryLite);
        }

        @Override
        @Deprecated
        public Object readGroupBySchemaWithCheck(Schema schema, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            this.requireWireType(3);
            return this.readGroup(schema, extensionRegistryLite);
        }

        private Object readMessage(Schema schema, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            Object object;
            int n;
            block3: {
                int n2 = this.readVarint32();
                this.requireBytes(n2);
                n = this.limit;
                this.limit = n2 = this.pos + n2;
                try {
                    object = schema.newInstance();
                    schema.mergeFrom(object, this, extensionRegistryLite);
                    schema.makeImmutable(object);
                    int n3 = this.pos;
                    if (n3 == n2) break block3;
                }
                catch (Throwable throwable) {
                    this.limit = n;
                    throw throwable;
                }
                throw InvalidProtocolBufferException.parseFailure();
            }
            this.limit = n;
            return object;
        }

        @Override
        public Object readMessage(Class clazz, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            this.requireWireType(2);
            return this.readMessage(Protobuf.getInstance().schemaFor(clazz), extensionRegistryLite);
        }

        @Override
        public Object readMessageBySchemaWithCheck(Schema schema, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            this.requireWireType(2);
            return this.readMessage(schema, extensionRegistryLite);
        }

        @Override
        public String readString() throws IOException {
            return this.readStringInternal(false);
        }

        public String readStringInternal(boolean bl) throws IOException {
            this.requireWireType(2);
            int n = this.readVarint32();
            if (n == 0) {
                return "";
            }
            this.requireBytes(n);
            if (bl && !Utf8.isValidUtf8(this.buffer, this.pos, this.pos + n)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            String string = new String(this.buffer, this.pos, n, Internal.UTF_8);
            this.pos += n;
            return string;
        }

        @Override
        public String readStringRequireUtf8() throws IOException {
            return this.readStringInternal(true);
        }

        public SafeHeapReader(ByteBuffer byteBuffer, boolean bl) {
            super(null);
            int n;
            this.bufferIsImmutable = bl;
            this.buffer = byteBuffer.array();
            this.pos = n = byteBuffer.arrayOffset() + byteBuffer.position();
            this.initialPos = n;
            this.limit = byteBuffer.arrayOffset() + byteBuffer.limit();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void readBoolList(List list) throws IOException {
            int n;
            block17: {
                int n2;
                BooleanArrayList booleanArrayList;
                block16: {
                    int n3;
                    block15: {
                        if (!(list instanceof BooleanArrayList)) break block15;
                        booleanArrayList = (BooleanArrayList)list;
                        switch (WireFormat.getTagWireType(this.tag)) {
                            case 0: {
                                break block16;
                            }
                            case 2: {
                                int n4 = this.readVarint32();
                                int n5 = this.pos + n4;
                                while (true) {
                                    if (this.pos >= n5) {
                                        this.requirePosition(n5);
                                        return;
                                    }
                                    n4 = this.readVarint32() != 0 ? 1 : 0;
                                    booleanArrayList.addBoolean(n4 != 0);
                                }
                            }
                            default: {
                                throw InvalidProtocolBufferException.invalidWireType();
                            }
                        }
                    }
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 0: {
                            break block17;
                        }
                        case 2: {
                            int n6 = this.readVarint32();
                            n3 = this.pos + n6;
                            while (this.pos < n3) {
                                n6 = this.readVarint32() != 0 ? 1 : 0;
                                list.add(n6 != 0);
                            }
                            break;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                    this.requirePosition(n3);
                    return;
                }
                do {
                    booleanArrayList.addBoolean(this.readBool());
                    if (this.isAtEnd()) {
                        return;
                    }
                    n2 = this.pos;
                } while (this.readVarint32() == this.tag);
                this.pos = n2;
                return;
            }
            do {
                list.add(this.readBool());
                if (this.isAtEnd()) {
                    return;
                }
                n = this.pos;
            } while (this.readVarint32() == this.tag);
            this.pos = n;
        }

        @Override
        public void readBytesList(List list) throws IOException {
            int n;
            if (WireFormat.getTagWireType(this.tag) == 2) {
                do {
                    list.add(this.readBytes());
                    if (this.isAtEnd()) {
                        return;
                    }
                    n = this.pos;
                } while (this.readVarint32() == this.tag);
            } else {
                throw InvalidProtocolBufferException.invalidWireType();
            }
            this.pos = n;
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        @Override
        public void readDoubleList(List list) throws IOException {
            int n;
            block17: {
                int n2;
                block16: {
                    int n3;
                    block15: {
                        block14: {
                            if (!(list instanceof DoubleArrayList)) break block14;
                            list = (DoubleArrayList)list;
                            switch (WireFormat.getTagWireType(this.tag)) {
                                case 1: {
                                    break block15;
                                }
                                case 2: {
                                    int n4 = this.readVarint32();
                                    this.verifyPackedFixed64Length(n4);
                                    n4 = this.pos + n4;
                                    while (this.pos < n4) {
                                        ((DoubleArrayList)list).addDouble(Double.longBitsToDouble(this.readLittleEndian64_NoCheck()));
                                    }
                                    return;
                                }
                                default: {
                                    throw InvalidProtocolBufferException.invalidWireType();
                                }
                            }
                        }
                        switch (WireFormat.getTagWireType(this.tag)) {
                            case 1: {
                                break block16;
                            }
                            case 2: {
                                n = this.readVarint32();
                                this.verifyPackedFixed64Length(n);
                                n = this.pos + n;
                                break block17;
                            }
                            default: {
                                throw InvalidProtocolBufferException.invalidWireType();
                            }
                        }
                    }
                    do {
                        ((DoubleArrayList)list).addDouble(this.readDouble());
                        if (this.isAtEnd()) {
                            return;
                        }
                        n3 = this.pos;
                    } while (this.readVarint32() == this.tag);
                    this.pos = n3;
                    return;
                }
                do {
                    list.add(this.readDouble());
                    if (this.isAtEnd()) {
                        return;
                    }
                    n2 = this.pos;
                } while (this.readVarint32() == this.tag);
                this.pos = n2;
                return;
            }
            while (this.pos < n) {
                list.add(Double.longBitsToDouble(this.readLittleEndian64_NoCheck()));
            }
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        @Override
        public void readEnumList(List list) throws IOException {
            int n;
            block17: {
                int n2;
                block16: {
                    int n3;
                    block15: {
                        block14: {
                            if (!(list instanceof IntArrayList)) break block14;
                            list = (IntArrayList)list;
                            switch (WireFormat.getTagWireType(this.tag)) {
                                case 0: {
                                    break block15;
                                }
                                case 2: {
                                    int n4 = this.readVarint32();
                                    n4 = this.pos + n4;
                                    while (this.pos < n4) {
                                        ((IntArrayList)list).addInt(this.readVarint32());
                                    }
                                    return;
                                }
                                default: {
                                    throw InvalidProtocolBufferException.invalidWireType();
                                }
                            }
                        }
                        switch (WireFormat.getTagWireType(this.tag)) {
                            case 0: {
                                break block16;
                            }
                            case 2: {
                                n = this.readVarint32();
                                n = this.pos + n;
                                break block17;
                            }
                            default: {
                                throw InvalidProtocolBufferException.invalidWireType();
                            }
                        }
                    }
                    do {
                        ((IntArrayList)list).addInt(this.readEnum());
                        if (this.isAtEnd()) {
                            return;
                        }
                        n3 = this.pos;
                    } while (this.readVarint32() == this.tag);
                    this.pos = n3;
                    return;
                }
                do {
                    list.add(this.readEnum());
                    if (this.isAtEnd()) {
                        return;
                    }
                    n2 = this.pos;
                } while (this.readVarint32() == this.tag);
                this.pos = n2;
                return;
            }
            while (this.pos < n) {
                list.add(this.readVarint32());
            }
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        @Override
        public void readFixed32List(List list) throws IOException {
            int n;
            block17: {
                int n2;
                block16: {
                    int n3;
                    block15: {
                        block14: {
                            if (!(list instanceof IntArrayList)) break block14;
                            list = (IntArrayList)list;
                            switch (WireFormat.getTagWireType(this.tag)) {
                                case 5: {
                                    break block15;
                                }
                                case 2: {
                                    int n4 = this.readVarint32();
                                    this.verifyPackedFixed32Length(n4);
                                    n4 = this.pos + n4;
                                    while (this.pos < n4) {
                                        ((IntArrayList)list).addInt(this.readLittleEndian32_NoCheck());
                                    }
                                    return;
                                }
                                default: {
                                    throw InvalidProtocolBufferException.invalidWireType();
                                }
                            }
                        }
                        switch (WireFormat.getTagWireType(this.tag)) {
                            case 5: {
                                break block16;
                            }
                            case 2: {
                                n = this.readVarint32();
                                this.verifyPackedFixed32Length(n);
                                n = this.pos + n;
                                break block17;
                            }
                            default: {
                                throw InvalidProtocolBufferException.invalidWireType();
                            }
                        }
                    }
                    do {
                        ((IntArrayList)list).addInt(this.readFixed32());
                        if (this.isAtEnd()) {
                            return;
                        }
                        n3 = this.pos;
                    } while (this.readVarint32() == this.tag);
                    this.pos = n3;
                    return;
                }
                do {
                    list.add(this.readFixed32());
                    if (this.isAtEnd()) {
                        return;
                    }
                    n2 = this.pos;
                } while (this.readVarint32() == this.tag);
                this.pos = n2;
                return;
            }
            while (this.pos < n) {
                list.add(this.readLittleEndian32_NoCheck());
            }
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        @Override
        public void readFixed64List(List list) throws IOException {
            int n;
            block17: {
                int n2;
                block16: {
                    int n3;
                    block15: {
                        block14: {
                            if (!(list instanceof LongArrayList)) break block14;
                            list = (LongArrayList)list;
                            switch (WireFormat.getTagWireType(this.tag)) {
                                case 1: {
                                    break block15;
                                }
                                case 2: {
                                    int n4 = this.readVarint32();
                                    this.verifyPackedFixed64Length(n4);
                                    n4 = this.pos + n4;
                                    while (this.pos < n4) {
                                        ((LongArrayList)list).addLong(this.readLittleEndian64_NoCheck());
                                    }
                                    return;
                                }
                                default: {
                                    throw InvalidProtocolBufferException.invalidWireType();
                                }
                            }
                        }
                        switch (WireFormat.getTagWireType(this.tag)) {
                            case 1: {
                                break block16;
                            }
                            case 2: {
                                n = this.readVarint32();
                                this.verifyPackedFixed64Length(n);
                                n = this.pos + n;
                                break block17;
                            }
                            default: {
                                throw InvalidProtocolBufferException.invalidWireType();
                            }
                        }
                    }
                    do {
                        ((LongArrayList)list).addLong(this.readFixed64());
                        if (this.isAtEnd()) {
                            return;
                        }
                        n3 = this.pos;
                    } while (this.readVarint32() == this.tag);
                    this.pos = n3;
                    return;
                }
                do {
                    list.add(this.readFixed64());
                    if (this.isAtEnd()) {
                        return;
                    }
                    n2 = this.pos;
                } while (this.readVarint32() == this.tag);
                this.pos = n2;
                return;
            }
            while (this.pos < n) {
                list.add(this.readLittleEndian64_NoCheck());
            }
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        @Override
        public void readFloatList(List list) throws IOException {
            int n;
            block17: {
                int n2;
                block16: {
                    int n3;
                    block15: {
                        block14: {
                            if (!(list instanceof FloatArrayList)) break block14;
                            list = (FloatArrayList)list;
                            switch (WireFormat.getTagWireType(this.tag)) {
                                case 5: {
                                    break block15;
                                }
                                case 2: {
                                    int n4 = this.readVarint32();
                                    this.verifyPackedFixed32Length(n4);
                                    n4 = this.pos + n4;
                                    while (this.pos < n4) {
                                        ((FloatArrayList)list).addFloat(Float.intBitsToFloat(this.readLittleEndian32_NoCheck()));
                                    }
                                    return;
                                }
                                default: {
                                    throw InvalidProtocolBufferException.invalidWireType();
                                }
                            }
                        }
                        switch (WireFormat.getTagWireType(this.tag)) {
                            case 5: {
                                break block16;
                            }
                            case 2: {
                                n = this.readVarint32();
                                this.verifyPackedFixed32Length(n);
                                n = this.pos + n;
                                break block17;
                            }
                            default: {
                                throw InvalidProtocolBufferException.invalidWireType();
                            }
                        }
                    }
                    do {
                        ((FloatArrayList)list).addFloat(this.readFloat());
                        if (this.isAtEnd()) {
                            return;
                        }
                        n3 = this.pos;
                    } while (this.readVarint32() == this.tag);
                    this.pos = n3;
                    return;
                }
                do {
                    list.add(Float.valueOf(this.readFloat()));
                    if (this.isAtEnd()) {
                        return;
                    }
                    n2 = this.pos;
                } while (this.readVarint32() == this.tag);
                this.pos = n2;
                return;
            }
            while (this.pos < n) {
                list.add(Float.valueOf(Float.intBitsToFloat(this.readLittleEndian32_NoCheck())));
            }
        }

        @Override
        @Deprecated
        public void readGroupList(List list, Schema schema, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            int n;
            if (WireFormat.getTagWireType(this.tag) != 3) {
                throw InvalidProtocolBufferException.invalidWireType();
            }
            int n2 = this.tag;
            do {
                list.add(this.readGroup(schema, extensionRegistryLite));
                if (this.isAtEnd()) {
                    return;
                }
                n = this.pos;
            } while (this.readVarint32() == n2);
            this.pos = n;
        }

        @Override
        public void readInt32List(List list) throws IOException {
            int n;
            if (list instanceof IntArrayList) {
                list = (IntArrayList)list;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 0: {
                        int n2;
                        do {
                            ((IntArrayList)list).addInt(this.readInt32());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n2 = this.pos;
                        } while (this.readVarint32() == this.tag);
                        this.pos = n2;
                        return;
                    }
                    case 2: {
                        int n3 = this.readVarint32();
                        n3 = this.pos + n3;
                        while (this.pos < n3) {
                            ((IntArrayList)list).addInt(this.readVarint32());
                        }
                        this.requirePosition(n3);
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 0: {
                    int n4;
                    do {
                        list.add(this.readInt32());
                        if (this.isAtEnd()) {
                            return;
                        }
                        n4 = this.pos;
                    } while (this.readVarint32() == this.tag);
                    this.pos = n4;
                    return;
                }
                case 2: {
                    n = this.readVarint32();
                    n = this.pos + n;
                    while (this.pos < n) {
                        list.add(this.readVarint32());
                    }
                    break;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
            this.requirePosition(n);
        }

        @Override
        public void readInt64List(List list) throws IOException {
            int n;
            if (list instanceof LongArrayList) {
                list = (LongArrayList)list;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 0: {
                        int n2;
                        do {
                            ((LongArrayList)list).addLong(this.readInt64());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n2 = this.pos;
                        } while (this.readVarint32() == this.tag);
                        this.pos = n2;
                        return;
                    }
                    case 2: {
                        int n3 = this.readVarint32();
                        n3 = this.pos + n3;
                        while (this.pos < n3) {
                            ((LongArrayList)list).addLong(this.readVarint64());
                        }
                        this.requirePosition(n3);
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 0: {
                    int n4;
                    do {
                        list.add(this.readInt64());
                        if (this.isAtEnd()) {
                            return;
                        }
                        n4 = this.pos;
                    } while (this.readVarint32() == this.tag);
                    this.pos = n4;
                    return;
                }
                case 2: {
                    n = this.readVarint32();
                    n = this.pos + n;
                    while (this.pos < n) {
                        list.add(this.readVarint64());
                    }
                    break;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
            this.requirePosition(n);
        }

        /*
         * Exception decompiling
         */
        @Override
        public void readMap(Map var1_1, MapEntryLite.Metadata var2_3, ExtensionRegistryLite var3_4) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [9 : 180->186)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void readMessageList(List list, Schema schema, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            int n;
            if (WireFormat.getTagWireType(this.tag) != 2) {
                throw InvalidProtocolBufferException.invalidWireType();
            }
            int n2 = this.tag;
            do {
                list.add(this.readMessage(schema, extensionRegistryLite));
                if (this.isAtEnd()) {
                    return;
                }
                n = this.pos;
            } while (this.readVarint32() == n2);
            this.pos = n;
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        @Override
        public void readSFixed32List(List list) throws IOException {
            int n;
            block17: {
                int n2;
                block16: {
                    int n3;
                    block15: {
                        block14: {
                            if (!(list instanceof IntArrayList)) break block14;
                            list = (IntArrayList)list;
                            switch (WireFormat.getTagWireType(this.tag)) {
                                case 5: {
                                    break block15;
                                }
                                case 2: {
                                    int n4 = this.readVarint32();
                                    this.verifyPackedFixed32Length(n4);
                                    n4 = this.pos + n4;
                                    while (this.pos < n4) {
                                        ((IntArrayList)list).addInt(this.readLittleEndian32_NoCheck());
                                    }
                                    return;
                                }
                                default: {
                                    throw InvalidProtocolBufferException.invalidWireType();
                                }
                            }
                        }
                        switch (WireFormat.getTagWireType(this.tag)) {
                            case 5: {
                                break block16;
                            }
                            case 2: {
                                n = this.readVarint32();
                                this.verifyPackedFixed32Length(n);
                                n = this.pos + n;
                                break block17;
                            }
                            default: {
                                throw InvalidProtocolBufferException.invalidWireType();
                            }
                        }
                    }
                    do {
                        ((IntArrayList)list).addInt(this.readSFixed32());
                        if (this.isAtEnd()) {
                            return;
                        }
                        n3 = this.pos;
                    } while (this.readVarint32() == this.tag);
                    this.pos = n3;
                    return;
                }
                do {
                    list.add(this.readSFixed32());
                    if (this.isAtEnd()) {
                        return;
                    }
                    n2 = this.pos;
                } while (this.readVarint32() == this.tag);
                this.pos = n2;
                return;
            }
            while (this.pos < n) {
                list.add(this.readLittleEndian32_NoCheck());
            }
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        @Override
        public void readSFixed64List(List list) throws IOException {
            int n;
            block17: {
                int n2;
                block16: {
                    int n3;
                    block15: {
                        block14: {
                            if (!(list instanceof LongArrayList)) break block14;
                            list = (LongArrayList)list;
                            switch (WireFormat.getTagWireType(this.tag)) {
                                case 1: {
                                    break block15;
                                }
                                case 2: {
                                    int n4 = this.readVarint32();
                                    this.verifyPackedFixed64Length(n4);
                                    n4 = this.pos + n4;
                                    while (this.pos < n4) {
                                        ((LongArrayList)list).addLong(this.readLittleEndian64_NoCheck());
                                    }
                                    return;
                                }
                                default: {
                                    throw InvalidProtocolBufferException.invalidWireType();
                                }
                            }
                        }
                        switch (WireFormat.getTagWireType(this.tag)) {
                            case 1: {
                                break block16;
                            }
                            case 2: {
                                n = this.readVarint32();
                                this.verifyPackedFixed64Length(n);
                                n = this.pos + n;
                                break block17;
                            }
                            default: {
                                throw InvalidProtocolBufferException.invalidWireType();
                            }
                        }
                    }
                    do {
                        ((LongArrayList)list).addLong(this.readSFixed64());
                        if (this.isAtEnd()) {
                            return;
                        }
                        n3 = this.pos;
                    } while (this.readVarint32() == this.tag);
                    this.pos = n3;
                    return;
                }
                do {
                    list.add(this.readSFixed64());
                    if (this.isAtEnd()) {
                        return;
                    }
                    n2 = this.pos;
                } while (this.readVarint32() == this.tag);
                this.pos = n2;
                return;
            }
            while (this.pos < n) {
                list.add(this.readLittleEndian64_NoCheck());
            }
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        @Override
        public void readSInt32List(List list) throws IOException {
            int n;
            block17: {
                int n2;
                block16: {
                    int n3;
                    block15: {
                        block14: {
                            if (!(list instanceof IntArrayList)) break block14;
                            list = (IntArrayList)list;
                            switch (WireFormat.getTagWireType(this.tag)) {
                                case 0: {
                                    break block15;
                                }
                                case 2: {
                                    int n4 = this.readVarint32();
                                    n4 = this.pos + n4;
                                    while (this.pos < n4) {
                                        ((IntArrayList)list).addInt(CodedInputStream.decodeZigZag32(this.readVarint32()));
                                    }
                                    return;
                                }
                                default: {
                                    throw InvalidProtocolBufferException.invalidWireType();
                                }
                            }
                        }
                        switch (WireFormat.getTagWireType(this.tag)) {
                            case 0: {
                                break block16;
                            }
                            case 2: {
                                n = this.readVarint32();
                                n = this.pos + n;
                                break block17;
                            }
                            default: {
                                throw InvalidProtocolBufferException.invalidWireType();
                            }
                        }
                    }
                    do {
                        ((IntArrayList)list).addInt(this.readSInt32());
                        if (this.isAtEnd()) {
                            return;
                        }
                        n3 = this.pos;
                    } while (this.readVarint32() == this.tag);
                    this.pos = n3;
                    return;
                }
                do {
                    list.add(this.readSInt32());
                    if (this.isAtEnd()) {
                        return;
                    }
                    n2 = this.pos;
                } while (this.readVarint32() == this.tag);
                this.pos = n2;
                return;
            }
            while (this.pos < n) {
                list.add(CodedInputStream.decodeZigZag32(this.readVarint32()));
            }
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        @Override
        public void readSInt64List(List list) throws IOException {
            int n;
            block17: {
                int n2;
                block16: {
                    int n3;
                    block15: {
                        block14: {
                            if (!(list instanceof LongArrayList)) break block14;
                            list = (LongArrayList)list;
                            switch (WireFormat.getTagWireType(this.tag)) {
                                case 0: {
                                    break block15;
                                }
                                case 2: {
                                    int n4 = this.readVarint32();
                                    n4 = this.pos + n4;
                                    while (this.pos < n4) {
                                        ((LongArrayList)list).addLong(CodedInputStream.decodeZigZag64(this.readVarint64()));
                                    }
                                    return;
                                }
                                default: {
                                    throw InvalidProtocolBufferException.invalidWireType();
                                }
                            }
                        }
                        switch (WireFormat.getTagWireType(this.tag)) {
                            case 0: {
                                break block16;
                            }
                            case 2: {
                                n = this.readVarint32();
                                n = this.pos + n;
                                break block17;
                            }
                            default: {
                                throw InvalidProtocolBufferException.invalidWireType();
                            }
                        }
                    }
                    do {
                        ((LongArrayList)list).addLong(this.readSInt64());
                        if (this.isAtEnd()) {
                            return;
                        }
                        n3 = this.pos;
                    } while (this.readVarint32() == this.tag);
                    this.pos = n3;
                    return;
                }
                do {
                    list.add(this.readSInt64());
                    if (this.isAtEnd()) {
                        return;
                    }
                    n2 = this.pos;
                } while (this.readVarint32() == this.tag);
                this.pos = n2;
                return;
            }
            while (this.pos < n) {
                list.add(CodedInputStream.decodeZigZag64(this.readVarint64()));
            }
        }

        @Override
        public void readStringList(List list) throws IOException {
            this.readStringListInternal(list, false);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void readStringListInternal(List list, boolean bl) throws IOException {
            int n;
            if (WireFormat.getTagWireType(this.tag) != 2) {
                throw InvalidProtocolBufferException.invalidWireType();
            }
            if (!(list instanceof LazyStringList) || bl) {
                int n2;
                do {
                    list.add(this.readStringInternal(bl));
                    if (this.isAtEnd()) {
                        return;
                    }
                    n2 = this.pos;
                } while (this.readVarint32() == this.tag);
                this.pos = n2;
                return;
            }
            list = (LazyStringList)list;
            do {
                list.add(this.readBytes());
                if (this.isAtEnd()) {
                    return;
                }
                n = this.pos;
            } while (this.readVarint32() == this.tag);
            this.pos = n;
        }

        @Override
        public void readStringListRequireUtf8(List list) throws IOException {
            this.readStringListInternal(list, true);
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        @Override
        public void readUInt32List(List list) throws IOException {
            int n;
            block17: {
                int n2;
                block16: {
                    int n3;
                    block15: {
                        block14: {
                            if (!(list instanceof IntArrayList)) break block14;
                            list = (IntArrayList)list;
                            switch (WireFormat.getTagWireType(this.tag)) {
                                case 0: {
                                    break block15;
                                }
                                case 2: {
                                    int n4 = this.readVarint32();
                                    n4 = this.pos + n4;
                                    while (this.pos < n4) {
                                        ((IntArrayList)list).addInt(this.readVarint32());
                                    }
                                    return;
                                }
                                default: {
                                    throw InvalidProtocolBufferException.invalidWireType();
                                }
                            }
                        }
                        switch (WireFormat.getTagWireType(this.tag)) {
                            case 0: {
                                break block16;
                            }
                            case 2: {
                                n = this.readVarint32();
                                n = this.pos + n;
                                break block17;
                            }
                            default: {
                                throw InvalidProtocolBufferException.invalidWireType();
                            }
                        }
                    }
                    do {
                        ((IntArrayList)list).addInt(this.readUInt32());
                        if (this.isAtEnd()) {
                            return;
                        }
                        n3 = this.pos;
                    } while (this.readVarint32() == this.tag);
                    this.pos = n3;
                    return;
                }
                do {
                    list.add(this.readUInt32());
                    if (this.isAtEnd()) {
                        return;
                    }
                    n2 = this.pos;
                } while (this.readVarint32() == this.tag);
                this.pos = n2;
                return;
            }
            while (this.pos < n) {
                list.add(this.readVarint32());
            }
        }

        @Override
        public void readUInt64List(List list) throws IOException {
            int n;
            if (list instanceof LongArrayList) {
                list = (LongArrayList)list;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 0: {
                        int n2;
                        do {
                            ((LongArrayList)list).addLong(this.readUInt64());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n2 = this.pos;
                        } while (this.readVarint32() == this.tag);
                        this.pos = n2;
                        return;
                    }
                    case 2: {
                        int n3 = this.readVarint32();
                        n3 = this.pos + n3;
                        while (this.pos < n3) {
                            ((LongArrayList)list).addLong(this.readVarint64());
                        }
                        this.requirePosition(n3);
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 0: {
                    int n4;
                    do {
                        list.add(this.readUInt64());
                        if (this.isAtEnd()) {
                            return;
                        }
                        n4 = this.pos;
                    } while (this.readVarint32() == this.tag);
                    this.pos = n4;
                    return;
                }
                case 2: {
                    n = this.readVarint32();
                    n = this.pos + n;
                    while (this.pos < n) {
                        list.add(this.readVarint64());
                    }
                    break;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
            this.requirePosition(n);
        }

        private void requireBytes(int n) throws IOException {
            if (n < 0 || n > this.limit - this.pos) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
        }

        private void requirePosition(int n) throws IOException {
            if (this.pos != n) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
        }

        private void requireWireType(int n) throws IOException {
            if (WireFormat.getTagWireType(this.tag) != n) {
                throw InvalidProtocolBufferException.invalidWireType();
            }
        }

        private void skipBytes(int n) throws IOException {
            this.requireBytes(n);
            this.pos += n;
        }

        private void skipGroup() throws IOException {
            int n = this.endGroupTag;
            this.endGroupTag = WireFormat.makeTag(WireFormat.getTagFieldNumber(this.tag), 4);
            while (this.getFieldNumber() != Integer.MAX_VALUE && this.skipField()) {
            }
            if (this.tag != this.endGroupTag) {
                throw InvalidProtocolBufferException.parseFailure();
            }
            this.endGroupTag = n;
        }

        private void skipVarint() throws IOException {
            if (this.limit - this.pos >= 10) {
                byte[] byArray = this.buffer;
                int n = this.pos;
                for (int i = 0; i < 10; ++i) {
                    int n2 = n + 1;
                    if (byArray[n] >= 0) {
                        this.pos = n2;
                        return;
                    }
                    n = n2;
                }
            }
            this.skipVarintSlowPath();
        }

        private void skipVarintSlowPath() throws IOException {
            int n = 0;
            while (true) {
                if (n < 10) {
                    if (this.readByte() >= 0) {
                        return;
                    }
                } else {
                    throw InvalidProtocolBufferException.malformedVarint();
                }
                ++n;
            }
        }

        private void verifyPackedFixed32Length(int n) throws IOException {
            this.requireBytes(n);
            if ((n & 3) != 0) {
                throw InvalidProtocolBufferException.parseFailure();
            }
        }

        private void verifyPackedFixed64Length(int n) throws IOException {
            this.requireBytes(n);
            if ((n & 7) != 0) {
                throw InvalidProtocolBufferException.parseFailure();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isAtEnd() {
            if (this.pos != this.limit) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean readBool() throws IOException {
            this.requireWireType(0);
            if (this.readVarint32() == 0) return false;
            return true;
        }

        @Override
        public boolean skipField() throws IOException {
            if (this.isAtEnd() || this.tag == this.endGroupTag) {
                return false;
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
                case 5: {
                    this.skipBytes(4);
                    return true;
                }
                case 3: {
                    this.skipGroup();
                    return true;
                }
                case 2: {
                    this.skipBytes(this.readVarint32());
                    return true;
                }
                case 1: {
                    this.skipBytes(8);
                    return true;
                }
                case 0: 
            }
            this.skipVarint();
            return true;
        }
    }
}

