/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import libcore.io.Memory;

final class Android {
    private static boolean ASSUME_ANDROID;
    private static final Class MEMORY_CLASS;
    private static final boolean IS_ROBOLECTRIC;

    private static Class getClassForName(String object) {
        try {
            object = Class.forName((String)object);
            return object;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static Class getMemoryClass() {
        return MEMORY_CLASS;
    }

    /*
     * Enabled aggressive block sorting
     */
    static {
        Class clazz = ASSUME_ANDROID ? Memory.class : Android.getClassForName("libcore.io.Memory");
        MEMORY_CLASS = clazz;
        boolean bl = !ASSUME_ANDROID && Android.getClassForName("org.robolectric.Robolectric") != null;
        IS_ROBOLECTRIC = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isOnAndroidDevice() {
        if (ASSUME_ANDROID) return true;
        if (MEMORY_CLASS == null) return false;
        if (IS_ROBOLECTRIC) return false;
        return true;
    }
}

