/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.AbstractMessageLite;
import androidx.test.espresso.remote.internal.deps.protobuf.AbstractMutableMessageLite;
import androidx.test.espresso.remote.internal.deps.protobuf.ByteString;
import androidx.test.espresso.remote.internal.deps.protobuf.CodedInputStream;
import androidx.test.espresso.remote.internal.deps.protobuf.ExtensionRegistryLite;
import androidx.test.espresso.remote.internal.deps.protobuf.InvalidProtocolBufferException;
import androidx.test.espresso.remote.internal.deps.protobuf.MessageLite;
import androidx.test.espresso.remote.internal.deps.protobuf.Parser;
import androidx.test.espresso.remote.internal.deps.protobuf.UninitializedMessageException;

public abstract class AbstractParser
implements Parser {
    private static final ExtensionRegistryLite EMPTY_REGISTRY = ExtensionRegistryLite.getEmptyRegistry();

    private MessageLite checkMessageInitialized(MessageLite messageLite) throws InvalidProtocolBufferException {
        if (messageLite != null && !messageLite.isInitialized()) {
            throw this.newUninitializedMessageException(messageLite).asInvalidProtocolBufferException().setUnfinishedMessage(messageLite);
        }
        return messageLite;
    }

    @Override
    public MessageLite parseFrom(ByteString byteString) throws InvalidProtocolBufferException {
        return this.parseFrom(byteString, EMPTY_REGISTRY);
    }

    @Override
    public MessageLite parseFrom(ByteString byteString, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
        return this.checkMessageInitialized(this.parsePartialFrom(byteString, extensionRegistryLite));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MessageLite parsePartialFrom(ByteString object, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
        object = ((ByteString)object).newCodedInput();
        MessageLite messageLite = (MessageLite)messageLite.parsePartialFrom((CodedInputStream)object, extensionRegistryLite);
        try {
            ((CodedInputStream)object).checkLastTagWas(0);
            return messageLite;
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw invalidProtocolBufferException.setUnfinishedMessage(messageLite);
        }
    }

    private UninitializedMessageException newUninitializedMessageException(MessageLite messageLite) {
        if (messageLite instanceof AbstractMessageLite) {
            return ((AbstractMessageLite)messageLite).newUninitializedMessageException();
        }
        if (messageLite instanceof AbstractMutableMessageLite) {
            return ((AbstractMutableMessageLite)messageLite).newUninitializedMessageException();
        }
        Object object = new UninitializedMessageException(messageLite);
        return object;
    }
}

