/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.ByteString;
import androidx.test.espresso.remote.internal.deps.protobuf.CodedInputStream;
import androidx.test.espresso.remote.internal.deps.protobuf.CodedOutputStream;
import androidx.test.espresso.remote.internal.deps.protobuf.ExtensionRegistryLite;
import androidx.test.espresso.remote.internal.deps.protobuf.Internal;
import androidx.test.espresso.remote.internal.deps.protobuf.InvalidProtocolBufferException;
import androidx.test.espresso.remote.internal.deps.protobuf.LazyStringList;
import androidx.test.espresso.remote.internal.deps.protobuf.MessageLite;
import androidx.test.espresso.remote.internal.deps.protobuf.MutableMessageLite;
import androidx.test.espresso.remote.internal.deps.protobuf.PrimitiveNonBoxingCollection;
import androidx.test.espresso.remote.internal.deps.protobuf.Schema;
import androidx.test.espresso.remote.internal.deps.protobuf.UninitializedMessageException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractMessageLite<MessageType extends AbstractMessageLite<MessageType, BuilderType>, BuilderType extends Builder<MessageType, BuilderType>>
implements MessageLite {
    protected int memoizedHashCode = 0;

    int getMemoizedSerializedSize() {
        Object object = new UnsupportedOperationException();
        throw object;
    }

    /*
     * WARNING - void declaration
     */
    int getSerializedSize(Schema schema) {
        int n = this.getMemoizedSerializedSize();
        if (n == -1) {
            void var1_1;
            int n2 = var1_1.getSerializedSize(this);
            this.setMemoizedSerializedSize(n2);
            return n2;
        }
        return n;
    }

    @Override
    public ByteString toByteString() {
        Object object;
        try {
            int n = this.getSerializedSize();
            object = ByteString.newCodedBuilder(n);
            this.writeTo(((ByteString.CodedBuilder)object).getCodedOutput());
            object = ((ByteString.CodedBuilder)object).build();
        }
        catch (IOException iOException) {
            RuntimeException runtimeException = new RuntimeException(this.getSerializingExceptionMessage("ByteString"), iOException);
            throw runtimeException;
        }
        return object;
    }

    public MutableMessageLite mutableCopy() {
        Object object = new UnsupportedOperationException("mutableCopy() is not implemented.");
        throw object;
    }

    UninitializedMessageException newUninitializedMessageException() {
        UninitializedMessageException uninitializedMessageException = new UninitializedMessageException(this);
        return uninitializedMessageException;
    }

    /*
     * WARNING - void declaration
     */
    private String getSerializingExceptionMessage(String target) {
        void var1_1;
        Object this_ = this_.getClass();
        this_ = ((Class)this_).getName();
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.append("Serializing ").append((String)this_).append(" to a ").append((String)var1_1).append(" threw an IOException (should never happen).").toString();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected static <T> void addAll(Iterable<T> values, Collection<? super T> list) {
        void var1_1;
        Builder.addAll(values, (List)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected static <T> void addAll(Iterable<T> values, List<? super T> list) {
        void var1_1;
        Builder.addAll(values, var1_1);
    }

    protected static void checkByteStringIsUtf8(ByteString byteString) throws IllegalArgumentException {
        if (!byteString.isValidUtf8()) {
            Serializable serializable = new IllegalArgumentException("Byte string is not UTF-8.");
            throw serializable;
        }
    }

    void setMemoizedSerializedSize(int n) {
        Object object = new UnsupportedOperationException();
        throw object;
    }

    public void writeDelimitedTo(OutputStream output) throws IOException {
        CodedOutputStream codedOutputStream;
        int n = this.getSerializedSize();
        codedOutputStream = CodedOutputStream.newInstance((OutputStream)((Object)codedOutputStream), CodedOutputStream.computePreferredBufferSize(CodedOutputStream.computeUInt32SizeNoTag(n) + n));
        codedOutputStream.writeUInt32NoTag(n);
        this.writeTo(codedOutputStream);
        codedOutputStream.flush();
    }

    public void writeTo(OutputStream output) throws IOException {
        CodedOutputStream codedOutputStream = CodedOutputStream.newInstance(output, CodedOutputStream.computePreferredBufferSize(this.getSerializedSize()));
        this.writeTo(codedOutputStream);
        codedOutputStream.flush();
    }

    @Override
    public byte[] toByteArray() {
        byte[] byArray;
        try {
            byArray = new byte[this.getSerializedSize()];
            CodedOutputStream codedOutputStream = CodedOutputStream.newInstance(byArray);
            this.writeTo(codedOutputStream);
            codedOutputStream.checkNoSpaceLeft();
        }
        catch (IOException iOException) {
            RuntimeException runtimeException = new RuntimeException(this.getSerializingExceptionMessage("byte array"), iOException);
            throw runtimeException;
        }
        return byArray;
    }

    public static abstract class Builder<MessageType extends AbstractMessageLite<MessageType, BuilderType>, BuilderType extends Builder<MessageType, BuilderType>>
    implements MessageLite.Builder {
        public abstract BuilderType clone();

        protected abstract BuilderType internalMergeFrom(MessageType var1);

        public BuilderType mergeFrom(ByteString data) throws InvalidProtocolBufferException {
            try {
                CodedInputStream codedInputStream = data.newCodedInput();
                this.mergeFrom(codedInputStream);
                codedInputStream.checkLastTagWas(0);
            }
            catch (IOException iOException) {
                RuntimeException runtimeException = new RuntimeException(this.getReadingExceptionMessage("ByteString"), iOException);
                throw runtimeException;
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException;
            }
            return (BuilderType)this;
        }

        /*
         * WARNING - void declaration
         */
        public BuilderType mergeFrom(CodedInputStream input) throws IOException {
            void var1_1;
            return (BuilderType)this.mergeFrom((CodedInputStream)var1_1, ExtensionRegistryLite.getEmptyRegistry());
        }

        /*
         * WARNING - void declaration
         */
        public BuilderType mergeFrom(MessageLite other) {
            void var1_1;
            if (!this_.getDefaultInstanceForType().getClass().isInstance(var1_1)) {
                Object this_ = new IllegalArgumentException("mergeFrom(MessageLite) can only merge messages of the same type.");
                throw this_;
            }
            return ((Builder)this_).internalMergeFrom((AbstractMessageLite)var1_1);
        }

        public BuilderType mergeFrom(InputStream input) throws IOException {
            CodedInputStream codedInputStream = CodedInputStream.newInstance(input);
            this.mergeFrom(codedInputStream);
            codedInputStream.checkLastTagWas(0);
            return (BuilderType)this;
        }

        /*
         * WARNING - void declaration
         */
        public BuilderType mergeFrom(byte[] data) throws InvalidProtocolBufferException {
            void var1_1;
            return (BuilderType)this.mergeFrom((byte[])var1_1, 0, ((void)var1_1).length);
        }

        public BuilderType mergeFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            RuntimeException runtimeException;
            try {
                CodedInputStream codedInputStream = data.newCodedInput();
                this.mergeFrom(codedInputStream, (ExtensionRegistryLite)((Object)runtimeException));
                codedInputStream.checkLastTagWas(0);
            }
            catch (IOException iOException) {
                runtimeException = new RuntimeException(this.getReadingExceptionMessage("ByteString"), iOException);
                throw runtimeException;
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException;
            }
            return (BuilderType)this;
        }

        public abstract BuilderType mergeFrom(CodedInputStream var1, ExtensionRegistryLite var2) throws IOException;

        /*
         * WARNING - void declaration
         */
        public BuilderType mergeFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            void var2_2;
            CodedInputStream codedInputStream = CodedInputStream.newInstance(input);
            this.mergeFrom(codedInputStream, (ExtensionRegistryLite)var2_2);
            codedInputStream.checkLastTagWas(0);
            return (BuilderType)this;
        }

        /*
         * WARNING - void declaration
         */
        public BuilderType mergeFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            void var2_2;
            void var1_1;
            return (BuilderType)this.mergeFrom((byte[])var1_1, 0, ((void)var1_1).length, (ExtensionRegistryLite)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public BuilderType mergeFrom(byte[] data, int off, int len) throws InvalidProtocolBufferException {
            try {
                void var3_6;
                void var2_4;
                CodedInputStream codedInputStream = CodedInputStream.newInstance(data, (int)var2_4, (int)var3_6);
                this.mergeFrom(codedInputStream);
                codedInputStream.checkLastTagWas(0);
            }
            catch (IOException iOException) {
                RuntimeException runtimeException = new RuntimeException(this.getReadingExceptionMessage("byte array"), iOException);
                throw runtimeException;
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException;
            }
            return (BuilderType)this;
        }

        /*
         * WARNING - void declaration
         */
        public BuilderType mergeFrom(byte[] data, int off, int len, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            try {
                void var4_7;
                void var3_6;
                void var2_4;
                CodedInputStream codedInputStream = CodedInputStream.newInstance(data, (int)var2_4, (int)var3_6);
                this.mergeFrom(codedInputStream, (ExtensionRegistryLite)var4_7);
                codedInputStream.checkLastTagWas(0);
            }
            catch (IOException iOException) {
                RuntimeException runtimeException = new RuntimeException(this.getReadingExceptionMessage("byte array"), iOException);
                throw runtimeException;
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException;
            }
            return (BuilderType)this;
        }

        protected static UninitializedMessageException newUninitializedMessageException(MessageLite message) {
            MessageLite messageLite;
            UninitializedMessageException uninitializedMessageException = new UninitializedMessageException(messageLite);
            return uninitializedMessageException;
        }

        /*
         * WARNING - void declaration
         */
        private String getReadingExceptionMessage(String target) {
            void var1_1;
            Object this_ = this_.getClass();
            this_ = ((Class)this_).getName();
            StringBuilder stringBuilder = new StringBuilder();
            return stringBuilder.append("Reading ").append((String)this_).append(" from a ").append((String)var1_1).append(" threw an IOException (should never happen).").toString();
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        protected static <T> void addAll(Iterable<T> values, Collection<? super T> list) {
            void var1_1;
            Builder.addAll(values, (List)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        protected static <T> void addAll(Iterable<T> values, List<? super T> list) {
            void var1_3;
            Object object;
            block7: {
                Object object2;
                block6: {
                    Internal.checkNotNull(values);
                    if (object instanceof LazyStringList) {
                        object = (LazyStringList)object;
                        object = object.getUnderlyingElements();
                        LazyStringList lazyStringList = (LazyStringList)var1_3;
                        int n = var1_3.size();
                        object = object.iterator();
                        while (object.hasNext()) {
                            object2 = object.next();
                            if (object2 == null) {
                                int n2 = lazyStringList.size();
                                object2 = new StringBuilder();
                                object2 = ((StringBuilder)object2).append("Element at index ").append(n2 - n).append(" is null.").toString();
                                for (n2 = lazyStringList.size() + -1; n2 >= n; --n2) {
                                    lazyStringList.remove(n2);
                                }
                                break block6;
                            }
                            if (object2 instanceof ByteString) {
                                lazyStringList.add((ByteString)object2);
                                continue;
                            }
                            lazyStringList.add((String)object2);
                        }
                        return;
                    }
                    if (object instanceof PrimitiveNonBoxingCollection) {
                        var1_3.addAll((Collection)object);
                        return;
                    }
                    break block7;
                }
                NullPointerException nullPointerException = new NullPointerException((String)object2);
                throw nullPointerException;
            }
            Builder.addAllCheckingNulls(object, var1_3);
        }

        /*
         * WARNING - void declaration
         */
        private static <T> void addAllCheckingNulls(Iterable<T> values, List<? super T> list) {
            void var1_3;
            Iterator<T> iterator;
            if (list instanceof ArrayList && iterator instanceof Collection) {
                ((ArrayList)var1_3).ensureCapacity(var1_3.size() + ((Collection)((Object)iterator)).size());
            }
            int n = var1_3.size();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (object == null) {
                    int n2 = var1_3.size();
                    object = new StringBuilder();
                    object = ((StringBuilder)object).append("Element at index ").append(n2 - n).append(" is null.").toString();
                    for (n2 = var1_3.size() + -1; n2 >= n; --n2) {
                        var1_3.remove(n2);
                    }
                } else {
                    var1_3.add(object);
                    continue;
                }
                NullPointerException nullPointerException = new NullPointerException((String)object);
                throw nullPointerException;
            }
        }

        /*
         * WARNING - void declaration
         */
        public boolean mergeDelimitedFrom(InputStream input) throws IOException {
            void var1_1;
            return this.mergeDelimitedFrom((InputStream)var1_1, ExtensionRegistryLite.getEmptyRegistry());
        }

        /*
         * WARNING - void declaration
         */
        public boolean mergeDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            void var2_2;
            void var1_1;
            int n = input.read();
            if (n == -1) {
                return false;
            }
            n = CodedInputStream.readRawVarint32(n, (InputStream)var1_1);
            LimitedInputStream limitedInputStream = new LimitedInputStream((InputStream)var1_1, n);
            this.mergeFrom(limitedInputStream, (ExtensionRegistryLite)var2_2);
            return true;
        }

        static final class LimitedInputStream
        extends FilterInputStream {
            private int limit;

            @Override
            public int available() throws IOException {
                return Math.min(super.available(), this.limit);
            }

            @Override
            public int read() throws IOException {
                if (this.limit <= 0) {
                    return -1;
                }
                int n = super.read();
                if (n >= 0) {
                    this.limit += -1;
                }
                return n;
            }

            @Override
            public int read(byte[] byArray, int n, int n2) throws IOException {
                if (this.limit <= 0) {
                    return -1;
                }
                int n3 = super.read(byArray, n, Math.min(n2, this.limit));
                if (n3 >= 0) {
                    this.limit -= n3;
                }
                return n3;
            }

            @Override
            public long skip(long l) throws IOException {
                int n = (int)super.skip(Math.min(l, (long)this.limit));
                if (n >= 0) {
                    this.limit -= n;
                }
                return n;
            }

            LimitedInputStream(InputStream inputStream, int n) {
                super(inputStream);
                this.limit = n;
            }
        }
    }
}

