/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.guava.util.concurrent;

import androidx.test.espresso.remote.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.remote.internal.deps.guava.util.concurrent.FluentFuture;
import androidx.test.espresso.remote.internal.deps.guava.util.concurrent.InterruptibleTask;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.RunnableFuture;

class TrustedListenableFutureTask
extends FluentFuture.TrustedFuture
implements RunnableFuture {
    private volatile InterruptibleTask task;

    static TrustedListenableFutureTask create(Callable callable) {
        TrustedListenableFutureTask trustedListenableFutureTask = new TrustedListenableFutureTask(callable);
        return trustedListenableFutureTask;
    }

    static TrustedListenableFutureTask create(Runnable runnable, Object object) {
        TrustedListenableFutureTask trustedListenableFutureTask = new TrustedListenableFutureTask(Executors.callable(runnable, object));
        return trustedListenableFutureTask;
    }

    @Override
    protected String pendingToString() {
        InterruptibleTask interruptibleTask = ((TrustedListenableFutureTask)object).task;
        if (interruptibleTask != null) {
            Object object = new StringBuilder();
            return ((StringBuilder)object).append("task=[").append(interruptibleTask).append("]").toString();
        }
        return super.pendingToString();
    }

    TrustedListenableFutureTask(Callable callable) {
        TrustedFutureInterruptibleTask trustedFutureInterruptibleTask = new TrustedFutureInterruptibleTask(callable);
        this.task = trustedFutureInterruptibleTask;
    }

    @Override
    protected void afterDone() {
        InterruptibleTask interruptibleTask;
        super.afterDone();
        if (this.wasInterrupted() && (interruptibleTask = this.task) != null) {
            interruptibleTask.interruptTask();
        }
        this.task = null;
    }

    @Override
    public void run() {
        InterruptibleTask interruptibleTask = this.task;
        if (interruptibleTask != null) {
            interruptibleTask.run();
        }
        this.task = null;
    }

    private final class TrustedFutureInterruptibleTask
    extends InterruptibleTask {
        private final Callable callable;

        @Override
        Object runInterruptibly() throws Exception {
            return this.callable.call();
        }

        @Override
        String toPendingString() {
            return this.callable.toString();
        }

        TrustedFutureInterruptibleTask(Callable callable) {
            this.callable = (Callable)Preconditions.checkNotNull(callable);
        }

        @Override
        void afterRanInterruptiblyFailure(Throwable throwable) {
            TrustedListenableFutureTask.this.setException(throwable);
        }

        @Override
        void afterRanInterruptiblySuccess(Object object) {
            TrustedListenableFutureTask.this.set(object);
        }

        @Override
        final boolean isDone() {
            return TrustedListenableFutureTask.this.isDone();
        }
    }
}

