/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.guava.util.concurrent;

import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public final class ThreadFactoryBuilder {
    private String nameFormat = null;
    private Boolean daemon = null;
    private Integer priority = null;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler = null;
    private ThreadFactory backingThreadFactory = null;

    public ThreadFactoryBuilder setNameFormat(String string) {
        Object[] objectArray = new Object[]{0};
        ThreadFactoryBuilder.format(string, objectArray);
        this.nameFormat = string;
        return this;
    }

    private static String format(String string, Object ... objectArray) {
        return String.format(Locale.ROOT, string, objectArray);
    }

    public ThreadFactory build() {
        return ThreadFactoryBuilder.doBuild(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static ThreadFactory doBuild(ThreadFactoryBuilder object) {
        String string = ((ThreadFactoryBuilder)object).nameFormat;
        Boolean bl = ((ThreadFactoryBuilder)object).daemon;
        Integer n = ((ThreadFactoryBuilder)object).priority;
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = ((ThreadFactoryBuilder)object).uncaughtExceptionHandler;
        object = ((ThreadFactoryBuilder)object).backingThreadFactory != null ? ((ThreadFactoryBuilder)object).backingThreadFactory : Executors.defaultThreadFactory();
        AtomicLong atomicLong = string != null ? new AtomicLong(0L) : null;
        return new ThreadFactory((ThreadFactory)object, string, atomicLong, bl, n, uncaughtExceptionHandler){
            final /* synthetic */ ThreadFactory val$backingThreadFactory;
            final /* synthetic */ String val$nameFormat;
            final /* synthetic */ AtomicLong val$count;
            final /* synthetic */ Boolean val$daemon;
            final /* synthetic */ Integer val$priority;
            final /* synthetic */ Thread.UncaughtExceptionHandler val$uncaughtExceptionHandler;

            @Override
            public Thread newThread(Runnable runnable) {
                runnable = this.val$backingThreadFactory.newThread(runnable);
                if (this.val$nameFormat != null) {
                    String string = this.val$nameFormat;
                    Object[] objectArray = new Object[1];
                    AtomicLong atomicLong = this.val$count;
                    atomicLong.getClass();
                    objectArray[0] = atomicLong.getAndIncrement();
                    ((Thread)runnable).setName(ThreadFactoryBuilder.format(string, objectArray));
                }
                if (this.val$daemon != null) {
                    ((Thread)runnable).setDaemon(this.val$daemon);
                }
                if (this.val$priority != null) {
                    ((Thread)runnable).setPriority(this.val$priority);
                }
                if (this.val$uncaughtExceptionHandler != null) {
                    ((Thread)runnable).setUncaughtExceptionHandler(this.val$uncaughtExceptionHandler);
                }
                return runnable;
            }
            {
                this.val$backingThreadFactory = threadFactory;
                this.val$nameFormat = string;
                this.val$count = atomicLong;
                this.val$daemon = bl;
                this.val$priority = n;
                this.val$uncaughtExceptionHandler = uncaughtExceptionHandler;
            }
        };
    }
}

