/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.guava.util.concurrent;

import androidx.test.espresso.remote.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.remote.internal.deps.guava.util.concurrent.AbstractFuture;
import androidx.test.espresso.remote.internal.deps.guava.util.concurrent.AbstractListeningExecutorService;
import androidx.test.espresso.remote.internal.deps.guava.util.concurrent.DirectExecutor;
import androidx.test.espresso.remote.internal.deps.guava.util.concurrent.ForwardingListenableFuture;
import androidx.test.espresso.remote.internal.deps.guava.util.concurrent.ListenableFuture;
import androidx.test.espresso.remote.internal.deps.guava.util.concurrent.ListenableScheduledFuture;
import androidx.test.espresso.remote.internal.deps.guava.util.concurrent.ListeningExecutorService;
import androidx.test.espresso.remote.internal.deps.guava.util.concurrent.TrustedListenableFutureTask;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class MoreExecutors {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ListeningExecutorService listeningDecorator(ExecutorService executorService) {
        if (executorService instanceof ListeningExecutorService) {
            return (ListeningExecutorService)executorService;
        }
        if (executorService instanceof ScheduledExecutorService) {
            ScheduledListeningDecorator scheduledListeningDecorator = new ScheduledListeningDecorator((ScheduledExecutorService)executorService);
            return scheduledListeningDecorator;
        }
        ListeningDecorator listeningDecorator = new ListeningDecorator(executorService);
        return listeningDecorator;
    }

    public static Executor directExecutor() {
        return DirectExecutor.INSTANCE;
    }

    static Executor rejectionPropagatingExecutor(final Executor executor, final AbstractFuture abstractFuture) {
        Preconditions.checkNotNull(executor);
        Preconditions.checkNotNull(abstractFuture);
        if (executor == MoreExecutors.directExecutor()) {
            return executor;
        }
        Executor executor2 = new Executor(){

            @Override
            public void execute(Runnable runnable) {
                try {
                    executor.execute(runnable);
                    return;
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    abstractFuture.setException(rejectedExecutionException);
                    return;
                }
            }
        };
        return executor2;
    }

    private static final class ScheduledListeningDecorator
    extends ListeningDecorator
    implements ScheduledExecutorService,
    ListeningExecutorService {
        final ScheduledExecutorService delegate;

        public ListenableScheduledFuture schedule(Runnable runnable, long l, TimeUnit object) {
            runnable = TrustedListenableFutureTask.create(runnable, null);
            Object object2 = ((ScheduledListeningDecorator)object2).delegate;
            object2 = object2.schedule(runnable, l, (TimeUnit)((Object)object));
            object = new ListenableScheduledTask((ListenableFuture)((Object)runnable), (ScheduledFuture)object2);
            return object;
        }

        public ListenableScheduledFuture schedule(Callable object, long l, TimeUnit object2) {
            object = TrustedListenableFutureTask.create((Callable)object);
            Object object3 = ((ScheduledListeningDecorator)object3).delegate;
            object3 = object3.schedule((Runnable)object, l, (TimeUnit)((Object)object2));
            object2 = new ListenableScheduledTask((ListenableFuture)object, (ScheduledFuture)object3);
            return object2;
        }

        public ListenableScheduledFuture scheduleAtFixedRate(Runnable object, long l, long l2, TimeUnit timeUnit) {
            NeverSuccessfulListenableFutureTask neverSuccessfulListenableFutureTask = new NeverSuccessfulListenableFutureTask((Runnable)object);
            Object object2 = ((ScheduledListeningDecorator)object2).delegate;
            object2 = object2.scheduleAtFixedRate(neverSuccessfulListenableFutureTask, l, l2, timeUnit);
            object = new ListenableScheduledTask(neverSuccessfulListenableFutureTask, (ScheduledFuture)object2);
            return object;
        }

        public ListenableScheduledFuture scheduleWithFixedDelay(Runnable object, long l, long l2, TimeUnit timeUnit) {
            NeverSuccessfulListenableFutureTask neverSuccessfulListenableFutureTask = new NeverSuccessfulListenableFutureTask((Runnable)object);
            Object object2 = ((ScheduledListeningDecorator)object2).delegate;
            object2 = object2.scheduleWithFixedDelay(neverSuccessfulListenableFutureTask, l, l2, timeUnit);
            object = new ListenableScheduledTask(neverSuccessfulListenableFutureTask, (ScheduledFuture)object2);
            return object;
        }

        ScheduledListeningDecorator(ScheduledExecutorService scheduledExecutorService) {
            super(scheduledExecutorService);
            this.delegate = (ScheduledExecutorService)Preconditions.checkNotNull(scheduledExecutorService);
        }

        private static final class ListenableScheduledTask
        extends ForwardingListenableFuture.SimpleForwardingListenableFuture
        implements ListenableScheduledFuture {
            private final ScheduledFuture scheduledDelegate;

            @Override
            public int compareTo(Delayed delayed) {
                return this.scheduledDelegate.compareTo(delayed);
            }

            @Override
            public long getDelay(TimeUnit timeUnit) {
                return this.scheduledDelegate.getDelay(timeUnit);
            }

            public ListenableScheduledTask(ListenableFuture listenableFuture, ScheduledFuture scheduledFuture) {
                super(listenableFuture);
                this.scheduledDelegate = scheduledFuture;
            }

            @Override
            public boolean cancel(boolean bl) {
                boolean bl2 = super.cancel(bl);
                if (bl2) {
                    this.scheduledDelegate.cancel(bl);
                }
                return bl2;
            }
        }

        private static final class NeverSuccessfulListenableFutureTask
        extends AbstractFuture.TrustedFuture
        implements Runnable {
            private final Runnable delegate;

            @Override
            protected String pendingToString() {
                StringBuilder stringBuilder = new StringBuilder();
                return stringBuilder.append("task=[").append(this.delegate).append("]").toString();
            }

            public NeverSuccessfulListenableFutureTask(Runnable runnable) {
                this.delegate = (Runnable)Preconditions.checkNotNull(runnable);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    this.delegate.run();
                    return;
                }
                catch (Error | RuntimeException throwable) {
                    this.setException(throwable);
                    throw throwable;
                }
            }
        }
    }

    private static class ListeningDecorator
    extends AbstractListeningExecutorService {
        private final ExecutorService delegate;

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            return stringBuilder.append(super.toString()).append("[").append(this.delegate).append("]").toString();
        }

        public final List shutdownNow() {
            return this.delegate.shutdownNow();
        }

        ListeningDecorator(ExecutorService executorService) {
            this.delegate = (ExecutorService)Preconditions.checkNotNull(executorService);
        }

        @Override
        public final void execute(Runnable runnable) {
            this.delegate.execute(runnable);
        }

        @Override
        public final void shutdown() {
            this.delegate.shutdown();
        }

        @Override
        public final boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
            return this.delegate.awaitTermination(l, timeUnit);
        }

        @Override
        public final boolean isShutdown() {
            return this.delegate.isShutdown();
        }

        @Override
        public final boolean isTerminated() {
            return this.delegate.isTerminated();
        }
    }
}

