/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.guava.util.concurrent;

import androidx.test.espresso.remote.internal.deps.guava.util.concurrent.NullnessCasts;
import androidx.test.espresso.remote.internal.deps.guava.util.concurrent.Platform;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.AbstractOwnableSynchronizer;
import java.util.concurrent.locks.LockSupport;

abstract class InterruptibleTask
extends AtomicReference
implements Runnable {
    private static final Runnable DONE;
    private static final Runnable PARKED;

    abstract Object runInterruptibly() throws Exception;

    abstract String toPendingString();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final String toString() {
        StringBuilder stringBuilder;
        Object object = (Runnable)this.get();
        if (object == DONE) {
            object = "running=[DONE]";
        } else if (object instanceof Blocker) {
            object = "running=[INTERRUPTED]";
        } else if (object instanceof Thread) {
            stringBuilder = new StringBuilder();
            object = stringBuilder.append("running=[RUNNING ON ").append(((Thread)object).getName()).append("]").toString();
        } else {
            object = "running=[NOT STARTED YET]";
        }
        stringBuilder = new StringBuilder();
        return stringBuilder.append((String)object).append(", ").append(this.toPendingString()).toString();
    }

    static {
        DoNothingRunnable doNothingRunnable = new DoNothingRunnable();
        DONE = doNothingRunnable;
        doNothingRunnable = new DoNothingRunnable();
        PARKED = doNothingRunnable;
    }

    InterruptibleTask() {
    }

    abstract void afterRanInterruptiblyFailure(Throwable var1);

    abstract void afterRanInterruptiblySuccess(Object var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void interruptTask() {
        Runnable runnable = (Runnable)this.get();
        if (!(runnable instanceof Thread)) return;
        Blocker blocker = new Blocker(this);
        blocker.setOwner(Thread.currentThread());
        if (!this.compareAndSet(runnable, blocker)) return;
        try {
            ((Thread)runnable).interrupt();
        }
        catch (Throwable throwable) {
            if (this.getAndSet(DONE) != PARKED) {
                throw throwable;
            }
            LockSupport.unpark((Thread)runnable);
            throw throwable;
        }
        if (this.getAndSet(DONE) != PARKED) return;
        LockSupport.unpark((Thread)runnable);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void run() {
        Object object;
        Thread thread = Thread.currentThread();
        if (!this.compareAndSet(null, thread)) {
            return;
        }
        boolean bl = !this.isDone();
        if (bl) {
            object = this.runInterruptibly();
        } else {
            object = null;
        }
        if (!this.compareAndSet(thread, DONE)) {
            this.waitForInterrupt(thread);
        }
        if (!bl) return;
        this.afterRanInterruptiblySuccess(NullnessCasts.uncheckedCastNullableTToT(object));
        return;
        catch (Throwable throwable) {
            try {
                Platform.restoreInterruptIfIsInterruptedException(throwable);
            }
            catch (Throwable throwable2) {
                if (!this.compareAndSet(thread, DONE)) {
                    this.waitForInterrupt(thread);
                }
                if (!bl) {
                    throw throwable2;
                }
                this.afterRanInterruptiblySuccess(NullnessCasts.uncheckedCastNullableTToT(null));
                throw throwable2;
            }
            if (!this.compareAndSet(thread, DONE)) {
                this.waitForInterrupt(thread);
            }
            if (!bl) return;
            this.afterRanInterruptiblyFailure(throwable);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void waitForInterrupt(Thread thread) {
        Runnable runnable = (Runnable)this.get();
        boolean bl = false;
        int n = 0;
        Blocker blocker = null;
        while (runnable instanceof Blocker || runnable == PARKED) {
            if (runnable instanceof Blocker) {
                blocker = (Blocker)runnable;
            }
            if (++n > 1000) {
                if (runnable == PARKED || this.compareAndSet(runnable, PARKED)) {
                    bl = Thread.interrupted() || bl;
                    LockSupport.park(blocker);
                }
            } else {
                Thread.yield();
            }
            runnable = (Runnable)this.get();
        }
        if (bl) {
            thread.interrupt();
            return;
        }
    }

    abstract boolean isDone();

    static final class Blocker
    extends AbstractOwnableSynchronizer
    implements Runnable {
        private final InterruptibleTask task;

        public String toString() {
            return this.task.toString();
        }

        private Blocker(InterruptibleTask interruptibleTask) {
            this.task = interruptibleTask;
        }

        @Override
        public void run() {
        }

        private void setOwner(Thread thread) {
            super.setExclusiveOwnerThread(thread);
        }
    }

    private static final class DoNothingRunnable
    implements Runnable {
        private DoNothingRunnable() {
        }

        @Override
        public void run() {
        }
    }
}

