/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.guava.util.concurrent;

import androidx.test.espresso.remote.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.remote.internal.deps.guava.util.concurrent.AbstractFuture;
import androidx.test.espresso.remote.internal.deps.guava.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

class ImmediateFuture<V>
implements ListenableFuture<V> {
    static final ListenableFuture NULL;
    private static final Logger log;
    private final Object value;

    @Override
    public V get() {
        return (V)this.value;
    }

    @Override
    public V get(long l, TimeUnit timeUnit) throws ExecutionException {
        Preconditions.checkNotNull((Object)timeUnit);
        return this.get();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.append(super.toString()).append("[status=SUCCESS, result=[").append(this.value).append("]]").toString();
    }

    static {
        ImmediateFuture immediateFuture;
        NULL = immediateFuture = new ImmediateFuture(null);
        log = Logger.getLogger(ImmediateFuture.class.getName());
    }

    ImmediateFuture(Object object) {
        this.value = object;
    }

    @Override
    public void addListener(Runnable runnable, Executor executor) {
        Preconditions.checkNotNull(runnable, "Runnable was null.");
        Preconditions.checkNotNull(executor, "Executor was null.");
        try {
            executor.execute(runnable);
            return;
        }
        catch (RuntimeException runtimeException) {
            Logger logger = log;
            Level level = Level.SEVERE;
            StringBuilder stringBuilder = new StringBuilder();
            logger.logp(level, "androidx.test.espresso.remote.internal.deps.guava.util.concurrent.ImmediateFuture", "addListener", stringBuilder.append("RuntimeException while executing runnable ").append(runnable).append(" with executor ").append(executor).toString(), runtimeException);
            return;
        }
    }

    @Override
    public boolean cancel(boolean bl) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    static final class ImmediateFailedFuture
    extends AbstractFuture.TrustedFuture {
        ImmediateFailedFuture(Throwable throwable) {
            this.setException(throwable);
        }
    }
}

