/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.guava.util.concurrent;

import androidx.test.espresso.remote.internal.deps.guava.base.Function;
import androidx.test.espresso.remote.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.remote.internal.deps.guava.util.concurrent.AbstractTransformFuture;
import androidx.test.espresso.remote.internal.deps.guava.util.concurrent.AsyncFunction;
import androidx.test.espresso.remote.internal.deps.guava.util.concurrent.GwtFuturesCatchingSpecialization;
import androidx.test.espresso.remote.internal.deps.guava.util.concurrent.ImmediateFuture;
import androidx.test.espresso.remote.internal.deps.guava.util.concurrent.ListenableFuture;
import androidx.test.espresso.remote.internal.deps.guava.util.concurrent.Uninterruptibles;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;

public final class Futures
extends GwtFuturesCatchingSpecialization {
    public static ListenableFuture immediateFailedFuture(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        ImmediateFuture.ImmediateFailedFuture immediateFailedFuture = new ImmediateFuture.ImmediateFailedFuture(throwable);
        return immediateFailedFuture;
    }

    public static ListenableFuture immediateFuture(Object object) {
        if (object == null) {
            return ImmediateFuture.NULL;
        }
        ImmediateFuture immediateFuture = new ImmediateFuture(object);
        return immediateFuture;
    }

    public static ListenableFuture transform(ListenableFuture listenableFuture, Function function, Executor executor) {
        return AbstractTransformFuture.create(listenableFuture, function, executor);
    }

    public static ListenableFuture transformAsync(ListenableFuture listenableFuture, AsyncFunction asyncFunction, Executor executor) {
        return AbstractTransformFuture.create(listenableFuture, asyncFunction, executor);
    }

    public static Object getDone(Future future) throws ExecutionException {
        Preconditions.checkState(future.isDone(), "Future was expected to be done: %s", future);
        return Uninterruptibles.getUninterruptibly(future);
    }
}

