/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.guava.io;

import androidx.test.espresso.remote.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.remote.internal.deps.guava.math.IntMath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;

public final class ByteStreams {
    private static final OutputStream NULL_OUTPUT_STREAM;

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        Preconditions.checkNotNull(inputStream);
        Preconditions.checkNotNull(outputStream);
        byte[] byArray = ByteStreams.createBuffer();
        long l = 0L;
        int n;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    static {
        OutputStream outputStream;
        NULL_OUTPUT_STREAM = outputStream = new OutputStream(){

            public String toString() {
                return "ByteStreams.nullOutputStream()";
            }

            @Override
            public void write(int n) {
            }

            @Override
            public void write(byte[] byArray) {
                Preconditions.checkNotNull(byArray);
            }

            @Override
            public void write(byte[] byArray, int n, int n2) {
                Preconditions.checkNotNull(byArray);
                Preconditions.checkPositionIndexes(n, n + n2, byArray.length);
            }
        };
    }

    private static byte[] combineBuffers(Queue queue, int n) {
        int n2;
        if (queue.isEmpty()) {
            return new byte[0];
        }
        byte[] byArray = (byte[])queue.remove();
        if (byArray.length == n) {
            return byArray;
        }
        int n3 = n - byArray.length;
        byte[] byArray2 = Arrays.copyOf(byArray, n);
        for (int i = n3; i > 0; i -= n2) {
            byte[] byArray3 = (byte[])queue.remove();
            n2 = Math.min(i, byArray3.length);
            System.arraycopy(byArray3, 0, byArray2, n - i, n2);
        }
        return byArray2;
    }

    static byte[] createBuffer() {
        return new byte[8192];
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        Preconditions.checkNotNull(inputStream);
        ArrayDeque arrayDeque = new ArrayDeque(20);
        return ByteStreams.toByteArrayInternal(inputStream, arrayDeque, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static byte[] toByteArrayInternal(InputStream object, Queue queue, int n) throws IOException {
        int n2 = Integer.highestOneBit(n);
        n2 = Math.min(8192, Math.max(128, n2 + n2));
        while (true) {
            int n3;
            int n4;
            byte[] byArray;
            if (n < 0x7FFFFFF7) {
                byArray = new byte[Math.min(n2, 0x7FFFFFF7 - n)];
                queue.add(byArray);
            } else {
                if (((InputStream)object).read() != -1) {
                    object = new OutOfMemoryError("input is too large to fit in a byte array");
                    throw object;
                }
                return ByteStreams.combineBuffers(queue, 0x7FFFFFF7);
            }
            for (n3 = 0; n3 < byArray.length; n3 += n4, n += n4) {
                n4 = ((InputStream)object).read(byArray, n3, byArray.length - n3);
                if (n4 != -1) continue;
                return ByteStreams.combineBuffers(queue, n);
            }
            n3 = n2 < 4096 ? 4 : 2;
            n2 = IntMath.saturatedMultiply(n2, n3);
        }
    }
}

