/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.guava.collect;

import androidx.test.espresso.remote.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.remote.internal.deps.guava.collect.CollectPreconditions;
import androidx.test.espresso.remote.internal.deps.guava.collect.Hashing;
import androidx.test.espresso.remote.internal.deps.guava.collect.ImmutableCollection;
import androidx.test.espresso.remote.internal.deps.guava.collect.ImmutableList;
import androidx.test.espresso.remote.internal.deps.guava.collect.ImmutableMap;
import androidx.test.espresso.remote.internal.deps.guava.collect.ImmutableSet;
import androidx.test.espresso.remote.internal.deps.guava.collect.UnmodifiableIterator;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;

final class RegularImmutableMap<K, V>
extends ImmutableMap<K, V> {
    static final ImmutableMap EMPTY;
    private static final long serialVersionUID = 0L;
    private final transient Object hashTable;
    final transient Object[] alternatingKeysAndValues;
    private final transient int size;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    ImmutableCollection createValues() {
        KeysOrValuesAsList keysOrValuesAsList = new KeysOrValuesAsList(this.alternatingKeysAndValues, 1, this.size);
        return keysOrValuesAsList;
    }

    @Override
    ImmutableSet createEntrySet() {
        EntrySet entrySet = new EntrySet(this, this.alternatingKeysAndValues, 0, this.size);
        return entrySet;
    }

    @Override
    ImmutableSet createKeySet() {
        KeysOrValuesAsList keysOrValuesAsList = new KeysOrValuesAsList(this.alternatingKeysAndValues, 0, this.size);
        KeySet keySet = new KeySet(this, keysOrValuesAsList);
        return keySet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static RegularImmutableMap create(int n, Object[] objectArray, ImmutableMap.Builder objectArray2) {
        Object[] objectArray3;
        if (n == 0) {
            return (RegularImmutableMap)EMPTY;
        }
        if (n == 1) {
            RegularImmutableMap regularImmutableMap = objectArray[0];
            regularImmutableMap.getClass();
            objectArray3 = objectArray[1];
            objectArray3.getClass();
            CollectPreconditions.checkEntryNotNull(regularImmutableMap, objectArray3);
            return new RegularImmutableMap(null, objectArray, 1);
        }
        Preconditions.checkPositionIndex(n, objectArray.length >> 1);
        Object object = RegularImmutableMap.createHashTable(objectArray, n, ImmutableSet.chooseTableSize(n), 0);
        if (object instanceof Object[]) {
            Object[] objectArray4 = (Object[])object;
            object = (ImmutableMap.Builder.DuplicateKey)objectArray4[2];
            if (objectArray3 == null) {
                throw ((ImmutableMap.Builder.DuplicateKey)object).exception();
            }
            objectArray3.duplicateKey = object;
            object = objectArray4[0];
            n = (Integer)objectArray4[1];
            objectArray3 = Arrays.copyOf(objectArray, n + n);
            return new RegularImmutableMap(object, objectArray3, n);
        }
        objectArray3 = objectArray;
        return new RegularImmutableMap(object, objectArray3, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Object createHashTable(Object[] object, int n, int n2, int n3) {
        int n4;
        block27: {
            block26: {
                block25: {
                    if (n == 1) {
                        Object object2 = object[n3];
                        object2.getClass();
                        object = object[n3 ^ 1];
                        object.getClass();
                        CollectPreconditions.checkEntryNotNull(object2, object);
                        return null;
                    }
                    n4 = n2 + -1;
                    if (n2 <= 128) break block25;
                    if (n2 <= 32768) break block26;
                    break block27;
                }
                byte[] byArray = new byte[n2];
                Arrays.fill(byArray, (byte)-1);
                ImmutableMap.Builder.DuplicateKey duplicateKey = null;
                int n5 = 0;
                int n6 = 0;
                block0: while (true) {
                    if (n6 >= n) {
                        if (n5 == n) {
                            return byArray;
                        }
                        object = new Object[]{byArray, n5, duplicateKey};
                        return object;
                    }
                    int n7 = n6 + n6 + n3;
                    int n8 = n5 + n5 + n3;
                    Object object3 = object[n7];
                    object3.getClass();
                    Object object4 = object[n7 ^ 1];
                    object4.getClass();
                    CollectPreconditions.checkEntryNotNull(object3, object4);
                    n7 = Hashing.smear(object3.hashCode());
                    while (true) {
                        block30: {
                            block29: {
                                int n9;
                                block28: {
                                    if ((n9 = byArray[n7 &= n4] & 0xFF) != 255) break block28;
                                    byArray[n7] = (byte)n8;
                                    if (n5 < n6) {
                                        object[n8] = object3;
                                        object[n8 ^ 1] = object4;
                                    }
                                    n7 = n5 + 1;
                                    break block29;
                                }
                                if (!object3.equals(object[n9])) break block30;
                                Object object5 = object[n9 ^ 1];
                                object5.getClass();
                                duplicateKey = new ImmutableMap.Builder.DuplicateKey(object3, object4, object5);
                                object[n9 ^ 1] = object4;
                                n7 = n5;
                            }
                            ++n6;
                            n5 = n7;
                            continue block0;
                        }
                        ++n7;
                    }
                    break;
                }
            }
            short[] sArray = new short[n2];
            Arrays.fill(sArray, (short)-1);
            ImmutableMap.Builder.DuplicateKey duplicateKey = null;
            int n10 = 0;
            int n11 = 0;
            block2: while (true) {
                if (n11 >= n) {
                    if (n10 == n) {
                        return sArray;
                    }
                    object = new Object[]{sArray, n10, duplicateKey};
                    return object;
                }
                int n12 = n11 + n11 + n3;
                int n13 = n10 + n10 + n3;
                Object object6 = object[n12];
                object6.getClass();
                Object object7 = object[n12 ^ 1];
                object7.getClass();
                CollectPreconditions.checkEntryNotNull(object6, object7);
                n12 = Hashing.smear(object6.hashCode());
                while (true) {
                    block33: {
                        block32: {
                            char c;
                            block31: {
                                if ((c = (char)sArray[n12 &= n4]) != '\uffff') break block31;
                                sArray[n12] = (short)n13;
                                if (n10 < n11) {
                                    object[n13] = object6;
                                    object[n13 ^ 1] = object7;
                                }
                                n12 = n10 + 1;
                                break block32;
                            }
                            if (!object6.equals(object[c])) break block33;
                            Object object8 = object[c ^ '\u0001'];
                            object8.getClass();
                            duplicateKey = new ImmutableMap.Builder.DuplicateKey(object6, object7, object8);
                            object[c ^ '\u0001'] = object7;
                            n12 = n10;
                        }
                        ++n11;
                        n10 = n12;
                        continue block2;
                    }
                    ++n12;
                }
                break;
            }
        }
        int[] nArray = new int[n2];
        Arrays.fill(nArray, -1);
        ImmutableMap.Builder.DuplicateKey duplicateKey = null;
        int n14 = 0;
        int n15 = 0;
        block4: while (true) {
            if (n15 >= n) {
                if (n14 == n) {
                    return nArray;
                }
                object = new Object[]{nArray, n14, duplicateKey};
                return object;
            }
            int n16 = n15 + n15 + n3;
            int n17 = n14 + n14 + n3;
            Object object9 = object[n16];
            object9.getClass();
            Object object10 = object[n16 ^ 1];
            object10.getClass();
            CollectPreconditions.checkEntryNotNull(object9, object10);
            n16 = Hashing.smear(object9.hashCode());
            while (true) {
                block36: {
                    block35: {
                        int n18;
                        block34: {
                            if ((n18 = nArray[n16 &= n4]) != -1) break block34;
                            nArray[n16] = n17;
                            if (n14 < n15) {
                                object[n17] = object9;
                                object[n17 ^ 1] = object10;
                            }
                            n16 = n14 + 1;
                            break block35;
                        }
                        if (!object9.equals(object[n18])) break block36;
                        Object object11 = object[n18 ^ 1];
                        object11.getClass();
                        duplicateKey = new ImmutableMap.Builder.DuplicateKey(object9, object10, object11);
                        object[n18 ^ 1] = object10;
                        n16 = n14;
                    }
                    ++n15;
                    n14 = n16;
                    continue block4;
                }
                ++n16;
            }
            break;
        }
    }

    @Override
    public V get(Object object) {
        Object object2 = RegularImmutableMap.get(((RegularImmutableMap)object2).hashTable, ((RegularImmutableMap)object2).alternatingKeysAndValues, ((RegularImmutableMap)object2).size, 0, object);
        if (object2 == null) {
            return null;
        }
        return (V)object2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Object get(Object object, Object[] objectArray, int n, int n2, Object object2) {
        if (object2 == null) {
            return null;
        }
        if (n == 1) {
            object = objectArray[n2];
            object.getClass();
            if (!object.equals(object2)) return null;
            object = objectArray[n2 ^ 1];
            object.getClass();
            return object;
        }
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            n2 = byArray.length + -1;
            int n3 = Hashing.smear(object2.hashCode());
            while (true) {
                int n4;
                if ((n4 = byArray[n3 &= n2] & 0xFF) == 255) {
                    return null;
                }
                if (object2.equals(objectArray[n4])) {
                    return objectArray[n4 ^ 1];
                }
                ++n3;
            }
        }
        if (object instanceof short[]) {
            short[] sArray = (short[])object;
            n2 = sArray.length + -1;
            int n5 = Hashing.smear(object2.hashCode());
            while (true) {
                char c;
                if ((c = (char)sArray[n5 &= n2]) == '\uffff') {
                    return null;
                }
                if (object2.equals(objectArray[c])) {
                    return objectArray[c ^ '\u0001'];
                }
                ++n5;
            }
        }
        int[] nArray = (int[])object;
        n2 = nArray.length + -1;
        int n6 = Hashing.smear(object2.hashCode());
        int n7;
        while ((n7 = nArray[n6 &= n2]) != -1) {
            if (object2.equals(objectArray[n7])) {
                return objectArray[n7 ^ 1];
            }
            ++n6;
        }
        return null;
    }

    static {
        RegularImmutableMap regularImmutableMap;
        EMPTY = regularImmutableMap = new RegularImmutableMap(null, new Object[0], 0);
    }

    private RegularImmutableMap(Object object, Object[] objectArray, int n) {
        this.hashTable = object;
        this.alternatingKeysAndValues = objectArray;
        this.size = n;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    static class EntrySet
    extends ImmutableSet {
        private final transient ImmutableMap map;
        private final transient Object[] alternatingKeysAndValues;
        private final transient int keyOffset;
        private final transient int size;

        @Override
        int copyIntoArray(Object[] objectArray, int n) {
            return this.asList().copyIntoArray(objectArray, n);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        ImmutableList createAsList() {
            ImmutableList immutableList = new ImmutableList(){

                @Override
                public int size() {
                    return EntrySet.this.size;
                }

                @Override
                public Map.Entry get(int n) {
                    Preconditions.checkElementIndex(n, object2.EntrySet.this.size);
                    Object object = object2.EntrySet.this.alternatingKeysAndValues[n + n + object2.EntrySet.this.keyOffset];
                    object.getClass();
                    Object object2 = object2.EntrySet.this.alternatingKeysAndValues[n + n + (object2.EntrySet.this.keyOffset ^ 1)];
                    object2.getClass();
                    AbstractMap.SimpleImmutableEntry<Object, Object> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<Object, Object>(object, object2);
                    return simpleImmutableEntry;
                }

                @Override
                public boolean isPartialView() {
                    return true;
                }
            };
            return immutableList;
        }

        @Override
        public UnmodifiableIterator iterator() {
            return this.asList().iterator();
        }

        EntrySet(ImmutableMap immutableMap, Object[] objectArray, int n, int n2) {
            this.map = immutableMap;
            this.alternatingKeysAndValues = objectArray;
            this.keyOffset = n;
            this.size = n2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) return false;
            object = (Map.Entry)object;
            Object k = object.getKey();
            if ((object = object.getValue()) == null) return false;
            if (!object.equals(this.map.get(k))) return false;
            return true;
        }

        @Override
        boolean isPartialView() {
            throw null;
        }
    }

    static final class KeysOrValuesAsList
    extends ImmutableList {
        private final transient Object[] alternatingKeysAndValues;
        private final transient int offset;
        private final transient int size;

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Object get(int n) {
            Preconditions.checkElementIndex(n, ((KeysOrValuesAsList)object).size);
            Object object = ((KeysOrValuesAsList)object).alternatingKeysAndValues[n + n + ((KeysOrValuesAsList)object).offset];
            object.getClass();
            return object;
        }

        KeysOrValuesAsList(Object[] objectArray, int n, int n2) {
            this.alternatingKeysAndValues = objectArray;
            this.offset = n;
            this.size = n2;
        }

        @Override
        boolean isPartialView() {
            return true;
        }
    }

    static final class KeySet
    extends ImmutableSet {
        private final transient ImmutableMap map;
        private final transient ImmutableList list;

        @Override
        int copyIntoArray(Object[] objectArray, int n) {
            return this.asList().copyIntoArray(objectArray, n);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public ImmutableList asList() {
            return this.list;
        }

        @Override
        public UnmodifiableIterator iterator() {
            return this.asList().iterator();
        }

        KeySet(ImmutableMap immutableMap, ImmutableList immutableList) {
            this.map = immutableMap;
            this.list = immutableList;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean contains(Object object) {
            if (this.map.get(object) == null) return false;
            return true;
        }

        @Override
        boolean isPartialView() {
            throw null;
        }
    }
}

