/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.guava.collect;

import androidx.test.espresso.remote.internal.deps.guava.base.Function;
import androidx.test.espresso.remote.internal.deps.guava.collect.ByFunctionOrdering;
import androidx.test.espresso.remote.internal.deps.guava.collect.ComparatorOrdering;
import java.util.Comparator;

public abstract class Ordering<T>
implements Comparator<T> {
    @Override
    public abstract int compare(T var1, T var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Ordering from(Comparator ordering) {
        if (ordering instanceof Ordering) {
            return ordering;
        }
        ComparatorOrdering comparatorOrdering = new ComparatorOrdering(ordering);
        return comparatorOrdering;
    }

    public Ordering onResultOf(Function function) {
        ByFunctionOrdering byFunctionOrdering = new ByFunctionOrdering(function, this);
        return byFunctionOrdering;
    }

    protected Ordering() {
    }
}

