/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.guava.collect;

import androidx.test.espresso.remote.internal.deps.guava.collect.CollectPreconditions;
import androidx.test.espresso.remote.internal.deps.guava.collect.ImmutableCollection;
import androidx.test.espresso.remote.internal.deps.guava.collect.ImmutableSet;
import androidx.test.espresso.remote.internal.deps.guava.collect.Maps;
import androidx.test.espresso.remote.internal.deps.guava.collect.Ordering;
import androidx.test.espresso.remote.internal.deps.guava.collect.RegularImmutableMap;
import androidx.test.espresso.remote.internal.deps.guava.collect.Sets;
import androidx.test.espresso.remote.internal.deps.guava.collect.UnmodifiableIterator;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;

public abstract class ImmutableMap<K, V>
implements Map<K, V>,
Serializable {
    static final Map.Entry[] EMPTY_ENTRY_ARRAY = new Map.Entry[0];
    private transient ImmutableSet entrySet;
    private transient ImmutableSet keySet;
    private transient ImmutableCollection values;

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this.entrySet());
    }

    abstract ImmutableCollection createValues();

    public ImmutableCollection values() {
        ImmutableCollection immutableCollection = this.values;
        if (immutableCollection == null) {
            this.values = immutableCollection = this.createValues();
            return immutableCollection;
        }
        return immutableCollection;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ImmutableMap copyOf(Iterable iterable) {
        int n = iterable instanceof Collection ? ((Collection)iterable).size() : 4;
        Builder builder = new Builder(n);
        builder.putAll(iterable);
        return builder.build();
    }

    public static ImmutableMap copyOf(Map map) {
        ImmutableMap immutableMap;
        if (map instanceof ImmutableMap && !(map instanceof SortedMap) && !(immutableMap = (ImmutableMap)map).isPartialView()) {
            return immutableMap;
        }
        return ImmutableMap.copyOf(map.entrySet());
    }

    abstract ImmutableSet createEntrySet();

    abstract ImmutableSet createKeySet();

    public ImmutableSet entrySet() {
        ImmutableSet immutableSet = this.entrySet;
        if (immutableSet == null) {
            this.entrySet = immutableSet = this.createEntrySet();
            return immutableSet;
        }
        return immutableSet;
    }

    public ImmutableSet keySet() {
        ImmutableSet immutableSet = this.keySet;
        if (immutableSet == null) {
            this.keySet = immutableSet = this.createKeySet();
            return immutableSet;
        }
        return immutableSet;
    }

    @Override
    public abstract V get(Object var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object getOrDefault(Object object, Object object2) {
        void var2_3;
        void var1_2;
        V v = this.get(var1_2);
        if (v != null) {
            return v;
        }
        return var2_3;
    }

    @Override
    @Deprecated
    public final V put(K k, V v) {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    @Override
    @Deprecated
    public final V remove(Object object) {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    Object writeReplace() {
        SerializedForm serializedForm = new SerializedForm(this);
        return serializedForm;
    }

    public String toString() {
        return Maps.toStringImpl(this);
    }

    ImmutableMap() {
    }

    @Override
    @Deprecated
    public final void clear() {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    @Override
    @Deprecated
    public final void putAll(Map<? extends K, ? extends V> map) {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        Serializable serializable = new InvalidObjectException("Use SerializedForm");
        throw serializable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean containsKey(Object object) {
        if (this.get(object) == null) return false;
        return true;
    }

    @Override
    public boolean containsValue(Object object) {
        return this.values().contains(object);
    }

    @Override
    public boolean equals(Object object) {
        return Maps.equalsImpl(this, object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEmpty() {
        if (this.size() != 0) return false;
        return true;
    }

    abstract boolean isPartialView();

    public static class Builder {
        Comparator valueComparator;
        Object[] alternatingKeysAndValues;
        int size;
        boolean entriesUsed;
        DuplicateKey duplicateKey;

        public Builder put(Map.Entry entry) {
            return this.put(entry.getKey(), entry.getValue());
        }

        public Builder put(Object objectArray, Object object) {
            this.ensureCapacity(this.size + 1);
            CollectPreconditions.checkEntryNotNull(objectArray, object);
            Object[] objectArray2 = this.alternatingKeysAndValues;
            int n = this.size;
            objectArray2[n + n] = objectArray;
            objectArray = this.alternatingKeysAndValues;
            int n2 = this.size++;
            objectArray[n2 + n2 + 1] = object;
            return this;
        }

        public Builder putAll(Iterable object) {
            if (object instanceof Collection) {
                this.ensureCapacity(this.size + ((Collection)object).size());
            }
            object = object.iterator();
            while (object.hasNext()) {
                this.put((Map.Entry)object.next());
            }
            return this;
        }

        @Deprecated
        public ImmutableMap build() {
            return this.buildOrThrow();
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        private ImmutableMap build(boolean bl) {
            void var2_4;
            if (bl && this.duplicateKey != null) {
                throw this.duplicateKey.exception();
            }
            int n = this.size;
            if (this.valueComparator == null) {
                Object[] objectArray = this.alternatingKeysAndValues;
            } else {
                void var2_9;
                Object[] objectArray;
                if (this.entriesUsed) {
                    Object[] objectArray2 = this.alternatingKeysAndValues;
                    int n2 = this.size;
                    this.alternatingKeysAndValues = Arrays.copyOf(objectArray2, n2 + n2);
                }
                Object[] objectArray3 = this.alternatingKeysAndValues;
                if (!bl && (objectArray = this.lastEntryForEachKey(objectArray3, this.size)).length < this.alternatingKeysAndValues.length) {
                    n = objectArray.length >>> 1;
                }
                Builder.sortEntries((Object[])var2_9, n, this.valueComparator);
            }
            this.entriesUsed = true;
            RegularImmutableMap regularImmutableMap = RegularImmutableMap.create(n, (Object[])var2_4, this);
            if (bl && this.duplicateKey != null) {
                throw this.duplicateKey.exception();
            }
            return regularImmutableMap;
        }

        public ImmutableMap buildOrThrow() {
            return this.build(true);
        }

        public Builder() {
            this(4);
        }

        Builder(int n) {
            this.alternatingKeysAndValues = new Object[n + n];
            this.size = 0;
            this.entriesUsed = false;
        }

        private void ensureCapacity(int n) {
            if (n + n > this.alternatingKeysAndValues.length) {
                this.alternatingKeysAndValues = Arrays.copyOf(this.alternatingKeysAndValues, ImmutableCollection.Builder.expandedCapacity(this.alternatingKeysAndValues.length, n + n));
                this.entriesUsed = false;
                return;
            }
        }

        static void sortEntries(Object[] objectArray, int n, Comparator comparator) {
            Map.Entry[] entryArray = new Map.Entry[n];
            for (int i = 0; i < n; ++i) {
                AbstractMap.SimpleImmutableEntry<Object, Object> simpleImmutableEntry;
                Object object = objectArray[i + i];
                object.getClass();
                Object object2 = objectArray[i + i + 1];
                object2.getClass();
                entryArray[i] = simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<Object, Object>(object, object2);
            }
            Arrays.sort(entryArray, 0, n, Ordering.from(comparator).onResultOf(Maps.valueFunction()));
            for (int i = 0; i < n; ++i) {
                objectArray[i + i] = entryArray[i].getKey();
                objectArray[i + i + 1] = entryArray[i].getValue();
            }
        }

        private Object[] lastEntryForEachKey(Object[] objectArray, int n) {
            Object[] objectArray2;
            int n2;
            HashSet<Object[]> hashSet = new HashSet<Object[]>();
            BitSet bitSet = new BitSet();
            for (n2 = n + -1; n2 >= 0; --n2) {
                objectArray2 = objectArray[n2 + n2];
                objectArray2.getClass();
                if (hashSet.add(objectArray2)) continue;
                bitSet.set(n2);
            }
            if (bitSet.isEmpty()) {
                return objectArray;
            }
            n2 = n - bitSet.cardinality();
            objectArray2 = new Object[n2 + n2];
            n2 = 0;
            int n3 = 0;
            while (n2 < n + n) {
                if (bitSet.get(n2 >>> 1)) {
                    n2 += 2;
                    continue;
                }
                int n4 = n3 + 1;
                int n5 = n2 + 1;
                Object object = objectArray[n2];
                object.getClass();
                objectArray2[n3] = object;
                n3 = n4 + 1;
                n2 = n5 + 1;
                Object object2 = objectArray[n5];
                object2.getClass();
                objectArray2[n4] = object2;
            }
            return objectArray2;
        }

        static final class DuplicateKey {
            private final Object key;
            private final Object value1;
            private final Object value2;

            IllegalArgumentException exception() {
                StringBuilder stringBuilder = new StringBuilder();
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(stringBuilder.append("Multiple entries with same key: ").append(this.key).append("=").append(this.value1).append(" and ").append(this.key).append("=").append(this.value2).toString());
                return illegalArgumentException;
            }

            DuplicateKey(Object object, Object object2, Object object3) {
                this.key = object;
                this.value1 = object2;
                this.value2 = object3;
            }
        }
    }

    static class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final Object keys;
        private final Object values;

        Builder makeBuilder(int n) {
            Object object = new Builder(n);
            return object;
        }

        final Object legacyReadResolve() {
            Object[] objectArray = (Object[])this.keys;
            Object[] objectArray2 = (Object[])this.values;
            Builder builder = this.makeBuilder(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                builder.put(objectArray[i], objectArray2[i]);
            }
            return builder.buildOrThrow();
        }

        final Object readResolve() {
            if (!(((SerializedForm)((Object)this_)).keys instanceof ImmutableSet)) {
                return ((SerializedForm)((Object)this_)).legacyReadResolve();
            }
            Object object = (ImmutableSet)((SerializedForm)((Object)this_)).keys;
            Object object2 = ((SerializedForm)((Object)this_)).values;
            object2 = (ImmutableCollection)object2;
            Builder this_ = ((SerializedForm)((Object)this_)).makeBuilder(((AbstractCollection)object).size());
            object = ((ImmutableSet)object).iterator();
            object2 = ((ImmutableCollection)object2).iterator();
            while (object.hasNext()) {
                this_.put(object.next(), object2.next());
            }
            return this_.buildOrThrow();
        }

        SerializedForm(ImmutableMap immutableMap) {
            Object[] objectArray = new Object[immutableMap.size()];
            Object[] objectArray2 = new Object[immutableMap.size()];
            UnmodifiableIterator unmodifiableIterator = immutableMap.entrySet().iterator();
            int n = 0;
            while (unmodifiableIterator.hasNext()) {
                Map.Entry entry = (Map.Entry)unmodifiableIterator.next();
                objectArray[n] = entry.getKey();
                objectArray2[n] = entry.getValue();
                ++n;
            }
            this.keys = objectArray;
            this.values = objectArray2;
        }
    }
}

