/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.guava.collect;

import androidx.test.espresso.remote.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.remote.internal.deps.guava.collect.AbstractIndexedListIterator;
import androidx.test.espresso.remote.internal.deps.guava.collect.ImmutableCollection;
import androidx.test.espresso.remote.internal.deps.guava.collect.Lists;
import androidx.test.espresso.remote.internal.deps.guava.collect.ObjectArrays;
import androidx.test.espresso.remote.internal.deps.guava.collect.RegularImmutableList;
import androidx.test.espresso.remote.internal.deps.guava.collect.UnmodifiableIterator;
import androidx.test.espresso.remote.internal.deps.guava.collect.UnmodifiableListIterator;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

public abstract class ImmutableList<E>
extends ImmutableCollection<E>
implements List<E>,
RandomAccess {
    private static final UnmodifiableListIterator EMPTY_ITR;

    @Override
    int copyIntoArray(Object[] objectArray, int n) {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            objectArray[n + i] = this.get(i);
        }
        return n + n2;
    }

    @Override
    public int hashCode() {
        int n = this.size();
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 = n2 * 31 + this.get(i).hashCode();
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int indexOf(Object object) {
        if (object != null) return Lists.indexOfImpl(this, object);
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int lastIndexOf(Object object) {
        if (object != null) return Lists.lastIndexOfImpl(this, object);
        return -1;
    }

    public static Builder builder() {
        Builder builder = new Builder();
        return builder;
    }

    static ImmutableList asImmutableList(Object[] objectArray) {
        return ImmutableList.asImmutableList(objectArray, objectArray.length);
    }

    static ImmutableList asImmutableList(Object[] objectArray, int n) {
        if (n == 0) {
            return ImmutableList.of();
        }
        RegularImmutableList regularImmutableList = new RegularImmutableList(objectArray, n);
        return regularImmutableList;
    }

    @Override
    @Deprecated
    public final ImmutableList asList() {
        return this;
    }

    private static ImmutableList construct(Object ... objectArray) {
        return ImmutableList.asImmutableList(ObjectArrays.checkElementsNotNull(objectArray));
    }

    public static ImmutableList copyOf(Collection collection) {
        if (collection instanceof ImmutableCollection) {
            if (((ImmutableCollection)(collection = ((ImmutableCollection)collection).asList())).isPartialView()) {
                return ImmutableList.asImmutableList(((ImmutableCollection)collection).toArray());
            }
            return collection;
        }
        return ImmutableList.construct(collection.toArray());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImmutableList copyOf(Object[] object) {
        void var0_2;
        if (((Object)object).length == 0) {
            ImmutableList immutableList = ImmutableList.of();
            return var0_2;
        }
        ImmutableList immutableList = ImmutableList.construct((Object[])object.clone());
        return var0_2;
    }

    public static ImmutableList of() {
        return RegularImmutableList.EMPTY;
    }

    public static ImmutableList of(Object object) {
        Object[] objectArray = new Object[]{object};
        return ImmutableList.construct(objectArray);
    }

    public static ImmutableList of(Object object, Object object2, Object object3, Object object4) {
        Object[] objectArray = new Object[]{object, object2, object3, object4};
        return ImmutableList.construct(objectArray);
    }

    public static ImmutableList of(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6};
        return ImmutableList.construct(objectArray);
    }

    public static ImmutableList of(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6, object7, object8};
        return ImmutableList.construct(objectArray);
    }

    public static ImmutableList of(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6, object7, object8, object9};
        return ImmutableList.construct(objectArray);
    }

    public ImmutableList subList(int n, int n2) {
        Preconditions.checkPositionIndexes(n, n2, this.size());
        int n3 = n2 - n;
        if (n3 == this.size()) {
            return this;
        }
        if (n3 == 0) {
            return ImmutableList.of();
        }
        return this.subListUnchecked(n, n2);
    }

    ImmutableList subListUnchecked(int n, int n2) {
        SubList subList = new SubList(n, n2 - n);
        return subList;
    }

    @Override
    public UnmodifiableIterator iterator() {
        return this.listIterator();
    }

    public UnmodifiableListIterator listIterator() {
        return this.listIterator(0);
    }

    public UnmodifiableListIterator listIterator(int n) {
        Preconditions.checkPositionIndex(n, this.size());
        if (this.isEmpty()) {
            return EMPTY_ITR;
        }
        Itr itr = new Itr(this, n);
        return itr;
    }

    @Override
    @Deprecated
    public final E remove(int n) {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    @Override
    @Deprecated
    public final E set(int n, E e) {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    @Override
    Object writeReplace() {
        SerializedForm serializedForm = new SerializedForm(this.toArray());
        return serializedForm;
    }

    static {
        Itr itr = new Itr(RegularImmutableList.EMPTY, 0);
        EMPTY_ITR = itr;
    }

    ImmutableList() {
    }

    @Override
    @Deprecated
    public final void add(int n, E e) {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        Serializable serializable = new InvalidObjectException("Use SerializedForm");
        throw serializable;
    }

    @Override
    @Deprecated
    public final boolean addAll(int n, Collection<? extends E> collection) {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean contains(Object object) {
        if (this.indexOf(object) < 0) return false;
        return true;
    }

    @Override
    public boolean equals(Object object) {
        return Lists.equalsImpl(this, object);
    }

    public static final class Builder
    extends ImmutableCollection.ArrayBasedBuilder {
        @Override
        public Builder add(Object object) {
            super.add(object);
            return this;
        }

        public ImmutableList build() {
            this.forceCopy = true;
            return ImmutableList.asImmutableList(this.contents, this.size);
        }

        public Builder() {
            this(4);
        }

        Builder(int n) {
            super(n);
        }
    }

    static class Itr
    extends AbstractIndexedListIterator {
        private final ImmutableList list;

        @Override
        protected Object get(int n) {
            return this.list.get(n);
        }

        Itr(ImmutableList immutableList, int n) {
            super(immutableList.size(), n);
            this.list = immutableList;
        }
    }

    class SubList
    extends ImmutableList {
        final transient int offset;
        final transient int length;

        @Override
        int internalArrayEnd() {
            return ImmutableList.this.internalArrayStart() + this.offset + this.length;
        }

        @Override
        int internalArrayStart() {
            return ImmutableList.this.internalArrayStart() + this.offset;
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        public ImmutableList subList(int n, int n2) {
            Preconditions.checkPositionIndexes(n, n2, this.length);
            return ImmutableList.this.subList(n + this.offset, n2 + this.offset);
        }

        @Override
        public E get(int n) {
            Preconditions.checkElementIndex(n, this.length);
            return ImmutableList.this.get(n + this.offset);
        }

        SubList(int n, int n2) {
            this.offset = n;
            this.length = n2;
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        Object[] internalArray() {
            return ImmutableList.this.internalArray();
        }
    }

    static class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 0L;
        final Object[] elements;

        Object readResolve() {
            return ImmutableList.copyOf(this.elements);
        }

        SerializedForm(Object[] objectArray) {
            this.elements = objectArray;
        }
    }
}

