/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.guava.collect;

import androidx.test.espresso.remote.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.remote.internal.deps.guava.collect.CollectPreconditions;
import androidx.test.espresso.remote.internal.deps.guava.collect.ImmutableList;
import androidx.test.espresso.remote.internal.deps.guava.collect.ObjectArrays;
import androidx.test.espresso.remote.internal.deps.guava.collect.Platform;
import androidx.test.espresso.remote.internal.deps.guava.collect.UnmodifiableIterator;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;

public abstract class ImmutableCollection<E>
extends AbstractCollection<E>
implements Serializable {
    private static final Object[] EMPTY_ARRAY = new Object[0];

    int copyIntoArray(Object[] objectArray, int n) {
        throw null;
    }

    int internalArrayEnd() {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    int internalArrayStart() {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    public ImmutableList asList() {
        throw null;
    }

    public abstract UnmodifiableIterator iterator();

    Object writeReplace() {
        ImmutableList.SerializedForm serializedForm = new ImmutableList.SerializedForm(this.toArray());
        return serializedForm;
    }

    ImmutableCollection() {
    }

    @Override
    @Deprecated
    public final void clear() {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        Serializable serializable = new InvalidObjectException("Use SerializedForm");
        throw serializable;
    }

    @Override
    @Deprecated
    public final boolean add(E e) {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    @Override
    @Deprecated
    public final boolean addAll(Collection<? extends E> collection) {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    @Override
    public abstract boolean contains(Object var1);

    abstract boolean isPartialView();

    @Override
    @Deprecated
    public final boolean remove(Object object) {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    @Override
    @Deprecated
    public final boolean removeAll(Collection<?> collection) {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    @Override
    @Deprecated
    public final boolean retainAll(Collection<?> collection) {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    Object[] internalArray() {
        return null;
    }

    @Override
    public final Object[] toArray() {
        return this.toArray(EMPTY_ARRAY);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final <T> T[] toArray(T[] objectArray) {
        Preconditions.checkNotNull(objectArray);
        int n = this.size();
        if (objectArray.length < n) {
            Object[] objectArray2 = this.internalArray();
            if (objectArray2 != null) {
                return Platform.copy(objectArray2, this.internalArrayStart(), this.internalArrayEnd(), objectArray);
            }
            objectArray = ObjectArrays.newArray(objectArray, n);
        } else if (objectArray.length > n) {
            objectArray[n] = null;
        }
        this.copyIntoArray(objectArray, 0);
        return objectArray;
    }

    static abstract class ArrayBasedBuilder
    extends Builder {
        Object[] contents;
        int size;
        boolean forceCopy;

        public ArrayBasedBuilder add(Object object) {
            Preconditions.checkNotNull(object);
            this.getReadyToExpandTo(this.size + 1);
            Object[] objectArray = this.contents;
            int n = this.size;
            this.size = n + 1;
            objectArray[n] = object;
            return this;
        }

        public Builder add(Object ... objectArray) {
            this.addAll(objectArray, objectArray.length);
            return this;
        }

        ArrayBasedBuilder(int n) {
            CollectPreconditions.checkNonnegative(n, "initialCapacity");
            this.contents = new Object[n];
            this.size = 0;
        }

        final void addAll(Object[] objectArray, int n) {
            ObjectArrays.checkElementsNotNull(objectArray, n);
            this.getReadyToExpandTo(this.size + n);
            System.arraycopy(objectArray, 0, this.contents, this.size, n);
            this.size += n;
        }

        private void getReadyToExpandTo(int n) {
            if (this.contents.length < n) {
                this.contents = Arrays.copyOf(this.contents, ArrayBasedBuilder.expandedCapacity(this.contents.length, n));
                this.forceCopy = false;
                return;
            }
            if (this.forceCopy) {
                this.contents = (Object[])this.contents.clone();
                this.forceCopy = false;
                return;
            }
        }
    }

    public static abstract class Builder {
        static int expandedCapacity(int n, int n2) {
            if (n2 < 0) {
                AssertionError assertionError = new AssertionError((Object)"cannot store more than MAX_VALUE elements");
                throw assertionError;
            }
            if ((n = n + (n >> 1) + 1) < n2) {
                n = Integer.highestOneBit(n2 + -1);
                n += n;
            }
            if (n < 0) {
                return Integer.MAX_VALUE;
            }
            return n;
        }

        Builder() {
        }
    }
}

