/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.guava.collect;

import androidx.test.espresso.remote.internal.deps.guava.base.Function;
import androidx.test.espresso.remote.internal.deps.guava.base.Objects;
import androidx.test.espresso.remote.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.remote.internal.deps.guava.collect.Ordering;
import java.io.Serializable;

final class ByFunctionOrdering<F, T>
extends Ordering<F>
implements Serializable {
    private static final long serialVersionUID = 0L;
    final Function function;
    final Ordering ordering;

    @Override
    public int compare(F f, F f2) {
        return this.ordering.compare(this.function.apply(f), this.function.apply(f2));
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.function, this.ordering};
        return Objects.hashCode(objectArray);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.append(this.ordering).append(".onResultOf(").append(this.function).append(")").toString();
    }

    ByFunctionOrdering(Function function, Ordering ordering) {
        this.function = (Function)Preconditions.checkNotNull(function);
        this.ordering = (Ordering)Preconditions.checkNotNull(ordering);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ByFunctionOrdering)) return false;
        object = (ByFunctionOrdering)object;
        if (!this.function.equals(((ByFunctionOrdering)object).function)) return false;
        if (!this.ordering.equals(((ByFunctionOrdering)object).ordering)) return false;
        return true;
    }
}

