/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.guava.cache;

import androidx.test.espresso.remote.internal.deps.guava.base.Ascii;
import androidx.test.espresso.remote.internal.deps.guava.base.Equivalence;
import androidx.test.espresso.remote.internal.deps.guava.base.MoreObjects;
import androidx.test.espresso.remote.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.remote.internal.deps.guava.base.Supplier;
import androidx.test.espresso.remote.internal.deps.guava.base.Suppliers;
import androidx.test.espresso.remote.internal.deps.guava.base.Ticker;
import androidx.test.espresso.remote.internal.deps.guava.cache.AbstractCache$SimpleStatsCounter;
import androidx.test.espresso.remote.internal.deps.guava.cache.AbstractCache$StatsCounter;
import androidx.test.espresso.remote.internal.deps.guava.cache.Cache;
import androidx.test.espresso.remote.internal.deps.guava.cache.CacheBuilder$$ExternalSyntheticLambda0;
import androidx.test.espresso.remote.internal.deps.guava.cache.CacheStats;
import androidx.test.espresso.remote.internal.deps.guava.cache.LocalCache;
import androidx.test.espresso.remote.internal.deps.guava.cache.RemovalListener;
import androidx.test.espresso.remote.internal.deps.guava.cache.RemovalNotification;
import androidx.test.espresso.remote.internal.deps.guava.cache.Weigher;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CacheBuilder {
    static final Supplier NULL_STATS_COUNTER;
    static final CacheStats EMPTY_STATS;
    static final Supplier CACHE_STATS_COUNTER;
    static final Ticker NULL_TICKER;
    private static final Logger logger;
    boolean strictParsing = true;
    int initialCapacity = -1;
    int concurrencyLevel = -1;
    long maximumSize = -1L;
    long maximumWeight = -1L;
    Weigher weigher;
    LocalCache.Strength keyStrength;
    LocalCache.Strength valueStrength;
    long expireAfterWriteNanos = -1L;
    long expireAfterAccessNanos = -1L;
    long refreshNanos = -1L;
    Equivalence keyEquivalence;
    Equivalence valueEquivalence;
    RemovalListener removalListener;
    Ticker ticker;
    Supplier statsCounterSupplier = NULL_STATS_COUNTER;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int getConcurrencyLevel() {
        if (this.concurrencyLevel != -1) return this.concurrencyLevel;
        return 4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int getInitialCapacity() {
        if (this.initialCapacity != -1) return this.initialCapacity;
        return 16;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long getExpireAfterAccessNanos() {
        if (this.expireAfterAccessNanos != -1L) return this.expireAfterAccessNanos;
        return 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long getExpireAfterWriteNanos() {
        if (this.expireAfterWriteNanos != -1L) return this.expireAfterWriteNanos;
        return 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long getMaximumWeight() {
        if (this.expireAfterWriteNanos == 0L) return 0L;
        if (this.expireAfterAccessNanos == 0L) {
            return 0L;
        }
        if (this.weigher != null) return this.maximumWeight;
        return this.maximumSize;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long getRefreshNanos() {
        if (this.refreshNanos != -1L) return this.refreshNanos;
        return 0L;
    }

    Equivalence getKeyEquivalence() {
        return (Equivalence)MoreObjects.firstNonNull(this.keyEquivalence, this.getKeyStrength().defaultEquivalence());
    }

    Equivalence getValueEquivalence() {
        return (Equivalence)MoreObjects.firstNonNull(this.valueEquivalence, this.getValueStrength().defaultEquivalence());
    }

    Supplier getStatsCounterSupplier() {
        return this.statsCounterSupplier;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Ticker getTicker(boolean bl) {
        if (((CacheBuilder)this).ticker != null) {
            return ((CacheBuilder)this).ticker;
        }
        if (!bl) return NULL_TICKER;
        return Ticker.systemTicker();
    }

    static /* synthetic */ AbstractCache$StatsCounter lambda$static$0() {
        AbstractCache$SimpleStatsCounter abstractCache$SimpleStatsCounter = new AbstractCache$SimpleStatsCounter();
        return abstractCache$SimpleStatsCounter;
    }

    public Cache build() {
        this.checkWeightWithWeigher();
        this.checkNonLoadingCache();
        LocalCache.LocalManualCache localManualCache = new LocalCache.LocalManualCache(this);
        return localManualCache;
    }

    /*
     * Enabled aggressive block sorting
     */
    public CacheBuilder concurrencyLevel(int n) {
        boolean bl = this.concurrencyLevel == -1;
        Preconditions.checkState(bl, "concurrency level was already set to %s", this.concurrencyLevel);
        bl = n > 0;
        Preconditions.checkArgument(bl);
        this.concurrencyLevel = n;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public CacheBuilder expireAfterAccess(long l, TimeUnit timeUnit) {
        boolean bl = this.expireAfterAccessNanos == -1L;
        Preconditions.checkState(bl, "expireAfterAccess was already set to %s ns", this.expireAfterAccessNanos);
        bl = l >= 0L;
        Preconditions.checkArgument(bl, "duration cannot be negative: %s %s", l, (Object)timeUnit);
        this.expireAfterAccessNanos = timeUnit.toNanos(l);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public CacheBuilder expireAfterWrite(long l, TimeUnit timeUnit) {
        boolean bl = this.expireAfterWriteNanos == -1L;
        Preconditions.checkState(bl, "expireAfterWrite was already set to %s ns", this.expireAfterWriteNanos);
        bl = l >= 0L;
        Preconditions.checkArgument(bl, "duration cannot be negative: %s %s", l, (Object)timeUnit);
        this.expireAfterWriteNanos = timeUnit.toNanos(l);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    CacheBuilder keyEquivalence(Equivalence equivalence) {
        boolean bl = this.keyEquivalence == null;
        Preconditions.checkState(bl, "key equivalence was already set to %s", this.keyEquivalence);
        this.keyEquivalence = (Equivalence)Preconditions.checkNotNull(equivalence);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public CacheBuilder maximumSize(long l) {
        boolean bl = this.maximumSize == -1L;
        Preconditions.checkState(bl, "maximum size was already set to %s", this.maximumSize);
        bl = this.maximumWeight == -1L;
        Preconditions.checkState(bl, "maximum weight was already set to %s", this.maximumWeight);
        bl = this.weigher == null;
        Preconditions.checkState(bl, "maximum size can not be combined with weigher");
        bl = l >= 0L;
        Preconditions.checkArgument(bl, "maximum size must not be negative");
        this.maximumSize = l;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public CacheBuilder maximumWeight(long l) {
        boolean bl = this.maximumWeight == -1L;
        Preconditions.checkState(bl, "maximum weight was already set to %s", this.maximumWeight);
        bl = this.maximumSize == -1L;
        Preconditions.checkState(bl, "maximum size was already set to %s", this.maximumSize);
        bl = l >= 0L;
        Preconditions.checkArgument(bl, "maximum weight must not be negative");
        this.maximumWeight = l;
        return this;
    }

    public static CacheBuilder newBuilder() {
        CacheBuilder cacheBuilder = new CacheBuilder();
        return cacheBuilder;
    }

    /*
     * Enabled aggressive block sorting
     */
    public CacheBuilder removalListener(RemovalListener removalListener) {
        boolean bl = this.removalListener == null;
        Preconditions.checkState(bl);
        this.removalListener = (RemovalListener)Preconditions.checkNotNull(removalListener);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    CacheBuilder setKeyStrength(LocalCache.Strength strength) {
        boolean bl = this.keyStrength == null;
        Preconditions.checkState(bl, "Key strength was already set to %s", (Object)this.keyStrength);
        this.keyStrength = (LocalCache.Strength)((Object)Preconditions.checkNotNull((Object)strength));
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    CacheBuilder setValueStrength(LocalCache.Strength strength) {
        boolean bl = this.valueStrength == null;
        Preconditions.checkState(bl, "Value strength was already set to %s", (Object)this.valueStrength);
        this.valueStrength = (LocalCache.Strength)((Object)Preconditions.checkNotNull((Object)strength));
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public CacheBuilder ticker(Ticker ticker) {
        boolean bl = this.ticker == null;
        Preconditions.checkState(bl);
        this.ticker = (Ticker)Preconditions.checkNotNull(ticker);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    CacheBuilder valueEquivalence(Equivalence equivalence) {
        boolean bl = this.valueEquivalence == null;
        Preconditions.checkState(bl, "value equivalence was already set to %s", this.valueEquivalence);
        this.valueEquivalence = (Equivalence)Preconditions.checkNotNull(equivalence);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public CacheBuilder weigher(Weigher weigher) {
        boolean bl = this.weigher == null;
        Preconditions.checkState(bl);
        if (this.strictParsing) {
            bl = this.maximumSize == -1L;
            Preconditions.checkState(bl, "weigher can not be combined with maximum size (%s provided)", this.maximumSize);
        }
        this.weigher = (Weigher)Preconditions.checkNotNull(weigher);
        return this;
    }

    LocalCache.Strength getKeyStrength() {
        return (LocalCache.Strength)((Object)MoreObjects.firstNonNull((Object)this.keyStrength, (Object)LocalCache.Strength.STRONG));
    }

    LocalCache.Strength getValueStrength() {
        return (LocalCache.Strength)((Object)MoreObjects.firstNonNull((Object)this.valueStrength, (Object)LocalCache.Strength.STRONG));
    }

    RemovalListener getRemovalListener() {
        return (RemovalListener)MoreObjects.firstNonNull(this.removalListener, NullListener.INSTANCE);
    }

    Weigher getWeigher() {
        return (Weigher)MoreObjects.firstNonNull(this.weigher, OneWeigher.INSTANCE);
    }

    public String toString() {
        StringBuilder stringBuilder;
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(this);
        if (this.initialCapacity != -1) {
            toStringHelper.add("initialCapacity", this.initialCapacity);
        }
        if (this.concurrencyLevel != -1) {
            toStringHelper.add("concurrencyLevel", this.concurrencyLevel);
        }
        if (this.maximumSize != -1L) {
            toStringHelper.add("maximumSize", this.maximumSize);
        }
        if (this.maximumWeight != -1L) {
            toStringHelper.add("maximumWeight", this.maximumWeight);
        }
        if (this.expireAfterWriteNanos != -1L) {
            stringBuilder = new StringBuilder();
            toStringHelper.add("expireAfterWrite", stringBuilder.append(this.expireAfterWriteNanos).append("ns").toString());
        }
        if (this.expireAfterAccessNanos != -1L) {
            stringBuilder = new StringBuilder();
            toStringHelper.add("expireAfterAccess", stringBuilder.append(this.expireAfterAccessNanos).append("ns").toString());
        }
        if (this.keyStrength != null) {
            toStringHelper.add("keyStrength", Ascii.toLowerCase(this.keyStrength.toString()));
        }
        if (this.valueStrength != null) {
            toStringHelper.add("valueStrength", Ascii.toLowerCase(this.valueStrength.toString()));
        }
        if (this.keyEquivalence != null) {
            toStringHelper.addValue("keyEquivalence");
        }
        if (this.valueEquivalence != null) {
            toStringHelper.addValue("valueEquivalence");
        }
        if (this.removalListener != null) {
            toStringHelper.addValue("removalListener");
        }
        return toStringHelper.toString();
    }

    static {
        Ticker ticker = new AbstractCache$StatsCounter(){

            @Override
            public void recordEviction() {
            }

            @Override
            public void recordHits(int n) {
            }

            @Override
            public void recordLoadException(long l) {
            }

            @Override
            public void recordLoadSuccess(long l) {
            }

            @Override
            public void recordMisses(int n) {
            }
        };
        NULL_STATS_COUNTER = Suppliers.ofInstance(ticker);
        ticker = new CacheStats(0L, 0L, 0L, 0L, 0L, 0L);
        EMPTY_STATS = ticker;
        CACHE_STATS_COUNTER = CacheBuilder$$ExternalSyntheticLambda0.INSTANCE;
        ticker = new Ticker(){

            @Override
            public long read() {
                return 0L;
            }
        };
        NULL_TICKER = ticker;
        logger = Logger.getLogger(CacheBuilder.class.getName());
    }

    private CacheBuilder() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkNonLoadingCache() {
        boolean bl = this.refreshNanos == -1L;
        Preconditions.checkState(bl, "refreshAfterWrite requires a LoadingCache");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkWeightWithWeigher() {
        if (this.weigher == null) {
            boolean bl = this.maximumWeight == -1L;
            Preconditions.checkState(bl, "maximumWeight requires weigher");
            return;
        }
        if (this.strictParsing) {
            boolean bl = this.maximumWeight != -1L;
            Preconditions.checkState(bl, "weigher requires maximumWeight");
            return;
        }
        if (this.maximumWeight == -1L) {
            logger.logp(Level.WARNING, "androidx.test.espresso.remote.internal.deps.guava.cache.CacheBuilder", "checkWeightWithWeigher", "ignoring weigher specified without maximumWeight");
            return;
        }
    }

    static final class OneWeigher
    extends Enum
    implements Weigher {
        public static final /* enum */ OneWeigher INSTANCE;
        private static final /* synthetic */ OneWeigher[] $VALUES;

        @Override
        public int weigh(Object object, Object object2) {
            return 1;
        }

        static {
            OneWeigher oneWeigher;
            INSTANCE = oneWeigher = new OneWeigher("INSTANCE", 0);
            $VALUES = oneWeigherArray = new OneWeigher[]{OneWeigher.INSTANCE};
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private OneWeigher() {
            void var2_-1;
            void var1_-1;
        }

        public static OneWeigher[] values() {
            return (OneWeigher[])$VALUES.clone();
        }
    }

    static final class NullListener
    extends Enum
    implements RemovalListener {
        public static final /* enum */ NullListener INSTANCE;
        private static final /* synthetic */ NullListener[] $VALUES;

        static {
            NullListener nullListener;
            INSTANCE = nullListener = new NullListener("INSTANCE", 0);
            $VALUES = nullListenerArray = new NullListener[]{NullListener.INSTANCE};
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private NullListener() {
            void var2_-1;
            void var1_-1;
        }

        @Override
        public void onRemoval(RemovalNotification removalNotification) {
        }

        public static NullListener[] values() {
            return (NullListener[])$VALUES.clone();
        }
    }
}

