/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.guava.base;

import androidx.test.espresso.remote.internal.deps.guava.base.Strings;

public final class Preconditions {
    public static int checkElementIndex(int n, int n2) {
        return Preconditions.checkElementIndex(n, n2, "index");
    }

    public static int checkElementIndex(int n, int n2, String string) {
        if (n < 0 || n >= n2) {
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(Preconditions.badElementIndex(n, n2, string));
            throw indexOutOfBoundsException;
        }
        return n;
    }

    public static int checkPositionIndex(int n, int n2) {
        return Preconditions.checkPositionIndex(n, n2, "index");
    }

    public static int checkPositionIndex(int n, int n2, String string) {
        if (n < 0 || n > n2) {
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(Preconditions.badPositionIndex(n, n2, string));
            throw indexOutOfBoundsException;
        }
        return n;
    }

    public static Object checkNotNull(Object object) {
        if (object == null) {
            object = new NullPointerException();
            throw object;
        }
        return object;
    }

    public static Object checkNotNull(Object object, Object object2) {
        if (object == null) {
            object = new NullPointerException(String.valueOf(object2));
            throw object;
        }
        return object;
    }

    public static Object checkNotNull(Object object, String string, Object object2) {
        if (object == null) {
            Object[] objectArray = new Object[]{object2};
            object = new NullPointerException(Strings.lenientFormat(string, objectArray));
            throw object;
        }
        return object;
    }

    private static String badElementIndex(int n, int n2, String charSequence) {
        if (n < 0) {
            Object[] objectArray = new Object[]{charSequence, n};
            return Strings.lenientFormat("%s (%s) must not be negative", objectArray);
        }
        if (n2 < 0) {
            charSequence = new StringBuilder();
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(((StringBuilder)charSequence).append("negative size: ").append(n2).toString());
            throw illegalArgumentException;
        }
        Object[] objectArray = new Object[]{charSequence, n, n2};
        return Strings.lenientFormat("%s (%s) must be less than size (%s)", objectArray);
    }

    private static String badPositionIndex(int n, int n2, String charSequence) {
        if (n < 0) {
            Object[] objectArray = new Object[]{charSequence, n};
            return Strings.lenientFormat("%s (%s) must not be negative", objectArray);
        }
        if (n2 < 0) {
            charSequence = new StringBuilder();
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(((StringBuilder)charSequence).append("negative size: ").append(n2).toString());
            throw illegalArgumentException;
        }
        Object[] objectArray = new Object[]{charSequence, n, n2};
        return Strings.lenientFormat("%s (%s) must not be greater than size (%s)", objectArray);
    }

    private static String badPositionIndexes(int n, int n2, int n3) {
        if (n < 0 || n > n3) {
            return Preconditions.badPositionIndex(n, n3, "start index");
        }
        if (n2 < 0 || n2 > n3) {
            return Preconditions.badPositionIndex(n2, n3, "end index");
        }
        Object[] objectArray = new Object[]{n2, n};
        return Strings.lenientFormat("end index (%s) must not be less than start index (%s)", objectArray);
    }

    public static void checkArgument(boolean bl) {
        if (!bl) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            throw illegalArgumentException;
        }
    }

    public static void checkArgument(boolean bl, Object object) {
        if (!bl) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(String.valueOf(object));
            throw illegalArgumentException;
        }
    }

    public static void checkArgument(boolean bl, String string, int n) {
        if (!bl) {
            Object[] objectArray = new Object[]{n};
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(Strings.lenientFormat(string, objectArray));
            throw illegalArgumentException;
        }
    }

    public static void checkArgument(boolean bl, String string, Object object) {
        if (!bl) {
            Object[] objectArray = new Object[]{object};
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(Strings.lenientFormat(string, objectArray));
            throw illegalArgumentException;
        }
    }

    public static void checkArgument(boolean bl, String string, long l, Object object) {
        if (!bl) {
            Object[] objectArray = new Object[]{l, object};
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(Strings.lenientFormat(string, objectArray));
            throw illegalArgumentException;
        }
    }

    public static void checkPositionIndexes(int n, int n2, int n3) {
        if (n < 0 || n2 < n || n2 > n3) {
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(Preconditions.badPositionIndexes(n, n2, n3));
            throw indexOutOfBoundsException;
        }
    }

    public static void checkState(boolean bl) {
        if (!bl) {
            IllegalStateException illegalStateException = new IllegalStateException();
            throw illegalStateException;
        }
    }

    public static void checkState(boolean bl, Object object) {
        if (!bl) {
            IllegalStateException illegalStateException = new IllegalStateException(String.valueOf(object));
            throw illegalStateException;
        }
    }

    public static void checkState(boolean bl, String string, int n) {
        if (!bl) {
            Object[] objectArray = new Object[]{n};
            IllegalStateException illegalStateException = new IllegalStateException(Strings.lenientFormat(string, objectArray));
            throw illegalStateException;
        }
    }

    public static void checkState(boolean bl, String string, long l) {
        if (!bl) {
            Object[] objectArray = new Object[]{l};
            IllegalStateException illegalStateException = new IllegalStateException(Strings.lenientFormat(string, objectArray));
            throw illegalStateException;
        }
    }

    public static void checkState(boolean bl, String string, Object object) {
        if (!bl) {
            Object[] objectArray = new Object[]{object};
            IllegalStateException illegalStateException = new IllegalStateException(Strings.lenientFormat(string, objectArray));
            throw illegalStateException;
        }
    }

    public static void checkState(boolean bl, String string, int n, Object object) {
        if (!bl) {
            Object[] objectArray = new Object[]{n, object};
            IllegalStateException illegalStateException = new IllegalStateException(Strings.lenientFormat(string, objectArray));
            throw illegalStateException;
        }
    }

    public static void checkState(boolean bl, String string, Object object, Object object2) {
        if (!bl) {
            Object[] objectArray = new Object[]{object, object2};
            IllegalStateException illegalStateException = new IllegalStateException(Strings.lenientFormat(string, objectArray));
            throw illegalStateException;
        }
    }
}

