/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.guava.base;

import androidx.test.espresso.core.internal.deps.guava.base.Optional;
import androidx.test.espresso.remote.internal.deps.guava.base.Function;
import androidx.test.espresso.remote.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.remote.internal.deps.guava.base.Supplier;
import java.util.Collections;
import java.util.Set;

final class Absent
extends Optional {
    static final Absent INSTANCE;
    private static final long serialVersionUID = 0L;

    public int hashCode() {
        return 2040732332;
    }

    public Optional or(Optional optional) {
        return (Optional)Preconditions.checkNotNull(optional);
    }

    public Optional transform(Function function) {
        Preconditions.checkNotNull(function);
        return Optional.absent();
    }

    static Optional withType() {
        return INSTANCE;
    }

    public Object get() {
        Object object = new IllegalStateException("Optional.get() cannot be called on an absent value");
        throw object;
    }

    public Object or(Supplier supplier) {
        return Preconditions.checkNotNull(supplier.get(), "use Optional.orNull() instead of a Supplier that returns null");
    }

    public Object or(Object object) {
        return Preconditions.checkNotNull(object, "use Optional.orNull() instead of Optional.or(null)");
    }

    public Object orNull() {
        return null;
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public String toString() {
        return "Optional.absent()";
    }

    public Set asSet() {
        return Collections.emptySet();
    }

    static {
        Absent absent;
        INSTANCE = absent = new Absent();
    }

    private Absent() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object != this) return false;
        return true;
    }

    public boolean isPresent() {
        return false;
    }
}

