/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.aidl;

import android.os.BadParcelableException;
import android.os.Parcel;
import android.os.Parcelable;

public class Codecs {
    private static final ClassLoader CLASS_LOADER = Codecs.class.getClassLoader();

    public static Parcelable createParcelable(Parcel parcel, Parcelable.Creator creator) {
        if (parcel.readInt() == 0) {
            return null;
        }
        return (Parcelable)creator.createFromParcel(parcel);
    }

    private Codecs() {
    }

    public static void enforceNoDataAvail(Parcel parcel) {
        int n = parcel.dataAvail();
        if (n > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            BadParcelableException badParcelableException = new BadParcelableException(stringBuilder.append("Parcel data not fully consumed, unread size: ").append(n).toString());
            throw badParcelableException;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void writeBoolean(Parcel parcel, boolean bl) {
        bl = bl;
        parcel.writeInt(bl ? 1 : 0);
    }

    public static void writeParcelable(Parcel parcel, Parcelable parcelable) {
        if (parcelable == null) {
            parcel.writeInt(0);
            return;
        }
        parcel.writeInt(1);
        parcelable.writeToParcel(parcel, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean createBoolean(Parcel parcel) {
        if (parcel.readInt() == 0) return false;
        return true;
    }
}

