/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote;

import android.os.Parcelable;
import androidx.test.espresso.remote.BuilderReflector;
import androidx.test.espresso.remote.EspressoRemoteMessage;
import androidx.test.espresso.remote.FieldDescriptor;
import androidx.test.espresso.remote.ProtoUtils;
import androidx.test.espresso.remote.RemoteDescriptor;
import androidx.test.espresso.remote.RemoteDescriptorRegistry;
import androidx.test.espresso.remote.RemoteProtocolException;
import androidx.test.espresso.remote.TypeProtoConverters;
import androidx.test.espresso.remote.internal.deps.guava.base.Function;
import androidx.test.espresso.remote.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.remote.internal.deps.guava.collect.Lists;
import androidx.test.espresso.remote.internal.deps.protobuf.MessageLite;
import androidx.test.internal.util.LogUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

final class RemoteMessageSerializer
implements EspressoRemoteMessage.To<MessageLite> {
    private static final String TAG = "RemoteMsgSerializer";
    private final RemoteDescriptorRegistry remoteDescriptorRegistry;
    private final Object instance;
    private final List<FieldDescriptor> fieldDescriptorList;
    private final Class<?> builderType;
    private final Class<?> protoType;

    /*
     * Enabled aggressive block sorting
     */
    private MessageLite createProtoFromTargetFields(List<Field> instanceTargetFields, Object instance) throws IllegalAccessException {
        Object[] objectArray;
        BuilderReflector builderReflector = new BuilderReflector(remoteMessageSerializer.builderType, remoteMessageSerializer.protoType);
        Iterator iterator = objectArray.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray2;
            Field field = (Field)iterator.next();
            field.setAccessible(true);
            String string = field.getName();
            Object object = field.get(objectArray2);
            boolean bl = object != null;
            Preconditions.checkState(bl, "Serialization of field %s.%s failed, field was null!", field.getDeclaringClass(), (Object)string);
            if (object instanceof Iterable) {
                objectArray = new ArrayList();
                Iterator iterator2 = ((Iterable)object).iterator();
                while (iterator2.hasNext()) {
                    objectArray.add(TypeProtoConverters.typeToAny(iterator2.next(), remoteMessageSerializer.remoteDescriptorRegistry));
                }
                Object[] objectArray3 = new Object[]{objectArray};
                builderReflector.invokeAddAllAnyList(string, objectArray3);
                continue;
            }
            if (object instanceof Serializable) {
                objectArray = new Object[]{TypeProtoConverters.typeToByteString(object)};
                builderReflector.invokeSetByteStringValue(string, objectArray);
                continue;
            }
            if (object instanceof Parcelable) {
                objectArray = new Object[]{TypeProtoConverters.parcelableToByteString((Parcelable)object)};
                builderReflector.invokeSetByteStringValue(string, objectArray);
                continue;
            }
            if (!remoteMessageSerializer.remoteDescriptorRegistry.hasArgForInstanceType(object.getClass())) {
                Locale locale = Locale.ROOT;
                objectArray2 = new Object[]{object.getClass().getName(), string};
                RemoteMessageSerializer remoteMessageSerializer = new RemoteProtocolException(String.format(locale, "Target field: %s#%s cannot be serialised into a proto. Supported target fields can be of type: Any, Serializable or an Iterable<Any/Serializable>", objectArray2));
                throw remoteMessageSerializer;
            }
            objectArray = new Object[]{TypeProtoConverters.typeToAny(object, remoteMessageSerializer.remoteDescriptorRegistry)};
            builderReflector.invokeSetAnyValue(string, objectArray);
        }
        return (MessageLite)builderReflector.invokeBuild();
    }

    public MessageLite toProto() {
        return this.toProtoInternal();
    }

    /*
     * Unable to fully structure code
     */
    private MessageLite toProtoInternal() {
        block12: {
            var1_1 = this.instance;
            var1_1 = var1_1.getClass();
            var2_9 = this.fieldDescriptorList;
            var3_10 = new Function<FieldDescriptor, String>(this){

                @Override
                public String apply(FieldDescriptor fieldDescriptor) {
                    return fieldDescriptor.fieldName;
                }
            };
            var2_9 = ProtoUtils.getFilteredFieldList(var1_1, Lists.transform((List)var2_9, (Function)var3_10));
            try {
                var1_1 = this.createProtoFromTargetFields((List<Field>)var2_9, this.instance);
            }
            catch (Exception var1_6) {
                ** continue;
            }
            catch (Throwable var1_7) {
                var3_10 = var2_9;
                ** GOTO lbl22
            }
            var3_10 = new Object[]{this.instance.getClass(), this.protoType, this.instance.getClass().getDeclaredFields().length, Arrays.toString(this.instance.getClass().getDeclaredFields()), var2_9.size(), var2_9};
            LogUtil.logDebug((String)"RemoteMsgSerializer", (String)"instance type: %s, protoType: %s, declaredFields %s total: %s, targetFields %s total: %s", (Object[])var3_10);
            return var1_1;
            catch (Exception var1_2) {
                var2_9 = null;
lbl14:
                // 2 sources

                while (true) {
                    var3_11 = var1_3 instanceof RemoteProtocolException;
                    if (!var3_11) break block12;
                    throw (RemoteProtocolException)var1_3;
                    break;
                }
            }
            catch (Throwable var1_4) {
                var3_10 = null;
lbl22:
                // 3 sources

                while (true) {
                    var2_9 = new Object[]{this.instance.getClass(), this.protoType, this.instance.getClass().getDeclaredFields().length, Arrays.toString(this.instance.getClass().getDeclaredFields()), var3_10.size(), var3_10};
                    LogUtil.logDebug((String)"RemoteMsgSerializer", (String)"instance type: %s, protoType: %s, declaredFields %s total: %s, targetFields %s total: %s", (Object[])var2_9);
                    throw var1_5;
                }
            }
        }
        var3_12 = new RemoteProtocolException("Error", (Throwable)var1_3);
        throw var3_12;
        {
            catch (Throwable var1_8) {
                var3_10 = var2_9;
                ** continue;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public RemoteMessageSerializer(Object instance, RemoteDescriptorRegistry remoteDescriptorRegistry) {
        void var1_1;
        void var2_2;
        RemoteDescriptor remoteDescriptor = ((RemoteDescriptorRegistry)Preconditions.checkNotNull(var2_2, "remoteDescriptorRegistry cannot be null!")).argForInstanceType(var1_1.getClass());
        this.remoteDescriptorRegistry = var2_2;
        this.instance = Preconditions.checkNotNull(var1_1, "instance cannot be null!");
        this.fieldDescriptorList = remoteDescriptor.getInstanceFieldDescriptorList();
        this.builderType = remoteDescriptor.getProtoBuilderClass();
        this.protoType = remoteDescriptor.getProtoType();
    }
}

