/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote;

import android.text.TextUtils;
import android.util.Log;
import androidx.test.espresso.remote.RemoteDescriptor;
import androidx.test.espresso.remote.RemoteProtocolException;
import androidx.test.espresso.remote.internal.deps.guava.base.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class RemoteDescriptorRegistry {
    private static final String TAG = "RemoteDescrRegistry";
    private static final RemoteDescriptorRegistry DEFAULT_INSTANCE;
    private final Map<Class<?>, RemoteDescriptor> instanceTypeToRemoteTargetTypeLookup;
    private final Map<Class<?>, RemoteDescriptor> protoMsgToRemoteTargetTypeLookup;
    private final Map<String, RemoteDescriptor> remoteTypeUrlToRemoteTypeLookup;

    /*
     * WARNING - void declaration
     */
    public RemoteDescriptor argForInstanceType(Class<?> targetType) {
        void var1_1;
        Preconditions.checkNotNull(targetType, "messageType cannot be null!");
        Map<Class<?>, RemoteDescriptor> map = this.instanceTypeToRemoteTargetTypeLookup;
        Object[] objectArray = new Object[]{var1_1};
        RemoteDescriptorRegistry.throwIfMapNotContains(map, var1_1, "No such message type registered: %s. All remote types must be registered using RemoteDescriptorRegistry#registerRemoteTypeArgs(List<RemoteDescriptor>)", objectArray);
        return this.instanceTypeToRemoteTargetTypeLookup.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public RemoteDescriptor argForMsgType(Class<?> protoMsgType) {
        void var1_1;
        Preconditions.checkNotNull(protoMsgType, "protoMsgType cannot be null!");
        Map<Class<?>, RemoteDescriptor> map = this.protoMsgToRemoteTargetTypeLookup;
        Object[] objectArray = new Object[]{var1_1};
        RemoteDescriptorRegistry.throwIfMapNotContains(map, var1_1, "No such message type registered: %s. All proto msg types must be registered using RemoteDescriptorRegistry#registerRemoteTypeArgs(List<RemoteDescriptor>)", objectArray);
        return this.protoMsgToRemoteTargetTypeLookup.get(var1_1);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public RemoteDescriptor argForRemoteTypeUrl(String typeUrl) {
        void var1_1;
        boolean bl = !TextUtils.isEmpty((CharSequence)typeUrl);
        Preconditions.checkState(bl);
        Map<String, RemoteDescriptor> map = this.remoteTypeUrlToRemoteTypeLookup;
        Object[] objectArray = new Object[]{var1_1};
        RemoteDescriptorRegistry.throwIfMapNotContains(map, var1_1, "Parser not found for type url: %s. All remote types must be registered using RemoteDescriptorRegistry#registerRemoteTypeArgs(List<RemoteDescriptor>", objectArray);
        return this.remoteTypeUrlToRemoteTypeLookup.get(var1_1);
    }

    public static RemoteDescriptorRegistry getInstance() {
        return DEFAULT_INSTANCE;
    }

    static {
        RemoteDescriptorRegistry remoteDescriptorRegistry;
        DEFAULT_INSTANCE = remoteDescriptorRegistry = new RemoteDescriptorRegistry();
    }

    RemoteDescriptorRegistry() {
        HashMap<String, RemoteDescriptor> hashMap = new HashMap<String, RemoteDescriptor>();
        this.instanceTypeToRemoteTargetTypeLookup = hashMap;
        hashMap = new HashMap<String, RemoteDescriptor>();
        this.protoMsgToRemoteTargetTypeLookup = hashMap;
        hashMap = new HashMap<String, RemoteDescriptor>();
        this.remoteTypeUrlToRemoteTypeLookup = hashMap;
    }

    void clear() {
        this.remoteTypeUrlToRemoteTypeLookup.clear();
        this.instanceTypeToRemoteTargetTypeLookup.clear();
        this.protoMsgToRemoteTargetTypeLookup.clear();
    }

    /*
     * WARNING - void declaration
     */
    private static final <K, V> void throwIfMapNotContains(Map<K, V> map, K key, String fmtError, Object ... fmtArgs) {
        void var1_1;
        if (!map.containsKey(var1_1)) {
            void var3_3;
            void var2_2;
            RemoteProtocolException remoteProtocolException = new RemoteProtocolException(String.format(Locale.ROOT, (String)var2_2, (Object[])var3_3));
            throw remoteProtocolException;
        }
    }

    public void unregisterRemoteTypeArgs(List<RemoteDescriptor> remoteDescriptors) {
        Object object;
        Preconditions.checkNotNull(remoteDescriptors, "remoteDescriptors cannot be null!");
        object = object.iterator();
        while (object.hasNext()) {
            RemoteDescriptor remoteDescriptor = (RemoteDescriptor)object.next();
            if (!((RemoteDescriptorRegistry)object2).isRegistered(remoteDescriptor)) {
                object = Locale.ROOT;
                Object[] objectArray = new Object[]{remoteDescriptor.getInstanceType()};
                Object object2 = new IllegalStateException(String.format((Locale)object, "Attempted to unregister RemoteDescriptor for target type: %s, that was not registered", objectArray));
                throw object2;
            }
            ((RemoteDescriptorRegistry)object2).remoteTypeUrlToRemoteTypeLookup.remove(remoteDescriptor.getInstanceTypeName());
            ((RemoteDescriptorRegistry)object2).instanceTypeToRemoteTargetTypeLookup.remove(remoteDescriptor.getInstanceType());
            ((RemoteDescriptorRegistry)object2).protoMsgToRemoteTargetTypeLookup.remove(remoteDescriptor.getProtoType());
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasArgForInstanceType(Class<?> instanceType) {
        void var1_1;
        Preconditions.checkNotNull(instanceType, "instanceType cannot be null!");
        return this.instanceTypeToRemoteTargetTypeLookup.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isRegistered(RemoteDescriptor remoteDescriptor) {
        void var1_2;
        if (!this.remoteTypeUrlToRemoteTypeLookup.containsKey(var1_2.getInstanceTypeName())) return false;
        if (!this.instanceTypeToRemoteTargetTypeLookup.containsKey(var1_2.getInstanceType())) return false;
        if (!this.protoMsgToRemoteTargetTypeLookup.containsKey(var1_2.getProtoType())) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean registerRemoteTypeArgs(List<RemoteDescriptor> remoteDescriptors) {
        void var1_1;
        Preconditions.checkNotNull(remoteDescriptors, "remoteDescriptors cannot be null!");
        Iterator iterator = var1_1.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            RemoteDescriptor remoteDescriptor = (RemoteDescriptor)iterator.next();
            if (this.isRegistered(remoteDescriptor)) {
                Locale locale = Locale.ROOT;
                Object[] objectArray = new Object[]{remoteDescriptor.getInstanceType()};
                Log.w((String)TAG, (String)String.format(locale, "Attempted to register RemoteDescriptor for target type: %s, that was already registered", objectArray));
                bl = false;
            }
            this.remoteTypeUrlToRemoteTypeLookup.put(remoteDescriptor.getInstanceTypeName(), remoteDescriptor);
            this.instanceTypeToRemoteTargetTypeLookup.put(remoteDescriptor.getInstanceType(), remoteDescriptor);
            this.protoMsgToRemoteTargetTypeLookup.put(remoteDescriptor.getProtoType(), remoteDescriptor);
        }
        return bl;
    }
}

